/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.Serializable;
import java.util.List;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Query;
import org.apache.torque.util.SQLBuilder;
import org.apache.torque.util.SqlEnum;
import org.apache.torque.util.SqlExpression;
import org.apache.torque.util.UniqueList;

public abstract class JoinBuilder
implements Serializable {
    public static final void processJoins(DB db, DatabaseMap dbMap, Criteria criteria, Query query) throws TorqueException {
        List criteriaJoins = criteria.getJoins();
        if (criteriaJoins == null) {
            return;
        }
        UniqueList queryFromClause = query.getFromClause();
        UniqueList queryWhereClause = query.getWhereClause();
        for (int i = 0; i < criteriaJoins.size(); ++i) {
            Query.FromElement fromElement;
            Criteria.Join join = (Criteria.Join)criteriaJoins.get(i);
            String leftColumn = join.getLeftColumn();
            String rightColumn = join.getRightColumn();
            if (leftColumn.indexOf(46) == -1) {
                SQLBuilder.throwMalformedColumnNameException("join", leftColumn);
            }
            if (rightColumn.indexOf(46) == -1) {
                SQLBuilder.throwMalformedColumnNameException("join", rightColumn);
            }
            int dot = leftColumn.lastIndexOf(46);
            String leftTableName = leftColumn.substring(0, dot);
            leftTableName = SQLBuilder.getTableNameForFromClause(leftTableName, criteria);
            dot = rightColumn.lastIndexOf(46);
            String rightTableName = rightColumn.substring(0, dot);
            String dbTableName = criteria.getTableForAlias(rightTableName);
            if (dbTableName == null) {
                dbTableName = rightTableName;
            }
            String columnName = rightColumn.substring(dot + 1, rightColumn.length());
            boolean ignoreCase = criteria.isIgnoreCase() && dbMap.getTable(dbTableName).getColumn(columnName).getType() instanceof String;
            rightTableName = SQLBuilder.getTableNameForFromClause(rightTableName, criteria);
            SqlEnum joinType = join.getJoinType();
            if (joinType == null) {
                if (!SQLBuilder.fromClauseContainsTableName(queryFromClause, leftTableName)) {
                    fromElement = new Query.FromElement(leftTableName, null, null);
                    queryFromClause.add(fromElement);
                }
                if (!SQLBuilder.fromClauseContainsTableName(queryFromClause, rightTableName)) {
                    fromElement = new Query.FromElement(rightTableName, null, null);
                    queryFromClause.add(fromElement);
                }
                queryWhereClause.add(SqlExpression.buildInnerJoin(leftColumn, rightColumn, ignoreCase, db));
                continue;
            }
            if (!SQLBuilder.fromClauseContainsTableName(queryFromClause, rightTableName)) {
                if (!SQLBuilder.fromClauseContainsTableName(queryFromClause, leftTableName)) {
                    fromElement = new Query.FromElement(leftTableName, null, null);
                    queryFromClause.add(fromElement);
                }
                fromElement = new Query.FromElement(rightTableName, joinType, SqlExpression.buildInnerJoin(leftColumn, rightColumn, ignoreCase, db));
                queryFromClause.add(fromElement);
                continue;
            }
            if (SQLBuilder.fromClauseContainsTableName(queryFromClause, leftTableName)) {
                throw new TorqueException("Unable to create a " + joinType + "because both table names " + leftTableName + " and " + rightTableName + " are already in use. " + "Try to create an(other) alias.");
            }
            fromElement = new Query.FromElement(leftTableName, JoinBuilder.reverseJoinType(joinType), SqlExpression.buildInnerJoin(rightColumn, leftColumn, ignoreCase, db));
            queryFromClause.add(fromElement);
        }
    }

    private static final SqlEnum reverseJoinType(SqlEnum joinType) {
        if (SqlEnum.LEFT_JOIN.equals(joinType)) {
            return SqlEnum.RIGHT_JOIN;
        }
        if (SqlEnum.RIGHT_JOIN.equals(joinType)) {
            return SqlEnum.LEFT_JOIN;
        }
        return joinType;
    }
}

