/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import junit.framework.TestCase;
import net.yher2.commons.io.Path;
import net.yher2.junit.db.TestDataManager;
import org.apache.commons.dbutils.DbUtils;

public abstract class DBTestCase
extends TestCase {
    protected abstract Connection getConnection() throws SQLException;

    public DBTestCase() {
    }

    public DBTestCase(String name) {
        super(name);
    }

    protected void prepare(Path testData) throws IOException, SQLException {
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            this.prepare(con, testData);
            con.commit();
        }
        finally {
            DbUtils.rollback((Connection)con);
            DbUtils.close((Connection)con);
        }
    }

    protected void prepare(Connection con, Path testData) throws IOException, SQLException {
        TestDataManager manager = new TestDataManager(con);
        manager.prepare(testData);
    }

    protected void clear(Path testData) throws IOException, SQLException {
        Connection con = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            this.clear(con, testData);
            con.commit();
        }
        finally {
            DbUtils.rollback((Connection)con);
            DbUtils.close((Connection)con);
        }
    }

    protected void clear(Connection con, Path testData) throws IOException, SQLException {
        TestDataManager manager = new TestDataManager(con);
        manager.clear(testData);
    }
}

