/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.commons.lang;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ExtendResourceBundle {
    private ArrayList resourceBundleList = new ArrayList();

    public static ExtendResourceBundle getBundle(String baseName) {
        ExtendResourceBundle resource = new ExtendResourceBundle();
        resource.addResourceBundle(ResourceBundle.getBundle(baseName));
        try {
            String[] include = resource.getStringArray("include");
            int i = 0;
            while (i < include.length) {
                resource.addResourceBundle(ResourceBundle.getBundle(include[i]));
                ++i;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resource;
    }

    private ExtendResourceBundle() {
    }

    private void addResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundleList.add(resourceBundle);
    }

    public String getString(String key) {
        for (ResourceBundle resource : this.resourceBundleList) {
            try {
                return resource.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        throw new MissingResourceException("Can't find resource:" + key, this.getClass().getName(), key);
    }

    public String[] getStringArray(String key) {
        String val = this.getString(key);
        if (key == null || key.length() == 0) {
            return new String[0];
        }
        String[] list = val.split(",");
        int i = 0;
        while (i < list.length) {
            list[i] = list[i].trim();
            ++i;
        }
        return list;
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.getString(key));
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getString(key));
    }
}

