/*
 * Decompiled with CFR 0.152.
 */
package net.yher2.junit.db.excel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.yher2.commons.io.Path;
import net.yher2.junit.db.data.ColumnData;
import net.yher2.junit.db.data.Header;
import net.yher2.junit.db.data.Row;
import net.yher2.junit.db.data.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class ExcelReader {
    Log log = LogFactory.getLog(this.getClass());
    HSSFWorkbook book;
    Map metaDataMap;
    String path;

    public ExcelReader(Path resourcePath) throws IOException {
        this.path = resourcePath.getPath();
        this.book = new HSSFWorkbook(new POIFSFileSystem(resourcePath.getInputStream()));
        this.metaDataMap = new HashMap();
    }

    public Table[] read() throws IllegalStateException {
        ArrayList<Table> tableList = new ArrayList<Table>();
        int sheetCount = this.book.getNumberOfSheets();
        int i = 0;
        while (i < sheetCount) {
            try {
                tableList.add(this.readSheet(this.book.getSheetName(i), this.book.getSheetAt(i)));
            }
            catch (IllegalStateException e) {
                IllegalStateException ex = new IllegalStateException(String.valueOf(this.path) + ":Sheet[" + this.book.getSheetName(i) + "]:" + e.getMessage());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            ++i;
        }
        return tableList.toArray(new Table[tableList.size()]);
    }

    private Table readSheet(String sheetName, HSSFSheet sheet) throws IllegalStateException {
        Table table = new Table(sheetName);
        int lastRowNum = sheet.getLastRowNum();
        HSSFRow header = sheet.getRow(0);
        if (header == null) {
            throw new IllegalStateException("The sheet does not have header.");
        }
        table.setHeader(this.readHeaderRow(header));
        int j = 1;
        while (j <= lastRowNum) {
            table.addRow(this.readRow(sheet.getRow(j)));
            ++j;
        }
        return table;
    }

    private Header[] readHeaderRow(HSSFRow header) {
        ArrayList<Header> list = new ArrayList<Header>();
        if (header == null) {
            throw new IllegalStateException("There is no Header.");
        }
        int lastCellNum = header.getLastCellNum();
        if (lastCellNum == 0) {
            throw new IllegalStateException("There is no Header.");
        }
        int i = 0;
        while (i < lastCellNum) {
            HSSFCell cell = header.getCell((short)i);
            if (cell == null) {
                throw new IllegalStateException("There is illegal header at " + i + "(0 based).");
            }
            switch (cell.getCellType()) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    list.add(new Header(cell.getStringCellValue().trim(), this.isPrimaryKey(cell)));
                    break;
                }
                default: {
                    throw new IllegalStateException("There is illegal header.");
                }
            }
            ++i;
        }
        return list.toArray(new Header[list.size()]);
    }

    private boolean isPrimaryKey(HSSFCell cell) {
        return this.book.getFontAt(cell.getCellStyle().getFontIndex()).getBoldweight() == 700;
    }

    private Row readRow(HSSFRow hssfRow) {
        Row row = new Row();
        int lastCellNum = hssfRow.getLastCellNum();
        int i = 0;
        while (i < lastCellNum) {
            HSSFCell cell = hssfRow.getCell((short)i);
            row.add(ColumnData.getInstance(cell));
            ++i;
        }
        return row;
    }
}

