/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public class LargeSelect
implements Runnable,
Serializable {
    private int pageSize;
    private int memoryLimit;
    private transient int blockBegin = 0;
    private transient int blockEnd;
    private volatile int currentlyFilledTo = -1;
    private String query;
    private String dbName;
    private transient List results = null;
    private transient Thread thread = null;
    private volatile transient boolean killThread = false;
    private volatile transient boolean threadRunning = false;
    private volatile transient boolean queryCompleted = false;
    private transient boolean totalsFinalized = false;
    private int position;
    private int totalPages = -1;
    private int totalRecords = 0;
    private Criteria criteria = null;
    private transient List lastResults;
    private Class returnBuilderClass = null;
    private transient Method populateObjectsMethod = null;
    public static final String DEFAULT_MORE_INDICATOR = "&gt;";
    private static String moreIndicator = "&gt;";
    public static final int DEFAULT_MEMORY_LIMIT_PAGES = 5;
    private static int memoryPageLimit = 5;
    private Hashtable params = null;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$util$LargeSelect == null ? (class$org$apache$torque$util$LargeSelect = LargeSelect.class$("org.apache.torque.util.LargeSelect")) : class$org$apache$torque$util$LargeSelect));
    static /* synthetic */ Class class$org$apache$torque$util$LargeSelect;
    static /* synthetic */ Class class$org$apache$torque$util$Criteria;
    static /* synthetic */ Class class$java$util$List;

    public LargeSelect(Criteria criteria, int pageSize) throws IllegalArgumentException {
        this(criteria, pageSize, memoryPageLimit);
    }

    public LargeSelect(Criteria criteria, int pageSize, int memoryPageLimit) throws IllegalArgumentException {
        this.init(criteria, pageSize, memoryPageLimit);
    }

    public LargeSelect(Criteria criteria, int pageSize, String returnBuilderClassName) throws IllegalArgumentException {
        this(criteria, pageSize, memoryPageLimit, returnBuilderClassName);
    }

    public LargeSelect(Criteria criteria, int pageSize, int memoryPageLimit, String returnBuilderClassName) throws IllegalArgumentException {
        try {
            this.returnBuilderClass = Class.forName(returnBuilderClassName);
            if (criteria.getSelectColumns().size() == 0) {
                Class[] argTypes = new Class[]{class$org$apache$torque$util$Criteria == null ? (class$org$apache$torque$util$Criteria = LargeSelect.class$("org.apache.torque.util.Criteria")) : class$org$apache$torque$util$Criteria};
                Method selectColumnAdder = this.returnBuilderClass.getMethod("addSelectColumns", argTypes);
                Object[] theArgs = new Object[]{criteria};
                selectColumnAdder.invoke(this.returnBuilderClass.newInstance(), theArgs);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The class named as returnBuilderClassName does not provide the necessary facilities - see javadoc.");
        }
        this.init(criteria, pageSize, memoryPageLimit);
    }

    private Method getPopulateObjectsMethod() throws SecurityException, NoSuchMethodException {
        if (null == this.populateObjectsMethod) {
            Class[] argTypes = new Class[]{class$java$util$List == null ? (class$java$util$List = LargeSelect.class$("java.util.List")) : class$java$util$List};
            this.populateObjectsMethod = this.returnBuilderClass.getMethod("populateObjects", argTypes);
        }
        return this.populateObjectsMethod;
    }

    private void init(Criteria criteria, int pageSize, int memoryLimitPages) throws IllegalArgumentException {
        if (criteria.getOffset() != 0 || criteria.getLimit() != -1) {
            throw new IllegalArgumentException("criteria must not use Offset and/or Limit.");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be greater than zero.");
        }
        if (memoryLimitPages < 1) {
            throw new IllegalArgumentException("memoryPageLimit must be greater than zero.");
        }
        this.pageSize = pageSize;
        this.memoryLimit = pageSize * memoryLimitPages;
        this.criteria = criteria;
        this.dbName = criteria.getDbName();
        this.blockEnd = this.blockBegin + this.memoryLimit - 1;
        this.startQuery(pageSize);
    }

    public List getPage(int pageNumber) throws TorqueException {
        if (pageNumber < 1) {
            throw new IllegalArgumentException("pageNumber must be greater than zero.");
        }
        return this.getResults((pageNumber - 1) * this.pageSize);
    }

    public List getNextResults() throws TorqueException {
        if (!this.getNextResultsAvailable()) {
            return this.getCurrentPageResults();
        }
        return this.getResults(this.position);
    }

    public List getCurrentPageResults() throws TorqueException {
        return null == this.lastResults && this.position > 0 ? this.getResults(this.position) : this.lastResults;
    }

    public List getPreviousResults() throws TorqueException {
        if (!this.getPreviousResultsAvailable()) {
            return this.getCurrentPageResults();
        }
        int start = this.position - 2 * this.pageSize < 0 ? 0 : this.position - 2 * this.pageSize;
        return this.getResults(start);
    }

    private List getResults(int start) throws TorqueException {
        return this.getResults(start, this.pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized List getResults(int start, int size) throws IllegalArgumentException, TorqueException {
        List returnResults;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResults(start: " + start + ", size: " + size + ") invoked."));
        }
        if (size > this.memoryLimit) {
            throw new IllegalArgumentException("size (" + size + ") exceeds memory limit (" + this.memoryLimit + ").");
        }
        if (start >= this.blockBegin && start + size - 1 <= this.blockEnd) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getResults(): Sleeping until start+size-1 (" + (start + size - 1) + ") > currentlyFilledTo (" + this.currentlyFilledTo + ") && !queryCompleted (!" + this.queryCompleted + ")"));
            }
            while (start + size - 1 > this.currentlyFilledTo && !this.queryCompleted) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new TorqueException("Unexpected interruption", e);
                }
            }
        } else {
            if (start < this.blockBegin && start >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getResults(): Paging backwards as start (" + start + ") < blockBegin (" + this.blockBegin + ") && start >= 0"));
                }
                this.stopQuery();
                if (this.memoryLimit >= 2 * size) {
                    this.blockBegin = start - size;
                    if (this.blockBegin < 0) {
                        this.blockBegin = 0;
                    }
                } else {
                    this.blockBegin = start;
                }
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
                return this.getResults(start, size);
            }
            if (start + size - 1 > this.blockEnd) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("getResults(): Paging past end of loaded data as start+size-1 (" + (start + size - 1) + ") > blockEnd (" + this.blockEnd + ")"));
                }
                this.stopQuery();
                this.blockBegin = start;
                this.blockEnd = this.blockBegin + this.memoryLimit - 1;
                this.startQuery(size);
                return this.getResults(start, size);
            }
            throw new IllegalArgumentException("Parameter configuration not accounted for.");
        }
        int fromIndex = start - this.blockBegin;
        int toIndex = fromIndex + Math.min(size, this.results.size() - fromIndex);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResults(): Retrieving records from results elements start-blockBegin (" + fromIndex + ") through " + "fromIndex + Math.min(size, results.size() - fromIndex) (" + toIndex + ")"));
        }
        List list = this.results;
        synchronized (list) {
            returnResults = new ArrayList(this.results.subList(fromIndex, toIndex));
        }
        if (null != this.returnBuilderClass) {
            Object[] theArgs = new Object[]{returnResults};
            try {
                returnResults = (List)this.getPopulateObjectsMethod().invoke(this.returnBuilderClass.newInstance(), theArgs);
            }
            catch (Exception e) {
                throw new TorqueException("Unable to populate results", e);
            }
        }
        this.position = start + size;
        this.lastResults = returnResults;
        return returnResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block42: {
            QueryDataSet qds;
            Connection conn;
            block40: {
                boolean dbSupportsNativeLimit;
                try {
                    dbSupportsNativeLimit = Torque.getDB(this.dbName).getLimitStyle() != 0;
                }
                catch (TorqueException e) {
                    log.error((Object)"run() : Exiting :", (Throwable)((Object)e));
                    return;
                }
                int size = dbSupportsNativeLimit ? this.pageSize : this.blockBegin + this.memoryLimit + 1;
                conn = null;
                qds = null;
                this.results = new ArrayList(this.memoryLimit + 1);
                if (dbSupportsNativeLimit) {
                    this.criteria.setOffset(this.blockBegin);
                    this.criteria.setLimit(this.memoryLimit + 1);
                }
                this.query = BasePeer.createQueryString(this.criteria);
                conn = Torque.getConnection(this.dbName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("run(): query = " + this.query));
                    log.debug((Object)("run(): memoryLimit = " + this.memoryLimit));
                    log.debug((Object)("run(): blockBegin = " + this.blockBegin));
                    log.debug((Object)("run(): blockEnd = " + this.blockEnd));
                }
                qds = new QueryDataSet(conn, this.query);
                while (!this.killThread && !qds.allRecordsRetrieved() && this.currentlyFilledTo + this.pageSize <= this.blockEnd) {
                    if (this.currentlyFilledTo + this.pageSize >= this.blockEnd && dbSupportsNativeLimit) {
                        size = this.blockEnd - this.currentlyFilledTo + 1;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("run(): Invoking BasePeer.getSelectResults(qds, " + size + ", false)"));
                    }
                    List tempResults = BasePeer.getSelectResults(qds, size, false);
                    List list = this.results;
                    synchronized (list) {
                        int n = tempResults.size();
                        for (int i = 0; i < n; ++i) {
                            if (!dbSupportsNativeLimit && i < this.blockBegin) continue;
                            this.results.add(tempResults.get(i));
                        }
                    }
                    this.currentlyFilledTo = dbSupportsNativeLimit ? (this.currentlyFilledTo += tempResults.size()) : tempResults.size() - 1 - this.blockBegin;
                    boolean perhapsLastPage = true;
                    if (dbSupportsNativeLimit && this.results.size() == this.memoryLimit + 1 || !dbSupportsNativeLimit && this.currentlyFilledTo >= this.memoryLimit) {
                        List list2 = this.results;
                        synchronized (list2) {
                            this.results.remove(this.currentlyFilledTo--);
                        }
                        perhapsLastPage = false;
                    }
                    if (this.results.size() > 0 && this.blockBegin + this.currentlyFilledTo >= this.totalRecords) {
                        this.totalRecords = this.blockBegin + this.currentlyFilledTo + 1;
                    }
                    if (qds.allRecordsRetrieved() || !dbSupportsNativeLimit) {
                        this.queryCompleted = true;
                        if (perhapsLastPage && this.getCurrentPageNumber() <= this.getTotalPages()) {
                            this.totalsFinalized = true;
                        }
                    }
                    qds.clearRecords();
                }
                if (!log.isDebugEnabled()) break block40;
                log.debug((Object)"run(): While loop terminated because either:");
                log.debug((Object)("run(): 1. qds.allRecordsRetrieved(): " + qds.allRecordsRetrieved()));
                log.debug((Object)("run(): 2. killThread: " + this.killThread));
                log.debug((Object)("run(): 3. !(currentlyFilledTo + size <= blockEnd): !" + (this.currentlyFilledTo + this.pageSize <= this.blockEnd)));
                log.debug((Object)("run(): - currentlyFilledTo: " + this.currentlyFilledTo));
                log.debug((Object)("run(): - size: " + this.pageSize));
                log.debug((Object)("run(): - blockEnd: " + this.blockEnd));
                log.debug((Object)("run(): - results.size(): " + this.results.size()));
            }
            Object var12_17 = null;
            try {
                if (qds != null) {
                    qds.close();
                }
                Torque.closeConnection(conn);
            }
            catch (SQLException e2) {
                log.error((Object)e2);
            }
            catch (DataSetException e3) {
                log.error((Object)e3);
            }
            this.threadRunning = false;
            {
                break block42;
                catch (TorqueException e) {
                    log.error((Object)e);
                    Object var12_18 = null;
                    try {
                        if (qds != null) {
                            qds.close();
                        }
                        Torque.closeConnection(conn);
                    }
                    catch (SQLException e2) {
                        log.error((Object)e2);
                    }
                    catch (DataSetException e3) {
                        log.error((Object)e3);
                    }
                    this.threadRunning = false;
                    break block42;
                }
                catch (SQLException e) {
                    log.error((Object)e);
                    Object var12_19 = null;
                    try {
                        if (qds != null) {
                            qds.close();
                        }
                        Torque.closeConnection(conn);
                    }
                    catch (SQLException e2) {
                        log.error((Object)e2);
                    }
                    catch (DataSetException e3) {
                        log.error((Object)e3);
                    }
                    this.threadRunning = false;
                    break block42;
                }
                catch (DataSetException e) {
                    log.error((Object)e);
                    Object var12_20 = null;
                    try {
                        if (qds != null) {
                            qds.close();
                        }
                        Torque.closeConnection(conn);
                    }
                    catch (SQLException e2) {
                        log.error((Object)e2);
                    }
                    catch (DataSetException e3) {
                        log.error((Object)e3);
                    }
                    this.threadRunning = false;
                }
            }
            catch (Throwable throwable) {
                Object var12_21 = null;
                try {
                    if (qds != null) {
                        qds.close();
                    }
                    Torque.closeConnection(conn);
                }
                catch (SQLException e2) {
                    log.error((Object)e2);
                }
                catch (DataSetException e3) {
                    log.error((Object)e3);
                }
                this.threadRunning = false;
                throw throwable;
            }
        }
    }

    private synchronized void startQuery(int initialSize) {
        if (!this.threadRunning) {
            this.pageSize = initialSize;
            this.currentlyFilledTo = -1;
            this.queryCompleted = false;
            this.thread = new Thread(this);
            this.thread.start();
            this.threadRunning = true;
        }
    }

    private synchronized void stopQuery() throws TorqueException {
        if (this.threadRunning) {
            this.killThread = true;
            while (this.thread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new TorqueException("Unexpected interruption", e);
                }
            }
            this.killThread = false;
        }
    }

    public int getCurrentPageNumber() {
        return this.position / this.pageSize;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public boolean getPaginated() {
        if (!this.getTotalsFinalized()) {
            return true;
        }
        return this.blockBegin + this.currentlyFilledTo + 1 > this.pageSize;
    }

    public int getTotalPages() {
        if (this.totalPages > -1) {
            return this.totalPages;
        }
        int tempPageCount = this.getTotalRecords() / this.pageSize + (this.getTotalRecords() % this.pageSize > 0 ? 1 : 0);
        if (this.getTotalsFinalized()) {
            this.totalPages = tempPageCount;
        }
        return tempPageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean getTotalsFinalized() {
        return this.totalsFinalized;
    }

    public static void setMoreIndicator(String moreIndicator) {
        LargeSelect.moreIndicator = moreIndicator;
    }

    public static String getMoreIndicator() {
        return moreIndicator;
    }

    public static void setMemoryPageLimit(int memoryPageLimit) {
        LargeSelect.memoryPageLimit = memoryPageLimit;
    }

    public static int getMemoryPageLimit() {
        return memoryPageLimit;
    }

    public String getPageProgressText() {
        StringBuffer result = new StringBuffer();
        result.append(this.getCurrentPageNumber());
        result.append(" of ");
        if (!this.totalsFinalized) {
            result.append(moreIndicator);
            result.append(" ");
        }
        result.append(this.getTotalPages());
        return result.toString();
    }

    public int getCurrentPageSize() throws TorqueException {
        if (null == this.getCurrentPageResults()) {
            return 0;
        }
        return this.getCurrentPageResults().size();
    }

    public int getFirstRecordNoForPage() {
        if (this.getCurrentPageNumber() < 1) {
            return 0;
        }
        return (this.getCurrentPageNumber() - 1) * this.getPageSize() + 1;
    }

    public int getLastRecordNoForPage() throws TorqueException {
        if (0 == this.getCurrentPageNumber()) {
            return 0;
        }
        return (this.getCurrentPageNumber() - 1) * this.getPageSize() + this.getCurrentPageSize();
    }

    public String getRecordProgressText() throws TorqueException {
        StringBuffer result = new StringBuffer();
        result.append(this.getFirstRecordNoForPage());
        result.append(" - ");
        result.append(this.getLastRecordNoForPage());
        result.append(" of ");
        if (!this.totalsFinalized) {
            result.append(moreIndicator);
            result.append(" ");
        }
        result.append(this.getTotalRecords());
        return result.toString();
    }

    public boolean getNextResultsAvailable() {
        return !this.totalsFinalized || this.getCurrentPageNumber() < this.getTotalPages();
    }

    public boolean getPreviousResultsAvailable() {
        return this.getCurrentPageNumber() > 1;
    }

    public boolean hasResultsAvailable() {
        return this.getTotalRecords() > 0;
    }

    public synchronized void invalidateResult() throws TorqueException {
        this.stopQuery();
        this.blockBegin = 0;
        this.blockEnd = 0;
        this.currentlyFilledTo = -1;
        this.results = null;
        this.position = 0;
        this.totalPages = -1;
        this.totalRecords = 0;
        this.queryCompleted = false;
        this.totalsFinalized = false;
        this.lastResults = null;
    }

    public String getSearchParam(String name) {
        return this.getSearchParam(name, null);
    }

    public String getSearchParam(String name, String defaultValue) {
        if (null == this.params) {
            return defaultValue;
        }
        String value = (String)this.params.get(name);
        return null == value ? defaultValue : value;
    }

    public void setSearchParam(String name, String value) {
        if (null == value) {
            this.removeSearchParam(name);
        } else if (null != name) {
            if (null == this.params) {
                this.params = new Hashtable();
            }
            this.params.put(name, value);
        }
    }

    public void removeSearchParam(String name) {
        if (null != this.params) {
            this.params.remove(name);
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.startQuery(this.pageSize);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("LargeSelect - TotalRecords: ");
        result.append(this.getTotalRecords());
        result.append(" TotalsFinalised: ");
        result.append(this.getTotalsFinalized());
        result.append("\nParameters:");
        if (null == this.params || this.params.size() == 0) {
            result.append(" No parameters have been set.");
        } else {
            Set keys = this.params.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.params.get(key);
                result.append("\n ").append(key).append(": ").append(val);
            }
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

