/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.Query;

public abstract class LimitHelper {
    public static final void buildLimit(Criteria criteria, Query query) throws TorqueException {
        int limit = criteria.getLimit();
        int offset = criteria.getOffset();
        DB db = Torque.getDB(criteria.getDbName());
        if (offset > 0 || limit > 0) {
            switch (db.getLimitStyle()) {
                case 2: {
                    LimitHelper.generateMySQLLimits(query, offset, limit);
                    break;
                }
                case 1: {
                    LimitHelper.generatePostgreSQLLimits(query, offset, limit);
                    break;
                }
                case 4: {
                    LimitHelper.generateOracleLimits(query, offset, limit);
                    break;
                }
                case 5: {
                    LimitHelper.generateDB2Limits(query, offset, limit);
                    break;
                }
                default: {
                    if (!db.supportsNativeLimit()) break;
                    query.setLimit(String.valueOf(limit));
                }
            }
        }
    }

    private static final void generateMySQLLimits(Query query, int offset, int limit) {
        StringBuffer limitStringBuffer = new StringBuffer();
        if (offset > 0) {
            limitStringBuffer.append(offset).append(", ").append(limit);
        } else if (limit > 0) {
            limitStringBuffer.append(limit);
        }
        query.setLimit(limitStringBuffer.toString());
        query.setPreLimit(null);
        query.setPostLimit(null);
    }

    private static final void generatePostgreSQLLimits(Query query, int offset, int limit) {
        StringBuffer limitStringBuffer = new StringBuffer();
        if (offset > 0) {
            limitStringBuffer.append(limit).append(" offset ").append(offset);
        } else if (limit > 0) {
            limitStringBuffer.append(limit);
        }
        query.setLimit(limitStringBuffer.toString());
        query.setPreLimit(null);
        query.setPostLimit(null);
    }

    private static final void generateOracleLimits(Query query, int offset, int limit) {
        StringBuffer preLimit = new StringBuffer().append("SELECT B.* FROM ( ").append("SELECT A.*, rownum AS TORQUE$ROWNUM FROM ( ");
        StringBuffer postLimit = new StringBuffer().append(" ) A ").append(" ) B WHERE ");
        if (offset > 0) {
            postLimit.append(" B.TORQUE$ROWNUM > ").append(offset);
            if (limit > 0) {
                postLimit.append(" AND B.TORQUE$ROWNUM <= ").append(offset + limit);
            }
        } else {
            postLimit.append(" B.TORQUE$ROWNUM <= ").append(limit);
        }
        query.setPreLimit(preLimit.toString());
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
    }

    private static final void generateDB2Limits(Query query, int offset, int limit) {
        StringBuffer preLimit = new StringBuffer().append("SELECT B.* FROM ( ").append("SELECT A.*, row_number() over() AS TORQUE$ROWNUM FROM ( ");
        StringBuffer postLimit = new StringBuffer().append(" ) A ").append(" ) B WHERE ");
        if (offset > 0) {
            postLimit.append(" B.TORQUE$ROWNUM > ").append(offset);
            if (limit > 0) {
                postLimit.append(" AND B.TORQUE$ROWNUM <= ").append(offset + limit);
            }
        } else {
            postLimit.append(" B.TORQUE$ROWNUM <= ").append(limit);
        }
        query.setPreLimit(preLimit.toString());
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
    }
}

