/*
 * Decompiled with CFR 0.152.
 */
package com.workingdogs.village;

import com.workingdogs.village.DataSetException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class Value {
    private Object valueObject;
    private int columnNumber;
    private int type;

    public Value(ResultSet rs, int columnNumber, int type) throws SQLException {
        this.columnNumber = columnNumber;
        this.type = type;
        this.valueObject = null;
        if (rs == null) {
            return;
        }
        switch (this.type()) {
            case -7: {
                String tmp = rs.getString(columnNumber);
                if (tmp == null) {
                    this.valueObject = Boolean.FALSE;
                    break;
                }
                if (this.isTrue(tmp)) {
                    this.valueObject = Boolean.TRUE;
                    break;
                }
                this.valueObject = Boolean.FALSE;
                break;
            }
            case -6: {
                this.valueObject = new Byte(rs.getByte(columnNumber));
                break;
            }
            case -5: {
                this.valueObject = new Long(rs.getLong(columnNumber));
                break;
            }
            case 5: {
                this.valueObject = new Short(rs.getShort(columnNumber));
                break;
            }
            case 4: {
                this.valueObject = new Integer(rs.getInt(columnNumber));
                break;
            }
            case 7: {
                this.valueObject = new Float(rs.getFloat(columnNumber));
                break;
            }
            case 6: 
            case 8: {
                this.valueObject = new Double(rs.getDouble(columnNumber));
                break;
            }
            case 2: 
            case 3: {
                String number = rs.getString(columnNumber);
                if (number == null) {
                    this.valueObject = null;
                    break;
                }
                this.valueObject = new BigDecimal(number);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.valueObject = rs.getBytes(columnNumber);
                break;
            }
            case 2004: {
                Blob blob = rs.getBlob(columnNumber);
                this.valueObject = blob.getBytes(1L, (int)blob.length());
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                this.valueObject = rs.getString(columnNumber);
                break;
            }
            case 91: {
                this.valueObject = rs.getDate(columnNumber);
                break;
            }
            case 92: {
                this.valueObject = rs.getTime(columnNumber);
                break;
            }
            case 93: {
                this.valueObject = rs.getTimestamp(columnNumber);
                break;
            }
            case 0: {
                this.valueObject = null;
                break;
            }
            default: {
                this.valueObject = rs.getString(columnNumber);
            }
        }
        if (rs.wasNull()) {
            this.valueObject = null;
        }
    }

    void setValue(Object value) {
        this.valueObject = value;
    }

    Object getValue() {
        return this.valueObject;
    }

    void setPreparedStatementValue(PreparedStatement stmt, int stmtNumber) throws DataSetException, SQLException {
        if (this.isNull()) {
            stmt.setNull(stmtNumber, this.type());
            return;
        }
        switch (this.type()) {
            case -7: {
                stmt.setBoolean(stmtNumber, this.asBoolean());
                break;
            }
            case -6: {
                stmt.setByte(stmtNumber, this.asByte());
                break;
            }
            case -5: {
                stmt.setLong(stmtNumber, this.asLong());
                break;
            }
            case 5: {
                stmt.setShort(stmtNumber, this.asShort());
                break;
            }
            case 4: {
                stmt.setInt(stmtNumber, this.asInt());
                break;
            }
            case 7: {
                stmt.setFloat(stmtNumber, this.asFloat());
                break;
            }
            case 6: 
            case 8: {
                stmt.setDouble(stmtNumber, this.asDouble());
                break;
            }
            case 2: 
            case 3: {
                stmt.setBigDecimal(stmtNumber, this.asBigDecimal());
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                byte[] value = this.asBytes();
                stmt.setBinaryStream(stmtNumber, (InputStream)new ByteArrayInputStream(value), value.length);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: {
                stmt.setString(stmtNumber, this.asString());
                break;
            }
            case 91: {
                stmt.setDate(stmtNumber, this.asDate());
                break;
            }
            case 92: {
                stmt.setTime(stmtNumber, this.asTime());
                break;
            }
            case 93: {
                stmt.setTimestamp(stmtNumber, this.asTimestamp());
                break;
            }
            case 0: {
                stmt.setNull(stmtNumber, 0);
                break;
            }
            default: {
                stmt.setString(stmtNumber, this.asString());
            }
        }
    }

    public String toString() {
        return this.asString();
    }

    public String asString() {
        if (this.isNull()) {
            return null;
        }
        if (this.isString()) {
            return (String)this.valueObject;
        }
        if (this.isBytes()) {
            return new String((byte[])this.valueObject);
        }
        return this.valueObject.toString();
    }

    public BigDecimal asBigDecimal() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBigDecimal()) {
                return (BigDecimal)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new BigDecimal(this.asString());
            }
            return null;
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public BigDecimal asBigDecimal(int scale) throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).setScale(scale);
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new BigDecimal(this.asString()).setScale(scale);
            }
            return null;
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public boolean asBoolean() throws DataSetException {
        try {
            if (this.isNull()) {
                return false;
            }
            if (this.isBoolean()) {
                return (Boolean)this.valueObject;
            }
            String check = this.asString();
            return check == null ? false : this.isTrue(check);
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Boolean asBooleanObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isBoolean()) {
                return (Boolean)this.valueObject;
            }
            String check = this.asString();
            if (check == null) {
                return null;
            }
            if (this.isTrue(check)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public int asInt() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0;
            }
            if (this.isInt()) {
                return (Integer)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject);
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).intValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).intValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).intValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).intValue();
            }
            return Integer.valueOf(this.asString());
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Integer asIntegerObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isInt()) {
                return (Integer)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isBigDecimal() || this.isLong() || this.isShort() || this.isByte()) {
                return new Integer(this.asString());
            }
            throw new DataSetException("Invalid type for Integer");
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public byte asByte() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0;
            }
            if (this.isByte()) {
                return (Byte)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).byteValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).byteValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).byteValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).byteValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).byteValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).byteValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).byteValue();
            }
            return Integer.valueOf(this.asString()).byteValue();
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Byte asByteObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isByte()) {
                return (Byte)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isBigDecimal()) {
                return new Byte(this.asString());
            }
            throw new DataSetException("Invalid type for Byte");
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public byte[] asBytes() throws DataSetException {
        try {
            if (this.isNull()) {
                return new byte[0];
            }
            if (this.isBytes()) {
                return (byte[])this.valueObject;
            }
            if (this.isString()) {
                return ((String)this.valueObject).getBytes();
            }
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
        return new byte[0];
    }

    public short asShort() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0;
            }
            if (this.isShort()) {
                return (Short)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).shortValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).shortValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).shortValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).shortValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).shortValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).shortValue();
            }
            return Integer.valueOf(this.asString()).shortValue();
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Short asShortObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isShort()) {
                return (Short)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isLong() || this.isBigDecimal() || this.isByte()) {
                return new Short(this.asString());
            }
            throw new DataSetException("Invalid type for Short");
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public long asLong() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0L;
            }
            if (this.isLong()) {
                return (Long)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).longValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).longValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).longValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).longValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).longValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).longValue();
            }
            return Integer.valueOf(this.asString()).longValue();
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Long asLongObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isLong()) {
                return (Long)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isFloat() || this.isInt() || this.isBigDecimal() || this.isShort() || this.isByte()) {
                return new Long(this.asString());
            }
            throw new DataSetException("Invalid type for Long");
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public double asDouble() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0.0;
            }
            if (this.isDouble()) {
                return (Double)this.valueObject;
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).doubleValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).doubleValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).doubleValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).doubleValue();
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).doubleValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).doubleValue();
            }
            return Integer.valueOf(this.asString()).doubleValue();
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Double asDoubleObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isDouble()) {
                return (Double)this.valueObject;
            }
            if (this.isString() || this.isBigDecimal() || this.isFloat() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new Double(this.asString());
            }
            throw new DataSetException("Invalid type for Double");
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public float asFloat() throws DataSetException {
        try {
            if (this.isNull()) {
                return 0.0f;
            }
            if (this.isFloat()) {
                return ((Float)this.valueObject).floatValue();
            }
            if (this.isString()) {
                return Integer.valueOf((String)this.valueObject).floatValue();
            }
            if (this.isShort()) {
                return ((Short)this.valueObject).floatValue();
            }
            if (this.isInt()) {
                return ((Integer)this.valueObject).floatValue();
            }
            if (this.isLong()) {
                return ((Long)this.valueObject).floatValue();
            }
            if (this.isDouble()) {
                return ((Double)this.valueObject).floatValue();
            }
            if (this.isBigDecimal()) {
                return ((BigDecimal)this.valueObject).floatValue();
            }
            return Integer.valueOf(this.asString()).floatValue();
        }
        catch (Exception e) {
            throw new DataSetException("Bad conversion: " + e.toString());
        }
    }

    public Float asFloatObj() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isFloat()) {
                return (Float)this.valueObject;
            }
            if (this.isString() || this.isDouble() || this.isBigDecimal() || this.isInt() || this.isLong() || this.isShort() || this.isByte()) {
                return new Float(this.asString());
            }
            throw new DataSetException("Invalid type for Float");
        }
        catch (Exception e) {
            throw new DataSetException("Illegal conversion: " + e.toString());
        }
    }

    public Time asTime() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isTime()) {
                return (Time)this.valueObject;
            }
            Calendar cal = Calendar.getInstance();
            if (this.isTimestamp()) {
                cal.setTime((Timestamp)this.valueObject);
                return new Time(cal.getTime().getTime());
            }
            if (this.isUtilDate()) {
                cal.setTime((java.util.Date)this.valueObject);
                return new Time(cal.getTime().getTime());
            }
            if (this.isString()) {
                return Time.valueOf((String)this.valueObject);
            }
            return Time.valueOf(this.asString());
        }
        catch (IllegalArgumentException a) {
            throw new DataSetException("Bad date value - Java Time Objects cannot be earlier than 1/1/70");
        }
        catch (Exception b) {
            throw new DataSetException("Bad conversion: " + b.toString());
        }
    }

    public Timestamp asTimestamp() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isTimestamp()) {
                return (Timestamp)this.valueObject;
            }
            if (this.isTime()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Time)this.valueObject);
                return new Timestamp(cal.getTime().getTime());
            }
            if (this.isUtilDate()) {
                return new Timestamp(((java.util.Date)this.valueObject).getTime());
            }
            if (this.isString()) {
                return Timestamp.valueOf((String)this.valueObject);
            }
            return Timestamp.valueOf(this.asString());
        }
        catch (IllegalArgumentException a) {
            throw new DataSetException("Bad date value - Java Timestamp Objects cannot be earlier than 1/1/70");
        }
        catch (Exception b) {
            throw new DataSetException("Bad conversion: " + b.toString());
        }
    }

    public Date asDate() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isDate()) {
                return (Date)this.valueObject;
            }
            Calendar cal = Calendar.getInstance();
            if (this.isTimestamp()) {
                Timestamp ts = (Timestamp)this.valueObject;
                long date = ts.getTime();
                int nanos = ts.getNanos();
                return new Date(date + (long)(nanos / 1000000));
            }
            if (this.isTime()) {
                cal.setTime((Time)this.valueObject);
                return Date.valueOf(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5));
            }
            if (this.isUtilDate()) {
                cal.setTime((java.util.Date)this.valueObject);
                return Date.valueOf(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5));
            }
            if (this.isString()) {
                return Date.valueOf((String)this.valueObject);
            }
            return Date.valueOf(this.asString());
        }
        catch (IllegalArgumentException a) {
            throw new DataSetException("Bad date value - Java Timestamp Objects cannot be earlier than 1/1/70");
        }
        catch (Exception b) {
            throw new DataSetException("Bad conversion: " + b.toString());
        }
    }

    public java.util.Date asUtilDate() throws DataSetException {
        try {
            if (this.isNull()) {
                return null;
            }
            if (this.isUtilDate()) {
                return (java.util.Date)this.valueObject;
            }
            Calendar cal = Calendar.getInstance();
            if (this.isTimestamp()) {
                Timestamp ts = (Timestamp)this.valueObject;
                long date = ts.getTime();
                int nanos = ts.getNanos();
                return new java.util.Date(date + (long)(nanos / 1000000));
            }
            if (this.isTime()) {
                cal.setTime((Time)this.valueObject);
                return Date.valueOf(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5));
            }
            if (this.isUtilDate()) {
                cal.setTime((java.util.Date)this.valueObject);
                return Date.valueOf(cal.get(1) + "-" + (cal.get(2) + 1) + "-" + cal.get(5));
            }
            return null;
        }
        catch (IllegalArgumentException a) {
            throw new DataSetException("Bad date value - Java java.util.Date Objects cannot be earlier than 1/1/70");
        }
        catch (Exception b) {
            throw new DataSetException("Bad conversion: " + b.toString());
        }
    }

    public boolean isBigDecimal() {
        return this.valueObject instanceof BigDecimal;
    }

    public boolean isByte() {
        return this.valueObject instanceof Byte;
    }

    public boolean isBytes() {
        return this.valueObject instanceof byte[];
    }

    public boolean isDate() {
        return this.valueObject instanceof Date;
    }

    public boolean isShort() {
        return this.valueObject instanceof Short;
    }

    public boolean isInt() {
        return this.valueObject instanceof Integer;
    }

    public boolean isLong() {
        return this.valueObject instanceof Long;
    }

    public boolean isDouble() {
        return this.valueObject instanceof Double;
    }

    public boolean isFloat() {
        return this.valueObject instanceof Float;
    }

    public boolean isBoolean() {
        return this.valueObject instanceof Boolean;
    }

    public boolean isNull() {
        return this.valueObject == null;
    }

    public boolean isString() {
        return this.valueObject instanceof String;
    }

    public boolean isTime() {
        return this.valueObject instanceof Time;
    }

    public boolean isTimestamp() {
        return this.valueObject instanceof Timestamp;
    }

    public boolean isUtilDate() {
        return this.valueObject instanceof java.util.Date;
    }

    public int type() {
        return this.type;
    }

    int columnNumber() {
        return this.columnNumber;
    }

    private boolean isTrue(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("y") || value.equals("1");
    }
}

