/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.platform;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.torque.engine.database.model.Domain;
import org.apache.torque.engine.database.model.SchemaType;
import org.apache.torque.engine.platform.Platform;

public class PlatformDefaultImpl
implements Platform {
    private Map schemaDomainMap;

    public PlatformDefaultImpl() {
        this.initialize();
    }

    private void initialize() {
        this.schemaDomainMap = new Hashtable(30);
        Iterator iter = SchemaType.iterator();
        while (iter.hasNext()) {
            SchemaType type = (SchemaType)((Object)iter.next());
            this.schemaDomainMap.put(type, new Domain(type));
        }
        this.schemaDomainMap.put(SchemaType.BOOLEANCHAR, new Domain(SchemaType.BOOLEANCHAR, "CHAR"));
        this.schemaDomainMap.put(SchemaType.BOOLEANINT, new Domain(SchemaType.BOOLEANINT, "INTEGER"));
    }

    protected void setSchemaDomainMapping(Domain domain) {
        this.schemaDomainMap.put(domain.getType(), domain);
    }

    public int getMaxColumnNameLength() {
        return 64;
    }

    public String getNativeIdMethod() {
        return "identity";
    }

    public Domain getDomainForSchemaType(SchemaType jdbcType) {
        return (Domain)this.schemaDomainMap.get((Object)jdbcType);
    }

    public String getNullString(boolean notNull) {
        return notNull ? "NOT NULL" : "";
    }

    public String getAutoIncrement() {
        return "IDENTITY";
    }

    public boolean hasScale(String sqlType) {
        return true;
    }

    public boolean hasSize(String sqlType) {
        return true;
    }
}

