/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.admin.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.memory.MemoryCache;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;

public class JCSAdminServlet
extends VelocityServlet {
    private static final String DEFAULT_TEMPLATE_NAME = "/org/apache/jcs/admin/servlet/JCSAdminServletDefault.vm";
    private static final String REGION_DETAIL_TEMPLATE_NAME = "/org/apache/jcs/admin/servlet/JCSAdminServletRegionDetail.vm";
    private static final String CACHE_NAME_PARAM = "cacheName";
    private static final String ACTION_PARAM = "action";
    private static final String KEY_PARAM = "key";
    private static final String SILENT_PARAM = "silent";
    private static final String CLEAR_ALL_REGIONS_ACTION = "clearAllRegions";
    private static final String CLEAR_REGION_ACTION = "clearRegion";
    private static final String REMOVE_ACTION = "remove";
    private static final String DETAIL_ACTION = "detail";
    private CompositeCacheManager cacheHub = CompositeCacheManager.getInstance();

    protected Template handleRequest(HttpServletRequest request, HttpServletResponse response, Context context) throws Exception {
        String templateName = DEFAULT_TEMPLATE_NAME;
        String cacheName = request.getParameter(CACHE_NAME_PARAM);
        String action = request.getParameter(ACTION_PARAM);
        if (action != null) {
            if (action.equals(CLEAR_ALL_REGIONS_ACTION)) {
                this.clearAllRegions();
            } else if (action.equals(CLEAR_REGION_ACTION)) {
                if (cacheName != null) {
                    this.clearRegion(cacheName);
                }
            } else if (action.equals(REMOVE_ACTION)) {
                String[] keys = request.getParameterValues(KEY_PARAM);
                for (int i = 0; i < keys.length; ++i) {
                    this.removeItem(cacheName, keys[i]);
                }
                templateName = REGION_DETAIL_TEMPLATE_NAME;
            } else if (action.equals(DETAIL_ACTION)) {
                templateName = REGION_DETAIL_TEMPLATE_NAME;
            }
        }
        if (request.getParameter(SILENT_PARAM) != null) {
            return null;
        }
        if (templateName == REGION_DETAIL_TEMPLATE_NAME) {
            context.put(CACHE_NAME_PARAM, (Object)cacheName);
            context.put("elementInfoRecords", (Object)this.buildElementInfo(cacheName));
        } else if (templateName == DEFAULT_TEMPLATE_NAME) {
            context.put("cacheInfoRecords", (Object)this.buildCacheInfo());
        }
        return this.getTemplate(templateName);
    }

    private LinkedList buildElementInfo(String cacheName) throws Exception {
        CompositeCache cache = this.cacheHub.getCache(cacheName);
        Object[] keys = cache.getMemoryCache().getKeyArray();
        try {
            Arrays.sort(keys);
        }
        catch (Exception e) {
            keys = cache.getMemoryCache().getKeyArray();
        }
        LinkedList<CacheElementInfo> records = new LinkedList<CacheElementInfo>();
        DateFormat format = DateFormat.getDateTimeInstance(3, 3);
        long now = System.currentTimeMillis();
        for (int i = 0; i < keys.length; ++i) {
            ICacheElement element = cache.getMemoryCache().getQuiet((Serializable)keys[i]);
            IElementAttributes attributes = element.getElementAttributes();
            CacheElementInfo elementInfo = new CacheElementInfo();
            elementInfo.key = String.valueOf(keys[i]);
            elementInfo.eternal = attributes.getIsEternal();
            elementInfo.maxLifeSeconds = attributes.getMaxLifeSeconds();
            elementInfo.createTime = format.format(new Date(attributes.getCreateTime()));
            elementInfo.expiresInSeconds = (now - attributes.getCreateTime() - attributes.getMaxLifeSeconds() * 1000L) / -1000L;
            records.add(elementInfo);
        }
        return records;
    }

    private LinkedList buildCacheInfo() throws Exception {
        Object[] cacheNames = this.cacheHub.getCacheNames();
        Arrays.sort(cacheNames);
        LinkedList<CacheRegionInfo> cacheInfo = new LinkedList<CacheRegionInfo>();
        for (int i = 0; i < cacheNames.length; ++i) {
            CompositeCache cache = this.cacheHub.getCache((String)cacheNames[i]);
            CacheRegionInfo regionInfo = new CacheRegionInfo();
            regionInfo.cache = cache;
            regionInfo.byteCount = this.getByteCount(cache);
            cacheInfo.add(regionInfo);
        }
        return cacheInfo;
    }

    public int getByteCount(CompositeCache cache) throws Exception {
        MemoryCache memCache = cache.getMemoryCache();
        Iterator iter = memCache.getIterator();
        CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(counter);
        while (iter.hasNext()) {
            ICacheElement ce = (ICacheElement)((Map.Entry)iter.next()).getValue();
            out.writeObject(ce.getVal());
        }
        return counter.getCount() - 4;
    }

    private void clearAllRegions() throws IOException {
        String[] names = this.cacheHub.getCacheNames();
        for (int i = 0; i < names.length; ++i) {
            this.cacheHub.getCache(names[i]).removeAll();
        }
    }

    private void clearRegion(String cacheName) throws IOException {
        this.cacheHub.getCache(cacheName).removeAll();
    }

    private void removeItem(String cacheName, String key) throws IOException {
        this.cacheHub.getCache(cacheName).remove((Serializable)((Object)key));
    }

    private static class CountingOnlyOutputStream
    extends OutputStream {
        private int count;

        private CountingOnlyOutputStream() {
        }

        public void write(byte[] b) throws IOException {
            this.count += b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
        }

        public void write(int b) throws IOException {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public class CacheElementInfo {
        String key = null;
        boolean eternal = false;
        String createTime = null;
        long maxLifeSeconds = -1L;
        long expiresInSeconds = -1L;

        public String getKey() {
            return this.key;
        }

        public boolean isEternal() {
            return this.eternal;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public long getMaxLifeSeconds() {
            return this.maxLifeSeconds;
        }

        public long getExpiresInSeconds() {
            return this.expiresInSeconds;
        }
    }

    public class CacheRegionInfo {
        CompositeCache cache = null;
        long byteCount = 0L;

        public CompositeCache getCache() {
            return this.cache;
        }

        public long getByteCount() {
            return this.byteCount;
        }

        public String getStatus() {
            int status = this.cache.getStatus();
            return status == 1 ? "ALIVE" : (status == 2 ? "DISPOSED" : (status == 3 ? "ERROR" : "UNKNOWN"));
        }
    }
}

