/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWaitFacade;

public class RemoteCacheFailoverRunner
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheFailoverRunner == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheFailoverRunner = RemoteCacheFailoverRunner.class$("org.apache.jcs.auxiliary.remote.RemoteCacheFailoverRunner")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheFailoverRunner));
    private RemoteCacheNoWaitFacade facade;
    private static long idlePeriod = 20000L;
    private boolean alright = true;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheFailoverRunner;

    public RemoteCacheFailoverRunner(RemoteCacheNoWaitFacade facade) {
        this.facade = facade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyError() {
        this.bad();
        RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
        synchronized (remoteCacheFailoverRunner) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        do {
            String[] failovers;
            log.debug((Object)"cache failover running.");
            if (!this.alright) {
                int i;
                failovers = this.facade.rca.getFailovers();
                int fidx = this.facade.rca.getFailoverIndex();
                log.debug((Object)("fidx = " + fidx + " failovers.length = " + failovers.length));
                log.debug((Object)("i = " + i));
                for (i = fidx + 1; i < failovers.length; ++i) {
                    log.debug((Object)("i = " + i));
                    String server = failovers[i];
                    RemoteCacheAttributes rca = null;
                    try {
                        rca = (RemoteCacheAttributes)this.facade.rca.copy();
                        rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                        rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                        RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca);
                        log.debug((Object)("RemoteCacheAttributes for failover = " + rca.toString()));
                        AuxiliaryCache ic = rcm.getCache(rca.getCacheName());
                        if (ic == null || ic.getStatus() != 1) continue;
                        log.debug((Object)"reseting no wait");
                        this.facade.noWaits = new RemoteCacheNoWait[1];
                        this.facade.noWaits[0] = (RemoteCacheNoWait)ic;
                        this.facade.rca.setFailoverIndex(i);
                        RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
                        synchronized (remoteCacheFailoverRunner) {
                            log.debug((Object)"setting ALRIGHT to true, moving to Primary Recovery Mode");
                            this.alright = true;
                            log.debug((Object)("CONNECTED to " + rca.getRemoteHost() + ":" + rca.getRemotePort() + "\n\n"));
                            continue;
                        }
                    }
                    catch (Exception ex) {
                        this.bad();
                        log.debug((Object)("FAILED to connect to " + rca.getRemoteHost() + ":" + rca.getRemotePort()));
                        log.error((Object)ex.toString());
                    }
                }
            } else {
                log.warn((Object)"ALRIGHT is true --  failover runner is in primary recovery mode");
            }
            failovers = this.facade.rca.getFailovers();
            String server = failovers[0];
            try {
                RemoteCacheAttributes rca = (RemoteCacheAttributes)this.facade.rca.copy();
                rca.setRemoteHost(server.substring(0, server.indexOf(":")));
                rca.setRemotePort(Integer.parseInt(server.substring(server.indexOf(":") + 1)));
                RemoteCacheManager rcm = RemoteCacheManager.getInstance(rca);
                AuxiliaryCache ic = rcm.getCache(rca.getCacheName());
                if (ic != null && ic.getStatus() == 1) {
                    log.debug((Object)"reseting no wait to PRIMARY");
                    this.facade.noWaits = new RemoteCacheNoWait[1];
                    this.facade.noWaits[0] = (RemoteCacheNoWait)ic;
                    this.facade.rca.setFailoverIndex(0);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            try {
                log.debug((Object)("cache failover runner sleeping for " + idlePeriod));
                Thread.currentThread();
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.facade.rca.getFailoverIndex() > 0);
        log.debug((Object)"exiting failover runner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bad() {
        if (this.alright) {
            RemoteCacheFailoverRunner remoteCacheFailoverRunner = this;
            synchronized (remoteCacheFailoverRunner) {
                this.alright = false;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

