/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.net.xmlrpc.JabberRPCException;
import groovy.net.xmlrpc.RPCServerProxy;
import groovy.net.xmlrpc.XMLRPCCallFailureException;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;
import uk.co.wilson.smackx.packet.JabberRPC;

public class JabberRPCServerProxy
extends RPCServerProxy {
    private final XMPPConnection connection;
    private final String to;

    public JabberRPCServerProxy(XMPPConnection connection, String to) {
        this.connection = connection;
        this.to = to;
        this.connection.sendPacket((Packet)new Presence(Presence.Type.AVAILABLE, "Jabber.RPC Client", 1, Presence.Mode.AVAILABLE));
    }

    public Object invokeMethod(String name, Object args) {
        if ("invokeMethod".equals(name)) {
            return super.invokeMethod(name, args);
        }
        Object[] params = args instanceof List ? ((List)args).toArray() : (Object[])args;
        int numberOfparams = params.length;
        if (numberOfparams != 0 && params[numberOfparams - 1] instanceof Closure) {
            --numberOfparams;
        }
        try {
            final JabberRPC request = new JabberRPC(XMLRPCMessageProcessor.emitCall(new StringBuffer(), name, params, numberOfparams).toString());
            PacketCollector responseCollector = this.connection.createPacketCollector(new PacketFilter(){

                public boolean accept(Packet packet) {
                    return packet instanceof JabberRPC && ((JabberRPC)packet).getType() == IQ.Type.RESULT && packet.getPacketID().equals(request.getPacketID());
                }
            });
            request.setType(IQ.Type.SET);
            request.setTo(this.getId(this.connection.getRoster(), this.to));
            request.setFrom(this.connection.getUser());
            this.connection.sendPacket((Packet)request);
            JabberRPC response = (JabberRPC)responseCollector.nextResult(20000L);
            responseCollector.cancel();
            if (response == null) {
                throw new XMLRPCCallFailureException((Object)"call timed out", new Integer(0));
            }
            XMLRPCMessageProcessor responseParser = new XMLRPCMessageProcessor();
            responseParser.parseMessage(response.getChildElementXML());
            List result = responseParser.getParams();
            if (result == null) {
                throw new XMLRPCCallFailureException((Object)"Empty response from server", new Integer(0));
            }
            if (numberOfparams == params.length) {
                return result.get(0);
            }
            Closure closure = (Closure)params[numberOfparams];
            closure.setDelegate(this);
            return closure.call(new Object[]{result.get(0)});
        }
        catch (IOException e) {
            throw new XMLRPCCallFailureException((Object)e.getMessage(), new Integer(0));
        }
        catch (XMLRPCFailException e) {
            throw new XMLRPCCallFailureException((Object)e.getFaultString(), (Object)e.getCause());
        }
    }

    private String getId(Roster roster, String to) {
        String posTo;
        block5: {
            int retries = 20;
            posTo = to;
            while (true) {
                Iterator iter = roster.getPresences(to);
                int pri = Integer.MIN_VALUE;
                if (iter != null) {
                    while (iter.hasNext()) {
                        Presence presence = (Presence)iter.next();
                        if (presence.getPriority() <= pri) continue;
                        posTo = presence.getFrom();
                        pri = presence.getPriority();
                    }
                }
                if (pri >= 0) break block5;
                if (retries-- <= 0) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            throw new JabberRPCException("User " + posTo + " not available");
        }
        return posTo;
    }
}

