/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.classgen.Variable;

public class CompileStack
implements Opcodes {
    private boolean clear = true;
    private VariableScope scope;
    private Label continueLabel;
    private Label breakLabel;
    private Label finallyLabel;
    private HashMap stackVariables = new HashMap();
    private int currentVariableIndex = 1;
    private int nextVariableIndex = 1;
    private LinkedList temporaryVariables = new LinkedList();
    private LinkedList usedVariables = new LinkedList();
    private HashMap superBlockNamedLabels = new HashMap();
    private HashMap currentBlockNamedLabels = new HashMap();
    private Label thisStartLabel;
    private Label thisEndLabel;
    private int currentClassIndex;
    private int currentMetaClassIndex;
    private MethodVisitor mv;
    private BytecodeHelper helper;
    private LinkedList stateStack = new LinkedList();
    private int localVariableOffset;
    private HashMap namedLoopBreakLabel = new HashMap();
    private HashMap namedLoopContinueLabel = new HashMap();
    private String className;

    private void pushState() {
        this.stateStack.add(new StateStackElement());
        this.stackVariables = new HashMap(this.stackVariables);
    }

    private void popState() {
        if (this.stateStack.size() == 0) {
            throw new GroovyBugError("Tried to do a pop on the compile stack without push.");
        }
        StateStackElement element = (StateStackElement)this.stateStack.removeLast();
        this.scope = element._scope;
        this.continueLabel = element._continueLabel;
        this.breakLabel = element._breakLabel;
        this.finallyLabel = element._finallyLabel;
        this.currentVariableIndex = element._lastVariableIndex;
        this.stackVariables = element._stackVariables;
        this.nextVariableIndex = element._nextVariableIndex;
    }

    public Label getContinueLabel() {
        return this.continueLabel;
    }

    public Label getBreakLabel() {
        return this.breakLabel;
    }

    public void removeVar(int tempIndex) {
        Iterator iter = this.temporaryVariables.iterator();
        while (iter.hasNext()) {
            Variable element = (Variable)iter.next();
            if (element.getIndex() != tempIndex) continue;
            iter.remove();
            return;
        }
        throw new GroovyBugError("CompileStack#removeVar: tried to remove a temporary variable with a non existent index");
    }

    private void setEndLabels() {
        Label endLabel = new Label();
        this.mv.visitLabel(endLabel);
        Iterator iter = this.stackVariables.values().iterator();
        while (iter.hasNext()) {
            Variable var = (Variable)iter.next();
            var.setEndLabel(endLabel);
        }
        this.thisEndLabel = endLabel;
    }

    public void pop() {
        this.setEndLabels();
        this.popState();
    }

    public VariableScope getScope() {
        return this.scope;
    }

    public int defineTemporaryVariable(org.codehaus.groovy.ast.Variable var, boolean store) {
        return this.defineTemporaryVariable(var.getName(), var.getType(), store);
    }

    public Variable getVariable(String variableName) {
        return this.getVariable(variableName, true);
    }

    public Variable getVariable(String variableName, boolean mustExist) {
        if (variableName.equals("this")) {
            return Variable.THIS_VARIABLE;
        }
        if (variableName.equals("super")) {
            return Variable.SUPER_VARIABLE;
        }
        Variable v = (Variable)this.stackVariables.get(variableName);
        if (v == null && mustExist) {
            throw new GroovyBugError("tried to get a variable with the name " + variableName + " as stack variable, but a variable with this name was not created");
        }
        return v;
    }

    public int defineTemporaryVariable(String name, boolean store) {
        return this.defineTemporaryVariable(name, ClassHelper.DYNAMIC_TYPE, store);
    }

    public int defineTemporaryVariable(String name, ClassNode node, boolean store) {
        Variable answer = this.defineVar(name, node, false);
        this.temporaryVariables.add(answer);
        this.usedVariables.removeLast();
        if (store) {
            this.mv.visitVarInsn(58, this.currentVariableIndex);
        }
        return answer.getIndex();
    }

    private void resetVariableIndex(boolean isStatic) {
        if (!isStatic) {
            this.currentVariableIndex = 1;
            this.nextVariableIndex = 1;
        } else {
            this.currentVariableIndex = 0;
            this.nextVariableIndex = 0;
        }
    }

    public void clear() {
        if (this.stateStack.size() > 1) {
            int size = this.stateStack.size() - 1;
            throw new GroovyBugError("the compile stack contains " + size + " more push instruction" + (size == 1 ? "" : "s") + " than pops.");
        }
        this.clear = true;
        if (this.thisEndLabel == null) {
            this.setEndLabels();
        }
        if (!this.scope.isInStaticContext()) {
            this.mv.visitLocalVariable("this", this.className, null, this.thisStartLabel, this.thisEndLabel, 0);
        }
        Iterator iterator = this.usedVariables.iterator();
        while (iterator.hasNext()) {
            Variable v = (Variable)iterator.next();
            String type = BytecodeHelper.getTypeDescription(v.getType());
            Label start = v.getStartLabel();
            Label end = v.getEndLabel();
            this.mv.visitLocalVariable(v.getName(), type, null, start, end, v.getIndex());
        }
        this.pop();
        this.stackVariables.clear();
        this.usedVariables.clear();
        this.scope = null;
        this.mv = null;
        this.resetVariableIndex(false);
        this.superBlockNamedLabels.clear();
        this.currentBlockNamedLabels.clear();
        this.namedLoopBreakLabel.clear();
        this.namedLoopContinueLabel.clear();
        this.continueLabel = null;
        this.breakLabel = null;
        this.finallyLabel = null;
        this.helper = null;
        this.thisStartLabel = null;
        this.thisEndLabel = null;
    }

    protected void init(VariableScope el, Parameter[] parameters, MethodVisitor mv, ClassNode cn) {
        if (!this.clear) {
            throw new GroovyBugError("CompileStack#init called without calling clear before");
        }
        this.clear = false;
        this.pushVariableScope(el);
        this.mv = mv;
        this.helper = new BytecodeHelper(mv);
        this.defineMethodVariables(parameters, el.isInStaticContext());
        this.className = BytecodeHelper.getTypeDescription(cn);
        this.currentClassIndex = -1;
        this.currentMetaClassIndex = -1;
    }

    protected void pushVariableScope(VariableScope el) {
        this.pushState();
        this.scope = el;
        this.superBlockNamedLabels = new HashMap(this.superBlockNamedLabels);
        this.superBlockNamedLabels.putAll(this.currentBlockNamedLabels);
        this.currentBlockNamedLabels = new HashMap();
    }

    protected void pushLoop(VariableScope el, String labelName) {
        this.pushVariableScope(el);
        this.initLoopLabels(labelName);
    }

    private void initLoopLabels(String labelName) {
        this.continueLabel = new Label();
        this.breakLabel = new Label();
        if (labelName != null) {
            this.namedLoopBreakLabel.put(labelName, this.breakLabel);
            this.namedLoopContinueLabel.put(labelName, this.continueLabel);
        }
    }

    protected void pushLoop(String labelName) {
        this.pushState();
        this.initLoopLabels(labelName);
    }

    protected Label getNamedBreakLabel(String name) {
        Label label = this.getBreakLabel();
        Label endLabel = (Label)this.namedLoopBreakLabel.get(name);
        if (endLabel != null) {
            label = endLabel;
        }
        return label;
    }

    protected Label getNamedContinueLabel(String name) {
        Label label = this.getLabel(name);
        Label endLabel = (Label)this.namedLoopContinueLabel.get(name);
        if (endLabel != null) {
            label = endLabel;
        }
        return label;
    }

    protected Label pushFinally() {
        this.pushState();
        this.finallyLabel = new Label();
        return this.finallyLabel;
    }

    protected Label pushSwitch() {
        this.pushState();
        this.breakLabel = new Label();
        return this.breakLabel;
    }

    protected void pushBooleanExpression() {
        this.pushState();
    }

    public Label getFinallyLabel() {
        return this.finallyLabel;
    }

    private Variable defineVar(String name, ClassNode type, boolean methodParameterUsedInClosure) {
        this.makeNextVariableID(type);
        int index = this.currentVariableIndex;
        if (methodParameterUsedInClosure) {
            index = this.localVariableOffset++;
        }
        Variable answer = new Variable(index, type, name);
        this.usedVariables.add(answer);
        answer.setHolder(methodParameterUsedInClosure);
        return answer;
    }

    private void makeLocalVariablesOffset(Parameter[] paras, boolean isInStaticContext) {
        this.resetVariableIndex(isInStaticContext);
        for (int i = 0; i < paras.length; ++i) {
            this.makeNextVariableID(paras[i].getType());
        }
        this.localVariableOffset = this.nextVariableIndex;
        this.resetVariableIndex(isInStaticContext);
    }

    private void defineMethodVariables(Parameter[] paras, boolean isInStaticContext) {
        Label startLabel;
        this.thisStartLabel = startLabel = new Label();
        this.mv.visitLabel(startLabel);
        this.makeLocalVariablesOffset(paras, isInStaticContext);
        boolean hasHolder = false;
        for (int i = 0; i < paras.length; ++i) {
            Variable answer;
            String name = paras[i].getName();
            if (paras[i].isClosureSharedVariable()) {
                answer = this.defineVar(name, ClassHelper.getWrapper(paras[i].getType()), true);
                ClassNode type = paras[i].getType();
                this.helper.load(type, this.currentVariableIndex);
                this.helper.box(type);
                this.createReference(answer);
                hasHolder = true;
            } else {
                answer = this.defineVar(name, paras[i].getType(), false);
            }
            answer.setStartLabel(startLabel);
            this.stackVariables.put(name, answer);
        }
        if (hasHolder) {
            this.nextVariableIndex = this.localVariableOffset;
        }
    }

    private void createReference(Variable reference) {
        this.mv.visitTypeInsn(187, "groovy/lang/Reference");
        this.mv.visitInsn(90);
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(183, "groovy/lang/Reference", "<init>", "(Ljava/lang/Object;)V");
        this.mv.visitVarInsn(58, reference.getIndex());
    }

    public Variable defineVariable(org.codehaus.groovy.ast.Variable v, boolean initFromStack) {
        String name = v.getName();
        Variable answer = this.defineVar(name, v.getType(), false);
        if (v.isClosureSharedVariable()) {
            answer.setHolder(true);
        }
        this.stackVariables.put(name, answer);
        Label startLabel = new Label();
        answer.setStartLabel(startLabel);
        if (answer.isHolder()) {
            if (!initFromStack) {
                this.mv.visitInsn(1);
            }
            this.createReference(answer);
        } else {
            if (!initFromStack) {
                this.mv.visitInsn(1);
            }
            this.mv.visitVarInsn(58, this.currentVariableIndex);
        }
        this.mv.visitLabel(startLabel);
        return answer;
    }

    public boolean containsVariable(String name) {
        return this.stackVariables.containsKey(name);
    }

    private void makeNextVariableID(ClassNode type) {
        this.currentVariableIndex = this.nextVariableIndex;
        if (type == ClassHelper.long_TYPE || type == ClassHelper.double_TYPE) {
            ++this.nextVariableIndex;
        }
        ++this.nextVariableIndex;
    }

    public Label getLabel(String name) {
        if (name == null) {
            return null;
        }
        Label l = (Label)this.superBlockNamedLabels.get(name);
        if (l == null) {
            l = this.createLocalLabel(name);
        }
        return l;
    }

    public Label createLocalLabel(String name) {
        Label l = (Label)this.currentBlockNamedLabels.get(name);
        if (l == null) {
            l = new Label();
            this.currentBlockNamedLabels.put(name, l);
        }
        return l;
    }

    public int getCurrentClassIndex() {
        return this.currentClassIndex;
    }

    public void setCurrentClassIndex(int index) {
        this.currentClassIndex = index;
    }

    public int getCurrentMetaClassIndex() {
        return this.currentMetaClassIndex;
    }

    public void setCurrentMetaClassIndex(int index) {
        this.currentMetaClassIndex = index;
    }

    private class StateStackElement {
        VariableScope _scope;
        Label _continueLabel;
        Label _breakLabel;
        Label _finallyLabel;
        int _lastVariableIndex;
        int _nextVariableIndex;
        HashMap _stackVariables;
        LinkedList _temporaryVariables = new LinkedList();
        LinkedList _usedVariables = new LinkedList();
        HashMap _superBlockNamedLabels;
        HashMap _currentBlockNamedLabels;

        StateStackElement() {
            this._scope = CompileStack.this.scope;
            this._continueLabel = CompileStack.this.continueLabel;
            this._breakLabel = CompileStack.this.breakLabel;
            this._lastVariableIndex = CompileStack.this.currentVariableIndex;
            this._stackVariables = CompileStack.this.stackVariables;
            this._temporaryVariables = CompileStack.this.temporaryVariables;
            this._nextVariableIndex = CompileStack.this.nextVariableIndex;
            this._finallyLabel = CompileStack.this.finallyLabel;
            this._superBlockNamedLabels = CompileStack.this.superBlockNamedLabels;
            this._currentBlockNamedLabels = CompileStack.this.currentBlockNamedLabels;
        }
    }
}

