/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.xml;

import groovy.util.IndentPrinter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DomToGroovy {
    private IndentPrinter out;

    public DomToGroovy(PrintWriter out) {
        this(new IndentPrinter(out));
    }

    public DomToGroovy(IndentPrinter out) {
        this.out = out;
    }

    public void print(Document document) {
        this.printChildren(document, new HashMap());
    }

    protected void print(Node node, Map namespaces, boolean endWithComma) {
        switch (node.getNodeType()) {
            case 1: {
                this.printElement((Element)node, namespaces, endWithComma);
                break;
            }
            case 7: {
                this.printPI((ProcessingInstruction)node, endWithComma);
                break;
            }
            case 3: {
                this.printText((Text)node, endWithComma);
                break;
            }
            case 8: {
                this.printComment((Comment)node, endWithComma);
            }
        }
    }

    protected void printElement(Element element, Map namespaces, boolean endWithComma) {
        namespaces = this.defineNamespaces(element, namespaces);
        element.normalize();
        this.printIndent();
        String prefix = element.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            this.print(prefix);
            this.print(".");
        }
        this.print(this.getLocalName(element));
        boolean hasAttributes = this.printAttributes(element);
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        if (length == 0) {
            this.printEnd(hasAttributes ? ")" : "()", endWithComma);
        } else {
            Node node = list.item(0);
            if (length == 1 && node instanceof Text) {
                Text textNode = (Text)node;
                String text = this.getTextNodeData(textNode);
                if (hasAttributes) {
                    this.print(", '");
                } else {
                    this.print("('");
                }
                this.print(text);
                this.printEnd("')", endWithComma);
            } else if (this.mixedContent(list)) {
                this.println(" [");
                this.out.incrementIndent();
                for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                    boolean useComma = node.getNextSibling() != null;
                    this.print(node, namespaces, useComma);
                }
                this.out.decrementIndent();
                this.printIndent();
                this.printEnd("]", endWithComma);
            } else {
                this.println(") {");
                this.out.incrementIndent();
                this.printChildren(element, namespaces);
                this.out.decrementIndent();
                this.printIndent();
                this.printEnd("}", endWithComma);
            }
        }
    }

    protected void printPI(ProcessingInstruction instruction, boolean endWithComma) {
        this.printIndent();
        this.print("xml.pi('");
        this.print(instruction.getTarget());
        this.print("', '");
        this.print(instruction.getData());
        this.printEnd("');", endWithComma);
    }

    protected void printComment(Comment comment, boolean endWithComma) {
        String text = comment.getData().trim();
        if (text.length() > 0) {
            this.printIndent();
            this.print("/* ");
            this.print(text);
            this.printEnd(" */", endWithComma);
        }
    }

    protected void printText(Text node, boolean endWithComma) {
        String text = this.getTextNodeData(node);
        if (text.length() > 0) {
            this.printIndent();
            this.print("'");
            this.print(text);
            this.printEnd("'", endWithComma);
        }
    }

    protected Map defineNamespaces(Element element, Map namespaces) {
        HashMap answer = null;
        String prefix = element.getPrefix();
        if (prefix != null && prefix.length() > 0 && !namespaces.containsKey(prefix)) {
            answer = new HashMap(namespaces);
            this.defineNamespace(answer, prefix, element.getNamespaceURI());
        }
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attribute = (Attr)attributes.item(i);
            prefix = attribute.getPrefix();
            if (prefix == null || prefix.length() <= 0 || namespaces.containsKey(prefix)) continue;
            if (answer == null) {
                answer = new HashMap(namespaces);
            }
            this.defineNamespace(answer, prefix, attribute.getNamespaceURI());
        }
        return answer != null ? answer : namespaces;
    }

    protected void defineNamespace(Map namespaces, String prefix, String uri) {
        namespaces.put(prefix, uri);
        if (!prefix.equals("xmlns") && !prefix.equals("xml")) {
            this.printIndent();
            this.print(prefix);
            this.print(" = xmlns.namespace('");
            this.print(uri);
            this.println("')");
        }
    }

    protected boolean printAttributes(Element element) {
        boolean hasAttribute = false;
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        if (length > 0) {
            int i;
            StringBuffer buffer = new StringBuffer();
            for (i = 0; i < length; ++i) {
                this.printAttributeWithPrefix((Attr)attributes.item(i), buffer);
            }
            this.print("(");
            for (i = 0; i < length; ++i) {
                hasAttribute = this.printAttributeWithoutPrefix((Attr)attributes.item(i), hasAttribute);
            }
            if (buffer.length() > 0) {
                if (hasAttribute) {
                    this.print(", ");
                }
                this.print("xmlns=[");
                this.print(buffer.toString());
                this.print("]");
                hasAttribute = true;
            }
        }
        return hasAttribute;
    }

    private void printAttributeWithPrefix(Attr attribute, StringBuffer buffer) {
        String prefix = attribute.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(prefix);
            buffer.append(".");
            buffer.append(this.getLocalName(attribute));
            buffer.append(":'");
            buffer.append(attribute.getValue());
            buffer.append("'");
        }
    }

    private boolean printAttributeWithoutPrefix(Attr attribute, boolean hasAttribute) {
        String prefix = attribute.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            if (!hasAttribute) {
                hasAttribute = true;
            } else {
                this.print(", ");
            }
            this.print(this.getLocalName(attribute));
            this.print(":'");
            this.print(attribute.getValue());
            this.print("'");
        }
        return hasAttribute;
    }

    protected String getTextNodeData(Text node) {
        return node.getData().trim();
    }

    protected boolean mixedContent(NodeList list) {
        boolean hasText = false;
        boolean hasElement = false;
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            String text;
            Node node = list.item(i);
            if (node instanceof Element) {
                hasElement = true;
                continue;
            }
            if (!(node instanceof Text) || (text = this.getTextNodeData((Text)node)).length() <= 0) continue;
            hasText = true;
        }
        return hasText && hasElement;
    }

    protected void printChildren(Node parent, Map namespaces) {
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.print(node, namespaces, false);
        }
    }

    protected String getLocalName(Node node) {
        String answer = node.getLocalName();
        if (answer == null) {
            answer = node.getNodeName();
        }
        return answer.trim();
    }

    protected void printEnd(String text, boolean endWithComma) {
        if (endWithComma) {
            this.print(text);
            this.println(",");
        } else {
            this.println(text);
        }
    }

    protected void println(String text) {
        this.out.println(text);
    }

    protected void print(String text) {
        this.out.print(text);
    }

    protected void printIndent() {
        this.out.printIndent();
    }
}

