/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;

public final class SQLDecimal
extends NumberDataType
implements VariableSizeDataValue {
    private static final BigDecimal ZERO;
    private static final BigDecimal ONE;
    static final BigDecimal MAXLONG_PLUS_ONE;
    static final BigDecimal MINLONG_MINUS_ONE;
    private BigDecimal value;
    private byte[] rawData;
    private int rawScale;
    private static final int BASE_MEMORY_USAGE;
    private static final int BIG_DECIMAL_MEMORY_USAGE;
    private static final Method toPlainString;
    private static final Method bdPrecision;
    static /* synthetic */ Class class$org$apache$derby$iapi$types$SQLDecimal;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        if (null != this.value) {
            n += BIG_DECIMAL_MEMORY_USAGE + (this.value.unscaledValue().bitLength() + 8) / 8;
        }
        if (null != this.rawData) {
            n += this.rawData.length;
        }
        return n;
    }

    public SQLDecimal() {
    }

    public SQLDecimal(BigDecimal bigDecimal) {
        this.value = bigDecimal;
    }

    public SQLDecimal(BigDecimal bigDecimal, int n, int n2) throws StandardException {
        this.value = bigDecimal;
        if (this.value != null && n2 >= 0) {
            this.value = this.value.setScale(n2, 1);
        }
    }

    public SQLDecimal(String string) {
        this.value = new BigDecimal(string);
    }

    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "INTEGER");
    }

    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -128L && l <= 127L) {
                return (byte)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "TINYINT");
    }

    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            long l = this.getLong();
            if (l >= -32768L && l <= 32767L) {
                return (short)l;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        throw StandardException.newException("22003", "SMALLINT");
    }

    public long getLong() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0L;
        }
        if (bigDecimal.compareTo(MINLONG_MINUS_ONE) == 1 && bigDecimal.compareTo(MAXLONG_PLUS_ONE) == -1) {
            return bigDecimal.longValue();
        }
        throw StandardException.newException("22003", "BIGINT");
    }

    public float getFloat() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0.0f;
        }
        float f = NumberDataType.normalizeREAL(bigDecimal.floatValue());
        return f;
    }

    public double getDouble() throws StandardException {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return 0.0;
        }
        double d = NumberDataType.normalizeDOUBLE(bigDecimal.doubleValue());
        return d;
    }

    private BigDecimal getBigDecimal() {
        if (this.value == null && this.rawData != null) {
            this.value = new BigDecimal(new BigInteger(this.rawData), this.rawScale);
        }
        return this.value;
    }

    public int typeToBigDecimal() {
        return 3;
    }

    public boolean getBoolean() {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return false;
        }
        return bigDecimal.compareTo(ZERO) != 0;
    }

    public String getString() {
        BigDecimal bigDecimal = this.getBigDecimal();
        if (bigDecimal == null) {
            return null;
        }
        if (JVMInfo.JDK_ID < 6) {
            return bigDecimal.toString();
        }
        try {
            return (String)toPlainString.invoke((Object)bigDecimal, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalAccessError("toPlainString");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IncompatibleClassChangeError("toPlainString");
        }
    }

    public Object getObject() {
        return this.getBigDecimal();
    }

    void setObject(Object object) throws StandardException {
        this.setValue((BigDecimal)object);
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setCoreValue(SQLDecimal.getBigDecimal(dataValueDescriptor));
    }

    public int getLength() {
        return this.getDecimalValuePrecision();
    }

    public String getTypeName() {
        return "DECIMAL";
    }

    public int getTypeFormatId() {
        return 200;
    }

    public boolean isNull() {
        return this.value == null && this.rawData == null;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        byte[] byArray;
        int n;
        if (this.value != null) {
            n = this.value.scale();
            if (n < 0) {
                n = 0;
                this.value = this.value.setScale(0);
            }
            BigInteger bigInteger = this.value.unscaledValue();
            byArray = bigInteger.toByteArray();
        } else {
            n = this.rawScale;
            byArray = this.rawData;
        }
        objectOutput.writeByte(n);
        objectOutput.writeByte(byArray.length);
        objectOutput.write(byArray);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = null;
        this.rawScale = objectInput.readUnsignedByte();
        int n = objectInput.readUnsignedByte();
        if (this.rawData == null || n != this.rawData.length) {
            this.rawData = new byte[n];
        }
        objectInput.readFully(this.rawData);
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.value = null;
        this.rawScale = arrayInputStream.readUnsignedByte();
        int n = arrayInputStream.readUnsignedByte();
        if (this.rawData == null || n != this.rawData.length) {
            this.rawData = new byte[n];
        }
        arrayInputStream.readFully(this.rawData);
    }

    public void restoreToNull() {
        this.value = null;
        this.rawData = null;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        BigDecimal bigDecimal = SQLDecimal.getBigDecimal(dataValueDescriptor);
        return this.getBigDecimal().compareTo(bigDecimal);
    }

    public DataValueDescriptor getClone() {
        return new SQLDecimal(this.getBigDecimal());
    }

    public DataValueDescriptor getNewNull() {
        return new SQLDecimal();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getBigDecimal(n);
        this.rawData = null;
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, 3);
            return;
        }
        preparedStatement.setBigDecimal(n, this.getBigDecimal());
    }

    public void setValue(String string) throws StandardException {
        this.rawData = null;
        if (string == null) {
            this.value = null;
        } else {
            try {
                string = string.trim();
                this.value = new BigDecimal(string);
                this.rawData = null;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
        }
    }

    public void setValue(double d) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeDOUBLE(d));
    }

    public void setValue(float f) throws StandardException {
        this.setCoreValue(NumberDataType.normalizeREAL(f));
    }

    public void setValue(long l) {
        this.value = BigDecimal.valueOf(l);
        this.rawData = null;
    }

    public void setValue(int n) {
        this.setValue((long)n);
    }

    public void setBigDecimal(Number number) throws StandardException {
        this.setCoreValue((BigDecimal)number);
    }

    public void setValue(Number number) throws StandardException {
        if (number instanceof BigDecimal || number == null) {
            this.setCoreValue((BigDecimal)number);
        } else {
            this.setValue(number.longValue());
        }
    }

    public void setValue(boolean bl) {
        this.setCoreValue(bl ? ONE : ZERO);
    }

    public int typePrecedence() {
        return 70;
    }

    private void setCoreValue(BigDecimal bigDecimal) {
        this.value = bigDecimal;
        this.rawData = null;
    }

    private void setCoreValue(double d) {
        this.value = new BigDecimal(Double.toString(d));
        this.rawData = null;
    }

    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getScale();
        int n2 = dataTypeDescriptor.getPrecision();
        this.setFrom(dataValueDescriptor);
        this.setWidth(n2, n, true);
    }

    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setBigDecimal(SQLDecimal.getBigDecimal(numberDataValue).add(SQLDecimal.getBigDecimal(numberDataValue2)));
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setBigDecimal(SQLDecimal.getBigDecimal(numberDataValue).subtract(SQLDecimal.getBigDecimal(numberDataValue2)));
        return numberDataValue3;
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        numberDataValue3.setBigDecimal(SQLDecimal.getBigDecimal(numberDataValue).multiply(SQLDecimal.getBigDecimal(numberDataValue2)));
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        return this.divide(numberDataValue, numberDataValue2, numberDataValue3, -1);
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3, int n) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLDecimal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        BigDecimal bigDecimal = SQLDecimal.getBigDecimal(numberDataValue2);
        if (bigDecimal.compareTo(ZERO) == 0) {
            throw StandardException.newException("22012");
        }
        BigDecimal bigDecimal2 = SQLDecimal.getBigDecimal(numberDataValue);
        numberDataValue3.setBigDecimal(bigDecimal2.divide(bigDecimal, n > -1 ? n : Math.max(bigDecimal2.scale() + SQLDecimal.getWholeDigits(bigDecimal) + 1, 4), 1));
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLDecimal();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        numberDataValue.setBigDecimal(this.getBigDecimal().negate());
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.getBigDecimal().compareTo(ZERO) == -1;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getString();
    }

    public int hashCode() {
        long l;
        double d;
        BigDecimal bigDecimal = this.getBigDecimal();
        double d2 = d = bigDecimal != null ? bigDecimal.doubleValue() : 0.0;
        if (Double.isInfinite(d)) {
            l = bigDecimal.longValue();
        } else {
            l = (long)d;
            if ((double)l != d) {
                l = Double.doubleToLongBits(d);
            }
        }
        return (int)(l ^ l >> 32);
    }

    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.isNull()) {
            return;
        }
        if (n != -1 && n - n2 < SQLDecimal.getWholeDigits(this.getBigDecimal())) {
            throw StandardException.newException("22003", "DECIMAL/NUMERIC(" + n + "," + n2 + ")");
        }
        this.value = this.value.setScale(n2, 1);
        this.rawData = null;
    }

    public int getDecimalValuePrecision() {
        if (this.isNull()) {
            return 0;
        }
        BigDecimal bigDecimal = this.getBigDecimal();
        return SQLDecimal.getWholeDigits(bigDecimal) + this.getDecimalValueScale();
    }

    public int getDecimalValueScale() {
        if (this.isNull()) {
            return 0;
        }
        if (this.value == null) {
            return this.rawScale;
        }
        int n = this.value.scale();
        if (n >= 0) {
            return n;
        }
        return 0;
    }

    public static BigDecimal getBigDecimal(DataValueDescriptor dataValueDescriptor) throws StandardException {
        switch (dataValueDescriptor.typeToBigDecimal()) {
            case 3: {
                return (BigDecimal)dataValueDescriptor.getObject();
            }
            case 1: {
                try {
                    return new BigDecimal(dataValueDescriptor.getString().trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("22018", "java.math.BigDecimal");
                }
            }
            case -5: {
                return BigDecimal.valueOf(dataValueDescriptor.getLong());
            }
        }
        return null;
    }

    private static int getWholeDigits(BigDecimal bigDecimal) {
        if (ONE.compareTo(bigDecimal = bigDecimal.abs()) == 1) {
            return 0;
        }
        if (JVMInfo.JDK_ID >= 6) {
            try {
                int n = (Integer)bdPrecision.invoke((Object)bigDecimal, null);
                return n - bigDecimal.scale();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalAccessError("precision");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new IncompatibleClassChangeError("precision");
            }
        }
        String string = bigDecimal.toString();
        return bigDecimal.scale() == 0 ? string.length() : string.indexOf(46);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Method method;
        ZERO = BigDecimal.valueOf(0L);
        ONE = BigDecimal.valueOf(1L);
        MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(ONE);
        MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(ONE);
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$org$apache$derby$iapi$types$SQLDecimal == null ? (class$org$apache$derby$iapi$types$SQLDecimal = SQLDecimal.class$("org.apache.derby.iapi.types.SQLDecimal")) : class$org$apache$derby$iapi$types$SQLDecimal);
        BIG_DECIMAL_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        try {
            method = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("toPlainString", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        toPlainString = method;
        try {
            method = (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SQLDecimal.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("precision", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        bdPrecision = method;
    }
}

