/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitReader;

public final class ReaderToUTF8Stream
extends InputStream {
    private LimitReader reader;
    private byte[] buffer;
    private int boff;
    private int blen;
    private boolean eof;
    private boolean multipleBuffer;
    private static final int BUFSIZE = 32768;
    private final int charsToTruncate;
    private static final char SPACE = ' ';
    private final int valueLength;
    private final int maximumLength;
    private final String typeName;

    public ReaderToUTF8Stream(Reader reader, int n, int n2, String string) {
        this.reader = new LimitReader(reader);
        this.reader.setLimit(n);
        this.buffer = new byte[32768];
        this.blen = -1;
        this.charsToTruncate = n2;
        this.valueLength = n;
        this.maximumLength = -1;
        this.typeName = string;
    }

    public ReaderToUTF8Stream(Reader reader, int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + n);
        }
        if (string == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        this.reader = new LimitReader(reader);
        this.reader.setLimit(n);
        this.buffer = new byte[32768];
        this.blen = -1;
        this.maximumLength = n;
        this.typeName = string;
        this.charsToTruncate = -1;
        this.valueLength = -1;
    }

    public int read() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.blen < 0) {
            this.fillBuffer(2);
        }
        while (this.boff == this.blen) {
            if (this.eof) {
                this.close();
                return -1;
            }
            this.fillBuffer(0);
        }
        return this.buffer[this.boff++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.blen < 0) {
            this.fillBuffer(2);
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.blen - this.boff;
            if (n4 == 0) {
                if (this.eof) {
                    if (n3 > 0) {
                        return n3;
                    }
                    this.close();
                    return -1;
                }
                this.fillBuffer(0);
                continue;
            }
            if (n2 < n4) {
                n4 = n2;
            }
            System.arraycopy(this.buffer, this.boff, byArray, n, n4);
            this.boff += n4;
            n2 -= n4;
            n3 += n4;
            n += n4;
        }
        return n3;
    }

    private void fillBuffer(int n) throws IOException {
        this.boff = n;
        int n2 = this.boff;
        if (n2 == 0) {
            this.multipleBuffer = true;
        }
        while (n2 <= this.buffer.length - 6) {
            int n3 = this.reader.read();
            if (n3 < 0) {
                this.eof = true;
                break;
            }
            if (n3 >= 1 && n3 <= 127) {
                this.buffer[n2++] = (byte)n3;
                continue;
            }
            if (n3 > 2047) {
                this.buffer[n2++] = (byte)(0xE0 | n3 >> 12 & 0xF);
                this.buffer[n2++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                this.buffer[n2++] = (byte)(0x80 | n3 >> 0 & 0x3F);
                continue;
            }
            this.buffer[n2++] = (byte)(0xC0 | n3 >> 6 & 0x1F);
            this.buffer[n2++] = (byte)(0x80 | n3 >> 0 & 0x3F);
        }
        this.blen = n2;
        this.boff = 0;
        if (this.eof) {
            this.checkSufficientData();
        }
    }

    private void checkSufficientData() throws IOException {
        int n;
        if (this.charsToTruncate > 0) {
            this.reader.setLimit(this.charsToTruncate);
            this.truncate();
        }
        if ((n = this.reader.clearLimit()) > 0 && this.valueLength > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
        }
        if (n == 0 && this.reader.read() >= 0) {
            if (this.valueLength > -1) {
                throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
            }
            if (this.canTruncate()) {
                this.truncate();
            } else {
                throw new DerbyIOException(MessageService.getTextMessage("22001"), "22001");
            }
        }
        if (!this.multipleBuffer) {
            int n2 = this.blen - 2;
            this.buffer[0] = (byte)(n2 >>> 8 & 0xFF);
            this.buffer[1] = (byte)(n2 >>> 0 & 0xFF);
        } else {
            this.buffer[this.blen++] = -32;
            this.buffer[this.blen++] = 0;
            this.buffer[this.blen++] = 0;
        }
    }

    private boolean canTruncate() {
        if (this.typeName.equals("CLOB")) {
            return true;
        }
        return this.typeName.equals("VARCHAR");
    }

    private void truncate() throws IOException {
        int n = 0;
        while ((n = this.reader.read()) >= 0) {
            if (n == 32) continue;
            throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "XXXX", String.valueOf(this.valueLength)), "22001");
        }
    }

    public void close() throws IOException {
        this.buffer = null;
    }

    public final int available() {
        int n = this.reader.getLimit();
        return 32768 > n ? n : 32768;
    }
}

