/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.model.hdftypes.definitions;

import org.apache.poi.hdf.model.hdftypes.HDFType;
import org.apache.poi.util.BitField;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public abstract class DOPAbstractType
implements HDFType {
    private byte field_1_formatFlags;
    private BitField fFacingPages = new BitField(1);
    private BitField fWidowControl = new BitField(2);
    private BitField fPMHMainDoc = new BitField(4);
    private BitField grfSupression = new BitField(24);
    private BitField fpc = new BitField(96);
    private BitField unused1 = new BitField(128);
    private short field_2_unused2;
    private short field_3_footnoteInfo;
    private BitField rncFtn = new BitField(3);
    private BitField nFtn = new BitField(65532);
    private byte field_4_fOutlineDirtySave;
    private byte field_5_docinfo;
    private BitField fOnlyMacPics = new BitField(1);
    private BitField fOnlyWinPics = new BitField(2);
    private BitField fLabelDoc = new BitField(4);
    private BitField fHyphCapitals = new BitField(8);
    private BitField fAutoHyphen = new BitField(16);
    private BitField fFormNoFields = new BitField(32);
    private BitField fLinkStyles = new BitField(64);
    private BitField fRevMarking = new BitField(128);
    private byte field_6_docinfo1;
    private BitField fBackup = new BitField(1);
    private BitField fExactCWords = new BitField(2);
    private BitField fPagHidden = new BitField(4);
    private BitField fPagResults = new BitField(8);
    private BitField fLockAtn = new BitField(16);
    private BitField fMirrorMargins = new BitField(32);
    private BitField unused3 = new BitField(64);
    private BitField fDfltTrueType = new BitField(128);
    private byte field_7_docinfo2;
    private BitField fPagSupressTopSpacing = new BitField(1);
    private BitField fProtEnabled = new BitField(2);
    private BitField fDispFormFldSel = new BitField(4);
    private BitField fRMView = new BitField(8);
    private BitField fRMPrint = new BitField(16);
    private BitField unused4 = new BitField(32);
    private BitField fLockRev = new BitField(64);
    private BitField fEmbedFonts = new BitField(128);
    private short field_8_docinfo3;
    private BitField oldfNoTabForInd = new BitField(1);
    private BitField oldfNoSpaceRaiseLower = new BitField(2);
    private BitField oldfSuppressSpbfAfterPageBreak = new BitField(4);
    private BitField oldfWrapTrailSpaces = new BitField(8);
    private BitField oldfMapPrintTextColor = new BitField(16);
    private BitField oldfNoColumnBalance = new BitField(32);
    private BitField oldfConvMailMergeEsc = new BitField(64);
    private BitField oldfSupressTopSpacing = new BitField(128);
    private BitField oldfOrigWordTableRules = new BitField(256);
    private BitField oldfTransparentMetafiles = new BitField(512);
    private BitField oldfShowBreaksInFrames = new BitField(1024);
    private BitField oldfSwapBordersFacingPgs = new BitField(2048);
    private BitField unused5 = new BitField(61440);
    private int field_9_dxaTab;
    private int field_10_wSpare;
    private int field_11_dxaHotz;
    private int field_12_cConsexHypLim;
    private int field_13_wSpare2;
    private int field_14_dttmCreated;
    private int field_15_dttmRevised;
    private int field_16_dttmLastPrint;
    private int field_17_nRevision;
    private int field_18_tmEdited;
    private int field_19_cWords;
    private int field_20_cCh;
    private int field_21_cPg;
    private int field_22_cParas;
    private short field_23_Edn;
    private BitField rncEdn = new BitField(3);
    private BitField nEdn = new BitField(65532);
    private short field_24_Edn1;
    private BitField epc = new BitField(3);
    private BitField nfcFtnRef1 = new BitField(60);
    private BitField nfcEdnRef1 = new BitField(960);
    private BitField fPrintFormData = new BitField(1024);
    private BitField fSaveFormData = new BitField(2048);
    private BitField fShadeFormData = new BitField(4096);
    private BitField fWCFtnEdn = new BitField(32768);
    private int field_25_cLines;
    private int field_26_cWordsFtnEnd;
    private int field_27_cChFtnEdn;
    private short field_28_cPgFtnEdn;
    private int field_29_cParasFtnEdn;
    private int field_30_cLinesFtnEdn;
    private int field_31_lKeyProtDoc;
    private short field_32_view;
    private BitField wvkSaved = new BitField(7);
    private BitField wScaleSaved = new BitField(4088);
    private BitField zkSaved = new BitField(12288);
    private BitField fRotateFontW6 = new BitField(16384);
    private BitField iGutterPos = new BitField(32768);
    private int field_33_docinfo4;
    private BitField fNoTabForInd = new BitField(1);
    private BitField fNoSpaceRaiseLower = new BitField(2);
    private BitField fSupressSpdfAfterPageBreak = new BitField(4);
    private BitField fWrapTrailSpaces = new BitField(8);
    private BitField fMapPrintTextColor = new BitField(16);
    private BitField fNoColumnBalance = new BitField(32);
    private BitField fConvMailMergeEsc = new BitField(64);
    private BitField fSupressTopSpacing = new BitField(128);
    private BitField fOrigWordTableRules = new BitField(256);
    private BitField fTransparentMetafiles = new BitField(512);
    private BitField fShowBreaksInFrames = new BitField(1024);
    private BitField fSwapBordersFacingPgs = new BitField(2048);
    private BitField fSuppressTopSPacingMac5 = new BitField(65536);
    private BitField fTruncDxaExpand = new BitField(131072);
    private BitField fPrintBodyBeforeHdr = new BitField(262144);
    private BitField fNoLeading = new BitField(524288);
    private BitField fMWSmallCaps = new BitField(0x200000);
    private short field_34_adt;
    private byte[] field_35_doptypography;
    private byte[] field_36_dogrid;
    private short field_37_docinfo5;
    private BitField lvl = new BitField(30);
    private BitField fGramAllDone = new BitField(32);
    private BitField fGramAllClean = new BitField(64);
    private BitField fSubsetFonts = new BitField(128);
    private BitField fHideLastVersion = new BitField(256);
    private BitField fHtmlDoc = new BitField(512);
    private BitField fSnapBorder = new BitField(2048);
    private BitField fIncludeHeader = new BitField(4096);
    private BitField fIncludeFooter = new BitField(8192);
    private BitField fForcePageSizePag = new BitField(16384);
    private BitField fMinFontSizePag = new BitField(32768);
    private short field_38_docinfo6;
    private BitField fHaveVersions = new BitField(1);
    private BitField fAutoVersions = new BitField(2);
    private byte[] field_39_asumyi;
    private int field_40_cChWS;
    private int field_41_cChWSFtnEdn;
    private int field_42_grfDocEvents;
    private int field_43_virusinfo;
    private BitField fVirusPrompted = new BitField(1);
    private BitField fVirusLoadSafe = new BitField(2);
    private BitField KeyVirusSession30 = new BitField(-4);
    private byte[] field_44_Spare;
    private int field_45_reserved1;
    private int field_46_reserved2;
    private int field_47_cDBC;
    private int field_48_cDBCFtnEdn;
    private int field_49_reserved;
    private short field_50_nfcFtnRef;
    private short field_51_nfcEdnRef;
    private short field_52_hpsZoonFontPag;
    private short field_53_dywDispPag;

    protected void fillFields(byte[] data, short size, int offset) {
        this.field_1_formatFlags = data[0 + offset];
        this.field_2_unused2 = LittleEndian.getShort((byte[])data, (int)(1 + offset));
        this.field_3_footnoteInfo = LittleEndian.getShort((byte[])data, (int)(3 + offset));
        this.field_4_fOutlineDirtySave = data[5 + offset];
        this.field_5_docinfo = data[6 + offset];
        this.field_6_docinfo1 = data[7 + offset];
        this.field_7_docinfo2 = data[8 + offset];
        this.field_8_docinfo3 = LittleEndian.getShort((byte[])data, (int)(9 + offset));
        this.field_9_dxaTab = LittleEndian.getShort((byte[])data, (int)(11 + offset));
        this.field_10_wSpare = LittleEndian.getShort((byte[])data, (int)(13 + offset));
        this.field_11_dxaHotz = LittleEndian.getShort((byte[])data, (int)(15 + offset));
        this.field_12_cConsexHypLim = LittleEndian.getShort((byte[])data, (int)(17 + offset));
        this.field_13_wSpare2 = LittleEndian.getShort((byte[])data, (int)(19 + offset));
        this.field_14_dttmCreated = LittleEndian.getInt((byte[])data, (int)(21 + offset));
        this.field_15_dttmRevised = LittleEndian.getInt((byte[])data, (int)(25 + offset));
        this.field_16_dttmLastPrint = LittleEndian.getInt((byte[])data, (int)(29 + offset));
        this.field_17_nRevision = LittleEndian.getShort((byte[])data, (int)(33 + offset));
        this.field_18_tmEdited = LittleEndian.getInt((byte[])data, (int)(35 + offset));
        this.field_19_cWords = LittleEndian.getInt((byte[])data, (int)(39 + offset));
        this.field_20_cCh = LittleEndian.getInt((byte[])data, (int)(43 + offset));
        this.field_21_cPg = LittleEndian.getShort((byte[])data, (int)(47 + offset));
        this.field_22_cParas = LittleEndian.getInt((byte[])data, (int)(49 + offset));
        this.field_23_Edn = LittleEndian.getShort((byte[])data, (int)(53 + offset));
        this.field_24_Edn1 = LittleEndian.getShort((byte[])data, (int)(55 + offset));
        this.field_25_cLines = LittleEndian.getInt((byte[])data, (int)(57 + offset));
        this.field_26_cWordsFtnEnd = LittleEndian.getInt((byte[])data, (int)(61 + offset));
        this.field_27_cChFtnEdn = LittleEndian.getInt((byte[])data, (int)(65 + offset));
        this.field_28_cPgFtnEdn = LittleEndian.getShort((byte[])data, (int)(69 + offset));
        this.field_29_cParasFtnEdn = LittleEndian.getInt((byte[])data, (int)(71 + offset));
        this.field_30_cLinesFtnEdn = LittleEndian.getInt((byte[])data, (int)(75 + offset));
        this.field_31_lKeyProtDoc = LittleEndian.getInt((byte[])data, (int)(79 + offset));
        this.field_32_view = LittleEndian.getShort((byte[])data, (int)(83 + offset));
        this.field_33_docinfo4 = LittleEndian.getInt((byte[])data, (int)(85 + offset));
        this.field_34_adt = LittleEndian.getShort((byte[])data, (int)(89 + offset));
        this.field_35_doptypography = LittleEndian.getByteArray((byte[])data, (int)(91 + offset), (int)size);
        this.field_36_dogrid = LittleEndian.getByteArray((byte[])data, (int)(401 + offset), (int)size);
        this.field_37_docinfo5 = LittleEndian.getShort((byte[])data, (int)(411 + offset));
        this.field_38_docinfo6 = LittleEndian.getShort((byte[])data, (int)(413 + offset));
        this.field_39_asumyi = LittleEndian.getByteArray((byte[])data, (int)(415 + offset), (int)size);
        this.field_40_cChWS = LittleEndian.getInt((byte[])data, (int)(427 + offset));
        this.field_41_cChWSFtnEdn = LittleEndian.getInt((byte[])data, (int)(431 + offset));
        this.field_42_grfDocEvents = LittleEndian.getInt((byte[])data, (int)(435 + offset));
        this.field_43_virusinfo = LittleEndian.getInt((byte[])data, (int)(439 + offset));
        this.field_44_Spare = LittleEndian.getByteArray((byte[])data, (int)(443 + offset), (int)size);
        this.field_45_reserved1 = LittleEndian.getInt((byte[])data, (int)(473 + offset));
        this.field_46_reserved2 = LittleEndian.getInt((byte[])data, (int)(477 + offset));
        this.field_47_cDBC = LittleEndian.getInt((byte[])data, (int)(481 + offset));
        this.field_48_cDBCFtnEdn = LittleEndian.getInt((byte[])data, (int)(485 + offset));
        this.field_49_reserved = LittleEndian.getInt((byte[])data, (int)(489 + offset));
        this.field_50_nfcFtnRef = LittleEndian.getShort((byte[])data, (int)(493 + offset));
        this.field_51_nfcEdnRef = LittleEndian.getShort((byte[])data, (int)(495 + offset));
        this.field_52_hpsZoonFontPag = LittleEndian.getShort((byte[])data, (int)(497 + offset));
        this.field_53_dywDispPag = LittleEndian.getShort((byte[])data, (int)(499 + offset));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DOP]\n");
        buffer.append("    .formatFlags          = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte)this.getFormatFlags()));
        buffer.append(" (").append(this.getFormatFlags()).append(" )\n");
        buffer.append("         .fFacingPages             = ").append(this.isFFacingPages()).append('\n');
        buffer.append("         .fWidowControl            = ").append(this.isFWidowControl()).append('\n');
        buffer.append("         .fPMHMainDoc              = ").append(this.isFPMHMainDoc()).append('\n');
        buffer.append("         .grfSupression            = ").append(this.getGrfSupression()).append('\n');
        buffer.append("         .fpc                      = ").append(this.getFpc()).append('\n');
        buffer.append("         .unused1                  = ").append(this.isUnused1()).append('\n');
        buffer.append("    .unused2              = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getUnused2()));
        buffer.append(" (").append(this.getUnused2()).append(" )\n");
        buffer.append("    .footnoteInfo         = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getFootnoteInfo()));
        buffer.append(" (").append(this.getFootnoteInfo()).append(" )\n");
        buffer.append("         .rncFtn                   = ").append(this.getRncFtn()).append('\n');
        buffer.append("         .nFtn                     = ").append(this.getNFtn()).append('\n');
        buffer.append("    .fOutlineDirtySave    = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte)this.getFOutlineDirtySave()));
        buffer.append(" (").append(this.getFOutlineDirtySave()).append(" )\n");
        buffer.append("    .docinfo              = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte)this.getDocinfo()));
        buffer.append(" (").append(this.getDocinfo()).append(" )\n");
        buffer.append("         .fOnlyMacPics             = ").append(this.isFOnlyMacPics()).append('\n');
        buffer.append("         .fOnlyWinPics             = ").append(this.isFOnlyWinPics()).append('\n');
        buffer.append("         .fLabelDoc                = ").append(this.isFLabelDoc()).append('\n');
        buffer.append("         .fHyphCapitals            = ").append(this.isFHyphCapitals()).append('\n');
        buffer.append("         .fAutoHyphen              = ").append(this.isFAutoHyphen()).append('\n');
        buffer.append("         .fFormNoFields            = ").append(this.isFFormNoFields()).append('\n');
        buffer.append("         .fLinkStyles              = ").append(this.isFLinkStyles()).append('\n');
        buffer.append("         .fRevMarking              = ").append(this.isFRevMarking()).append('\n');
        buffer.append("    .docinfo1             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte)this.getDocinfo1()));
        buffer.append(" (").append(this.getDocinfo1()).append(" )\n");
        buffer.append("         .fBackup                  = ").append(this.isFBackup()).append('\n');
        buffer.append("         .fExactCWords             = ").append(this.isFExactCWords()).append('\n');
        buffer.append("         .fPagHidden               = ").append(this.isFPagHidden()).append('\n');
        buffer.append("         .fPagResults              = ").append(this.isFPagResults()).append('\n');
        buffer.append("         .fLockAtn                 = ").append(this.isFLockAtn()).append('\n');
        buffer.append("         .fMirrorMargins           = ").append(this.isFMirrorMargins()).append('\n');
        buffer.append("         .unused3                  = ").append(this.isUnused3()).append('\n');
        buffer.append("         .fDfltTrueType            = ").append(this.isFDfltTrueType()).append('\n');
        buffer.append("    .docinfo2             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte)this.getDocinfo2()));
        buffer.append(" (").append(this.getDocinfo2()).append(" )\n");
        buffer.append("         .fPagSupressTopSpacing     = ").append(this.isFPagSupressTopSpacing()).append('\n');
        buffer.append("         .fProtEnabled             = ").append(this.isFProtEnabled()).append('\n');
        buffer.append("         .fDispFormFldSel          = ").append(this.isFDispFormFldSel()).append('\n');
        buffer.append("         .fRMView                  = ").append(this.isFRMView()).append('\n');
        buffer.append("         .fRMPrint                 = ").append(this.isFRMPrint()).append('\n');
        buffer.append("         .unused4                  = ").append(this.isUnused4()).append('\n');
        buffer.append("         .fLockRev                 = ").append(this.isFLockRev()).append('\n');
        buffer.append("         .fEmbedFonts              = ").append(this.isFEmbedFonts()).append('\n');
        buffer.append("    .docinfo3             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getDocinfo3()));
        buffer.append(" (").append(this.getDocinfo3()).append(" )\n");
        buffer.append("         .oldfNoTabForInd          = ").append(this.isOldfNoTabForInd()).append('\n');
        buffer.append("         .oldfNoSpaceRaiseLower     = ").append(this.isOldfNoSpaceRaiseLower()).append('\n');
        buffer.append("         .oldfSuppressSpbfAfterPageBreak     = ").append(this.isOldfSuppressSpbfAfterPageBreak()).append('\n');
        buffer.append("         .oldfWrapTrailSpaces      = ").append(this.isOldfWrapTrailSpaces()).append('\n');
        buffer.append("         .oldfMapPrintTextColor     = ").append(this.isOldfMapPrintTextColor()).append('\n');
        buffer.append("         .oldfNoColumnBalance      = ").append(this.isOldfNoColumnBalance()).append('\n');
        buffer.append("         .oldfConvMailMergeEsc     = ").append(this.isOldfConvMailMergeEsc()).append('\n');
        buffer.append("         .oldfSupressTopSpacing     = ").append(this.isOldfSupressTopSpacing()).append('\n');
        buffer.append("         .oldfOrigWordTableRules     = ").append(this.isOldfOrigWordTableRules()).append('\n');
        buffer.append("         .oldfTransparentMetafiles     = ").append(this.isOldfTransparentMetafiles()).append('\n');
        buffer.append("         .oldfShowBreaksInFrames     = ").append(this.isOldfShowBreaksInFrames()).append('\n');
        buffer.append("         .oldfSwapBordersFacingPgs     = ").append(this.isOldfSwapBordersFacingPgs()).append('\n');
        buffer.append("         .unused5                  = ").append(this.getUnused5()).append('\n');
        buffer.append("    .dxaTab               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getDxaTab()));
        buffer.append(" (").append(this.getDxaTab()).append(" )\n");
        buffer.append("    .wSpare               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getWSpare()));
        buffer.append(" (").append(this.getWSpare()).append(" )\n");
        buffer.append("    .dxaHotz              = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getDxaHotz()));
        buffer.append(" (").append(this.getDxaHotz()).append(" )\n");
        buffer.append("    .cConsexHypLim        = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCConsexHypLim()));
        buffer.append(" (").append(this.getCConsexHypLim()).append(" )\n");
        buffer.append("    .wSpare2              = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getWSpare2()));
        buffer.append(" (").append(this.getWSpare2()).append(" )\n");
        buffer.append("    .dttmCreated          = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getDttmCreated()));
        buffer.append(" (").append(this.getDttmCreated()).append(" )\n");
        buffer.append("    .dttmRevised          = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getDttmRevised()));
        buffer.append(" (").append(this.getDttmRevised()).append(" )\n");
        buffer.append("    .dttmLastPrint        = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getDttmLastPrint()));
        buffer.append(" (").append(this.getDttmLastPrint()).append(" )\n");
        buffer.append("    .nRevision            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getNRevision()));
        buffer.append(" (").append(this.getNRevision()).append(" )\n");
        buffer.append("    .tmEdited             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getTmEdited()));
        buffer.append(" (").append(this.getTmEdited()).append(" )\n");
        buffer.append("    .cWords               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCWords()));
        buffer.append(" (").append(this.getCWords()).append(" )\n");
        buffer.append("    .cCh                  = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCCh()));
        buffer.append(" (").append(this.getCCh()).append(" )\n");
        buffer.append("    .cPg                  = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCPg()));
        buffer.append(" (").append(this.getCPg()).append(" )\n");
        buffer.append("    .cParas               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCParas()));
        buffer.append(" (").append(this.getCParas()).append(" )\n");
        buffer.append("    .Edn                  = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getEdn()));
        buffer.append(" (").append(this.getEdn()).append(" )\n");
        buffer.append("         .rncEdn                   = ").append(this.getRncEdn()).append('\n');
        buffer.append("         .nEdn                     = ").append(this.getNEdn()).append('\n');
        buffer.append("    .Edn1                 = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getEdn1()));
        buffer.append(" (").append(this.getEdn1()).append(" )\n");
        buffer.append("         .epc                      = ").append(this.getEpc()).append('\n');
        buffer.append("         .nfcFtnRef1               = ").append(this.getNfcFtnRef1()).append('\n');
        buffer.append("         .nfcEdnRef1               = ").append(this.getNfcEdnRef1()).append('\n');
        buffer.append("         .fPrintFormData           = ").append(this.isFPrintFormData()).append('\n');
        buffer.append("         .fSaveFormData            = ").append(this.isFSaveFormData()).append('\n');
        buffer.append("         .fShadeFormData           = ").append(this.isFShadeFormData()).append('\n');
        buffer.append("         .fWCFtnEdn                = ").append(this.isFWCFtnEdn()).append('\n');
        buffer.append("    .cLines               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCLines()));
        buffer.append(" (").append(this.getCLines()).append(" )\n");
        buffer.append("    .cWordsFtnEnd         = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCWordsFtnEnd()));
        buffer.append(" (").append(this.getCWordsFtnEnd()).append(" )\n");
        buffer.append("    .cChFtnEdn            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCChFtnEdn()));
        buffer.append(" (").append(this.getCChFtnEdn()).append(" )\n");
        buffer.append("    .cPgFtnEdn            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getCPgFtnEdn()));
        buffer.append(" (").append(this.getCPgFtnEdn()).append(" )\n");
        buffer.append("    .cParasFtnEdn         = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCParasFtnEdn()));
        buffer.append(" (").append(this.getCParasFtnEdn()).append(" )\n");
        buffer.append("    .cLinesFtnEdn         = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCLinesFtnEdn()));
        buffer.append(" (").append(this.getCLinesFtnEdn()).append(" )\n");
        buffer.append("    .lKeyProtDoc          = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getLKeyProtDoc()));
        buffer.append(" (").append(this.getLKeyProtDoc()).append(" )\n");
        buffer.append("    .view                 = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getView()));
        buffer.append(" (").append(this.getView()).append(" )\n");
        buffer.append("         .wvkSaved                 = ").append(this.getWvkSaved()).append('\n');
        buffer.append("         .wScaleSaved              = ").append(this.getWScaleSaved()).append('\n');
        buffer.append("         .zkSaved                  = ").append(this.getZkSaved()).append('\n');
        buffer.append("         .fRotateFontW6            = ").append(this.isFRotateFontW6()).append('\n');
        buffer.append("         .iGutterPos               = ").append(this.isIGutterPos()).append('\n');
        buffer.append("    .docinfo4             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getDocinfo4()));
        buffer.append(" (").append(this.getDocinfo4()).append(" )\n");
        buffer.append("         .fNoTabForInd             = ").append(this.isFNoTabForInd()).append('\n');
        buffer.append("         .fNoSpaceRaiseLower       = ").append(this.isFNoSpaceRaiseLower()).append('\n');
        buffer.append("         .fSupressSpdfAfterPageBreak     = ").append(this.isFSupressSpdfAfterPageBreak()).append('\n');
        buffer.append("         .fWrapTrailSpaces         = ").append(this.isFWrapTrailSpaces()).append('\n');
        buffer.append("         .fMapPrintTextColor       = ").append(this.isFMapPrintTextColor()).append('\n');
        buffer.append("         .fNoColumnBalance         = ").append(this.isFNoColumnBalance()).append('\n');
        buffer.append("         .fConvMailMergeEsc        = ").append(this.isFConvMailMergeEsc()).append('\n');
        buffer.append("         .fSupressTopSpacing       = ").append(this.isFSupressTopSpacing()).append('\n');
        buffer.append("         .fOrigWordTableRules      = ").append(this.isFOrigWordTableRules()).append('\n');
        buffer.append("         .fTransparentMetafiles     = ").append(this.isFTransparentMetafiles()).append('\n');
        buffer.append("         .fShowBreaksInFrames      = ").append(this.isFShowBreaksInFrames()).append('\n');
        buffer.append("         .fSwapBordersFacingPgs     = ").append(this.isFSwapBordersFacingPgs()).append('\n');
        buffer.append("         .fSuppressTopSPacingMac5     = ").append(this.isFSuppressTopSPacingMac5()).append('\n');
        buffer.append("         .fTruncDxaExpand          = ").append(this.isFTruncDxaExpand()).append('\n');
        buffer.append("         .fPrintBodyBeforeHdr      = ").append(this.isFPrintBodyBeforeHdr()).append('\n');
        buffer.append("         .fNoLeading               = ").append(this.isFNoLeading()).append('\n');
        buffer.append("         .fMWSmallCaps             = ").append(this.isFMWSmallCaps()).append('\n');
        buffer.append("    .adt                  = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getAdt()));
        buffer.append(" (").append(this.getAdt()).append(" )\n");
        buffer.append("    .doptypography        = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte[])this.getDoptypography()));
        buffer.append(" (").append(this.getDoptypography()).append(" )\n");
        buffer.append("    .dogrid               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte[])this.getDogrid()));
        buffer.append(" (").append(this.getDogrid()).append(" )\n");
        buffer.append("    .docinfo5             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getDocinfo5()));
        buffer.append(" (").append(this.getDocinfo5()).append(" )\n");
        buffer.append("         .lvl                      = ").append(this.getLvl()).append('\n');
        buffer.append("         .fGramAllDone             = ").append(this.isFGramAllDone()).append('\n');
        buffer.append("         .fGramAllClean            = ").append(this.isFGramAllClean()).append('\n');
        buffer.append("         .fSubsetFonts             = ").append(this.isFSubsetFonts()).append('\n');
        buffer.append("         .fHideLastVersion         = ").append(this.isFHideLastVersion()).append('\n');
        buffer.append("         .fHtmlDoc                 = ").append(this.isFHtmlDoc()).append('\n');
        buffer.append("         .fSnapBorder              = ").append(this.isFSnapBorder()).append('\n');
        buffer.append("         .fIncludeHeader           = ").append(this.isFIncludeHeader()).append('\n');
        buffer.append("         .fIncludeFooter           = ").append(this.isFIncludeFooter()).append('\n');
        buffer.append("         .fForcePageSizePag        = ").append(this.isFForcePageSizePag()).append('\n');
        buffer.append("         .fMinFontSizePag          = ").append(this.isFMinFontSizePag()).append('\n');
        buffer.append("    .docinfo6             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getDocinfo6()));
        buffer.append(" (").append(this.getDocinfo6()).append(" )\n");
        buffer.append("         .fHaveVersions            = ").append(this.isFHaveVersions()).append('\n');
        buffer.append("         .fAutoVersions            = ").append(this.isFAutoVersions()).append('\n');
        buffer.append("    .asumyi               = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte[])this.getAsumyi()));
        buffer.append(" (").append(this.getAsumyi()).append(" )\n");
        buffer.append("    .cChWS                = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCChWS()));
        buffer.append(" (").append(this.getCChWS()).append(" )\n");
        buffer.append("    .cChWSFtnEdn          = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCChWSFtnEdn()));
        buffer.append(" (").append(this.getCChWSFtnEdn()).append(" )\n");
        buffer.append("    .grfDocEvents         = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getGrfDocEvents()));
        buffer.append(" (").append(this.getGrfDocEvents()).append(" )\n");
        buffer.append("    .virusinfo            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getVirusinfo()));
        buffer.append(" (").append(this.getVirusinfo()).append(" )\n");
        buffer.append("         .fVirusPrompted           = ").append(this.isFVirusPrompted()).append('\n');
        buffer.append("         .fVirusLoadSafe           = ").append(this.isFVirusLoadSafe()).append('\n');
        buffer.append("         .KeyVirusSession30        = ").append(this.getKeyVirusSession30()).append('\n');
        buffer.append("    .Spare                = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((byte[])this.getSpare()));
        buffer.append(" (").append(this.getSpare()).append(" )\n");
        buffer.append("    .reserved1            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getReserved1()));
        buffer.append(" (").append(this.getReserved1()).append(" )\n");
        buffer.append("    .reserved2            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getReserved2()));
        buffer.append(" (").append(this.getReserved2()).append(" )\n");
        buffer.append("    .cDBC                 = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCDBC()));
        buffer.append(" (").append(this.getCDBC()).append(" )\n");
        buffer.append("    .cDBCFtnEdn           = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getCDBCFtnEdn()));
        buffer.append(" (").append(this.getCDBCFtnEdn()).append(" )\n");
        buffer.append("    .reserved             = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((int)this.getReserved()));
        buffer.append(" (").append(this.getReserved()).append(" )\n");
        buffer.append("    .nfcFtnRef            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getNfcFtnRef()));
        buffer.append(" (").append(this.getNfcFtnRef()).append(" )\n");
        buffer.append("    .nfcEdnRef            = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getNfcEdnRef()));
        buffer.append(" (").append(this.getNfcEdnRef()).append(" )\n");
        buffer.append("    .hpsZoonFontPag       = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getHpsZoonFontPag()));
        buffer.append(" (").append(this.getHpsZoonFontPag()).append(" )\n");
        buffer.append("    .dywDispPag           = ");
        buffer.append("0x");
        buffer.append(HexDump.toHex((short)this.getDywDispPag()));
        buffer.append(" (").append(this.getDywDispPag()).append(" )\n");
        buffer.append("[/DOP]\n");
        return buffer.toString();
    }

    public int getSize() {
        return 505;
    }

    public byte getFormatFlags() {
        return this.field_1_formatFlags;
    }

    public void setFormatFlags(byte field_1_formatFlags) {
        this.field_1_formatFlags = field_1_formatFlags;
    }

    public short getUnused2() {
        return this.field_2_unused2;
    }

    public void setUnused2(short field_2_unused2) {
        this.field_2_unused2 = field_2_unused2;
    }

    public short getFootnoteInfo() {
        return this.field_3_footnoteInfo;
    }

    public void setFootnoteInfo(short field_3_footnoteInfo) {
        this.field_3_footnoteInfo = field_3_footnoteInfo;
    }

    public byte getFOutlineDirtySave() {
        return this.field_4_fOutlineDirtySave;
    }

    public void setFOutlineDirtySave(byte field_4_fOutlineDirtySave) {
        this.field_4_fOutlineDirtySave = field_4_fOutlineDirtySave;
    }

    public byte getDocinfo() {
        return this.field_5_docinfo;
    }

    public void setDocinfo(byte field_5_docinfo) {
        this.field_5_docinfo = field_5_docinfo;
    }

    public byte getDocinfo1() {
        return this.field_6_docinfo1;
    }

    public void setDocinfo1(byte field_6_docinfo1) {
        this.field_6_docinfo1 = field_6_docinfo1;
    }

    public byte getDocinfo2() {
        return this.field_7_docinfo2;
    }

    public void setDocinfo2(byte field_7_docinfo2) {
        this.field_7_docinfo2 = field_7_docinfo2;
    }

    public short getDocinfo3() {
        return this.field_8_docinfo3;
    }

    public void setDocinfo3(short field_8_docinfo3) {
        this.field_8_docinfo3 = field_8_docinfo3;
    }

    public int getDxaTab() {
        return this.field_9_dxaTab;
    }

    public void setDxaTab(int field_9_dxaTab) {
        this.field_9_dxaTab = field_9_dxaTab;
    }

    public int getWSpare() {
        return this.field_10_wSpare;
    }

    public void setWSpare(int field_10_wSpare) {
        this.field_10_wSpare = field_10_wSpare;
    }

    public int getDxaHotz() {
        return this.field_11_dxaHotz;
    }

    public void setDxaHotz(int field_11_dxaHotz) {
        this.field_11_dxaHotz = field_11_dxaHotz;
    }

    public int getCConsexHypLim() {
        return this.field_12_cConsexHypLim;
    }

    public void setCConsexHypLim(int field_12_cConsexHypLim) {
        this.field_12_cConsexHypLim = field_12_cConsexHypLim;
    }

    public int getWSpare2() {
        return this.field_13_wSpare2;
    }

    public void setWSpare2(int field_13_wSpare2) {
        this.field_13_wSpare2 = field_13_wSpare2;
    }

    public int getDttmCreated() {
        return this.field_14_dttmCreated;
    }

    public void setDttmCreated(int field_14_dttmCreated) {
        this.field_14_dttmCreated = field_14_dttmCreated;
    }

    public int getDttmRevised() {
        return this.field_15_dttmRevised;
    }

    public void setDttmRevised(int field_15_dttmRevised) {
        this.field_15_dttmRevised = field_15_dttmRevised;
    }

    public int getDttmLastPrint() {
        return this.field_16_dttmLastPrint;
    }

    public void setDttmLastPrint(int field_16_dttmLastPrint) {
        this.field_16_dttmLastPrint = field_16_dttmLastPrint;
    }

    public int getNRevision() {
        return this.field_17_nRevision;
    }

    public void setNRevision(int field_17_nRevision) {
        this.field_17_nRevision = field_17_nRevision;
    }

    public int getTmEdited() {
        return this.field_18_tmEdited;
    }

    public void setTmEdited(int field_18_tmEdited) {
        this.field_18_tmEdited = field_18_tmEdited;
    }

    public int getCWords() {
        return this.field_19_cWords;
    }

    public void setCWords(int field_19_cWords) {
        this.field_19_cWords = field_19_cWords;
    }

    public int getCCh() {
        return this.field_20_cCh;
    }

    public void setCCh(int field_20_cCh) {
        this.field_20_cCh = field_20_cCh;
    }

    public int getCPg() {
        return this.field_21_cPg;
    }

    public void setCPg(int field_21_cPg) {
        this.field_21_cPg = field_21_cPg;
    }

    public int getCParas() {
        return this.field_22_cParas;
    }

    public void setCParas(int field_22_cParas) {
        this.field_22_cParas = field_22_cParas;
    }

    public short getEdn() {
        return this.field_23_Edn;
    }

    public void setEdn(short field_23_Edn) {
        this.field_23_Edn = field_23_Edn;
    }

    public short getEdn1() {
        return this.field_24_Edn1;
    }

    public void setEdn1(short field_24_Edn1) {
        this.field_24_Edn1 = field_24_Edn1;
    }

    public int getCLines() {
        return this.field_25_cLines;
    }

    public void setCLines(int field_25_cLines) {
        this.field_25_cLines = field_25_cLines;
    }

    public int getCWordsFtnEnd() {
        return this.field_26_cWordsFtnEnd;
    }

    public void setCWordsFtnEnd(int field_26_cWordsFtnEnd) {
        this.field_26_cWordsFtnEnd = field_26_cWordsFtnEnd;
    }

    public int getCChFtnEdn() {
        return this.field_27_cChFtnEdn;
    }

    public void setCChFtnEdn(int field_27_cChFtnEdn) {
        this.field_27_cChFtnEdn = field_27_cChFtnEdn;
    }

    public short getCPgFtnEdn() {
        return this.field_28_cPgFtnEdn;
    }

    public void setCPgFtnEdn(short field_28_cPgFtnEdn) {
        this.field_28_cPgFtnEdn = field_28_cPgFtnEdn;
    }

    public int getCParasFtnEdn() {
        return this.field_29_cParasFtnEdn;
    }

    public void setCParasFtnEdn(int field_29_cParasFtnEdn) {
        this.field_29_cParasFtnEdn = field_29_cParasFtnEdn;
    }

    public int getCLinesFtnEdn() {
        return this.field_30_cLinesFtnEdn;
    }

    public void setCLinesFtnEdn(int field_30_cLinesFtnEdn) {
        this.field_30_cLinesFtnEdn = field_30_cLinesFtnEdn;
    }

    public int getLKeyProtDoc() {
        return this.field_31_lKeyProtDoc;
    }

    public void setLKeyProtDoc(int field_31_lKeyProtDoc) {
        this.field_31_lKeyProtDoc = field_31_lKeyProtDoc;
    }

    public short getView() {
        return this.field_32_view;
    }

    public void setView(short field_32_view) {
        this.field_32_view = field_32_view;
    }

    public int getDocinfo4() {
        return this.field_33_docinfo4;
    }

    public void setDocinfo4(int field_33_docinfo4) {
        this.field_33_docinfo4 = field_33_docinfo4;
    }

    public short getAdt() {
        return this.field_34_adt;
    }

    public void setAdt(short field_34_adt) {
        this.field_34_adt = field_34_adt;
    }

    public byte[] getDoptypography() {
        return this.field_35_doptypography;
    }

    public void setDoptypography(byte[] field_35_doptypography) {
        this.field_35_doptypography = field_35_doptypography;
    }

    public byte[] getDogrid() {
        return this.field_36_dogrid;
    }

    public void setDogrid(byte[] field_36_dogrid) {
        this.field_36_dogrid = field_36_dogrid;
    }

    public short getDocinfo5() {
        return this.field_37_docinfo5;
    }

    public void setDocinfo5(short field_37_docinfo5) {
        this.field_37_docinfo5 = field_37_docinfo5;
    }

    public short getDocinfo6() {
        return this.field_38_docinfo6;
    }

    public void setDocinfo6(short field_38_docinfo6) {
        this.field_38_docinfo6 = field_38_docinfo6;
    }

    public byte[] getAsumyi() {
        return this.field_39_asumyi;
    }

    public void setAsumyi(byte[] field_39_asumyi) {
        this.field_39_asumyi = field_39_asumyi;
    }

    public int getCChWS() {
        return this.field_40_cChWS;
    }

    public void setCChWS(int field_40_cChWS) {
        this.field_40_cChWS = field_40_cChWS;
    }

    public int getCChWSFtnEdn() {
        return this.field_41_cChWSFtnEdn;
    }

    public void setCChWSFtnEdn(int field_41_cChWSFtnEdn) {
        this.field_41_cChWSFtnEdn = field_41_cChWSFtnEdn;
    }

    public int getGrfDocEvents() {
        return this.field_42_grfDocEvents;
    }

    public void setGrfDocEvents(int field_42_grfDocEvents) {
        this.field_42_grfDocEvents = field_42_grfDocEvents;
    }

    public int getVirusinfo() {
        return this.field_43_virusinfo;
    }

    public void setVirusinfo(int field_43_virusinfo) {
        this.field_43_virusinfo = field_43_virusinfo;
    }

    public byte[] getSpare() {
        return this.field_44_Spare;
    }

    public void setSpare(byte[] field_44_Spare) {
        this.field_44_Spare = field_44_Spare;
    }

    public int getReserved1() {
        return this.field_45_reserved1;
    }

    public void setReserved1(int field_45_reserved1) {
        this.field_45_reserved1 = field_45_reserved1;
    }

    public int getReserved2() {
        return this.field_46_reserved2;
    }

    public void setReserved2(int field_46_reserved2) {
        this.field_46_reserved2 = field_46_reserved2;
    }

    public int getCDBC() {
        return this.field_47_cDBC;
    }

    public void setCDBC(int field_47_cDBC) {
        this.field_47_cDBC = field_47_cDBC;
    }

    public int getCDBCFtnEdn() {
        return this.field_48_cDBCFtnEdn;
    }

    public void setCDBCFtnEdn(int field_48_cDBCFtnEdn) {
        this.field_48_cDBCFtnEdn = field_48_cDBCFtnEdn;
    }

    public int getReserved() {
        return this.field_49_reserved;
    }

    public void setReserved(int field_49_reserved) {
        this.field_49_reserved = field_49_reserved;
    }

    public short getNfcFtnRef() {
        return this.field_50_nfcFtnRef;
    }

    public void setNfcFtnRef(short field_50_nfcFtnRef) {
        this.field_50_nfcFtnRef = field_50_nfcFtnRef;
    }

    public short getNfcEdnRef() {
        return this.field_51_nfcEdnRef;
    }

    public void setNfcEdnRef(short field_51_nfcEdnRef) {
        this.field_51_nfcEdnRef = field_51_nfcEdnRef;
    }

    public short getHpsZoonFontPag() {
        return this.field_52_hpsZoonFontPag;
    }

    public void setHpsZoonFontPag(short field_52_hpsZoonFontPag) {
        this.field_52_hpsZoonFontPag = field_52_hpsZoonFontPag;
    }

    public short getDywDispPag() {
        return this.field_53_dywDispPag;
    }

    public void setDywDispPag(short field_53_dywDispPag) {
        this.field_53_dywDispPag = field_53_dywDispPag;
    }

    public void setFFacingPages(boolean value) {
        this.field_1_formatFlags = (byte)this.fFacingPages.setBoolean((int)this.field_1_formatFlags, value);
    }

    public boolean isFFacingPages() {
        return this.fFacingPages.isSet((int)this.field_1_formatFlags);
    }

    public void setFWidowControl(boolean value) {
        this.field_1_formatFlags = (byte)this.fWidowControl.setBoolean((int)this.field_1_formatFlags, value);
    }

    public boolean isFWidowControl() {
        return this.fWidowControl.isSet((int)this.field_1_formatFlags);
    }

    public void setFPMHMainDoc(boolean value) {
        this.field_1_formatFlags = (byte)this.fPMHMainDoc.setBoolean((int)this.field_1_formatFlags, value);
    }

    public boolean isFPMHMainDoc() {
        return this.fPMHMainDoc.isSet((int)this.field_1_formatFlags);
    }

    public void setGrfSupression(byte value) {
        this.field_1_formatFlags = (byte)this.grfSupression.setValue((int)this.field_1_formatFlags, (int)value);
    }

    public byte getGrfSupression() {
        return (byte)this.grfSupression.getValue((int)this.field_1_formatFlags);
    }

    public void setFpc(byte value) {
        this.field_1_formatFlags = (byte)this.fpc.setValue((int)this.field_1_formatFlags, (int)value);
    }

    public byte getFpc() {
        return (byte)this.fpc.getValue((int)this.field_1_formatFlags);
    }

    public void setUnused1(boolean value) {
        this.field_1_formatFlags = (byte)this.unused1.setBoolean((int)this.field_1_formatFlags, value);
    }

    public boolean isUnused1() {
        return this.unused1.isSet((int)this.field_1_formatFlags);
    }

    public void setRncFtn(byte value) {
        this.field_3_footnoteInfo = (short)this.rncFtn.setValue((int)this.field_3_footnoteInfo, (int)value);
    }

    public byte getRncFtn() {
        return (byte)this.rncFtn.getValue((int)this.field_3_footnoteInfo);
    }

    public void setNFtn(short value) {
        this.field_3_footnoteInfo = (short)this.nFtn.setValue((int)this.field_3_footnoteInfo, (int)value);
    }

    public short getNFtn() {
        return (short)this.nFtn.getValue((int)this.field_3_footnoteInfo);
    }

    public void setFOnlyMacPics(boolean value) {
        this.field_5_docinfo = (byte)this.fOnlyMacPics.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFOnlyMacPics() {
        return this.fOnlyMacPics.isSet((int)this.field_5_docinfo);
    }

    public void setFOnlyWinPics(boolean value) {
        this.field_5_docinfo = (byte)this.fOnlyWinPics.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFOnlyWinPics() {
        return this.fOnlyWinPics.isSet((int)this.field_5_docinfo);
    }

    public void setFLabelDoc(boolean value) {
        this.field_5_docinfo = (byte)this.fLabelDoc.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFLabelDoc() {
        return this.fLabelDoc.isSet((int)this.field_5_docinfo);
    }

    public void setFHyphCapitals(boolean value) {
        this.field_5_docinfo = (byte)this.fHyphCapitals.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFHyphCapitals() {
        return this.fHyphCapitals.isSet((int)this.field_5_docinfo);
    }

    public void setFAutoHyphen(boolean value) {
        this.field_5_docinfo = (byte)this.fAutoHyphen.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFAutoHyphen() {
        return this.fAutoHyphen.isSet((int)this.field_5_docinfo);
    }

    public void setFFormNoFields(boolean value) {
        this.field_5_docinfo = (byte)this.fFormNoFields.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFFormNoFields() {
        return this.fFormNoFields.isSet((int)this.field_5_docinfo);
    }

    public void setFLinkStyles(boolean value) {
        this.field_5_docinfo = (byte)this.fLinkStyles.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFLinkStyles() {
        return this.fLinkStyles.isSet((int)this.field_5_docinfo);
    }

    public void setFRevMarking(boolean value) {
        this.field_5_docinfo = (byte)this.fRevMarking.setBoolean((int)this.field_5_docinfo, value);
    }

    public boolean isFRevMarking() {
        return this.fRevMarking.isSet((int)this.field_5_docinfo);
    }

    public void setFBackup(boolean value) {
        this.field_6_docinfo1 = (byte)this.fBackup.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFBackup() {
        return this.fBackup.isSet((int)this.field_6_docinfo1);
    }

    public void setFExactCWords(boolean value) {
        this.field_6_docinfo1 = (byte)this.fExactCWords.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFExactCWords() {
        return this.fExactCWords.isSet((int)this.field_6_docinfo1);
    }

    public void setFPagHidden(boolean value) {
        this.field_6_docinfo1 = (byte)this.fPagHidden.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFPagHidden() {
        return this.fPagHidden.isSet((int)this.field_6_docinfo1);
    }

    public void setFPagResults(boolean value) {
        this.field_6_docinfo1 = (byte)this.fPagResults.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFPagResults() {
        return this.fPagResults.isSet((int)this.field_6_docinfo1);
    }

    public void setFLockAtn(boolean value) {
        this.field_6_docinfo1 = (byte)this.fLockAtn.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFLockAtn() {
        return this.fLockAtn.isSet((int)this.field_6_docinfo1);
    }

    public void setFMirrorMargins(boolean value) {
        this.field_6_docinfo1 = (byte)this.fMirrorMargins.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFMirrorMargins() {
        return this.fMirrorMargins.isSet((int)this.field_6_docinfo1);
    }

    public void setUnused3(boolean value) {
        this.field_6_docinfo1 = (byte)this.unused3.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isUnused3() {
        return this.unused3.isSet((int)this.field_6_docinfo1);
    }

    public void setFDfltTrueType(boolean value) {
        this.field_6_docinfo1 = (byte)this.fDfltTrueType.setBoolean((int)this.field_6_docinfo1, value);
    }

    public boolean isFDfltTrueType() {
        return this.fDfltTrueType.isSet((int)this.field_6_docinfo1);
    }

    public void setFPagSupressTopSpacing(boolean value) {
        this.field_7_docinfo2 = (byte)this.fPagSupressTopSpacing.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFPagSupressTopSpacing() {
        return this.fPagSupressTopSpacing.isSet((int)this.field_7_docinfo2);
    }

    public void setFProtEnabled(boolean value) {
        this.field_7_docinfo2 = (byte)this.fProtEnabled.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFProtEnabled() {
        return this.fProtEnabled.isSet((int)this.field_7_docinfo2);
    }

    public void setFDispFormFldSel(boolean value) {
        this.field_7_docinfo2 = (byte)this.fDispFormFldSel.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFDispFormFldSel() {
        return this.fDispFormFldSel.isSet((int)this.field_7_docinfo2);
    }

    public void setFRMView(boolean value) {
        this.field_7_docinfo2 = (byte)this.fRMView.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFRMView() {
        return this.fRMView.isSet((int)this.field_7_docinfo2);
    }

    public void setFRMPrint(boolean value) {
        this.field_7_docinfo2 = (byte)this.fRMPrint.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFRMPrint() {
        return this.fRMPrint.isSet((int)this.field_7_docinfo2);
    }

    public void setUnused4(boolean value) {
        this.field_7_docinfo2 = (byte)this.unused4.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isUnused4() {
        return this.unused4.isSet((int)this.field_7_docinfo2);
    }

    public void setFLockRev(boolean value) {
        this.field_7_docinfo2 = (byte)this.fLockRev.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFLockRev() {
        return this.fLockRev.isSet((int)this.field_7_docinfo2);
    }

    public void setFEmbedFonts(boolean value) {
        this.field_7_docinfo2 = (byte)this.fEmbedFonts.setBoolean((int)this.field_7_docinfo2, value);
    }

    public boolean isFEmbedFonts() {
        return this.fEmbedFonts.isSet((int)this.field_7_docinfo2);
    }

    public void setOldfNoTabForInd(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfNoTabForInd.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfNoTabForInd() {
        return this.oldfNoTabForInd.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfNoSpaceRaiseLower(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfNoSpaceRaiseLower.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfNoSpaceRaiseLower() {
        return this.oldfNoSpaceRaiseLower.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfSuppressSpbfAfterPageBreak(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfSuppressSpbfAfterPageBreak.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfSuppressSpbfAfterPageBreak() {
        return this.oldfSuppressSpbfAfterPageBreak.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfWrapTrailSpaces(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfWrapTrailSpaces.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfWrapTrailSpaces() {
        return this.oldfWrapTrailSpaces.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfMapPrintTextColor(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfMapPrintTextColor.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfMapPrintTextColor() {
        return this.oldfMapPrintTextColor.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfNoColumnBalance(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfNoColumnBalance.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfNoColumnBalance() {
        return this.oldfNoColumnBalance.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfConvMailMergeEsc(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfConvMailMergeEsc.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfConvMailMergeEsc() {
        return this.oldfConvMailMergeEsc.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfSupressTopSpacing(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfSupressTopSpacing.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfSupressTopSpacing() {
        return this.oldfSupressTopSpacing.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfOrigWordTableRules(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfOrigWordTableRules.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfOrigWordTableRules() {
        return this.oldfOrigWordTableRules.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfTransparentMetafiles(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfTransparentMetafiles.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfTransparentMetafiles() {
        return this.oldfTransparentMetafiles.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfShowBreaksInFrames(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfShowBreaksInFrames.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfShowBreaksInFrames() {
        return this.oldfShowBreaksInFrames.isSet((int)this.field_8_docinfo3);
    }

    public void setOldfSwapBordersFacingPgs(boolean value) {
        this.field_8_docinfo3 = (short)this.oldfSwapBordersFacingPgs.setBoolean((int)this.field_8_docinfo3, value);
    }

    public boolean isOldfSwapBordersFacingPgs() {
        return this.oldfSwapBordersFacingPgs.isSet((int)this.field_8_docinfo3);
    }

    public void setUnused5(byte value) {
        this.field_8_docinfo3 = (short)this.unused5.setValue((int)this.field_8_docinfo3, (int)value);
    }

    public byte getUnused5() {
        return (byte)this.unused5.getValue((int)this.field_8_docinfo3);
    }

    public void setRncEdn(byte value) {
        this.field_23_Edn = (short)this.rncEdn.setValue((int)this.field_23_Edn, (int)value);
    }

    public byte getRncEdn() {
        return (byte)this.rncEdn.getValue((int)this.field_23_Edn);
    }

    public void setNEdn(short value) {
        this.field_23_Edn = (short)this.nEdn.setValue((int)this.field_23_Edn, (int)value);
    }

    public short getNEdn() {
        return (short)this.nEdn.getValue((int)this.field_23_Edn);
    }

    public void setEpc(byte value) {
        this.field_24_Edn1 = (short)this.epc.setValue((int)this.field_24_Edn1, (int)value);
    }

    public byte getEpc() {
        return (byte)this.epc.getValue((int)this.field_24_Edn1);
    }

    public void setNfcFtnRef1(byte value) {
        this.field_24_Edn1 = (short)this.nfcFtnRef1.setValue((int)this.field_24_Edn1, (int)value);
    }

    public byte getNfcFtnRef1() {
        return (byte)this.nfcFtnRef1.getValue((int)this.field_24_Edn1);
    }

    public void setNfcEdnRef1(byte value) {
        this.field_24_Edn1 = (short)this.nfcEdnRef1.setValue((int)this.field_24_Edn1, (int)value);
    }

    public byte getNfcEdnRef1() {
        return (byte)this.nfcEdnRef1.getValue((int)this.field_24_Edn1);
    }

    public void setFPrintFormData(boolean value) {
        this.field_24_Edn1 = (short)this.fPrintFormData.setBoolean((int)this.field_24_Edn1, value);
    }

    public boolean isFPrintFormData() {
        return this.fPrintFormData.isSet((int)this.field_24_Edn1);
    }

    public void setFSaveFormData(boolean value) {
        this.field_24_Edn1 = (short)this.fSaveFormData.setBoolean((int)this.field_24_Edn1, value);
    }

    public boolean isFSaveFormData() {
        return this.fSaveFormData.isSet((int)this.field_24_Edn1);
    }

    public void setFShadeFormData(boolean value) {
        this.field_24_Edn1 = (short)this.fShadeFormData.setBoolean((int)this.field_24_Edn1, value);
    }

    public boolean isFShadeFormData() {
        return this.fShadeFormData.isSet((int)this.field_24_Edn1);
    }

    public void setFWCFtnEdn(boolean value) {
        this.field_24_Edn1 = (short)this.fWCFtnEdn.setBoolean((int)this.field_24_Edn1, value);
    }

    public boolean isFWCFtnEdn() {
        return this.fWCFtnEdn.isSet((int)this.field_24_Edn1);
    }

    public void setWvkSaved(byte value) {
        this.field_32_view = (short)this.wvkSaved.setValue((int)this.field_32_view, (int)value);
    }

    public byte getWvkSaved() {
        return (byte)this.wvkSaved.getValue((int)this.field_32_view);
    }

    public void setWScaleSaved(short value) {
        this.field_32_view = (short)this.wScaleSaved.setValue((int)this.field_32_view, (int)value);
    }

    public short getWScaleSaved() {
        return (short)this.wScaleSaved.getValue((int)this.field_32_view);
    }

    public void setZkSaved(byte value) {
        this.field_32_view = (short)this.zkSaved.setValue((int)this.field_32_view, (int)value);
    }

    public byte getZkSaved() {
        return (byte)this.zkSaved.getValue((int)this.field_32_view);
    }

    public void setFRotateFontW6(boolean value) {
        this.field_32_view = (short)this.fRotateFontW6.setBoolean((int)this.field_32_view, value);
    }

    public boolean isFRotateFontW6() {
        return this.fRotateFontW6.isSet((int)this.field_32_view);
    }

    public void setIGutterPos(boolean value) {
        this.field_32_view = (short)this.iGutterPos.setBoolean((int)this.field_32_view, value);
    }

    public boolean isIGutterPos() {
        return this.iGutterPos.isSet((int)this.field_32_view);
    }

    public void setFNoTabForInd(boolean value) {
        this.field_33_docinfo4 = this.fNoTabForInd.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFNoTabForInd() {
        return this.fNoTabForInd.isSet(this.field_33_docinfo4);
    }

    public void setFNoSpaceRaiseLower(boolean value) {
        this.field_33_docinfo4 = this.fNoSpaceRaiseLower.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFNoSpaceRaiseLower() {
        return this.fNoSpaceRaiseLower.isSet(this.field_33_docinfo4);
    }

    public void setFSupressSpdfAfterPageBreak(boolean value) {
        this.field_33_docinfo4 = this.fSupressSpdfAfterPageBreak.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFSupressSpdfAfterPageBreak() {
        return this.fSupressSpdfAfterPageBreak.isSet(this.field_33_docinfo4);
    }

    public void setFWrapTrailSpaces(boolean value) {
        this.field_33_docinfo4 = this.fWrapTrailSpaces.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFWrapTrailSpaces() {
        return this.fWrapTrailSpaces.isSet(this.field_33_docinfo4);
    }

    public void setFMapPrintTextColor(boolean value) {
        this.field_33_docinfo4 = this.fMapPrintTextColor.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFMapPrintTextColor() {
        return this.fMapPrintTextColor.isSet(this.field_33_docinfo4);
    }

    public void setFNoColumnBalance(boolean value) {
        this.field_33_docinfo4 = this.fNoColumnBalance.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFNoColumnBalance() {
        return this.fNoColumnBalance.isSet(this.field_33_docinfo4);
    }

    public void setFConvMailMergeEsc(boolean value) {
        this.field_33_docinfo4 = this.fConvMailMergeEsc.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFConvMailMergeEsc() {
        return this.fConvMailMergeEsc.isSet(this.field_33_docinfo4);
    }

    public void setFSupressTopSpacing(boolean value) {
        this.field_33_docinfo4 = this.fSupressTopSpacing.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFSupressTopSpacing() {
        return this.fSupressTopSpacing.isSet(this.field_33_docinfo4);
    }

    public void setFOrigWordTableRules(boolean value) {
        this.field_33_docinfo4 = this.fOrigWordTableRules.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFOrigWordTableRules() {
        return this.fOrigWordTableRules.isSet(this.field_33_docinfo4);
    }

    public void setFTransparentMetafiles(boolean value) {
        this.field_33_docinfo4 = this.fTransparentMetafiles.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFTransparentMetafiles() {
        return this.fTransparentMetafiles.isSet(this.field_33_docinfo4);
    }

    public void setFShowBreaksInFrames(boolean value) {
        this.field_33_docinfo4 = this.fShowBreaksInFrames.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFShowBreaksInFrames() {
        return this.fShowBreaksInFrames.isSet(this.field_33_docinfo4);
    }

    public void setFSwapBordersFacingPgs(boolean value) {
        this.field_33_docinfo4 = this.fSwapBordersFacingPgs.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFSwapBordersFacingPgs() {
        return this.fSwapBordersFacingPgs.isSet(this.field_33_docinfo4);
    }

    public void setFSuppressTopSPacingMac5(boolean value) {
        this.field_33_docinfo4 = this.fSuppressTopSPacingMac5.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFSuppressTopSPacingMac5() {
        return this.fSuppressTopSPacingMac5.isSet(this.field_33_docinfo4);
    }

    public void setFTruncDxaExpand(boolean value) {
        this.field_33_docinfo4 = this.fTruncDxaExpand.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFTruncDxaExpand() {
        return this.fTruncDxaExpand.isSet(this.field_33_docinfo4);
    }

    public void setFPrintBodyBeforeHdr(boolean value) {
        this.field_33_docinfo4 = this.fPrintBodyBeforeHdr.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFPrintBodyBeforeHdr() {
        return this.fPrintBodyBeforeHdr.isSet(this.field_33_docinfo4);
    }

    public void setFNoLeading(boolean value) {
        this.field_33_docinfo4 = this.fNoLeading.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFNoLeading() {
        return this.fNoLeading.isSet(this.field_33_docinfo4);
    }

    public void setFMWSmallCaps(boolean value) {
        this.field_33_docinfo4 = this.fMWSmallCaps.setBoolean(this.field_33_docinfo4, value);
    }

    public boolean isFMWSmallCaps() {
        return this.fMWSmallCaps.isSet(this.field_33_docinfo4);
    }

    public void setLvl(byte value) {
        this.field_37_docinfo5 = (short)this.lvl.setValue((int)this.field_37_docinfo5, (int)value);
    }

    public byte getLvl() {
        return (byte)this.lvl.getValue((int)this.field_37_docinfo5);
    }

    public void setFGramAllDone(boolean value) {
        this.field_37_docinfo5 = (short)this.fGramAllDone.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFGramAllDone() {
        return this.fGramAllDone.isSet((int)this.field_37_docinfo5);
    }

    public void setFGramAllClean(boolean value) {
        this.field_37_docinfo5 = (short)this.fGramAllClean.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFGramAllClean() {
        return this.fGramAllClean.isSet((int)this.field_37_docinfo5);
    }

    public void setFSubsetFonts(boolean value) {
        this.field_37_docinfo5 = (short)this.fSubsetFonts.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFSubsetFonts() {
        return this.fSubsetFonts.isSet((int)this.field_37_docinfo5);
    }

    public void setFHideLastVersion(boolean value) {
        this.field_37_docinfo5 = (short)this.fHideLastVersion.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFHideLastVersion() {
        return this.fHideLastVersion.isSet((int)this.field_37_docinfo5);
    }

    public void setFHtmlDoc(boolean value) {
        this.field_37_docinfo5 = (short)this.fHtmlDoc.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFHtmlDoc() {
        return this.fHtmlDoc.isSet((int)this.field_37_docinfo5);
    }

    public void setFSnapBorder(boolean value) {
        this.field_37_docinfo5 = (short)this.fSnapBorder.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFSnapBorder() {
        return this.fSnapBorder.isSet((int)this.field_37_docinfo5);
    }

    public void setFIncludeHeader(boolean value) {
        this.field_37_docinfo5 = (short)this.fIncludeHeader.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFIncludeHeader() {
        return this.fIncludeHeader.isSet((int)this.field_37_docinfo5);
    }

    public void setFIncludeFooter(boolean value) {
        this.field_37_docinfo5 = (short)this.fIncludeFooter.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFIncludeFooter() {
        return this.fIncludeFooter.isSet((int)this.field_37_docinfo5);
    }

    public void setFForcePageSizePag(boolean value) {
        this.field_37_docinfo5 = (short)this.fForcePageSizePag.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFForcePageSizePag() {
        return this.fForcePageSizePag.isSet((int)this.field_37_docinfo5);
    }

    public void setFMinFontSizePag(boolean value) {
        this.field_37_docinfo5 = (short)this.fMinFontSizePag.setBoolean((int)this.field_37_docinfo5, value);
    }

    public boolean isFMinFontSizePag() {
        return this.fMinFontSizePag.isSet((int)this.field_37_docinfo5);
    }

    public void setFHaveVersions(boolean value) {
        this.field_38_docinfo6 = (short)this.fHaveVersions.setBoolean((int)this.field_38_docinfo6, value);
    }

    public boolean isFHaveVersions() {
        return this.fHaveVersions.isSet((int)this.field_38_docinfo6);
    }

    public void setFAutoVersions(boolean value) {
        this.field_38_docinfo6 = (short)this.fAutoVersions.setBoolean((int)this.field_38_docinfo6, value);
    }

    public boolean isFAutoVersions() {
        return this.fAutoVersions.isSet((int)this.field_38_docinfo6);
    }

    public void setFVirusPrompted(boolean value) {
        this.field_43_virusinfo = this.fVirusPrompted.setBoolean(this.field_43_virusinfo, value);
    }

    public boolean isFVirusPrompted() {
        return this.fVirusPrompted.isSet(this.field_43_virusinfo);
    }

    public void setFVirusLoadSafe(boolean value) {
        this.field_43_virusinfo = this.fVirusLoadSafe.setBoolean(this.field_43_virusinfo, value);
    }

    public boolean isFVirusLoadSafe() {
        return this.fVirusLoadSafe.isSet(this.field_43_virusinfo);
    }

    public void setKeyVirusSession30(int value) {
        this.field_43_virusinfo = this.KeyVirusSession30.setValue(this.field_43_virusinfo, value);
    }

    public int getKeyVirusSession30() {
        return this.KeyVirusSession30.getValue(this.field_43_virusinfo);
    }
}

