/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.ExceptionHandler;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class RequestProcessor {
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    protected HashMap actions = new HashMap();
    protected ModuleConfig moduleConfig = null;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$struts$action$RequestProcessor == null ? (class$org$apache$struts$action$RequestProcessor = RequestProcessor.class$("org.apache.struts.action.RequestProcessor")) : class$org$apache$struts$action$RequestProcessor));
    protected ActionServlet servlet = null;
    static /* synthetic */ Class class$org$apache$struts$action$RequestProcessor;

    public void destroy() {
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            Iterator actions = this.actions.values().iterator();
            while (actions.hasNext()) {
                Action action = (Action)actions.next();
                action.setServlet(null);
            }
            this.actions.clear();
        }
        this.servlet = null;
    }

    public void init(ActionServlet servlet, ModuleConfig moduleConfig) throws ServletException {
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            this.actions.clear();
        }
        this.servlet = servlet;
        this.moduleConfig = moduleConfig;
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String path = this.processPath(request = this.processMultipart(request), response);
        if (path == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing a '" + request.getMethod() + "' for path '" + path + "'"));
        }
        this.processLocale(request, response);
        this.processContent(request, response);
        this.processNoCache(request, response);
        if (!this.processPreprocess(request, response)) {
            return;
        }
        this.processCachedMessages(request, response);
        ActionMapping mapping = this.processMapping(request, response, path);
        if (mapping == null) {
            return;
        }
        if (!this.processRoles(request, response, mapping)) {
            return;
        }
        ActionForm form = this.processActionForm(request, response, mapping);
        this.processPopulate(request, response, form, mapping);
        if (!this.processValidate(request, response, form, mapping)) {
            return;
        }
        if (!this.processForward(request, response, mapping)) {
            return;
        }
        if (!this.processInclude(request, response, mapping)) {
            return;
        }
        Action action = this.processActionCreate(request, response, mapping);
        if (action == null) {
            return;
        }
        ActionForward forward = this.processActionPerform(request, response, action, form, mapping);
        this.processForwardConfig(request, response, forward);
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException {
        String className = mapping.getType();
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Looking for Action instance for class " + className));
        }
        Action instance = null;
        HashMap hashMap = this.actions;
        synchronized (hashMap) {
            instance = (Action)this.actions.get(className);
            if (instance != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"  Returning existing Action instance");
                }
                Action action = instance;
                return action;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Creating new Action instance");
            }
            try {
                instance = (Action)RequestUtils.applicationInstance(className);
            }
            catch (Exception e) {
                log.error((Object)this.getInternal().getMessage("actionCreate", (Object)mapping.getPath()), (Throwable)e);
                response.sendError(500, this.getInternal().getMessage("actionCreate", (Object)mapping.getPath()));
                Action action = null;
                return action;
            }
            instance.setServlet(this.servlet);
            this.actions.put(className, instance);
        }
        return instance;
    }

    protected ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) {
        ActionForm instance = RequestUtils.createActionForm(request, mapping, this.moduleConfig, this.servlet);
        if (instance == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Storing ActionForm bean instance in scope '" + mapping.getScope() + "' under attribute key '" + mapping.getAttribute() + "'"));
        }
        if ("request".equals(mapping.getScope())) {
            request.setAttribute(mapping.getAttribute(), (Object)instance);
        } else {
            HttpSession session = request.getSession();
            session.setAttribute(mapping.getAttribute(), (Object)instance);
        }
        return instance;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        if (forward == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("processForwardConfig(" + forward + ")"));
        }
        String forwardPath = forward.getPath();
        String uri = null;
        uri = forwardPath.startsWith("/") ? RequestUtils.forwardURL(request, forward, null) : forwardPath;
        if (forward.getRedirect()) {
            if (uri.startsWith("/")) {
                uri = request.getContextPath() + uri;
            }
            response.sendRedirect(response.encodeRedirectURL(uri));
        } else {
            this.doForward(uri, request, response);
        }
    }

    protected ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        try {
            return action.execute(mapping, form, request, response);
        }
        catch (Exception e) {
            return this.processException(request, response, e, form, mapping);
        }
    }

    protected void processCachedMessages(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        ActionMessages messages = (ActionMessages)session.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        if (messages != null && messages.isAccessed()) {
            session.removeAttribute("org.apache.struts.action.ACTION_MESSAGE");
        }
        if ((messages = (ActionMessages)session.getAttribute("org.apache.struts.action.ERROR")) != null && messages.isAccessed()) {
            session.removeAttribute("org.apache.struts.action.ERROR");
        }
    }

    protected void processContent(HttpServletRequest request, HttpServletResponse response) {
        String contentType = this.moduleConfig.getControllerConfig().getContentType();
        if (contentType != null) {
            response.setContentType(contentType);
        }
    }

    protected ActionForward processException(HttpServletRequest request, HttpServletResponse response, Exception exception, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        ExceptionConfig config = mapping.findException(exception.getClass());
        if (config == null) {
            log.warn((Object)this.getInternal().getMessage("unhandledException", exception.getClass()));
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ServletException) {
                throw (ServletException)((Object)exception);
            }
            throw new ServletException((Throwable)exception);
        }
        try {
            ExceptionHandler handler = (ExceptionHandler)RequestUtils.applicationInstance(config.getHandler());
            return handler.execute(exception, config, mapping, form, request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String forward = mapping.getForward();
        if (forward == null) {
            return true;
        }
        this.internalModuleRelativeForward(forward, request, response);
        return false;
    }

    protected boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String include = mapping.getInclude();
        if (include == null) {
            return true;
        }
        this.internalModuleRelativeInclude(include, request, response);
        return false;
    }

    protected void processLocale(HttpServletRequest request, HttpServletResponse response) {
        if (!this.moduleConfig.getControllerConfig().getLocale()) {
            return;
        }
        HttpSession session = request.getSession();
        if (session.getAttribute("org.apache.struts.action.LOCALE") != null) {
            return;
        }
        Locale locale = request.getLocale();
        if (locale != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Setting user locale '" + locale + "'"));
            }
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)locale);
        }
    }

    protected ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        ActionMapping mapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        if (mapping != null) {
            request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
            return mapping;
        }
        ActionConfig[] configs = this.moduleConfig.findActionConfigs();
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getUnknown()) {
                mapping = (ActionMapping)configs[i];
                request.setAttribute("org.apache.struts.action.mapping.instance", (Object)mapping);
                return mapping;
            }
            ++i;
        }
        String msg = this.getInternal().getMessage("processInvalid");
        log.error((Object)(msg + " " + path));
        response.sendError(404, msg);
        return null;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return request;
        }
        String contentType = request.getContentType();
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            return new MultipartRequestWrapper(request);
        }
        return request;
    }

    protected void processNoCache(HttpServletRequest request, HttpServletResponse response) {
        if (this.moduleConfig.getControllerConfig().getNocache()) {
            response.setHeader("Pragma", "No-cache");
            response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
            response.setDateHeader("Expires", 1L);
        }
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String prefix;
        String path = null;
        path = (String)request.getAttribute(INCLUDE_PATH_INFO);
        if (path == null) {
            path = request.getPathInfo();
        }
        if (path != null && path.length() > 0) {
            return path;
        }
        path = (String)request.getAttribute(INCLUDE_SERVLET_PATH);
        if (path == null) {
            path = request.getServletPath();
        }
        if (!path.startsWith(prefix = this.moduleConfig.getPrefix())) {
            String msg = this.getInternal().getMessage("processPath");
            log.error((Object)(msg + " " + request.getRequestURI()));
            response.sendError(400, msg);
            return null;
        }
        path = path.substring(prefix.length());
        int slash = path.lastIndexOf("/");
        int period = path.lastIndexOf(".");
        if (period >= 0 && period > slash) {
            path = path.substring(0, period);
        }
        return path;
    }

    protected void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws ServletException {
        if (form == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Populating bean properties from this request");
        }
        form.setServlet(this.servlet);
        form.reset(mapping, request);
        if (mapping.getMultipartClass() != null) {
            request.setAttribute("org.apache.struts.action.mapping.multipartclass", (Object)mapping.getMultipartClass());
        }
        RequestUtils.populate(form, mapping.getPrefix(), mapping.getSuffix(), request);
        if (request.getParameter("org.apache.struts.taglib.html.CANCEL") != null || request.getParameter("org.apache.struts.taglib.html.CANCEL.x") != null) {
            request.setAttribute("org.apache.struts.action.CANCEL", (Object)Boolean.TRUE);
        }
    }

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping) throws IOException, ServletException {
        String[] roles = mapping.getRoleNames();
        if (roles == null || roles.length < 1) {
            return true;
        }
        int i = 0;
        while (i < roles.length) {
            if (request.isUserInRole(roles[i])) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" User '" + request.getRemoteUser() + "' has role '" + roles[i] + "', granting access"));
                }
                return true;
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" User '" + request.getRemoteUser() + "' does not have any required role, denying access"));
        }
        response.sendError(403, this.getInternal().getMessage("notAuthorized", (Object)mapping.getPath()));
        return false;
    }

    protected boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        String input;
        ActionErrors errors;
        if (form == null) {
            return true;
        }
        if (request.getAttribute("org.apache.struts.action.CANCEL") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)" Cancelled transaction, skipping validation");
            }
            return true;
        }
        if (!mapping.getValidate()) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)" Validating input form properties");
        }
        if ((errors = form.validate(mapping, request)) == null || errors.isEmpty()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  No errors detected, accepting input");
            }
            return true;
        }
        if (form.getMultipartRequestHandler() != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Rolling back multipart request");
            }
            form.getMultipartRequestHandler().rollback();
        }
        if ((input = mapping.getInput()) == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Validation failed but no input form available");
            }
            response.sendError(500, this.getInternal().getMessage("noInput", (Object)mapping.getPath()));
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Validation failed, returning to '" + input + "'"));
        }
        request.setAttribute("org.apache.struts.action.ERROR", (Object)errors);
        if (this.moduleConfig.getControllerConfig().getInputForward()) {
            ActionForward forward = mapping.findForward(input);
            this.processForwardConfig(request, response, forward);
        } else {
            this.internalModuleRelativeForward(input, request, response);
        }
        return false;
    }

    protected void internalModuleRelativeForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        uri = this.moduleConfig.getPrefix() + uri;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Delegating via forward to '" + uri + "'"));
        }
        this.doForward(uri, request, response);
    }

    protected void internalModuleRelativeInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        uri = this.moduleConfig.getPrefix() + uri;
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Delegating via include to '" + uri + "'"));
        }
        this.doInclude(uri, request, response);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher rd;
        if (request instanceof MultipartRequestWrapper) {
            request = ((MultipartRequestWrapper)request).getRequest();
        }
        if ((rd = this.getServletContext().getRequestDispatcher(uri)) == null) {
            response.sendError(500, this.getInternal().getMessage("requestDispatcher", (Object)uri));
            return;
        }
        rd.include((ServletRequest)request, (ServletResponse)response);
    }

    protected MessageResources getInternal() {
        return this.servlet.getInternal();
    }

    protected ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }

    protected void log(String message) {
        this.servlet.log(message);
    }

    protected void log(String message, Throwable exception) {
        this.servlet.log(message, exception);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

