package net.yher.workstyle.action.tagType.rest;

import javax.servlet.http.HttpServletRequest;

import net.yher.commons.struts.Validator;
import net.yher.workstyle.Properties;
import net.yher.workstyle.torque.bean.TagTypeBean;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;

public class EditForm extends AddForm {
	private int tagTypeId;

	@Override
	public void reset(ActionMapping mapping, HttpServletRequest request) {
		super.reset(mapping, request);
		tagTypeId = 0;
	}

	@Override
	public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
		Validator validator = new Validator(super.validate(mapping, request));
		validator.verifyRequired(Properties.TAG_TYPE_ID, tagTypeId);
		return validator.getErrors();
	}
	
	protected TagTypeBean getTagTypeBean() {
		TagTypeBean bean = super.getTagTypeBean();
		bean.setTagTypeId(tagTypeId);
		return bean;
	}

	public int getTagTypeId() {
		return tagTypeId;
	}

	public void setTagTypeId(int tagTypeId) {
		this.tagTypeId = tagTypeId;
	}
}
