package net.yher.waft.controller;

import net.yher.waft.controller.URLMapPattern;
import junit.framework.TestCase;

public class URLMapPatternTest extends TestCase {
	String url = "^/task/(\\d)/$";
	String klass = "net.yher.workstyle.controller.Task";
	String method = "get";
	String argument = "{id:\\1, show:\"detail\"}";

	public void testUrlMap_no_argument() {
		URLMapPattern map = new URLMapPattern(url + "\t"+ klass + "\t" + method);
		
		assertEquals(url, map.getUrlPattern().toString());
		assertEquals(klass, map.getClassName());
		assertEquals(method, map.getMethod());
	}
	public void testUrlMap_with_argument() {
		URLMapPattern map = new URLMapPattern(url + "\t"+ klass + "\t" + method + "\t" + argument);
		
		assertEquals(url, map.getUrlPattern().toString());
		assertEquals(klass, map.getClassName());
		assertEquals(method, map.getMethod());
		assertEquals(argument, map.getArgumentJSON());
	}
	public void testUrlMap_line_is_not_enough() {
		try {
			new URLMapPattern(url + "\t"+ klass);
		} catch (IllegalArgumentException e) {
			return;
		}
		fail();
	}

	/**
	 * space is used to write JSON string.
	 * so url map pattern can't use space as splitter.
	 */
	public void testURLMap_split_with_tab_and_space() {
		try {
			new URLMapPattern(url + " "+ klass + " " + method + " " + argument);
		} catch (IllegalArgumentException e) {
			return;
		}
		fail();
	}
}

