/**
 * Copyright (c) 2006, yher project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.workstyle.torque.bean;

import java.util.List;

import junit.framework.TestCase;

public class TaskBeanTest extends TestCase {
    public void testParseTagList() {
        List<String> result = TaskBean.parseTagList("[test 1st]test 1st test");
        assertEquals(3, result.size());
        assertTrue(result.contains("test 1st"));
        assertTrue(result.contains("test"));
        assertTrue(result.contains("1st"));
        
        result = TaskBean.parseTagList("[aaa[bbb]ccc]");
        assertEquals(3, result.size());
        assertTrue(result.contains("aaa"));
        assertTrue(result.contains("bbb"));
        assertTrue(result.contains("ccc"));

        result = TaskBean.parseTagList("[aaa");
        assertEquals(1, result.size());
        assertTrue(result.contains("aaa"));

        result = TaskBean.parseTagList("aaa]");
        assertEquals(1, result.size());
        assertTrue(result.contains("aaa"));
    }

    public void testNormalizeTagList() {
        String result = TaskBean.normalizeTagList("[test 1st]test 1st test");
        assertEquals("[test 1st][test][1st]", result);
    }

}
