package net.yher.waft.controller;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ControllerServlet extends HttpServlet {
	List<URLMapTable> mapTableList = null;

	@Override
	public void init() throws ServletException {
		super.init();
		String releaseSetting = getServletConfig().getInitParameter("release");
		URLMapPattern.setRelease(Boolean.valueOf(releaseSetting));
		
		String pathParam = getServletConfig().getInitParameter("path");
		if (pathParam == null || pathParam.length() == 0) throw new UnavailableException("path configuration is required.");
		mapTableList = new ArrayList<URLMapTable>();
		String paths[] = pathParam.split("[ \t,]");
		for (String path : paths) {
				try {
					mapTableList.add(new URLMapTable(getServletConfig().getServletContext().getResource(path)));
				} catch (MalformedURLException e) {
					throw new UnavailableException("path configuration is invalid: " + path);
				}
		}
		
	}

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doAction(request, response);
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doAction(request, response);
	}
	
	protected void doAction(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		HttpRequest request = new HttpRequest(req);
		HttpResponse response = new HttpResponse(res);
		String relativeURL = request.getRequestURI().substring(req.getContextPath().length());
		for (URLMapTable mapTable : mapTableList) {
			URLMap map = mapTable.find(relativeURL);
			if (map != null) {
				try {
					String forward = map.invokeAction(request, response);
					if (forward != null) {
						request.getRequestDispatcher(forward).forward(req, res);
					}
				} catch (IOException e) {
					throw e;
				} catch (ServletException e) {
					throw e;
				} catch (Exception e) {
					e.printStackTrace();
					res.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
				}
				return;
			}
		}
		res.sendError(HttpServletResponse.SC_NOT_FOUND);
	}

}
