/**
 * Copyright (c) 2006, yher project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.waft.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import net.yher.commons.lang.BeanUtils;

public class ParameterMap implements Map {
    private Map paramter = null;

    public ParameterMap(Map map) {
        this.paramter = map;
    }

    public <T> T populate(T bean) throws IllegalAccessException, InvocationTargetException {
        BeanUtils.populate(bean, this);
        return bean;
    }

    @SuppressWarnings("unchecked")
    public <T> T populate(T bean, Map<String, String> attributeMap) throws IllegalAccessException, InvocationTargetException {
        Map tmpMap = new HashMap();
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (attributeMap.containsKey(key)) {
                tmpMap.put(attributeMap.get(key), this.get(key));
            } else {
                tmpMap.put(key, this.get(key));
            }
        }

        BeanUtils.populate(bean, tmpMap);
        return bean;
    }

    public void clear() {
        paramter.clear();
    }

    public boolean containsKey(Object key) {
        return paramter.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return paramter.containsValue(value);
    }

    public Set entrySet() {
        return paramter.entrySet();
    }

    public Object get(Object key) {
        return paramter.get(key);
    }

    public boolean isEmpty() {
        return paramter.isEmpty();
    }

    public Set keySet() {
        return paramter.keySet();
    }

    @SuppressWarnings("unchecked")
    public Object put(Object key, Object value) {
        return paramter.put(key, value);
    }

    @SuppressWarnings("unchecked")
    public void putAll(Map t) {
        paramter.putAll(t);
    }

    public Object remove(Object key) {
        return paramter.remove(key);
    }

    public int size() {
        return paramter.size();
    }

    public Collection values() {
        return paramter.values();
    }

}
