package net.yher.waft.db;

import groovy.lang.Closure;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.torque.Torque;
import org.apache.torque.TorqueException;

public class Transaction {
	public static Object commitOnSuccess(Closure closure) throws TorqueException {
		Connection con = null;
		try {
			con = begin(Torque.getDefaultDB());
			Object obj = closure.call(con);
			commit(con);
            return obj;
		} finally {
			rollback(con);
		}
	}
	public static Object rollbackOnSuccess(Closure closure) throws TorqueException {
		Connection con = null;
		try {
			con = begin(Torque.getDefaultDB());
			return closure.call(con);
		} finally {
			rollback(con);
		}
	}
    
	public static Connection begin(String dbName) throws TorqueException {
		Connection con = Torque.getConnection(dbName);
		try {
			if (con.getMetaData().supportsTransactions()) {
				con.setAutoCommit(false);
			}
		} catch (SQLException e) {
			throw new TorqueException(e);
		}
		return con;
	}
    /**
     * Commit a transaction.  This method takes care of releasing the
     * connection after the commit.  In databases that do not support
     * transactions, it only returns the connection.
     *
     * @param con The Connection for the transaction.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    private static void commit(Connection con) throws TorqueException {
        if (con == null) {
            throw new NullPointerException("Connection object was null. "
                    + "This could be due to a misconfiguration of the "
                    + "DataSourceFactory. Check the logs and Torque.properties "
                    + "to better determine the cause.");
        }

        try {
            if (con.getMetaData().supportsTransactions()) {
                con.commit();
            }
        } catch (SQLException e) {
            throw new TorqueException(e);
        }
    }
    /**
     * Roll back a transaction in databases that support transactions.
     * It also releases the connection. In databases that do not support
     * transactions, this method will log the attempt and release the
     * connection.
     *
     * @param con The Connection for the transaction.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void rollback(Connection con) throws TorqueException {
        if (con != null) {
            org.apache.torque.util.Transaction.rollback(con);
        }
    }
}
