package net.yher.workstyle.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import net.yher.commons.lang.Pager;
import net.yher.workstyle.TaskQuery;
import net.yher.workstyle.torque.bean.StatusBean;
import net.yher.workstyle.torque.bean.TagBean;
import net.yher.workstyle.torque.bean.TagTypeBean;
import net.yher.workstyle.torque.bean.TaskBean;

import org.apache.torque.TorqueException;

public class Session {
	private HttpServletRequest request = null;
	public static final String SESSION_UNLINKED_TASK_PAGER = "unlinkedTaskPager";
	public static final String SESSION_UNLINKED_TASK_QUERY = "unlinkedTaskQuery";
	public static final String SESSION_TASK_PAGER = "taskPager";
	public static final String SESSION_TASK_QUERY = "taskQuery";
	public static final String ATTRIBUTE_TASK = "task";
	public static final String ATTRIBUTE_TASK_LIST = "taskList";
	public static final String ATTRIBUTE_STATUS_LIST = "statusList";
	public static final String ATTRIBUTE_TAG_MAP = "tagMap";
	public static final String ATTRIBUTE_TAG_LIST = "tagList";
	public static final String TAG = "tag";
	public static final String TAG_TYPE = "tagType";
	public static final String TAG_TYPE_LIST = "tagTypeList";

	public Session(HttpServletRequest request) {
		this.request = request;
	}
	
	public void setStatusList(List<StatusBean> list) {
		request.setAttribute(ATTRIBUTE_STATUS_LIST, list);
	}
	public void setTask(TaskBean task) {
		request.setAttribute(ATTRIBUTE_TASK, task);
	}
	public void setTaskList(List<TaskBean> list) {
		request.setAttribute(ATTRIBUTE_TASK_LIST, list);
	}
	public void setTagTypeList(List<TagTypeBean> list) {
		request.setAttribute(TAG_TYPE_LIST, list);
	}
	public void setTagType(TagTypeBean type) throws TorqueException {
		request.setAttribute(TAG_TYPE, type);
	}
	public void setTag(TagBean tag) throws TorqueException {
		request.setAttribute(TAG, tag);
	}
	public void setTagList(List<TagBean> list) throws TorqueException {
		Map<String, TagBean> map = new HashMap<String, TagBean>();
		for (TagBean tag : list) {
			map.put(tag.getName(), tag);
		}
		request.setAttribute(ATTRIBUTE_TAG_LIST, list);
		request.setAttribute(ATTRIBUTE_TAG_MAP, map);
	}
	public TaskQuery getQuery() {
		TaskQuery query = (TaskQuery)request.getSession().getAttribute(Session.SESSION_TASK_QUERY);
		if (query == null) query = new TaskQuery();
		request.getSession().setAttribute(Session.SESSION_TASK_QUERY, query);
		return query;
	}
	public void setQuery(TaskQuery query, Pager pager) {
		request.getSession().setAttribute(SESSION_TASK_QUERY, query);
		request.getSession().setAttribute(SESSION_TASK_PAGER, pager);
	}
	public void setUnlinkedTaskQuery(TaskQuery query, Pager pager) {
		request.getSession().setAttribute(SESSION_UNLINKED_TASK_QUERY, query);
		request.getSession().setAttribute(SESSION_UNLINKED_TASK_PAGER, pager);
	}
}
