/**
 * Copyright (c) 2006, yher project
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.workstyle.manager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.derby.tools.ij;

public class SystemManager {
    private Log log = LogFactory.getLog(this.getClass());
    public static enum VERSION {
        V0_4("0.4"), V1_0a("1.0a");
        String value = "";

        private VERSION(String value) {
            this.value = value;
        }

        public static VERSION valueOfVersionString(String value) {
            for (VERSION v : VERSION.values()) {
                if (v.value.equals(value))
                    return v;
            }
            throw new IllegalArgumentException();
        }
    }

    private Connection con = null;

    public SystemManager(Connection con) {
        this.con = con;
    }

    public VERSION getVersion() throws SQLException {
        String sql = "select VALUE from SYSTEM_INFO where NAME='version'";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            rs.next();
            String version = rs.getString(1);
            return VERSION.valueOfVersionString(version);
        } catch (SQLException e) {
            return VERSION.V0_4;
        } finally {
            DbUtils.close(rs);
            DbUtils.close(ps);
        }
    }

    public void update() throws SQLException, FileNotFoundException, UnsupportedEncodingException {
        VERSION v = getVersion();
        switch (v) {
        case V0_4:
            updateFrom0_4();
        case V1_0a:
            break;
        }
    }
    
    private void updateFrom0_4() throws FileNotFoundException, UnsupportedEncodingException {
        InputStream in = new FileInputStream(getUpdateSQLFile("from0_4.sql"));
        OutputStream out = new ByteArrayOutputStream();
        ij.runScript(con, in, "UTF-8", out, "Windows-31J");
        log.debug(out.toString());
    }
    private File getUpdateSQLFile(String fileName) {
        String path = System.getProperty("derby.system.home");
        if (!path.endsWith("/")) path += "/";
        path += "../../update/" + fileName;
        return new File(path);
    }
}
