/**
 * Copyright (c) 2006, yher.net
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the nor the names of its contributors may be used to endorse or 
 *   promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY 
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE.
 */
package net.yher.workstyle.torque.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import net.yher.workstyle.torque.Tag;

import org.apache.commons.lang.StringUtils;

/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Mon Jan 02 04:36:48 GMT+09:00 2006]
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 */
public class TaskBean
    extends net.yher.workstyle.torque.bean.BaseTaskBean
    implements Serializable
{
	private List<TaskBean> linkedTaskList = new ArrayList<TaskBean>();
	
	
	public List<String> getTagAsList() {
		return parseTagList(getTagList());
	}
	
	public boolean hasTag(String tag) {
		return hasTag(getTagList(), tag);
	}
	
	public static boolean hasTag(String tagList, String tag) {
		return StringUtils.indexOf(tagList, Tag.format(tag)) >= 0;
	}
	
	public static List<String> parseTagList(String tagList) {
		if (StringUtils.isBlank(tagList)) return new ArrayList<String>();
        
		List<String> result = new ArrayList<String>();
        char charList[] = tagList.toCharArray();
        StringBuffer buf = new StringBuffer();
        boolean inTag = false;
        for (char c : charList) {
            switch(c) {
            case '[':
                if (inTag) inTag = false;
                else inTag = true;
                buildTagList(result, buf);
                buf = new StringBuffer();
                break;
            case ']':
                inTag = false;
                buildTagList(result, buf);
                buf = new StringBuffer();
                break;
            case ' ':
            case '\t':
                if (!inTag) {
                    buildTagList(result, buf);
                    buf = new StringBuffer();
                    break;
                } else {
                    buf.append(c);
                    break;
                }
            default:
                buf.append(c);
            }
        }
        buildTagList(result, buf);
		return result;
	}
    private  static void buildTagList(List<String> list, StringBuffer tagBuffer) {
        if (tagBuffer.length() > 0) {
            String tag = tagBuffer.toString();
            if (!list.contains(tag)) list.add(tag);
        }
    }
	public static String normalizeTagList(String targetTagList) {
		List<String> list = parseTagList(targetTagList);
		String result = "";
		for (String tag : list) {
			result += Tag.format(tag);
		}
		return result;
	}

	public List<TaskBean> getLinkedTaskList() {
		return linkedTaskList;
	}

	public void setLinkedTaskList(List<TaskBean> linkedTaskList) {
		this.linkedTaskList = linkedTaskList;
	}
    
    public double getLinkedTaskEstimatedManHourTotal() {
        double total = 0;
        for (TaskBean bean : linkedTaskList) {
            total += bean.getEstimatedManHour();
        }
        return total;
    }
}
