package org.apache.commons.lang;

import org.apache.commons.lang.Entities;

public class CustomStringEscapeUtils extends StringEscapeUtils {
    public static String escapeHtml(String str) {
    	return escape(Entities.HTML40, str);
    }
    public static String escapeXml(String str) {
    	return escape(Entities.XML, str);
    }
    private static String escape(Entities entities, String str) {
        if (str == null) {
            return null;
        }
        //todo: rewrite to use a Writer
        StringBuffer buf = new StringBuffer(str.length() * 2);
        int i;
        for (i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entityName = entities.entityName(ch);
            if (entityName == null) {
                buf.append(ch);
            } else {
                buf.append('&');
                buf.append(entityName);
                buf.append(';');
            }
        }
        return buf.toString();
    }

}
