package net.yher.workstyle.test;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

import net.yher.commons.torque.TorqueUtils;
import net.yher.waft.db.Transaction;
import net.yher2.commons.io.Path;

import org.apache.torque.Torque;

public class DBTestCase extends net.yher2.junit.db.DBTestCase {
    private Connection con = null;

	@Override
	protected Connection getConnection() throws SQLException {
        return con;
	}

	@Override
    protected void prepare(Path path) throws IOException, SQLException {
        super.prepare(con, path);
    }

    @Override
	protected void setUp() throws Exception {
		super.setUp();
        System.setProperty("derby.system.home", "web/WEB-INF/data/derby");
		TorqueUtils.initialize("Torque.properties");
        con = Transaction.begin(Torque.getDefaultDB());
	}

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Transaction.rollback(con);
    }

}
