<?php
/*
+----------------------------------------------------------------+
|																							|
|	WordPress 2.0 Plugin: WP-postratings 1.02								|
|	Copyright (c) 2006 Lester "GaMerZ" Chan									|
|																							|
|	File Written By:																	|
|	- Lester "GaMerZ" Chan															|
|	- http://www.lesterchan.net													|
|																							|
|	File Information:																	|
|	- Manage Post Ratings Logs													|
|	- wp-content/plugins/postratings/postratings-manager.php			|
|																							|
+----------------------------------------------------------------+
*/


### Check Whether User Can Manage Ratings
if(!current_user_can('manage_ratings')) {
	die('Access Denied');
}


### Ratings Variables
$base_name = plugin_basename('postratings/postratings-manager.php');
$base_page = 'admin.php?page='.$base_name;
$postratings_page = intval($_GET['ratingpage']);
$postratings_sortby = trim($_GET['by']);
$postratings_sortby_text = '';
$postratings_sortorder = trim($_GET['order']);
$postratings_sortorder_text = '';
$postratings_log_perpage = intval($_GET['perpage']);
$postratings_sort_url = '';
$ratings_image = get_settings('postratings_image');
$ratings_max = intval(get_settings('postratings_max'));

### Form Sorting URL
if(!empty($postratings_sortby)) {
	$postratings_sort_url .= '&amp;by='.$postratings_sortby;
}
if(!empty($postratings_sortorder)) {
	$postratings_sort_url .= '&amp;order='.$postratings_sortorder;
}
if(!empty($postratings_log_perpage)) {
	$postratings_sort_url .= '&amp;perpage='.$postratings_log_perpage;
}


### Get Order By
switch($postratings_sortby) {
	case 'id':
		$postratings_sortby = 'rating_id';
		$postratings_sortby_text = __('ID');
		break;
	case 'username':
		$postratings_sortby = 'rating_username';
		$postratings_sortby_text = __('Username','postratings');
		break;
	case 'rating':
		$postratings_sortby = 'rating_rating';
		$postratings_sortby_text = __('Rating','postratings');
		break;
	case 'postid':
		$postratings_sortby = 'rating_postid';
		$postratings_sortby_text = __('Post ID','postratings');
		break;
	case 'posttitle':
		$postratings_sortby = 'rating_posttitle';
		$postratings_sortby_text = __('Post Title','postratings');
		break;
	case 'ip':
		$postratings_sortby = 'rating_ip';
		$postratings_sortby_text = 'IP';
		break;
	case 'host':
		$postratings_sortby = 'rating_host';
		$postratings_sortby_text = __('Host','postratings');
		break;
	case 'date':
	default:
		$postratings_sortby = 'rating_timestamp';
		$postratings_sortby_text = __('Date','postratings');
}


### Get Sort Order
switch($postratings_sortorder) {
	case 'asc':
		$postratings_sortorder = 'ASC';
		$postratings_sortorder_text = __('Ascending','postratings');
		break;
	case 'desc':
	default:
		$postratings_sortorder = 'DESC';
		$postratings_sortorder_text = __('Descending','postratings');
}


### Form Processing 
if(!empty($_POST['delete_logs'])) {
	if(trim($_POST['delete_logs_yes']) == 'yes') {
		$delete_logs = $wpdb->query("DELETE FROM $wpdb->ratings");
		if($delete_logs) {
			$text = '<font color="green">'.__('All Post Ratings Logs Have Been Deleted.','postratings').'</font>';
		} else {
			$text = '<font color="red">'.__('An Error Has Occured While Deleting All Post Ratings Logs.','postratings').'</font>';
		}
	}
}


### Get Post Ratings Logs Data
$total_ratings = $wpdb->get_var("SELECT COUNT(rating_id) FROM $wpdb->ratings");
$total_users = $wpdb->get_var("SELECT SUM(CAST(meta_value AS UNSIGNED)) FROM $wpdb->postmeta WHERE meta_key = 'ratings_users'");
$total_score = $wpdb->get_var("SELECT SUM(CAST(meta_value AS UNSIGNED)) FROM $wpdb->postmeta WHERE meta_key = 'ratings_score'");
if($total_users == 0) { 
	$total_average = 0;
} else {
	$total_average = $total_score/$total_users;
}


### Checking $postratings_page and $offset
if(empty($postratings_page) || $postratings_page == 0) { $postratings_page = 1; }
if(empty($offset)) { $offset = 0; }
if(empty($postratings_log_perpage) || $postratings_log_perpage == 0) { $postratings_log_perpage = 20; }


### Determin $offset
$offset = ($postratings_page-1) * $postratings_log_perpage;


### Determine Max Number Of Polls To Display On Page
if(($offset + $postratings_log_perpage) > $total_ratings) { 
	$max_on_page = $total_ratings; 
} else { 
	$max_on_page = ($offset + $postratings_log_perpage); 
}


### Determine Number Of Polls To Display On Page
if (($offset + 1) > ($total_ratings)) { 
	$display_on_page = $total_ratings; 
} else { 
	$display_on_page = ($offset + 1); 
}


### Determing Total Amount Of Pages
$total_pages = ceil($total_ratings / $postratings_log_perpage);


### Get The Logs
$postratings_logs = $wpdb->get_results("SELECT * FROM $wpdb->ratings ORDER BY $postratings_sortby $postratings_sortorder LIMIT $offset, $postratings_log_perpage");
?>
<?php if(!empty($text)) { echo '<!-- Last Action --><div id="message" class="updated fade"><p>'.$text.'</p></div>'; } ?>
<!-- Manage Post Ratings -->
<div class="wrap">
	<h2><?php _e('Post Ratings Logs','postratings'); ?></h2>
	<p><?php _e('Displaying','postratings'); ?> <b><?php echo $display_on_page;?></b> <?php _e('To','postratings'); ?> <b><?php echo $max_on_page; ?></b> <?php _e('Of','postratings'); ?> <b><?php echo $total_ratings; ?></b> <?php _e('Post Ratings Logs','postratings'); ?></p>
	<p><?php _e('Sorted By','postratings'); ?> <b><?php echo $postratings_sortby_text;?></b> <?php _e('In','postratings'); ?> <b><?php echo $postratings_sortorder_text;?></b> <?php _e('Order','postratings'); ?></p>
	<table width="100%"  border="0" cellspacing="3" cellpadding="3">
	<tr>
		<th width="2%"><?php _e('ID','postratings'); ?></th>
		<th width="20%"><?php _e('Username','postratings'); ?></th>
		<th width="10%"><?php _e('Rating','postratings'); ?></th>
		<th width="28%"><?php _e('Post Title','postratings'); ?></th>	
		<th width="20%"><?php _e('Date / Time','postratings'); ?></th>
		<th width="20%"><?php _e('IP / Host','postratings'); ?></th>			
	</tr>
	<?php
		if($postratings_logs) {
			$i = 0;
			foreach($postratings_logs as $postratings_log) {
				if($i%2 == 0) {
					$style = 'style=\'background-color: #eee\'';
				}  else {
					$style = 'style=\'background-color: none\'';
				}
				$postratings_id = intval($postratings_log->rating_id);
				$postratings_username = stripslashes($postratings_log->rating_username);
				$postratings_rating = intval($postratings_log->rating_rating);
				$postratings_postid = intval($postratings_log->rating_postid);
				$postratings_posttitle = stripslashes($postratings_log->rating_posttitle);
				$postratings_date = gmdate("jS F Y", $postratings_log->rating_timestamp);
				$postratings_time = gmdate("H:i", $postratings_log->rating_timestamp);
				$postratings_ip = $postratings_log->rating_ip;
				$postratings_host = $postratings_log->rating_host;				
				echo "<tr $style>\n";
				echo "<td>$postratings_id</td>\n";
				echo "<td>$postratings_username</td>\n";
				echo '<td>';
				if(file_exists(ABSPATH.'/wp-content/plugins/postratings/images/'.$ratings_image.'/rating_start.gif')) {
					echo '<img src="'.get_settings('siteurl').'/wp-content/plugins/postratings/images/'.$ratings_image.'/rating_start.gif" alt="" />';
				}
				for($j=1; $j <= $ratings_max; $j++) {
					if($j <= $postratings_rating) {
						echo '<img src="'.get_settings('siteurl').'/wp-content/plugins/postratings/images/'.$ratings_image.'/rating_on.gif" alt="'.__('User Rate This Post ','postratings').$postratings_rating.__(' Stars Out Of ','postratings').$ratings_max.'" title="'.__('User Rate This Post ','postratings').$postratings_rating.__(' Stars Out Of ','postratings').$ratings_max.'" />';
					} else {
						echo '<img src="'.get_settings('siteurl').'/wp-content/plugins/postratings/images/'.$ratings_image.'/rating_off.gif" alt="'.__('User Rate This Post ','postratings').$postratings_rating.__(' Stars Out Of ','postratings').$ratings_max.'" title="'.__('User Rate This Post ','postratings').$postratings_rating.__(' Stars Out Of ','postratings').$ratings_max.'" />';
					}
				}
				if(file_exists(ABSPATH.'/wp-content/plugins/postratings/images/'.$ratings_image.'/rating_end.gif')) {
					echo '<img src="'.get_settings('siteurl').'/wp-content/plugins/postratings/images/'.$ratings_image.'/rating_end.gif" alt="" />';
				}
				echo '</td>'."\n";
				echo "<td>$postratings_posttitle</td>\n";
				echo "<td>$postratings_date, $postratings_time</td>\n";
				echo "<td>$postratings_ip / $postratings_host</td>\n";
				echo '</tr>';
				$i++;
			}
		} else {
			echo '<tr><td colspan="8" align="center"><b>'.__('No Post Ratings Logs Found','postratings').'</b></td></tr>';
		}
	?>
	</table>
		<!-- <Paging> -->
		<?php
			if($total_pages > 1) {
		?>
		<br />
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td align="left" width="50%">
					<?php
						if($postratings_page > 1 && ((($postratings_page*$postratings_log_perpage)-($postratings_log_perpage-1)) <= $total_ratings)) {
							echo '<b>&laquo;</b> <a href="'.$base_page.'&amp;ratingpage='.($postratings_page-1).'" title="&laquo; '.__('Previous Page','postratings').'">'.__('Previous Page','postratings').'</a>';
						} else {
							echo '&nbsp;';
						}
					?>
				</td>
				<td align="right" width="50%">
					<?php
						if($postratings_page >= 1 && ((($postratings_page*$postratings_log_perpage)+1) <=  $total_ratings)) {
							echo '<a href="'.$base_page.'&amp;ratingpage='.($postratings_page+1).'" title="'.__('Next Page','postratings').' &raquo;">'.__('Next Page','postratings').'</a> <b>&raquo;</b>';
						} else {
							echo '&nbsp;';
						}
					?>
				</td>
			</tr>
			<tr>
				<td colspan="2" align="center">
					<?php _e('Pages','postratings'); ?> (<?php echo $total_pages; ?>) :
					<?php
						if ($postratings_page >= 4) {
							echo '<b><a href="'.$base_page.'&amp;ratingpage=1'.$postratings_sort_url.$postratings_sort_url.'" title="'.__('Go to First Page','postratings').'">&laquo; '.__('First','postratings').'</a></b> ... ';
						}
						if($postratings_page > 1) {
							echo ' <b><a href="'.$base_page.'&amp;ratingpage='.($postratings_page-1).$postratings_sort_url.'" title="&laquo; '.__('Go to Page','postratings').' '.($postratings_page-1).'">&laquo;</a></b> ';
						}
						for($i = $postratings_page - 2 ; $i  <= $postratings_page +2; $i++) {
							if ($i >= 1 && $i <= $total_pages) {
								if($i == $postratings_page) {
									echo "<b>[$i]</b> ";
								} else {
									echo '<a href="'.$base_page.'&amp;ratingpage='.($i).$postratings_sort_url.'" title="'.__('Page','postratings').' '.$i.'">'.$i.'</a> ';
								}
							}
						}
						if($postratings_page < $total_pages) {
							echo ' <b><a href="'.$base_page.'&amp;ratingpage='.($postratings_page+1).$postratings_sort_url.'" title="'.__('Go to Page','postratings').' '.($postratings_page+1).' &raquo;">&raquo;</a></b> ';
						}
						if (($postratings_page+2) < $total_pages) {
							echo ' ... <b><a href="'.$base_page.'&amp;ratingpage='.($total_pages).$postratings_sort_url.'" title="'.__('Go to Last Page','postratings').'">'.__('Last','postratings').' &raquo;</a></b>';
						}
					?>
				</td>
			</tr>
		</table>	
		<!-- </Paging> -->
		<?php
			}
		?>
	<br />
	<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get">
		<input type="hidden" name="page" value="<?php echo $base_name; ?>" />
		<?php _e('Sort Options:','postratings'); ?>&nbsp;&nbsp;&nbsp;
		<select name="by" size="1">
			<option value="id"<?php if($postratings_sortby == 'rating_id') { echo ' selected="selected"'; }?>><?php _e('ID','postratings'); ?></option>
			<option value="username"<?php if($postratings_sortby == 'rating_username') { echo ' selected="selected"'; }?>><?php _e('UserName','postratings'); ?></option>
			<option value="rating"<?php if($postratings_sortby == 'rating_rating') { echo ' selected="selected"'; }?>><?php _e('Rating','postratings'); ?></option>
			<option value="postid"<?php if($postratings_sortby == 'rating_postid') { echo ' selected="selected"'; }?>><?php _e('Post ID','postratings'); ?></option>
			<option value="posttitle"<?php if($postratings_sortby == 'rating_posttitle') { echo ' selected="selected"'; }?>><?php _e('Post Title','postratings'); ?></option>
			<option value="date"<?php if($postratings_sortby == 'rating_timestamp') { echo ' selected="selected"'; }?>><?php _e('Date','postratings'); ?></option>
			<option value="ip"<?php if($postratings_sortby == 'rating_ip') { echo ' selected="selected"'; }?>><?php _e('IP','postratings'); ?></option>
			<option value="host"<?php if($postratings_sortby == 'rating_host') { echo ' selected="selected"'; }?>><?php _e('Host','postratings'); ?></option>
		</select>
		&nbsp;&nbsp;&nbsp;
		<select name="order" size="1">
			<option value="asc"<?php if($postratings_sortorder == 'ASC') { echo ' selected="selected"'; }?>><?php _e('Ascending','postratings'); ?></option>
			<option value="desc"<?php if($postratings_sortorder == 'DESC') { echo ' selected="selected"'; } ?>><?php _e('Descending','postratings'); ?></option>
		</select>
		&nbsp;&nbsp;&nbsp;
		<select name="perpage" size="1">
		<?php
			for($i=10; $i <= 100; $i+=10) {
				if($postratings_log_perpage == $i) {
					echo "<option value=\"$i\" selected=\"selected\"><?php _e('Per Page:','postratings'); ?> $i</option>\n";
				} else {
					echo "<option value=\"$i\"><?php _e('Per Page:','postratings'); ?> $i</option>\n";
				}
			}
		?>
		</select>
		<input type="submit" value="<?php _e('Sort','postratings'); ?>" class="button" />
	</form>
</div>

<!-- Post Ratings Stats -->
<div class="wrap">
	<h2><?php _e('Post Ratings Logs Stats','postratings'); ?></h2>
	<table border="0" cellspacing="3" cellpadding="3">
	<tr>
		<th align="left"><?php _e('Total Users Voted:','postratings'); ?></th>
		<td align="left"><?php echo number_format($total_users); ?></td>
	</tr>
	<tr>
		<th align="left"><?php _e('Total Score:','postratings'); ?></th>
		<td align="left"><?php echo number_format($total_score); ?></td>
	</tr>
	<tr>
		<th align="left"><?php _e('Total Average:','postratings'); ?></th>
		<td align="left"><?php echo number_format($total_average, 2); ?></td>
	</tr>
	</table>
</div>

<!-- Delete Post Ratings Logs -->
<div class="wrap">
	<h2><?php _e('Post Ratings Logs','postratings'); ?></h2>
	<div align="center">
		<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
			<strong><?php _e('Are You Sure You Want To Delete All Post Ratings Logs?','postratings'); ?></strong><br /><br />
			<input type="checkbox" name="delete_logs_yes" value="yes" /> <?php _e('Yes'); ?><br /><br />
			<input type="submit" name="delete_logs" value="<?php echo __('Delete All Logs','postratings'); ?>" class="button" onclick="return confirm('<?php echo __('You Are About To Delete All Post Ratings Logs. This Action Is Not Reversible.','postratings'); ?>\n\n<?php echo __('Choose &lsquo;Cancel&rsquo; to stop, &lsquo;OK&rsquo; to delete.','postratings')?>')" />
		</form>
	</div>
	<p><?php echo __('Note: If your logging method is by IP and Cookie or by Cookie, users may still be unable to rate if they have voted before as the cookie is still stored in their computer.','postratings')?></p>
</div>