<?php
/*
Plugin Name: wp-lwSitemap
Plugin URI: http://wppluginsj.sourceforge.jp/wp-lwSitemap/
Description: The fastest, the lightest, Google sitemap plugin for WordPress.
Author: hiromasa
Version: 1.00
Author URI: http://another.maple4ever.net/
*/

/*  Copyright 2007 hiromasa  (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * WpLightWeightSitemap - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;

/******************************************************************************
 * WpLightWeightSitemapController
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class WpLightWeightSitemapController {
	
	var $view;
	var $model;
	var $request;
	
	var $plugin_name;
	var $plugin_uri;
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpLightWeightSitemapController() {
		
		$this->plugin_name = 'wp-lwSitemap';
		
		$this->plugin_uri = get_settings('siteurl');
		$this->plugin_uri .= '/wp-content/plugins/wp-lwSitemap/';
		
		$this->request = new WpLightWeightSitemapHTTPRequestVO();
		
		$this->model = $this->getModelObject();
		$this->view = new WpLightWeightSitemapView();
		
	}
	
	/**
	 * getModelObject
	 * 
	 * @param none
	 * @return $model
	 */
	function getModelObject() {
		
		$option = get_option($this->plugin_name);
		
		$model = null;
		//PHP 4.0 Bug?
		if(strtolower(get_class($option)) == strtolower('WpLightWeightSitemap')) {
			$model = $option;
		} else {
			$model = new WpLightWeightSitemap(ABSPATH);
			$this->writeWpOption($model);
		}
		
		return $model;
		
	}
	
	/**
	 * setWpOption
	 * 
	 * @param $optionValue
	 * @return none
	 */
	function writeWpOption($optionValue) {
		
		$option_description = $this->plugin_name . " Options";
		
		add_option($this->plugin_name, $optionValue, $option_description);
		
	}
	
	/**
	 * updateWpOption
	 * 
	 * @param $optionValue
	 * @return none
	 */
	function updateWpOption($optionValue) {
		
		$option_description = $this->plugin_name . " Options";
		
		update_option($this->plugin_name, $optionValue, $option_description);
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function addAdminMenu() {
		
		add_options_page(
			'lwSitemap',
			'lwSitemap',
			8,
			'wp-lwSitemap.php',
			array (&$this, 'executeAdmin')
		);
	
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function executeAdmin() {
		
		$action = $this->request->getParam('action');
		
		$messages = array ();
		
		if($action == 'update') {
			if($this->model->updateOptions($this->request, $messages)) {
				$this->updateWpOption($this->model);
			}
		}
		if($action == 'build') {
			if($this->model->updateOptions($this->request, $messages)) {
				$this->updateWpOption($this->model);
			}
			if($this->model->makeSitemap($messages)) {
				$this->model->doPing($messages);
			}
		}
		
		$resultVO = & new WpLightWeightSitemapValueObject();
		
		$this->model->getOptions($resultVO);
		$this->view->echoAdmin($resultVO, $messages);
		
	}
	
	/**
	 * WordPress Schedule Interface
	 * 
	 * @param none
	 * @return none
	 */
	function executeSchedule() {
		
		wp_schedule_single_event(time(), 'makeSitemaps');
		
	}
	
	/**
	 * WordPress Schedule Interface
	 * 
	 * @param none
	 * @return none
	 */
	function makeSitemap() {
		
		$this->model->makeSitemap();
		
	}
	
}

/******************************************************************************
 * WpLightWeightSitemap
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class WpLightWeightSitemap {
	
	var $contents = array ();
	var $xmlLocation;
	var $sendPing;
	
	var $version;
	var $staleKey;
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpLightWeightSitemap($xmlLocation) {
		
		$this->version = 'LwSitemap/1.0';
		$this->staleKey = md5(time());
		
		$this->contents['homepage']['include'] = true;
		$this->contents['homepage']['frequency'] = 2;
		$this->contents['homepage']['priority'] = 5;
		
		$this->contents['post']['include'] = true;
		$this->contents['post']['frequency'] = 3;
		$this->contents['post']['priority'] = 8;
		
		$this->contents['page']['include'] = true;
		$this->contents['page']['frequency'] = 4;
		$this->contents['page']['priority'] = 8;
		
		$this->xmlLocation = $xmlLocation;
		$this->sendPing = true;
		
	}
	
	/**
	 * getOptions
	 * 
	 * @param $resultVO
	 * @return none
	 */
	function getOptions(&$resultVO) {
		
		$resultVO->setParam('contents', $this->contents);
		$resultVO->setParam('xmlLocation', $this->xmlLocation);
		$resultVO->setParam('sendPing', $this->sendPing);
		$resultVO->setParam('staleKey', $this->staleKey);
		
	}
	
	/**
	 * updateOptions
	 * 
	 * @param $requestVO
	 * @return none
	 */
	function updateOptions($requestVO, & $messages) {
		
		if($this->staleKey != $requestVO->getParam('stalekey')) {
			array_push($messages, "データが他で更新されている可能性があるため、更新を中止しました。");
			return false;
		}
		
		$this->xmlLocation = stripslashes($requestVO->getParam('xmllocation'));
		$this->sendPing = $requestVO->getParam('sendping') != '' ? true : false;
		
		$includes = $requestVO->getParam('include');
		$frequency = $requestVO->getParam('frequency');
		$priority = $requestVO->getParam('priority');
		
		foreach ($includes as $value) {
			$include[$value] = true;
		}
		
		$this->contents['homepage']['include'] = $include[0];
		$this->contents['homepage']['frequency'] = $frequency[0];
		$this->contents['homepage']['priority'] = $priority[0];
		
		$this->contents['post']['include'] = $include[1];
		$this->contents['post']['frequency'] = $frequency[1];
		$this->contents['post']['priority'] = $priority[1];
		
		$this->contents['page']['include'] = $include[2];
		$this->contents['page']['frequency'] = $frequency[2];
		$this->contents['page']['priority'] = $priority[2];
		
		$this->staleKey = md5(time());
		
		array_push($messages, "オプションを更新しました。");
		return true;
		
	}

	/**
	 * makeSitemap(Google Sitemap)
	 * 
	 * @param none
	 * @return none
	 */
	function makeSitemap(&$messages) {
		
		global $wpdb;
		
		$filename = $this->xmlLocation . 'sitemap.xml';
		if(!($fp = @fopen($filename, 'w'))) {
			array_push(
				$messages,
				"サイトマップの作成に失敗しました。サイトマップ作成先のパスや権限を確認してください。");
			return false;
		}
		
		$frequencys = array ("always", "hourly", "daily", "weekly", "monthly", "yearly", "never");
		$prioritys = array ("0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6" ,"0.7" ,"0.8" ,"0.9" ,"1");
		
		$now = date('F j, Y, g:i a');
		
		fputs($fp, '<?xml version="1.0" encoding="UTF-8"?>' . "\n");
		fputs($fp, "<!-- generated-on=\"$now\" -->\n");
		fputs($fp, '<urlset xmlns="http://www.google.com/schemas/sitemap/0.84" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.google.com/schemas/sitemap/0.84 http://www.google.com/schemas/sitemap/0.84/sitemap.xsd">' . "\n");
		
		$query =
			"SELECT " .
				"distinct year(post_date) as year " .
			"FROM " .
				"$wpdb->posts " .
			"WHERE " .
				"post_status='publish' AND " .
				"post_password='' " .
			"ORDER BY " .
				"year desc;";
		$years = $wpdb->get_results($query);
		
		if($years == '') return;
		
		$finalmod = '';
		foreach ($years as $year) {
			
			$query =
				"SELECT " .
					"ID, " .
					"post_date, " .
					"post_name, " .
					"post_title, " .
					"post_author, " .
					"post_category, " .
					"post_date, " .
					"post_modified_gmt, " .
					"post_type " .
				"FROM " .
					"$wpdb->posts " .
				"WHERE " .
					"year(post_date)='$year->year'  AND " .
					"post_status='publish'          AND " .
					"post_password='' " .
					$this->makeIncludeSQL() .
				"ORDER BY " .
					"post_modified desc";
			$year_entrys = $wpdb->get_results($query);
			
			foreach ($year_entrys as $entry) {
				
				$loc = get_permalink($entry);
				$lastmod = $this->getTimestampFromMySql($entry->post_modified_gmt);
				$lastmod = date('Y-m-d\TH:i:s+00:00', $lastmod);
				if($finalmod == '') $finalmod = $lastmod; 
				
				$changefreq = '';
				$priority = '';
				if($entry->post_type == 'post' || $entry->post_type == '') {
					$changefreq = $this->contents['post']['frequency'];
					$priority = $this->contents['post']['priority'];
				}
				if($entry->post_type == 'page') {
					$changefreq = $this->contents['page']['frequency'];
					$priority = $this->contents['page']['priority'];
				}
				$changefreq = $frequencys[$changefreq];
				$priority = $prioritys[$priority];
				
				fputs($fp, "\t<url>\n");
				fputs($fp, "\t\t<loc>$loc</loc>\n");
				fputs($fp, "\t\t<lastmod>$lastmod</lastmod>\n");
				fputs($fp, "\t\t<changefreq>$changefreq</changefreq>\n");
				fputs($fp, "\t\t<priority>$priority</priority>\n");
				fputs($fp, "\t</url>\n");
				
			}
		}
		
		if($this->contents['homepage']['include']) {
			$loc = get_bloginfo('home') . '/'; // :-P
			$lastmod = $finalmod;
			$changefreq = $this->contents['homepage']['frequency'];
			$priority = $this->contents['homepage']['priority'];
			$changefreq = $frequencys[$changefreq];
			$priority = $prioritys[$priority];
			fputs($fp, "\t<url>\n");
			fputs($fp, "\t\t<loc>$loc</loc>\n");
			fputs($fp, "\t\t<lastmod>$lastmod</lastmod>\n");
			fputs($fp, "\t\t<changefreq>$changefreq</changefreq>\n");
			fputs($fp, "\t\t<priority>$priority</priority>\n");
			fputs($fp, "\t</url>\n");
		}
		
		fputs($fp, '</urlset>' . "\n");
		
		fclose($fp);
		
		array_push($messages, "サイトマップを作成しました。");
		return true;
		
	}
	
	/**
	 * makeIncludeSQL
	 * 
	 * @param $none
	 * @return $sql
	 */
	function makeIncludeSQL() {
		
		$sqls = array ();
		
		array_push($sqls, "post_type <> 'post' AND post_type <> '' AND post_type <> 'page' ");
		
		if($this->contents['post']['include']) {
			array_push($sqls, "post_type = 'post' OR post_type = '' ");
		}
		
		if($this->contents['page']['include']) {
			array_push($sqls, "post_type = 'page' ");
		}
		
		$sql = '';
		for ($i = 0; $i < count($sqls); $i++) {
			$sql .= $sqls[$i];
			if($sqls[$i +1] != '') {
				$sql .= ' OR ';
			}
		}
		
		if($sql != '') $sql = ' AND (' . $sql . ')';
		
		return $sql;
		
	}
	
	/**
	 * getTimestampFromMySql
	 * 
	 * @param $mysqlDateTime
	 * @return mktime
	 */
	function getTimestampFromMySql($mysqlDateTime) {
		
		list ($date, $hours) = split(' ', $mysqlDateTime);
		list ($year, $month, $day) = split('-', $date);
		list ($hour, $min, $sec) = split(':', $hours);
		
		return mktime($hour, $min, $sec, $month, $day, $year);
		
	}
	
	/**
	 * doPing
	 * 
	 * @param none
	 * @return true / false / null
	 */
	function doPing(&$messages) {
		
		if(!$this->sendPing) return null;
		
		$sitemap = trailingslashit(get_bloginfo('home')) . 'sitemap.xml';
		$pingUrl = "http://www.google.com/webmasters/sitemaps/ping?sitemap=" . urlencode($sitemap);
		$ping = @wp_remote_fopen($pingUrl);
		
		if($ping == false) {
			array_push($messages, "Google への更新 ping の送信に失敗しました。");
			return false;
		}
		
		array_push($messages,
			"Google への更新 ping を送信しました。" . 
			"(<a href=\"$pingUrl\">$pingUrl</a>)");
		return true;
		
	}
	
}

/******************************************************************************
 * WpLightWeightSitemapView
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class WpLightWeightSitemapView {
	
	var $result;
	
	var $frequency = array ();
	var $priority = array ();
	
	/**
	 * The Constructor
	 * 
	 * @param $result
	 * @return none
	 */
	function WpLightWeightSitemapView() {
		
		$this->frequency = array ("always", "hourly", "daily", "weekly", "monthly", "yearly", "never");
		$this->priority = array ("0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1");
		
	}
	
	/**
	 * echoAdmin
	 * 
	 * @param $result
	 * @return none
	 */
	function echoAdmin($result, $messages = array()) {
		
		$this->result = $result;
		$contents = $this->result->getParam('contents');
		
		$checked = 'checked="checked" ';
		
		$include[0] = $contents['homepage']['include'] == true ? $checked : '';
		$include[1] = $contents['post']['include'] == true ? $checked : '';
		$include[2] = $contents['page']['include'] == true ? $checked : '';
		
		$xmlLocation = $this->result->getParam('xmlLocation');
		$sendping = $this->result->getParam('sendPing') == true ? $checked : '';
		
		$this->echoMessage($messages);
		
		$this->echoAdminHeader();
		
		echo '<p class="submit">' . "\n";
		echo '<input type="submit" name="Submit" onclick="document.getElementById(\'action\').value=\'build\';" value="サイトマップの手動ビルド &raquo;" />' . "\n";
		echo '<input type="submit" name="Submit" value="設定の保存 &raquo;" />' . "\n";
		echo '</p>' . "\n";
		
		echo '<fieldset class="options">' . "\n";
		echo '<legend>サイトマップの設定</legend>' . "\n";
		
		echo '<table class="optiontable">' . "\n";
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row">サイトマップ作成先ディレクトリ:</th>' . "\n";
		echo "<td><input name=\"xmllocation\" type=\"text\" value=\"$xmlLocation\" size=\"60\" /></td>" . "\n";
		echo '</tr>' . "\n";
		echo '<tr>' . "\n";
		echo '<th scope="row">更新pingの送信:</th>' . "\n";
		echo "<td><input type=\"checkbox\" name=\"sendping\" value=\"0\" {$sendping} /> 送信する</td>" . "\n";
		echo '</tr>' . "\n";
		echo '</table>' . "\n";
		
		echo '</fieldset>' . "\n";
		
		echo '<fieldset class="options">' . "\n";
		echo '<legend>サイトマップの属性</legend>' . "\n";
		
		echo '<table class="optiontable">' . "\n";
		
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row">サイトマップに含めるコンテンツ:</th>' . "\n";
		echo '<td>' . "\n";
		echo '<ul>' . "\n";
		echo "<li><input type=\"checkbox\" name=\"include[]\" value=\"0\" {$include[0]} /> ホームページ</li>" . "\n";
		echo "<li><input type=\"checkbox\" name=\"include[]\" value=\"1\"  {$include[1]} /> 記事</li>" . "\n";
		echo "<li><input type=\"checkbox\" name=\"include[]\" value=\"2\"  {$include[2]} /> ページ</li>" . "\n";
		echo '</ul>' . "\n";
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row">コンテンツの更新頻度:</th>' . "\n";
		echo '<td>' . "\n";
		echo '<ul>' . "\n";
		echo '<li>' .
			$this->echoOptionList('frequency', $this->frequency, $contents['homepage']['frequency']) . 'ホームページ</li>' . "\n";
		echo '<li>' .
			$this->echoOptionList('frequency', $this->frequency, $contents['post']['frequency']) . '記事</li>' . "\n";
		echo '<li>' .
			$this->echoOptionList('frequency', $this->frequency, $contents['page']['frequency']) . 'ページ</li>' . "\n";
		echo '</ul>' . "\n";
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		
		echo '<tr valign="top">' . "\n";
		echo '<th scope="row">コンテンツの優先順位:</th>' . "\n";
		echo '<td>' . "\n";
		echo '<ul>' . "\n";
		echo '<li>' .
			$this->echoOptionList('priority', $this->priority, $contents['homepage']['priority']) .'ホームページ</li>' . "\n";
		echo '<li>' .
			$this->echoOptionList('priority', $this->priority, $contents['post']['priority']) . '記事</li>' . "\n";
		echo '<li>' .
			$this->echoOptionList('priority', $this->priority, $contents['page']['priority']) . 'ページ</li>' . "\n";
		echo '</ul>' . "\n";
		echo '</td>' . "\n";
		echo '</tr>' . "\n";
		
		echo '</table>' . "\n";
		
		echo '</fieldset>' . "\n";
		
		echo '<p class="submit">' . "\n";
		echo '<input type="submit" name="Submit" onclick="document.getElementById(\'action\').value=\'build\';" value="サイトマップの手動ビルド &raquo;" />' . "\n";
		echo '<input type="submit" name="Submit" value="設定の保存 &raquo;" />' . "\n";
		echo '</p>' . "\n";
		
		$this->echoAdminFooter();
		
	}
	
	/**
	 * echoOptionList
	 * 
	 * @param $name
	 * @param $list
	 * @param $selected
	 * @return $html
	 */
	function echoOptionList($name, $lists, $selected) {
		
		$html = '';
		
		$html .= "<select name=\"{$name}[]\">" . "\n";
		
		$count = 0;
		foreach ($lists as $list) {
			$html .= "<option value=\"$count\" ";
			if($count == $selected)
				$html .= 'selected="selected" ';
			$html .= ">$list</option>" . "\n";
			$count++;
		}
		
		$html .= "</select>" . "\n";
		
		return $html;
		
	}
	
	/**
	 * Output Message
	 * 
	 * @param $message
	 * @return none
	 */
	function echoMessage($messages) {
		
		if(count($messages) == 0) return;
		
		$information = '';
		foreach($messages as $message) {
			$information .= '<p>' . $message . '</p>';
		}
		
		echo '<div id="message" class="updated fade">' . "\n";
		echo "<p><strong>$information</strong></p>" . "\n";
		echo '</div>' . "\n";
		
	}
	
	/**
	 * echoAdminHeader
	 * 
	 * @param $scr
	 * @return none
	 */
	function echoAdminHeader() {
		
		echo '<div class="wrap">' . "\n";
		echo '<h2>Lightweight Sitemap Generator</h2>' . "\n";
		
		echo '<form name="lwsitemap" method="post">' . "\n";
		
	}
	
	/**
	 * echoAdminFooter
	 * 
	 * @param none
	 * @return none
	 */
	function echoAdminFooter() {
		
		$stakeKey = $this->result->getParam('staleKey');
		
		echo '<input type="hidden" name="action" id="action" value="update" />' . "\n";
		echo "<input type=\"hidden\" name=\"stalekey\" value=\"$stakeKey\" />" . "\n";
		echo '</form>' . "\n";
		echo '</div>' . "\n";
		
	}
	
}

/******************************************************************************
 * ValueObject Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpLightWeightSitemapValueObject {
	
	var $paramsMap = Array ();
	
	/**
	 * setParam
	 * 
	 * @param $name
	 * @return none
	 */
	function setParam($name, $value) {
		
		$this->paramsMap[$name] = $value;
		
	}
	
	/**
	 * getParam
	 * 
	 * @param $name
	 * @return none
	 */
	function getParam($name) {
		
		return $this->paramsMap[$name];
		
	}
	
}

/******************************************************************************
 * HTTPRequestVO Class
 * 
 * @author     hiromasa
 * @version    0.1a
 * 
 *****************************************************************************/
class WpLightWeightSitemapHTTPRequestVO extends WpLightWeightSitemapValueObject {
	
	/**
	 * The Constructor
	 * 
	 * @param none
	 * @return none
	 */
	function WpLightWeightSitemapHTTPRequestVO() {
		
		if(is_array($_REQUEST)) {
			foreach ($_REQUEST as $name => $value) {
				$this->setParam($name, $value);
			}
		}
		
	}
	
}

/******************************************************************************
 * WpLightWeightSitemap - WordPress Schedule Interface Define
 *****************************************************************************/
function makeSitemap() {
	
	$lwSitemap = & new WpLightWeightSitemapController();
	$lwSitemap->makeSitemap();
	
}

add_action('makeSitemaps', 'makeSitemap');

/******************************************************************************
 * WpLightWeightSitemap - WordPress Administrator Interface Define
 *****************************************************************************/

if(!(is_admin() || defined('XMLRPC_REQUEST'))) return;

$lwSitemap = & new WpLightWeightSitemapController();

add_action('publish_post', array (&$lwSitemap, 'executeSchedule'));
add_action('edit_post', array (&$lwSitemap, 'executeSchedule'));
add_action('delete_post', array (&$lwSitemap, 'executeSchedule'));

if(is_admin()) {
	add_action('admin_menu', array (&$lwSitemap, 'addAdminMenu'));
}
?>