<?php

// ----- Settings -------------------------
define('KE_SET_CATEGORY',        'CAT:');
define('KE_ADD_CATEGORY',        'CAT+');
define('KE_CHANGE_CATEGORY',     'CAT>');
define('KE_ADD_CHANGE_CATEGORY', 'CAT+>');
define('KE_SET_TAGS',            'TAG:');
define('KE_ROTATE_IMAGE',        'ROT:');
define('KE_SET_POSTSLUG',        'SLUG:');
define('KE_DRAFT',               'DRAFT');
define('KE_PENDING',             'PENDING');
define('KE_PRIVATE',             'PRIVATE');
define('KE_DELIM_STR',           '-- ');

define('KE_IMAGE_PERM', 0666);

/* ==================================================
 *   Ktai_Entry_Post class
   ================================================== */

class Ktai_Entry_Post extends Ktai_Entry {
	public $type;
	private $operator;

/* ==================================================
 * @param	string   $type
 * @return	object   $this
 */
public function __construct ($type = 'pop3') {
	$this->type = $type;
	
	$level = error_reporting(E_ALL ^ E_WARNING ^ E_NOTICE);
	require_once ABSPATH . 'wp-admin/admin-functions.php';
	if (! include_once 'Mail/mimeDecode.php') { // try to use PEAR in the server.
		require_once dirname(__FILE__) . '/Mail_mimeDecode.php'; // use local version
	}
	error_reporting($level);

	// ----- Remove filters of Change Max Thumbnail Length (http://www.yuriko.net/arc/2008/03/27d)
	if (defined('MY_THUMBNAIL_MAX_SIDE_LENGTH')) {
		remove_filter('wp_thumbnail_max_side_length', array('Change_Thumb_Max_Length', 'decide_length'));
		remove_filter('wp_thumbnail_max_side_length', 'change_thumb_max_length', 10, 3);
	}
	add_filter('wp_thumbnail_max_side_length', create_function('$size,$id,$file', 'return ' . intval($this->get_option('ke_thumb_size')) . ';'), 11, 3);
	add_filter('wp_create_thumbnail', create_function('$path', 'chmod($path, KE_IMAGE_PERM); return $path;'), 11);
	
	global $allowedposttags, $allowedtags;
	if (! defined('CUSTOM_TAGS')) {
		define('CUSTOM_TAGS', true);
	}
	if (! CUSTOM_TAGS) {
		$allowedposttags = array (
			'address' => array (), 
			'a' => array (
				'href' => array (), 'title' => array (), 'rel' => array (), 
				'rev' => array (), 'name' => array ()
				), 
			'abbr' => array ('title' => array ()), 
			'acronym' => array ('title' => array ()),
			'b' => array (),
			'big' => array (), 
			'blockquote' => array ('cite' => array ()), 
			'br' => array ('class' => array ()), 
			'button' => array (
				'disabled' => array (), 'name' => array (), 'type' => array (), 
				'value' => array ()
				), 
			'caption' => array ('align' => array ()), 
			'code' => array (), 
			'col' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'span' => array (), 'valign' => array (), 'width' => array ()
				), 
			'del' => array ('datetime' => array ()), 
			'dd' => array (), 
			'div' => array (
				'align' => array (), 'class' => array()
				), 
			'dl' => array (), 
			'dt' => array (), 
			'em' => array (), 
			'fieldset' => array (), 
			'font' => array (
				'color' => array (), 'size' => array ()
				), 
			'form' => array (
				'action' => array ('type' => 'uri'), 'accept' => array (), 
				'accept-charset' => array (), 'enctype' => array (), 
				'method' => array (), 'name' => array (), 'target' => array ()
				), 
			'h1' => array ('align' => array ()), 
			'h2' => array ('align' => array ()), 
			'h3' => array ('align' => array ()), 
			'h4' => array ('align' => array ()), 
			'h5' => array ('align' => array ()), 
			'h6' => array ('align' => array ()), 
			'hr' => array (
				'align' => array (), 'color' => array(), 'noshade' => array (), 
				'size' => array (), 'width' => array ()
				), 
			'i' => array (), 
			'img' => array (
				'alt' => array (), 'align' => array (), 'border' => array (), 
				'class' => array(), 'copyright' => array(), 'height' => array (), 
				'hspace' => array (), 'localsrc' => array (), 
				'longdesc' => array (), 'vspace' => array (), 
				'src' => array ('type' => 'uri'), 'title' => array(), 
				'vspace' => array(), 'width' => array ()
				), 
			'input' => array(
				'accesskey' => array(), 'checked' => array(), 'emptyok' => array(),
				'format' => array(), 'istyle' => array(), 'localsrc' => array(),
				'maxlength' => array(), 'mode' => array(), 'name' => array(), 
				'size' => array(), 'type' => array(), 'value' => array(),
				),
			'ins' => array (
				'datetime' => array(), 'cite' => array('type' => 'uri')
				),
			'kbd' => array (), 
			'label' => array ('for' => array ()), 
			'legend' => array ('align' => array ()), 
			'li' => array (), 
			'ol' => array(
				'start' => array(), 'type' => array()
				),
			'option' => array(
				'value' => array(), 'selected' => array()
				),
			'p' => array (
				'align' => array (), 'class' => array()
				), 
			'param' => array(
				'name' => array(), 'value' => array(), 'valuetype' => array()
				),
			'pre' => array ('width' => array ()), 
			'q' => array('cite' => array('type' => 'uri')),
			's' => array (), 
			'select' => array(
				'name' => array(), 'size' => array(), 'multiple' => array()
				),
			'strike' => array (), 
			'strong' => array (), 
			'sub' => array (), 
			'sup' => array (), 
			'table' => array (
				'align' => array (), 'bgcolor' => array (), 'border' => array (), 
				'cellpadding' => array (), 'cellspacing' => array (), 
				'rules' => array (), 'summary' => array (), 'width' => array ()
				), 
			'tbody' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'valign' => array ()), 
			'td' => array (
				'abbr' => array (), 'align' => array (), 'axis' => array (), 
				'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 
				'colspan' => array (), 'headers' => array (), 'height' => array (), 
				'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 
				'valign' => array (), 'width' => array ()
				), 
			'textarea' => array (
				'cols' => array (), 'rows' => array (), 'disabled' => array (), 
				'name' => array (), 'readonly' => array ()
				), 
			'tfoot' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'valign' => array ()
				), 
			'th' => array (
				'abbr' => array (), 'align' => array (), 'axis' => array (), 
				'bgcolor' => array (), 'char' => array (), 'charoff' => array (), 
				'colspan' => array (), 'headers' => array (), 'height' => array (), 
				'nowrap' => array (), 'rowspan' => array (), 'scope' => array (), 
				'valign' => array (), 'width' => array ()
				), 
			'thead' => array (
				'align' => array (), 'char' => array (), 'charoff' => array (), 
				'valign' => array ()
				), 
			'title' => array (), 
			'tr' => array (
				'align' => array (), 'bgcolor' => array (), 'char' => array (), 
				'charoff' => array (), 'valign' => array ()
				), 
			'tt' => array (), 
			'u' => array (), 
			'ul' => array (), 
			'var' => array () 
		);

		$allowedtags = array (
			'a' => array ('href' => array (), 'title' => array ()),
			'abbr' => array ('title' => array ()),
			'acronym' => array ('title' => array ()),
			'b' => array (),
			'blockquote' => array ('cite' => array ()),
			//	'br' => array(),
			'code' => array (),
			//	'del' => array('datetime' => array()),
			'div' => array ('align' => array (), 'class' => array()), 
			//	'dd' => array(),
			//	'dl' => array(),
			//	'dt' => array(),
			'em' => array (),
			'i' => array (),
			'img' => array (
				'alt' => array (), 'align' => array (), 'border' => array (), 
				'class' => array(), 'height' => array (), 'hspace' => array (), 
				'localsrc' => array (), 'longdesc' => array (), 'vspace' => array (), 
				'src' => array (), 'title' => array (),  'width' => array ()),
			//	'ins' => array('datetime' => array(), 'cite' => array()),
			//	'li' => array(),
			//	'ol' => array(),
			'p' => array ('align' => array (), 'class' => array()), 
			//	'q' => array(),
 			'strike' => array (),
 			'strong' => array (),
			//	'sub' => array(),
			//	'sup' => array(),
			//	'u' => array(),
			//	'ul' => array(),
		);
	}
}

/* ==================================================
 * @param	string   $input
 * @return	array    $contents
 */
public function parse($input) {
	global $allowedposttags, $allowedtags;

	try {
		$structure = $this->decode_message($input);
		if (is_email($this->get_option('ke_posting_addr'))) {
			$recipients = $this->read_recipients($structure);
			if (! in_array($this->get_option('ke_posting_addr'), $recipients)) {
				throw new Ktai_Error('Invalid recipient address.');
			}
		}
		$from = $this->read_sender($structure);
		if (! $from || preg_match('/^MAILER-DAEMON@/i', $from)) {
			throw new Ktai_Error('No sender address found.');
		}
		$post_author = $this->validate_address($from);
		if (! $post_author) {
			throw new Ktai_Error("Sender address is not registered: $from");
		}
		$post_time_gmt = strtotime(trim($structure->headers['date']));
		if (! $post_time_gmt) {
			throw new Ktai_Error('There is no Date: field.');
		} elseif ($this->check_duplication($post_time_gmt)) {
			throw new Ktai_Error(sprintf('The mail at "%s" was already posted.', $structure->headers['date']));
		}

		$this->select_operator($from);
		$contents = $this->get_mime_parts($structure);
		$this->debug_print(sprintf('Text %d bytes, Attachment %d part(s)', strlen($contents->text), count($contents->images)));
		$contents->from            = $from;
		$contents->post_author     = $post_author;
		$contents->post_time_gmt   = $post_time_gmt;
		$contents->post_time_local = $post_time_gmt + (get_option('gmt_offset') * 3600);
		$post_title = xmlrpc_getposttitle($content_text);
		if (! $post_title) {
			$subject = mb_convert_encoding($structure->headers['subject'], get_option('blog_charset'), 'auto');
			$post_title = trim(str_replace(get_option('subjectprefix'), '', $subject));
		}
		$contents->post_title = $post_title;
		return $contents;

	} catch (Ktai_Error $e) {
		if (! $e->getCode()) {
			$e->setCode(QMAIL_DELIVERY_FAILED_PERMANENTLY);
		}
		return $e;
	}
}

/* ==================================================
 * @param	array    $contents
 * @return	int      $status
 * based on wp-mail.php of WordPress 2.0.5
 */
public function insert($contents) {
	try {
		$post = get_default_post_to_edit();
		$this->chop_signature($contents);
		$post_category  = $this->decide_category($contents);
		$tags_input     = $this->decide_keywords($contents);
		$rotations      = $this->decide_rotations($contents);
		$post_name      = $this->decide_postname($contents);
		$post_date      = gmdate('Y-m-d H:i:s', $contents->post_time_local);
		$post_date_gmt  = gmdate('Y-m-d H:i:s', $contents->post_time_gmt);
		if (! $post_name) {
			$post_name = gmdate('His', $contents->post_time_local);
		}
		$status = $this->decide_status($contents);
		if (! $status) {
			throw new Ktai_Error('You are not allowed to post.');
		}
		if (count($contents->images)) {
			$post_status  = 'draft';
		} else {
			$post_status  = $status;
		}
		$post_title     = $contents->post_title;
		$post_author    = $contents->post_author;
		$comment_status = $post->comment_status;
		$ping_status    = $post->ping_status;
		$post_content   = apply_filters('phone_content', $contents->text);

		$post_data = compact('post_title', 'post_name', 'post_date', 'post_date_gmt', 'post_author', 'post_category', 'tags_input', 'post_status', 'comment_status', 'ping_status', 'post_content');
		$post_data = add_magic_quotes($post_data);
		if (defined('KE_DEBUG') && KE_DEBUG) {
			$poster_info = get_userdata($post_author);
			$log  = "From    : {$contents->from}\n";
			$log .= "Author  : {$poster_info->user_nicename} (ID: {$post_data['post_author']})\n";
			$log .= "Date    : {$post_data['post_date']}\n";
			$log .= "Date GMT: {$post_data['post_date_gmt']}\n";
			$log .= "Title   : {$post_data['post_title']}\n";
			$log .=   "+-- Content -------------------\n";			
			$log .= preg_replace('/^/m', '|', $post_data['post_content']);
			$log .= "\n+------------------------------";
			$this->debug_print($log);
		}
	
		$post_ID = wp_insert_post($post_data);
		if (! $post_ID) {
			throw new Ktai_Error("We couldn't post, for whatever reason.");
		}
		$this->debug_print(sprintf('Inserted a post with ID: %d, status: %s', $post_ID, $post_status));

		if (count($contents->images)) {
			if ($image_ids = $this->upload_images($contents, $rotations, $post_ID)) {
				$post = get_post($post_ID); // refresh cache
				$post_content = $this->images_to_html($contents->text, $image_ids);
				$post_content = apply_filters('phone_content', $post_content);
				$content_array = add_magic_quotes((array) $post_content);
				$post_data['post_content'] = $content_array[0];
				$log =    "+-- Content w/images ----------\n";			
				$log .= preg_replace('/^/m', '|', $post_data['post_content']);
				$log .= "\n+------------------------------";
				$this->debug_print($log);
			}
			$post_data['ID'] = $post_ID;
			$post_data['post_status'] = $status;
			wp_update_post($post_data);
			$this->debug_print(sprintf('Updated the post to status "%s" with %d image(s).',  $status, count($image_ids)));
		}

		if ($post_data['post_status'] == 'publish') {
			do_action('publish_phone', $post_ID);
		}
		return QMAIL_DELIVERY_SUCCESSFUL;

	} catch (Ktai_Error $e) {
		if (! $e->getCode()) {
			$e->setCode(QMAIL_DELIVERY_FAILED_PERMANENTLY);
		}
		return $e;
	}
}

/* ==================================================
 * @param	string   $message
 * @return	object   $structure
 */
private function decode_message($message) {
	$params['include_bodies'] = true;
	$params['decode_bodies']  = true;
	$params['decode_headers'] = true;
	$params['input'] = $message;
	$structure = Mail_mimeDecode::decode($params);
	return $structure;
}

/* ==================================================
 * @param	string   $field
 * @return	array    $addresses
 */
private function pickup_rfc2822_address($field) {
	$addresses = array();
	$quoted    = array();
	// ----- save quoted text -----
	while (1) {
		preg_match('/(^|[^\\\\])("([^\\\\"]|\\\\.)*")/', $field, $m);
		if (! isset($m[2])) {
			break;
		}
		$field = preg_replace("/(^|[^\\\\])$m[2]/", "$1\376\376\376" . count($quoted) . "\376\376\376", $field, 1);
		$quoted[] = $m[2];
	}
	// ---- remove comments -----
	$field = preg_replace('/\([^)]*[^\\\\]\)/', '', $field);
	// ----- remove group name -----
	$field = preg_replace('/[-\w ]+:([^;]*);/', '$1', $field);
	// ----- split into each address -----
	foreach (explode(',', $field) as $a) {
		$a = str_replace(' ', '', $a);
		preg_match('/<([^>]*)>/', $a, $m);
		if (isset($m[1]) && $m[1]) {
			$a = $m[1];
		}
		// ----- restore quoted text -----
		$a = preg_replace('/\376\376\376(\d+)\376\376\376/e', '$quoted[$1]', $a);
		// ----- got address -----
		if ($a) {
			$addresses[] = $a;
		}
	}
	return $addresses;
}

/* ==================================================
 * @param	object   $structure
 * @return	string   $sender
 */
private function read_sender($structure) {
	$senders = $this->pickup_rfc2822_address(trim($structure->headers['from']));
	$sender = $senders[0];
	if (! $sender) {
		$senders = $this->pickup_rfc2822_address($_ENV['SENDER']);
		$sender = $senders[0];
	}
	return $sender;
}

/* ==================================================
 * @param	object   $structure
 * @return	array    $recipients
 */
private function read_recipients($structure) {
	$recipients = $this->pickup_rfc2822_address(trim($structure->headers['to'])) 
	            + $this->pickup_rfc2822_address(trim($structure->headers['cc']));
	return $recipients;
}

/* ==================================================
 * @param	string   $address
 * @return	int      $user_id
 */
private function validate_address($address) {
	$user_id = 0;
	if (function_exists('get_user_by_email')) {
		$user = get_user_by_email($address);
		if ($user) {
			$user_id = $user->ID;
		}
	} else {
		global $wpdb;
		$email4sql = $wpdb->escape($address);
		$user_id = $wpdb->get_var("SELECT ID FROM {$wpdb->users} WHERE user_email = '$email4sql' ORDER BY ID ASC LIMIT 1");
	}
	$user_id = apply_filters('validate_address/ktai_entry.php', $user_id, $address);
	if (! $user_id) {
		return NULL;
	}
	return $user_id;
}

/* ==================================================
 * @param	string   $address
 * @return	none
 */
private function select_operator($address) {
	if (preg_match('/@ezweb\.ne\.jp$/i', $address)) {
		$this->operator = new Ktai_Entry_EZweb();
	} elseif (preg_match('/@(\w+\.)?pdx\.ne\.jp$/i', $address)) {
		$this->operator = new Ktai_Entry_WILLCOM();
	} else {
		$this->operator = NULL;
	}
	return;
}

/* ==================================================
 * @param	string   $post_time_gmt
 * @return	int      $ID
 */
private function check_duplication($post_time_gmt) {
	global $wpdb;
	$time4sql = gmdate('Y-m-d H:i:s', $post_time_gmt);
	$result = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_date_gmt = '$time4sql' LIMIT 1");
	return $result;
}

/* ==================================================
 * @param	object   $part
 * @return	array    $contents
 */
private function get_mime_parts($part) {
	$contents = new stdClass;
	$contents->text = '';
	$contents->images = array();
	switch (strtolower($part->ctype_primary)) {
		case 'multipart':
			foreach ($part->parts as $p) {
				$part_content = $this->get_mime_parts($p);
				$contents->text .= $part_content->text;
				$contents->images = array_merge($contents->images, $part_content->images);
			}
			break;
		case 'text':
			if ($part->ctype_secondary == 'plain' || $part->ctype_secondary == 'x-pmaildx') {
				$text = trim($part->body);
			} elseif ($part->ctype_secondary == 'html') {
				$text = trim(strip_tags($part->body));
			}
			if (preg_match('/charset=[\'"]?([^\'"]*)/', $part->headers['content-type'], $c)) {
				$charset = $c[1];
			} else {
				$charset = 'auto';
			}
			if (is_object($this->operator)) {
				$text = $this->operator->pickup_pics($text, $charset);
			}
			$contents->text .= mb_convert_encoding($text, get_option('blog_charset'), $charset);
			break;
		case 'image':
			$name = $part->d_parameters['filename'] ? $part->d_parameters['filename'] : $part->ctype_parameters['name'];
			$contents->images[] = array($name, $part->ctype_secondary, $part->body);
			break;
	}		
	return $contents;
}

/* ==================================================
 * @param	array    $contents
 * @return	array    $categories
 */
private function decide_category(&$contents) {
	$categories = array();
	if (preg_match('/^((' . preg_quote(KE_SET_CATEGORY, '/') . 
	               ')|(' . preg_quote(KE_ADD_CATEGORY, '/') . 
	               ')|(' . preg_quote(KE_CHANGE_CATEGORY, '/') . 
	               ')|(' . preg_quote(KE_ADD_CHANGE_CATEGORY, '/') . 
	               '))(.*)$/m', $contents->text, $c)) {
		$new_default = 0;
		$contents->text = preg_replace('/^' . preg_quote($c[0], '/') . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		$categories = $this->cat_name2id($c[6]);
		if (isset($c[4]) && $c[4] || isset($c[5]) && $c[5]) {
			$new_default = $categories[0];
		}
		if (isset($c[3]) && $c[3] || isset($c[5]) && $c[5]) {
			array_unshift($categories, get_option('default_email_category'));
		}
		if ($new_default) {
			update_option('default_email_category', $new_default);
		}
	}
	if (count($categories) < 1) {
		$categories[] = get_option('default_email_category');
	}
	$this->debug_print('Category: ' . implode(', ', array_map('get_catname', $categories)));
	return $categories;
}

/* ==================================================
 * @param	string   $cat_names
 * @return	array    $categories
 */
private function cat_name2id($cat_names) {
	$categories = array();
	foreach (explode(',', $cat_names) as $c) {
		$c = trim($c);
		if (is_numeric($c)) {
			$c = intval($c);
		} elseif (function_exists('get_category_by_slug') && $cat = get_category_by_slug($c)) {
			$c = $cat->cat_ID;
		} else {
			$c = get_cat_ID($c);
		}
		if ($c) {
			$categories[] = $c;
		}
	}
	if (count($categories)) {
		$this->debug_print(sprintf("Assign cats: '%s' -> %s", $cat_names, implode(',',$categories)));
	} else {
		$this->debug_print(sprintf("No categories found from: '%s'", $cat_names));
	}
	return $categories;
}

/* ==================================================
 * @param	array    $contents
 * @return	string   $keywords
 */
private function decide_keywords(&$contents) {
	$keywords = '';
	if (preg_match('/^' . preg_quote(KE_SET_TAGS, '/') . '(.*)$/m', $contents->text, $k)) {
		$keywords = trim($k[1]);
		$contents->text = preg_replace('/^' . preg_quote($k[0], '/') . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		$this->debug_print("Tags: '$keywords'");
	}
	return $keywords;
}

/* ==================================================
 * @param	array    $contents
 * @return	array    $rotations
 */
private function decide_rotations(&$contents) {
	if (preg_match('/^' . preg_quote(KE_ROTATE_IMAGE) . '(.*)$/m', $contents->text, $r) ) {
		$contents->text = preg_replace('/^' . preg_quote($r[0], '/') . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		$rotations = $this->parse_rotation(strtoupper($r[1]), count($contents->images));
	} else {
		$rotations = $this->parse_rotation('', count($contents->images));
	}
	if (isset($rotations) && count($rotations)) {
		$this->debug_print('Rotation: ' . implode(',', $rotations));
	}
	return $rotations;
}

/* ==================================================
 * @param	string   $rotations
 * @param	int      $num_images
 * @return	array    $rotations
 */
private function parse_rotation($rot_desc, $num_images) {
	if ($num_images < 1) {
		return NULL;
	}
	$rot_desc = trim($rot_desc);
	// ----- Single 'L' or 'R' means rotating all image to the same direction.
	if ($rot_desc == 'L' || $rot_desc == 'R' || $rot_desc == 'N') {
		$rotations = array_fill(0, $num_images, $rot_desc);
	// ----- Continuous of 'N', 'L', or 'R' string means rotating each image to such direction.
	} elseif (preg_match('/^[NLR]+$/', $rot_desc)) {
		$rotations = str_split($rot_desc) + array_fill(0, $num_images, 'N');
	// ----- Number and 'L'/'R' means to rotate the numbered images to the desired direction.
	} elseif (preg_match('/^(\d+[LR])+/', $rot_desc)) {
		$rotations = array_fill(0, $num_images, 'N');
		preg_match_all('/(\d+)([LR])/', $rot_desc, $rot, PREG_SET_ORDER);
		foreach ($rot as $r) {
			$rotations[$r[1] -1] = $r[2];
		}
	// ----- Default is no rotation.
	} else {
		$rotations = array_fill(0, $num_images, 'N');
	}
	return $rotations;
}

/* ==================================================
 * @param	array    $contents
 * @return	string   $post_name
 */
private function decide_postname(&$contents) {
	$post_name = '';
	if (preg_match('/^' . preg_quote(KE_SET_POSTSLUG, '/') . '(.*)$/m', $contents->text, $p)) {
		$post_name = trim($p[1]);
		$contents->text = preg_replace('/^' . preg_quote($p[0], '/') . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		$this->debug_print("Post slug: '$post_name'");
	}
	return $post_name;
}

/* ==================================================
 * @param	array    $contents
 * @return	string   $status
 */
private function decide_status(&$contents) {
	$can_pending = version_compare($this->get_wp_version(), 2.3, '>=');
	$user = set_current_user($contents->post_author);
	if (current_user_can('publish_posts')) {
		$status = 'publish';
	} elseif (current_user_can('edit_posts')) {
		$status = $can_pending ? 'pending' : 'draft';
	} else {
		$status = NULL;
	}

	$status = apply_filters('post_status/ktai_entry.php', $status, $can_pending, $contents->post_author, $contents->from);
	$available = array('publish' => 1, 'pending' => 1, 'draft' => 1, 'private' => 1);
	if (empty($status) || ! isset($available[$status])) {
		$status = NULL;
	}

	if (preg_match('/^' . preg_quote(KE_PRIVATE) . '$/m', $contents->text, $s) ) {
		$contents->text = preg_replace('/^' . preg_quote($s[0]) . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		$status = $status ? 'private' : $status;
	} elseif (preg_match('/^' . preg_quote(KE_DRAFT) . '$/m', $contents->text, $s) ) {
		$contents->text = preg_replace('/^' . preg_quote($s[0]) . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		$status = $status ? 'draft' : $status;
	} elseif (preg_match('/^' . preg_quote(KE_PENDING) . '$/m', $contents->text, $s) ) {
		$contents->text = preg_replace('/^' . preg_quote($s[0]) . '[ \t\r]*(\n|\z)/m', '', $contents->text, 1);
		if ($can_pending) {
			$status = ($status == 'publish') ? 'pending' : $status;
		} else {
			$status = $status ? 'draft' : $status;
		}
	}
	$this->debug_print('Status: ' . ($status ? $status : '(N/A)'));
	return $status;
}

/* ==================================================
 * @param	object   $contents
 * @return	none
 */
private function chop_signature(&$contents) {
	if (defined('KE_DELIM_STR')) {
		$text = $contents->text;
		$sig_match = strripos($text, "\n" . KE_DELIM_STR);
		if ($sig_match > 0) {
			$text = substr($text, 0, $sig_match);
			$this->debug_print("Signature chopped at position: $sig_match");
		}
		$contents->text = $text;
	}
	return;
}

/* ==================================================
 * @param	object   $contents
 * @param	array    $rotations
 * @param	int      $post_id
 * @return	array    $image_ids
 * based on wp_handle_upload() at wp-admin/includes/file.php of WP 2.5
 */
private function upload_images($contents, $rotations, $post_id = 0) {
	if (count($contents->images) < 1) {
		return NULL;
	}
	$image_ids = array();
	foreach ($contents->images as $count => $img) {
		if ( ! ( ( $uploads = wp_upload_dir() ) && false === $uploads['error'] ) ) {
			$this->logging(@$uploads['error']);
			return NULL;
		}
		$filename = $this->unique_filename($uploads['path'], $img[0]);
		$new_file = $uploads['path'] . "/$filename";
		$this->debug_print("Saving file: $new_file");
		$result = $this->save_image($new_file, $img[1], $img[2], @$rotations[$count]);
		if (is_ktai_error($result)) {
			$this->logging($result->getMessage());
			return NULL;
		}
		$url = $uploads['url'] . "/$filename";
		$file = apply_filters('wp_handle_upload', array('file' => $new_file, 'url' => $url, 'type' => "image/{$img[1]}"));

		$url  = $file['url'];
		$type = $file['type'];
		$file = $file['file'];
		$title = preg_replace('/\.[^.]+$/', '', basename($file));
		$content = '';

		if ( function_exists('wp_read_image_metadata') 
		 && $image_meta = @wp_read_image_metadata($file) ) {
			if ( trim($image_meta['title']) )
				$title = $image_meta['title'];
			if ( trim($image_meta['caption']) )
				$content = $image_meta['caption'];
		}

		$attachment = array(
			'post_mime_type' => $type,
			'guid'           => $url,
			'post_parent'    => $post_id,
			'post_title'     => $title,
			'post_content'   => $content,
			'post_excerpt'   => ($content ? $content : basename($file)),
		);

		$id = wp_insert_attachment($attachment, $file, $post_id);
		if ((function_exists('is_wp_error') && is_wp_error($id)) || $id <= 0) {
			$this->logging(sprintf('Failed inserting attachment for post#%d: %s', $post_id,  $file));
		} else {
			if (function_exists('wp_generate_attachment_metadata')) {
				wp_update_attachment_metadata($id, wp_generate_attachment_metadata($id, $file));
			} else {
				$this->update_attachment_metadata($attachment, $id, $file);
			}
			$this->debug_print("Inserted attachment: $id for post $post_id");
			$image_ids[] = $id;
		}
	}
	return $image_ids;
}


/* ==================================================
 * @param	string   $dir
 * @param	string   $filename
 * @param	string   $new_file
 */
// If $file is exists, change filename to $file_2, $file_3, ...
private function unique_filename($dir, $filename) {
	$parts = pathinfo($filename);
	$ext = $parts['extension'];
	$name = preg_replace("/\.{$ext}\$/", '', $parts['basename']);
	$name = preg_replace('/[^-_.~+a-zA-Z0-9]/', '', $name);
	$count = '';
	while (file_exists("$dir/$name$count.$ext")) {
		$count = $count ? preg_replace('/(\d+)/e', "intval('$1') + 1", $count) : "_2";
	}
	return "$name$count.$ext";
}

/* ==================================================
 * @param	string   $filepath
 * @param	string   $type
 * @param	string   $image_string
 * @param	string   $rotation
 * @return	boolean  $result
 */
private function save_image($filepath, $type, $image_string, $rotation) {
	try {
		$image  = imagecreatefromstring($image_string);
		$width  = imagesx($image);
		$height = imagesy($image);
		if ($rotation != 'L' && $rotation != 'R') {
			$fp = fopen($filepath, 'w');
			if (! $fp) {throw new Ktai_Error("Can't create a file: $filepath");}
			if (! fwrite($fp, $image_string)) {throw new Ktai_Error("Can't write to file: $filepath");}
			if (! fclose($fp)) {throw new Ktai_Error("Can't close the file: $filepath");}
			if (! chmod($filepath, KE_IMAGE_PERM)) {throw new Ktai_Error("Can't chmod the file: $filepath");}
			$this->debug_print("Image without rotation: {$width}x{$height} type:$type");
		} else {
			$rotated = $this->rotate_image($image, $type, $rotation, $filepath);
			if (is_ktai_error($rotated)) {
				return $rotated;
			}
			if (! chmod($filepath, KE_IMAGE_PERM)) {throw new Ktai_Error("Can't chmod the file: $filepath");}
			imagedestroy($rotated);
			$this->debug_print("Image with rotation($rotation): {$width}x{$height} type:$type");
		}
		imagedestroy($image);
		return TRUE;

	} catch (Ktai_Error $e) {
		return $e;
	}
}

/* ==================================================
 * @param	resource $image
 * @param	string   $type
 * @param	string   $direction
 * @param	string   $filepath
 * @return	resource $rotated
 */
private function rotate_image($image, $type, $direction, $filepath) {	
	$angle = $direction == 'L' ? 90: 270;
	$rotated = imagerotate($image, $angle, 0);
	switch (strtolower($type)) {
	case 'gif':
		$result = imagegif($rotated, $filepath);
		break;
	case 'png':
		$result = imagepng($rotated, $filepath);
		break;
	case 'jpeg':
	default:
		$result = imagejpeg($rotated, $filepath);
		break;
	}
	if (! $result || ! file_exists($filepath)) {
		return new Ktai_Error("Can't write rotated image: $filepath");
	}
	return $rotated;
}

/* ==================================================
 * @param	object   $attachment
 * @param	int      $id
 * @param	string   $file
 * @return	object   $this
 * based on line 78-105 at inline-uploading.php of WP ME 2.0.11
 */
private function update_attachment_metadata($attachment, $id, $file) {
	if ( preg_match('!^image/!', $attachment['post_mime_type']) ) {
		// Generate the attachment's postmeta.
		$imagesize = getimagesize($file);
		$imagedata['width'] = $imagesize['0'];
		$imagedata['height'] = $imagesize['1'];
		list($uwidth, $uheight) = get_udims($imagedata['width'], $imagedata['height']);
		$imagedata['hwstring_small'] = "height='$uheight' width='$uwidth'";
		$imagedata['file'] = $file;

		add_post_meta($id, '_wp_attachment_metadata', $imagedata);

		$max_length = intval($this->get_option('ke_thumb_size'));
		if ($max_length < 10) {
			$max_length = 128;
		}
		if ( $imagedata['width'] * $imagedata['height'] < 3 * 1024 * 1024 ) {
			if ( $imagedata['width'] > $max_length 
			&& $imagedata['width'] >= $imagedata['height'] * 4 / 3 )
				$thumb = wp_create_thumbnail($file, $max_length);
			elseif ( $imagedata['height'] > $max_length )
				$thumb = wp_create_thumbnail($file, $max_length);

			if ( @ file_exists($thumb) ) {
				chmod($thumb, KE_IMAGE_PERM);
				$newdata = $imagedata;
				$newdata['thumb'] = basename($thumb);
				update_post_meta($id, '_wp_attachment_metadata', $newdata, $imagedata);
			} else {
				$error = $thumb;
			}
		}
	} else {
		add_post_meta($id, '_wp_attachment_metadata', array());
	}
}

/* ==================================================
 * @param	array    $html
 * @param	array    $image_ids
 * @return	string   $html
 */
private function images_to_html($content, $image_ids) {
	if (is_array($image_ids) && count($image_ids)) {
		$img = array();
		if (function_exists('wp_get_attachment_link')) {
			$link_func = 'wp_get_attachment_link';
			$size      = ($this->get_option('ke_thumb_size') == 'medium') ? 'medium' : 'thumbnail';
		} else {
			$link_func = 'get_the_attachment_link';
			$size      = FALSE;
		}
		foreach ($image_ids as $id) {
			if (! $id) continue;
			$html = $link_func($id, $size);
			if (! preg_match('/href=(["\'])([^"\']*)\\1/', $html, $file)) {
				preg_match('/src=(["\'])([^"\']*)\\1/', $html, $file);
			}
			if (preg_match('/alt=(""|\'\')/', $html, $match)) {
				$html = str_replace($match[0], 'alt="' . basename($file[2]) . '"', $html);
			} elseif (! preg_match('/alt=/', $html)) {
				$html = str_replace('<img ', '<img alt="' . basename($file[2]) . '" ', $html);
			}
			$img[] = apply_filters('image_link/ktai_entry.php', $html, $id, $size);
		}
		$template = $this->get_option('ke_post_template');
		if (strpos($template, KE_TEMPLATE_IMAGES) === FALSE) {
			$template .= KE_TEMPLATE_IMAGES;
		}
		if (count($img)) {
			$search  = array(KE_TEMPLATE_TEXT, KE_TEMPLATE_IMAGES);
			$replace = array($content, implode(' ', $img));
			$content = apply_filters('media_to_html/ktai_entry.php', 
				str_replace($search, $replace, $template), 
				$content, $img);
		}
	}
	return $content;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_EZweb class
   ================================================== */

class Ktai_Entry_EZweb {
	// http://www.au.kddi.com/ezfactory/tec/spec/3.html
	static public $pics = array (
		"\x75\x3a" => '1'  , // 「!」
		"\x75\x3b" => '2'  , // 「!」
		"\x75\x3c" => '3'  , // 「?」
		"\x77\x29" => '4'  , // 「Q」
		"\x77\x2a" => '5'  , // 左向き三角1
		"\x77\x2b" => '6'  , // 右向き三角1
		"\x77\x2c" => '7'  , // 左向き三角2
		"\x77\x2d" => '8'  , // 右向き三角2
		"\x77\x2e" => '9'  , // 小四角 1
		"\x77\x2f" => '10' , // 小四角 2
		"\x77\x30" => '11' , // インフォメーションシンボル
		"\x75\x7a" => '12' , // ワイングラス
		"\x76\x6c" => '13' , // スピーカー
		"\x77\x76" => '14' , // ドルマーク
		"\x76\x5e" => '15' , // 月 1
		"\x75\x40" => '16' , // いなずま
		"\x77\x31" => '17' , // 中四角 1
		"\x77\x32" => '18' , // 中四角 2
		"\x77\x33" => '19' , // 小菱形 1
		"\x77\x34" => '20' , // 小菱形 2
		"\x77\x35" => '21' , // 中四角 1
		"\x77\x36" => '22' , // 中四角 2
		"\x77\x37" => '23' , // 小菱形 1
		"\x77\x38" => '24' , // 小菱形 2
		"\x77\x77" => '25' , // 腕時計
		"\x77\x39" => '26' , // プラス
		"\x77\x3a" => '27' , // マイナス
		"\x77\x3b" => '28' , // 星 1
		"\x77\x3c" => '29' , // 上矢印 1
		"\x77\x3d" => '30' , // 下矢印 1
		"\x77\x3e" => '31' , // 丸に斜め線
		"\x77\x3f" => '32' , // 下三角 1
		"\x77\x40" => '33' , // 上三角 1
		"\x77\x41" => '34' , // 下三角 2
		"\x77\x42" => '35' , // 上三角 2
		"\x77\x43" => '36' , // 大菱形 1
		"\x77\x44" => '37' , // 大菱形 2
		"\x77\x45" => '38' , // 特大四角 1
		"\x77\x46" => '39' , // 特大四角 2
		"\x77\x47" => '40' , // 大丸 1
		"\x77\x48" => '41' , // 大丸 2
		"\x77\x49" => '42' , // 上矢印 2 (左上)
		"\x77\x4a" => '43' , // 下矢印 2 (右下)
		"\x75\x41" => '44' , // 太陽
		"\x75\x73" => '45' , // 野球ボール
		"\x78\x33" => '46' , // 時計
		"\x75\x42" => '47' , // 月 2 (顔つき)
		"\x76\x6d" => '48' , // ベル
		"\x77\x5d" => '49' , // プッシュピン (画鋲)
		"\x76\x55" => '50' , // 小顔
		"\x78\x34" => '51' , // ハート
		"\x75\x7b" => '52' , // マティーニ (カクテルグラス)
		"\x76\x6e" => '53' , // 四つ葉
		"\x77\x4b" => '54' , // トレードマーク (TM)
		"\x77\x4c" => '55' , // かける
		"\x77\x5e" => '56' , // 文書 1
		"\x77\x78" => '57' , // 砂時計 1
		"\x75\x35" => '58' , // 砂時計 2
		"\x77\x5f" => '59' , // フロッピーディスク 1
		"\x75\x43" => '60' , // 雪の結晶
		"\x77\x4d" => '61' , // バツ 1
		"\x77\x4e" => '62' , // バツ 2
		"\x77\x4f" => '63' , // 右矢印 1
		"\x77\x50" => '64' , // 左矢印 1
		"\x75\x7c" => '65' , // マグカップ
		"\x77\x51" => '66' , // 割る
		"\x77\x60" => '67' , // カレンダー
		"\x76\x56" => '68' , // スマイルフェイス
		"\x75\x44" => '69' , // 星 2
		"\x77\x52" => '70' , // 右矢印 2 (右上)
		"\x77\x53" => '71' , // 左矢印 2 (左下)
		"\x76\x6f" => '72' , // ジュエリー
		"\x77\x54" => '73' , // チェックマーク 1
		"\x76\x3a" => '74' , // 犬 (プードル)
		"\x75\x21" => '75' , // 星 3
		"\x75\x25" => '76' , // スパーク
		"\x75\x2f" => '77' , // 電球
		"\x76\x3b" => '78' , // 鳥
		"\x78\x2e" => '79' , // フォルダ 1 (閉)
		"\x76\x57" => '80' , // 顔 1
		"\x77\x55" => '81' , // コピーライトマーク (C)
		"\x77\x56" => '82' , // レジスタードマーク (R)
		"\x75\x55" => '83' , // ブリーフケース (ハンドバック)
		"\x78\x2f" => '84' , // フォルダ 2 (開)
		"\x78\x35" => '85' , // 電話 1 (プッシュホン)
		"\x76\x58" => '86' , // 吹き出しコメント
		"\x77\x79" => '87' , // クレジットカード
		"\x77\x57" => '88' , // 上三角 3
		"\x77\x58" => '89' , // 下三角 3
		"\x77\x70" => '90' , // USA (国旗)
		"\x75\x56" => '91' , // ノート 3
		"\x77\x61" => '92' , // クリップボード
		"\x78\x36" => '93' , // カップ
		"\x76\x70" => '94' , // カメラ
		"\x75\x45" => '95' , // 雨
		"\x75\x74" => '96' , // フットボール
		"\x77\x62" => '97' , // 本 1
		"\x75\x3d" => '98' , // 立ち入り禁止
		"\x75\x23" => '99' , // 信号
		"\x77\x63" => '100', // 本 2
		"\x77\x64" => '101', // 本 3
		"\x77\x65" => '102', // 本 4
		"\x77\x66" => '103', // 文書 2
		"\x76\x71" => '104', // はさみ
		"\x77\x67" => '105', // ひめくりカレンダー
		"\x75\x57" => '106', // チケット・キップ
		"\x75\x46" => '107', // くもり
		"\x76\x7c" => '108', // 封筒
		"\x77\x7a" => '109', // 小切手 (CHECK)
		"\x76\x72" => '110', // ビデオカメラ
		"\x77\x7b" => '111', // ハンディカム
		"\x75\x64" => '112', // 家
		"\x76\x3f" => '113', // 花 (チューリップ)
		"\x77\x7c" => '114', // ナイフ
		"\x77\x7d" => '115', // ビデオテープ
		"\x76\x59" => '116', // めがね
		"\x77\x59" => '117', // 回り矢印 1
		"\x77\x5a" => '118', // 回り矢印 2
		"\x76\x73" => '119', // むしめがね
		"\x76\x74" => '120', // 鍵
		"\x77\x68" => '121', // ノート 1
		"\x75\x58" => '122', // ノート 2 (開)
		"\x77\x7e" => '123', // ボルト & ナット
		"\x76\x75" => '124', // くつ (ハイヒール)
		"\x75\x6a" => '125', // 車
		"\x78\x21" => '126', // フロッピー 2
		"\x77\x71" => '127', // チャート (棒グラフ)
		"\x77\x72" => '128', // グラフ 1 (折れ線グラフ)
		"\x76\x76" => '129', // メールボックス
		"\x78\x22" => '130', // 懐中電灯
		"\x77\x69" => '131', // Roldex
		"\x77\x5b" => '132', // チェックマーク 2
		"\x76\x29" => '133', // はっぱ
		"\x76\x3c" => '134', // 猟犬
		"\x78\x23" => '135', // 電池
		"\x77\x5c" => '136', // スクロール
		"\x77\x6a" => '137', // がびょう
		"\x76\x77" => '138', // 錠前
		"\x78\x24" => '139', // ドル札
		"\x76\x5a" => '140', // 指差し確認左
		"\x76\x5b" => '141', // 指差し確認右
		"\x77\x6b" => '142', // 台帳
		"\x75\x59" => '143', // クリップ
		"\x76\x2a" => '144', // プレゼント
		"\x76\x78" => '145', // 名札
		"\x75\x65" => '146', // ゴハン 1 (ナイフとフォーク)
		"\x77\x6c" => '147', // 複数本
		"\x75\x6b" => '148', // トラック
		"\x75\x5a" => '149', // エンピツ
		"\x78\x25" => '150', // ロゴ (PDC社)
		"\x78\x30" => '151', // 封筒 2
		"\x78\x26" => '152', // レンチ
		"\x78\x31" => '153', // 送信 BOX
		"\x78\x32" => '154', // 受信 BOX
		"\x76\x79" => '155', // 電話 2 (受話器)
		"\x76\x86" => '156', // 工場・建物
		"\x77\x6d" => '157', // 定規 1 (直線)
		"\x75\x5b" => '158', // 定規 2 (三角)
		"\x77\x73" => '159', // グラフ 2
		"\x75\x7d" => '160', // 食事 2 (マンガ肉)
		"\x78\x27" => '161', // 電話 3 (携帯)
		"\x78\x28" => '162', // コンセント
		"\x76\x5c" => '163', // 家族
		"\x78\x29" => '164', // リンク
		"\x76\x7a" => '165', // パッケージ
		"\x76\x7b" => '166', // FAX
		"\x75\x47" => '167', // ときどき曇り
		"\x75\x6c" => '168', // 飛行機
		"\x75\x6d" => '169', // ボート (船)
		"\x76\x23" => '170', // サイコロ
		"\x78\x2a" => '171', // 新聞
		"\x75\x6e" => '172', // 電車
		"\x78\x2b" => '173', // 全部ブランク
		"\x78\x2c" => '174', // 半分ブランク
		"\x78\x2d" => '175', // 4分の1ブランク
		"\x75\x36" => '176', // 喫煙
		"\x75\x37" => '177', // 禁煙
		"\x75\x38" => '178', // 車椅子
		"\x75\x39" => '179', // 若葉マーク
		"\x76\x7d" => '180', // 四角数字 1
		"\x76\x7e" => '181', // 四角数字 2
		"\x77\x21" => '182', // 四角数字 3
		"\x77\x22" => '183', // 四角数字 4
		"\x77\x23" => '184', // 四角数字 5
		"\x77\x24" => '185', // 四角数字 6
		"\x77\x25" => '186', // 四角数字 7
		"\x77\x26" => '187', // 四角数字 8
		"\x77\x27" => '188', // 四角数字 9
		"\x77\x28" => '189', // 四角数字 10
		"\x75\x22" => '190', // 台風
		"\x75\x3e" => '191', // ゆきだるま
		"\x75\x48" => '192', // 星座 (おひつじ座)
		"\x75\x49" => '193', // 星座 (おうし座)
		"\x75\x4a" => '194', // 星座 (双子座)
		"\x75\x4b" => '195', // 星座 (かに座)
		"\x75\x4c" => '196', // 星座 (しし座)
		"\x75\x4d" => '197', // 星座 (おとめ座)
		"\x75\x4e" => '198', // 星座 (天秤座)
		"\x75\x4f" => '199', // 星座 (さそり座)
		"\x75\x50" => '200', // 星座 (いて座)
		"\x75\x51" => '201', // 星座 (やぎ座)
		"\x75\x52" => '202', // 星座 (水瓶座)
		"\x75\x53" => '203', // 星座 (うお座)
		"\x75\x54" => '204', // 星座 (へびつかい座)
		"\x75\x5c" => '205', // ATM
		"\x75\x5d" => '206', // 24 HOURS (コンビニ)
		"\x75\x5e" => '207', // トイレ
		"\x75\x5f" => '208', // パーキング
		"\x75\x60" => '209', // バス停
		"\x75\x61" => '210', // アンテナ (位置情報マーク)
		"\x75\x62" => '211', // 港 (いかりマーク)
		"\x75\x63" => '212', // 銀行
		"\x77\x6e" => '213', // ガススタンド
		"\x77\x6f" => '214', // 地図
		"\x75\x67" => '215', // 自転車
		"\x75\x68" => '216', // バス
		"\x75\x69" => '217', // 新幹線
		"\x75\x24" => '218', // マラソン
		"\x75\x6f" => '219', // サッカー
		"\x75\x70" => '220', // テニス
		"\x75\x71" => '221', // スノーボード
		"\x75\x72" => '222', // チェッカーフラッグ (モータースポーツ)
		"\x75\x26" => '223', // 遊園地
		"\x75\x75" => '224', // 温泉
		"\x75\x76" => '225', // 居酒屋 (赤ちょうちん)
		"\x75\x77" => '226', // 映画 (かちんこ)
		"\x75\x78" => '227', // 夜の橋
		"\x75\x79" => '228', // 東京タワー
		"\x75\x27" => '229', // スロット (777)
		"\x75\x28" => '230', // くす玉 (アタリのくす玉)
		"\x75\x7e" => '231', // 当選弓矢
		"\x76\x21" => '232', // ゲームのコントローラ
		"\x76\x22" => '233', // 賞金
		"\x76\x24" => '234', // クリスマスツリー
		"\x76\x25" => '235', // 花見 (さくら)
		"\x76\x26" => '236', // お化け
		"\x76\x27" => '237', // 旗 (祝日・日の丸)
		"\x76\x28" => '238', // スイカ
		"\x76\x2b" => '239', // ケーキ
		"\x76\x2c" => '240', // フライパン (目玉焼き)
		"\x76\x2d" => '241', // さくらんぼ
		"\x76\x2e" => '242', // ふぐ
		"\x76\x2f" => '243', // イチゴ
		"\x76\x30" => '244', // おにぎり
		"\x76\x31" => '245', // ハンバーガー (ファーストフード)
		"\x76\x29" => '246', // くじら
		"\x76\x32" => '247', // うさぎ
		"\x76\x33" => '248', // うま
		"\x76\x34" => '249', // さる
		"\x76\x35" => '250', // かえる
		"\x76\x36" => '251', // 猫
		"\x76\x37" => '252', // ペンギン
		"\x76\x38" => '253', // あり
		"\x76\x39" => '254', // ぶた
		"\x76\x3d" => '255', // やしのき
		"\x76\x3e" => '256', // ひまわり
		"\x75\x2a" => '257', // 顔 1 (うれしいカオ)
		"\x75\x2b" => '258', // 顔 2 (おこったカオ)
		"\x75\x2c" => '259', // 顔 3 (かなしいカオ)
		"\x75\x2d" => '260', // 顔 4 (つかれたカオ)
		"\x75\x2e" => '261', // 眠い (ZZZ...)
		"\x76\x40" => '262', // 怒り (ムカッ)
		"\x76\x41" => '263', // 雫 (涙・汗)
		"\x76\x42" => '264', // からかう (あっかんべえ)
		"\x75\x30" => '265', // ハート 2 (われている)
		"\x75\x31" => '266', // ハート 3 (大きい & 小さい)
		"\x75\x32" => '267', // スパーク 2 (キラリマーク)
		"\x75\x33" => '268', // 爆弾
		"\x75\x34" => '269', // 炎
		"\x76\x43" => '270', // 捜索 (SOS)
		"\x76\x44" => '271', // 力こぶ
		"\x76\x45" => '272', // ハート 5 (矢がささっている)
		"\x76\x46" => '273', // キスマーク
		"\x76\x47" => '274', // 宇宙人
		"\x76\x48" => '275', // なると
		"\x76\x49" => '276', // 足跡 (犬)
		"\x76\x4a" => '277', // 悪魔
		"\x76\x4b" => '278', // 花丸
		"\x76\x4c" => '279', // 丸秘
		"\x76\x4d" => '280', // 100点満点
		"\x76\x4e" => '281', // パンチ
		"\x76\x4f" => '282', // ダッシュ
		"\x76\x50" => '283', // ウンチマーク
		"\x76\x51" => '284', // 人差し指サイン
		"\x76\x52" => '285', // マル得
		"\x76\x53" => '286', // どくろ
		"\x76\x54" => '287', // おやゆびサイン (指が上)
		"\x76\x5d" => '288', // テレビ
		"\x76\x5e" => '289', // マイク
		"\x76\x5f" => '290', // 財布
		"\x76\x60" => '291', // メロディ
		"\x76\x61" => '292', // ギター (エレキ)
		"\x76\x62" => '293', // バイオリン (クラシック)
		"\x76\x63" => '294', // ヘッドフォン
		"\x76\x64" => '295', // 口紅
		"\x76\x65" => '296', // アクション (ピストル)
		"\x76\x66" => '297', // エステ
		"\x77\x74" => '298', // EZ マーク
		"\x77\x75" => '299', // 無料 (FREE)
		"\x76\x67" => '300', // CD/DVD
		"\x76\x68" => '301', // 婦人服
		"\x76\x69" => '302', // UFO
		"\x76\x6a" => '303', // 更新 (UP!)
		"\x76\x6b" => '304', // 注射器 (血)
		"\x78\x37" => '305', // 霧
		"\x78\x38" => '306', // ゴルフ
		"\x78\x39" => '307', // バスケットボール
		"\x78\x3a" => '308', // ポケットベル
		"\x78\x3b" => '309', // アート
		"\x78\x3c" => '310', // 演劇
		"\x78\x3d" => '311', // イベント (サーカス)
		"\x78\x3e" => '312', // リボン
		"\x78\x3f" => '313', // バースデー
		"\x78\x40" => '314', // スペード
		"\x78\x41" => '315', // ダイヤ
		"\x78\x42" => '316', // クラブ
		"\x78\x43" => '317', // 目
		"\x78\x44" => '318', // 耳
		"\x78\x45" => '319', // 手 (チョキ)
		"\x78\x46" => '320', // 手 (パー)
		"\x78\x47" => '321', // 新月
		"\x78\x48" => '322', // やや欠け月
		"\x78\x49" => '323', // 半月
		"\x78\x4a" => '324', // クリア
		"\x78\x4b" => '325', // 四角数字 0
		"\x78\x4c" => '326', // 決定 (OK)
		"\x78\x4d" => '327', // ふらふら (顔)
		"\x78\x4e" => '328', // かわいい
		"\x78\x4f" => '329', // どんっ (衝撃)
		"\x78\x50" => '330', // あせあせ (飛び散る汗)
		"\x78\x51" => '331', // イージープラス
		"\x78\x52" => '332', // 地球
		"\x78\x53" => '333', // ラーメン
		"\x78\x67" => '334', // NEW
		"\x78\x68" => '335', // 紳士服
		"\x78\x69" => '336', // 紳士靴
		"\x78\x6a" => '337', // パソコン
		"\x78\x6b" => '338', // ラジオ
		"\x78\x6c" => '339', // バラ
		"\x78\x6d" => '340', // チャペル
		"\x78\x6e" => '341', // 地下鉄
		"\x78\x6f" => '342', // 富士山
		"\x78\x70" => '343', // 八分音符
		"\x78\x71" => '344', // 天使
		"\x78\x72" => '345', // トラ
		"\x78\x73" => '346', // くま
		"\x78\x74" => '347', // ねずみ
		"\x78\x75" => '348', // ウィンク (顔)
		"\x78\x76" => '349', // 目がハート (顔)
		"\x78\x77" => '350', // ショッキング (顔)
		"\x78\x78" => '351', // 困り (顔)
		"\x78\x79" => '352', // たこ
		"\x78\x7a" => '353', // ロケット
		"\x78\x7b" => '354', // 王冠
		"\x78\x7c" => '355', // チュー (キスしている)
		"\x78\x7d" => '356', // ハンマー
		"\x78\x7e" => '357', // 打ち上げ花火
		"\x79\x21" => '358', // 枯れ葉
		"\x79\x22" => '359', // 仕事かばん
		"\x79\x23" => '360', // 噴水
		"\x79\x24" => '361', // キャンプ
		"\x79\x25" => '362', // 麻雀
		"\x79\x26" => '363', // VS (バーサス)
		"\x79\x27" => '364', // トロフィー
		"\x79\x28" => '365', // カメ
		"\x79\x29" => '366', // スペイン国旗
		"\x79\x2a" => '367', // ロシア国旗
		"\x79\x2b" => '368', // 工事中
		"\x79\x2c" => '369', // 風呂
		"\x79\x2d" => '370', // 祝日マーク
		"\x79\x2e" => '371', // 夕方街並み
		"\x79\x2f" => '372', // 卵割り
		"\x79\x30" => '373', // 株価
		"\x79\x31" => '374', // ポリス
		"\x79\x32" => '375', // 郵便局
		"\x79\x33" => '376', // 病院
		"\x79\x34" => '377', // 学校
		"\x79\x35" => '378', // ホテル
		"\x79\x36" => '379', // 船
		"\x79\x37" => '380', // 18禁
		"\x79\x38" => '381', // 圏内
		"\x79\x39" => '382', // COOL!
		"\x79\x3a" => '383', // 割マーク
		"\x79\x3b" => '384', // ザ・マーク
		"\x79\x3c" => '385', // IDマーク
		"\x79\x3d" => '386', // 満マーク
		"\x79\x3e" => '387', // 空マーク
		"\x79\x3f" => '388', // 指定マーク
		"\x79\x40" => '389', // 営業中マーク
		"\x79\x41" => '390', // 上指差し
		"\x79\x42" => '391', // 下指差し
		"\x79\x43" => '392', // 占い (水晶)
		"\x79\x44" => '393', // マナーモード
		"\x79\x45" => '394', // 電源OFF
		"\x79\x46" => '395', // メモする
		"\x79\x47" => '396', // ネクタイ
		"\x79\x48" => '397', // ハイビスカス
		"\x79\x49" => '398', // 花束
		"\x79\x4a" => '399', // サボテン
		"\x79\x4b" => '400', // お銚子 & 杯
		"\x79\x4c" => '401', // 乾杯 (ビール)
		"\x79\x4d" => '402', // 祝マーク
		"\x79\x4e" => '403', // 風邪薬 (カプセル)
		"\x79\x4f" => '404', // 風船
		"\x79\x50" => '405', // クラッカー
		"\x79\x51" => '406', // eznavigation
		"\x79\x52" => '407', // 帽子
		"\x79\x53" => '408', // ロングブーツ
		"\x79\x54" => '409', // ネイル
		"\x79\x55" => '410', // 美容院
		"\x79\x56" => '411', // 床屋
		"\x79\x57" => '412', // 着物
		"\x79\x58" => '413', // ビキニ
		"\x79\x59" => '414', // ハート (トランプ)
		"\x79\x5a" => '415', // 光るハート
		"\x79\x5b" => '416', // 青ハート
		"\x79\x5c" => '417', // 緑ハート
		"\x79\x5d" => '418', // 黄ハート
		"\x79\x5e" => '419', // 紫ハート
		"\x79\x5f" => '420', // きらきら
		"\x79\x60" => '421', // スキー
		"\x79\x61" => '422', // ○
		"\x79\x62" => '423', // 日本茶
		"\x79\x63" => '424', // 食パン
		"\x79\x64" => '425', // ソフトクリーム
		"\x79\x65" => '426', // ポテト
		"\x79\x66" => '427', // だんご
		"\x79\x67" => '428', // おせんべい
		"\x79\x68" => '429', // ごはん
		"\x79\x69" => '430', // スパゲティ
		"\x79\x6a" => '431', // カレー
		"\x79\x6b" => '432', // おでん
		"\x79\x6c" => '433', // 寿司
		"\x79\x6d" => '434', // りんご
		"\x79\x6e" => '435', // みかん
		"\x79\x6f" => '436', // トマト
		"\x79\x70" => '437', // なす
		"\x79\x71" => '438', // 弁当
		"\x79\x72" => '439', // 鍋
		"\x79\x73" => '440', // ふっ (顔)
		"\x79\x74" => '441', // しょんぼり (顔)
		"\x79\x75" => '442', // 勝ち誇り (顔)
		"\x79\x76" => '443', // 失敗 (顔)
		"\x79\x77" => '444', // わからん
		"\x79\x78" => '445', // 眠い
		"\x79\x79" => '446', // てれてれ (顔)
		"\x79\x7a" => '447', // 青ざめ (顔)
		"\x79\x7b" => '448', // 風邪ひき
		"\x79\x7c" => '449', // 熱 (顔)
		"\x79\x7d" => '450', // 横目 (顔)
		"\x79\x7e" => '451', // びっくり (顔)
		"\x7a\x21" => '452', // あせり (顔)
		"\x7a\x22" => '453', // 楽譜
		"\x7a\x23" => '454', // にこにこ (顔)
		"\x7a\x24" => '455', // チュー 2 (顔)
		"\x7a\x25" => '456', // チュッ (顔)
		"\x7a\x26" => '457', // 鼻
		"\x7a\x27" => '458', // 口
		"\x7a\x28" => '459', // ゴメン／お願い
		"\x7a\x29" => '460', // 拍手
		"\x7a\x2a"=> '461', // OK! (指で丸サイン)
		"\x7a\x2b" => '462', // ブーイング (指が下)
		"\x7a\x2c" => '463', // バイバイ
		"\x7a\x2d" => '464', // NG (ネコ)
		"\x7a\x2e" => '465', // OK! 2 (ネコ)
		"\x7a\x2f" => '466', // 平謝り (ネコ)
		"\x7a\x30" => '467', // カップル
		"\x7a\x31" => '468', // バニー
		"\x7a\x32" => '469', // トランペット
		"\x7a\x33" => '470', // ビリヤード
		"\x7a\x34" => '471', // 水泳
		"\x7a\x35" => '472', // 消防車
		"\x7a\x36" => '473', // 救急車
		"\x7a\x37" => '474', // パトカー
		"\x7a\x38" => '475', // ジェットコースター
		"\x7a\x39" => '476', // 門松
		"\x7a\x3a" => '477', // 雛祭り
		"\x7a\x3b" => '478', // 卒業式
		"\x7a\x3c" => '479', // 入学式
		"\x7a\x3d" => '480', // こいのぼり
		"\x7a\x3e" => '481', // 傘
		"\x7a\x3f" => '482', // 花嫁
		"\x7a\x40" => '483', // かき氷
		"\x7a\x41" => '484', // 線香花火
		"\x7a\x42" => '485', // 巻き貝
		"\x7a\x43" => '486', // 風鈴
		"\x7a\x44" => '487', // ハロウィン
		"\x7a\x45" => '488', // お月見
		"\x7a\x46" => '489', // サンタ
		"\x7a\x47" => '490', // 夜／流れ星
		"\x7a\x48" => '491', // 虹
		"\x7a\x49" => '492', // ホテル 2
		"\x7a\x4a" => '493', // 日の出
		"\x7a\x4b" => '494', // シルクハット
		"\x7a\x4c" => '495', // デパート
		"\x7a\x4d" => '496', // 城 (日本)
		"\x7a\x4e" => '497', // 城 (ヨーロッパ)
		"\x7a\x4f" => '498', // 工場 2
		"\x7a\x50" => '499', // フランス国旗
		"\x77\x54" => '500', // オープンウェーブ
		"\x77\x55" => '501', // ロック確認
		"\x77\x56" => '502', // 大文字
		"\x77\x57" => '503', // 小文字
		"\x77\x58" => '504', // 数字
		"\x77\x59" => '505', // 記号
		"\x77\x5a" => '506', // アクセプト
		"\x77\x5b" => '507', // チェックボックス
		"\x77\x5c" => '508', // エディット
		"\x77\x5d" => '509', // ラジオボタン
		"\x77\x5e" => '510', // 見る (虫眼鏡)
		"\x77\x5f" => '511', // 戻る
		"\x77\x60" => '512', // お気に入り
		"\x77\x61" => '513', // 終了
		"\x77\x62" => '514', // ホーム
		"\x77\x63" => '515', // 受信箱 1
		"\x77\x64" => '516', // マーク
		"\x77\x65" => '517', // 個人 (鍵)
		"\x77\x66" => '518', // 再読み込み
		"\x7a\x51" => '700', // ドイツ国旗
		"\x7a\x52" => '701', // イタリア国旗
		"\x7a\x53" => '702', // イギリス国旗
		"\x7a\x54" => '703', // 中国国旗
		"\x7a\x55" => '704', // 韓国国旗
		"\x7a\x56" => '705', // 白人
		"\x7a\x57" => '706', // 中国人
		"\x7a\x58" => '707', // インド人
		"\x7a\x59" => '708', // おじいさん
		"\x7a\x5a" => '709', // おばあさん
		"\x7a\x5b" => '710', // 赤ちゃん
		"\x7a\x5c" => '711', // 工事現場の人
		"\x7a\x5d" => '712', // お姫様
		"\x7a\x5e" => '713', // イルカ
		"\x7a\x5f" => '714', // ダンス
		"\x7a\x60" => '715', // 熱帯魚
		"\x7a\x61" => '716', // げじげじ
		"\x7a\x62" => '717', // 象
		"\x7a\x63" => '718', // コアラ
		"\x7a\x64" => '719', // ホルスタイン
		"\x7a\x65" => '720', // ヘビ
		"\x7a\x66" => '721', // 鶏
		"\x7a\x67" => '722', // うりぼう
		"\x7a\x68" => '723', // ふたこぶらくだ
		"\x7a\x69" => '724', // A型
		"\x7a\x6a" => '725', // B型
		"\x7a\x6b" => '726', // O型
		"\x7a\x6c" => '727', // AB型
		"\x7a\x6d" => '728', // 足跡
		"\x7a\x6e" => '729', // スニーカー
		"\x7a\x6f" => '730', // 旗
		"\x7a\x70" => '731', // 上向きカーブ矢印
		"\x7a\x71" => '732', // 下向きカーブ矢印
		"\x7a\x72" => '733', // 「!?」
		"\x7a\x73" => '734', // 「!!」
		"\x7a\x74" => '735', // くるり
		"\x7a\x75" => '736', // メロン
		"\x7a\x76" => '737', // パイナップル
		"\x7a\x77" => '738', // ぶどう
		"\x7a\x78" => '739', // バナナ
		"\x7a\x79" => '740', // とうもろこし
		"\x7a\x7a" => '741', // きのこ
		"\x7a\x7b" => '742', // 栗
		"\x7a\x7c" => '743', // 桃
		"\x7a\x7d" => '744', // やきいも
		"\x7a\x7e" => '745', // ピザ
		"\x7b\x21" => '746', // ターキー
		"\x7b\x22" => '747', // 七夕笹飾り
		"\x7b\x23" => '748', // トロピカルドリンク
		"\x7b\x24" => '749', // 辰
		"\x7b\x25" => '750', // ピアノ
		"\x7b\x26" => '751', // サーフィン
		"\x7b\x27" => '752', // 釣り
		"\x7b\x28" => '753', // ボウリング
		"\x7b\x29" => '754', // なまはげ
		"\x7b\x2a" => '755', // 天狗
		"\x7b\x2b" => '756', // パンダ
		"\x7b\x2c" => '757', // あかんべー
		"\x7b\x2d" => '758', // ぶたの鼻
		"\x7b\x2e" => '759', // 花
		"\x7b\x2f" => '760', // アイスクリーム
		"\x7b\x30" => '761', // ドーナツ
		"\x7b\x31" => '762', // クッキー
		"\x7b\x32" => '763', // チョコ
		"\x7b\x33" => '764', // キャンディ (包み)
		"\x7b\x34" => '765', // キャンディ (ぺろぺろ)
		"\x7b\x35" => '766', // 見ざる (猿)
		"\x7b\x36" => '767', // 言わざる (猿)
		"\x7b\x37" => '768', // 聞かざる (猿)
		"\x7b\x38" => '769', // 火山
		"\x7b\x39" => '770', // リボンがけのハート
		"\x7b\x3a" => '771', // 英語「ABC」
		"\x7b\x3b" => '772', // プリン
		"\x7b\x3c" => '773', // ミツバチ
		"\x7b\x3d" => '774', // テントウムシ
		"\x7b\x3e" => '775', // 蜂蜜ポット
		"\x7b\x3f" => '776', // 青りんご
		"\x7b\x40" => '777', // 羽のはえたお札
		"\x7b\x41" => '778', // 目がまわる時の記号
		"\x7b\x42" => '779', // ぷー (かわいく怒)
		"\x7b\x43" => '780', // ぷー (かわいく怒) (ネコ)
		"\x7b\x44" => '781', // 天の川
		"\x7b\x45" => '782', // チュー (ネコ)
		"\x7b\x46" => '783', // にこ (ネコ)
		"\x7b\x47" => '784', // メールする
		"\x7b\x48" => '785', // 泣き笑い (ネコ)
		"\x7b\x49" => '786', // 泣き笑い (顔)
		"\x7b\x4a" => '787', // 目がハート (ネコ)
		"\x7b\x4b" => '788', // ほえー (ネコ)
		"\x7b\x4c" => '789', // ほえー (顔)
		"\x7b\x4d" => '790', // 涙ぽろり (ネコ)
		"\x7b\x4e" => '791', // 涙ぽろり (顔)
		"\x7b\x4f" => '792', // きりり (ネコ)
		"\x7b\x50" => '793', // ドレス
		"\x7b\x51" => '794', // モヤイ像
		"\x7b\x52" => '795', // 駅
		"\x7b\x53" => '796', // 花札
		"\x7b\x54" => '797', // ジョーカー
		"\x7b\x55" => '798', // エビフライ
		"\x7b\x56" => '799', // eメールアイコン
		"\x7b\x57" => '800', // 歩く人
		"\x7b\x58" => '801', // パトカーのランプ
		"\x7b\x59" => '802', // ezmovie
		"\x7b\x5a" => '803', // ドキドキしているハート
		"\x7b\x5b" => '804', // 正面向きのひよこ
		"\x7b\x5c" => '805', // ジーンズ
		"\x7b\x5d" => '806', // ハートつきメール
		"\x7b\x5e" => '807', // 循環矢印
		"\x7b\x5f" => '808', // 左右両方矢印
		"\x7b\x60" => '809', // 上下両方矢印
		"\x7b\x61" => '810', // 荒波
		"\x7b\x62" => '811', // 双葉
		"\x7b\x63" => '812', // かたつむり
		"\x7b\x64" => '813', // うっしっし (ネコ)
		"\x7b\x65" => '814', // うっしっし (顔)
		"\x7b\x66" => '815', // Cメールアイコン
		"\x7b\x67" => '816', // ハーブ
		"\x7b\x68" => '817', // 手 (グー)
		"\x7b\x69" => '818', // 「#」
		"\x7b\x6a" => '819', // 挙手 (キャラクター)
		"\x7b\x6b" => '820', // 万歳 (キャラクター)
		"\x7b\x6c" => '821', // しょんぼり (キャラクター)
		"\x7b\x6d" => '822', // かわいく怒る (キャラクター)
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	if (strtolower($charset) == 'iso-2022-jp') {
		for ($offset = 0 , $replace = 'X' ;
			 preg_match('/\x1b\$B([\x21-\x7e]+)\x1b\(B/', $buffer, $sequence, PREG_OFFSET_CAPTURE, $offset); //)
			 $offset += strlen($replace)) 
		{
			$orig    = $sequence[0][0];
			$offset  = $sequence[0][1];
			$chars   = $sequence[1][0];
			$replace = "\x1b\$B";
			for ($i = 0 ; $i < strlen($chars) -1 ; $i += 2) {
				if (isset(self::$pics[$chars[$i] . $chars[$i+1]])) {
					$replace .= sprintf("\x1b(B<img localsrc=\"%d\" />\x1b\$B", self::$pics[$chars[$i] . $chars[$i+1]]); //)
				} else {
					$replace .= $chars[$i] . $chars[$i+1];
				}
			}
			$replace .= "\x1b(B"; //)
			$replace = str_replace("\x1b\$B\x1b(B", '', $replace); //)
			$buffer = substr_replace($buffer, $replace, $offset, strlen($orig));	
		}
	}
	return $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Entry_WILLCOM class
   ================================================== */

class Ktai_Entry_WILLCOM {
	// http://www.willcom-inc.com/ja/service/contents_service/club_air_edge/for_phone/homepage/pdf/contents_reference.pdf
	static public $pics_willcom = array(
		'<#HEART>'     => 'wf040', // ハート
		'<#CLOCK>'     => 'wf041', // 掛時計
		'<#TELEPHONE>' => 'wf042', // 電話
		'<#CUP>'       => 'wf043', // マグカップ
		'<#STAR>'      => 'wf044', // *
		'<#VSEL>'      => 'wf045', // 上下矢印
		'<#HSEL>'      => 'wf046', // 左右矢印
		'<#DENPA>'     => 'wf047', // (((
		'<#FINE>'      => 'wf048', // 晴れ
		'<#RAIN>'      => 'wf049', // 雨
		'<#CLOUD>'     => 'wf04a', // 曇り
		'<#TEAR>'      => 'wf04b', // 雫
		'<#SMILE>'     => 'wf04c', // 笑顔
		'<#KISS>'      => 'wf04d', // キスマーク
		'<#MELODY>'    => 'wf04e', // 十六分音符
		'<#CAR>'       => 'wf04f', // 車
		'<#TRAIN>'     => 'wf050', // 電車
		'<#PLANE>'     => 'wf051', // 飛行機
		'<#BIKE>'      => 'wf052', // バイク
		'<#HOME>'      => 'wf053', // 家
		'<#BUIL>'      => 'wf054', // ビル
		'<#PEACE>'     => 'wf055', // 手 (チョキ)
		'<#DINNER>'    => 'wf056', // ナイフとフォーク (レストラン)
		'<#GLASS>'     => 'wf057', // マティーニ (カクテル)
		'<#CRY>'       => 'wf058', // 涙顔
		'<#TULIP>'     => 'wf059', // チューリップ
		'<#BASEBALL>'  => 'wf05a', // バット
		'<#BALL>'      => 'wf05b', // 野球ボール
		'<#PUNCH>'     => 'wf05c', // 手 (グー)
		'<#THUNDER>'   => 'wf05d', // 雷
		'<#ANGRY>'     => 'wf05e', // 怒り顔
		'<#BEER>'      => 'wf05f', // ビール
		'<#NOTE>'      => 'wf060', // ノート
		'<#PEN>'       => 'wf061', // 鉛筆
		'<#DOKURO>'    => 'wf062', // ドクロ
		'<#MAIL>'      => 'wf063', // メール
		'<#NOSMOKING>' => 'wf064', // 禁煙
		'<#BELL>'      => 'wf065', // ベル
		'<#FLOWER>'    => 'wf066', // 花
		'<#SPA>'       => 'wf067', // 温泉
		'<#MOON>'      => 'wf068', // 二十六日月
		'<#FLAG>'      => 'wf069', // 旗
		'<#MASK>'      => 'wf06a', // マスク顔
		'<#RECORD>'    => 'wf06b', // 音楽
		'<#MEAT>'      => 'wf06c', // 肉
		'<#DOG>'       => 'wf06d', // 犬
		'<#CAT>'       => 'wf06e', // 猫
		'<#MONKEY>'    => 'wf06f', // 猿
		'<#ELEPHANT>'  => 'wf070', // 象
		'<#TAKO>'      => 'wf071', // 蛸
		'<#NOODLE>'    => 'wf072', // ラーメン
		'<#MIC>'       => 'wf073', // マイク (カラオケ)
		'<#PIKI>'      => 'wf074', // 怒りマーク
		'<#PIYOPIYO>'  => 'wf075', // ひよこ
		'<#SLEEP>'     => 'wf076', // 眠り顔
		'<#COFFEE>'    => 'wf077', // コーヒーカップ
		'<#TABACCO>'   => 'wf078', // 喫煙
		'<#AUAU>'      => 'wf079', // 飛び散る汗
		'<#ONIGIRI>'   => 'wf07a', // おにぎり
		'<#BAG>'       => 'wf07b', // バッグ
		'<#UNCHI>'     => 'wf07c', // ウンチ
		'<#TIE>'       => 'wf07d', // ネクタイ
		'<#SHIRT>'     => 'wf07e', // Tシャツ
		'<#SUIKA>'     => 'wf080', // 西瓜
		'<#ICE>'       => 'wf081', // かき氷
		'<#BIKINI>'    => 'wf082', // 水着
		'<#HASAMI>'    => 'wf083', // 鋏
		'<#CHUSHA>'    => 'wf084', // 注射器
		'<#MARINE>'    => 'wf085', // 錨
		'<#FROG>'      => 'wf086', // 蛙
		'<#BYEBYE>'    => 'wf087', // 手 (パー)
		'<#BHEART>'    => 'wf088', // 失恋
		'<#DIA>'       => 'wf089', // ダイヤモンド (トランプ)
		'<#CLUBS>'     => 'wf08a', // クラブ (トランプ)
		'<#SPADE>'     => 'wf08b', // スペード (トランプ)
		'<#CLIP>'      => 'wf08c', // クリップ
		'<#SNOWMAN>'   => 'wf08d', // 雪だるま
		'<#CAKE>'      => 'wf08e', // バースデーケーキ
		'<#APPLE>'     => 'wf08f', // 林檎
		'<#PRESENT>'   => 'wf090', // プレゼント
		'<#MONEY>'     => 'wf091', // ドル袋
		'<#EXIT>'      => 'wf092', // 非常口 (右向き)
		'<#DOOR>'      => 'wf093', // ドア
		'<#OYAJI>'     => 'wf094', // おやじ
		'<#PHS>'       => 'wf095', // 携帯電話
		'<#HOSHI>'     => 'wf096', // 星
		'<#TICKET>'    => 'wf097', // チケット
		'<#LOVELOVE>'  => 'wf098', // ハート2つ
		'<#HIRAMEKI>'  => 'wf099', // 電球
		'<#PETA>'      => 'wf09a', // 足跡
		'<#NIKONIKO>'  => 'wf09b', // 喜び顔
		'<#TENNIS>'    => 'wf09c', // テニス
		'<#MOVIE>'     => 'wf09d', // 映画カメラ
		'<#SKI>'       => 'wf09e', // スキー
		'<#!!>'        => 'wf09f', // !!
		'<#!?>'        => 'wf0a0', // !?
		'<#?>'         => 'wf0a1', // ?
		'<#DOWN>'      => 'wf0a2', // カーブ下矢印
		'<#UP>'        => 'wf0a3', // カーブ上矢印
		'<#GOOD>'      => 'wf0a4', // 親指 OK サイン
		'<#MORIMORI>'  => 'wf0a5', // 力こぶ
		'<#CHEART>'    => 'wf0a6', // 矢を射止めたハート
		'<#UZUMAKI>'   => 'wf0a7', // 花丸
		'<#TYPHOON>'   => 'wf0a8', // 台風
		'<#SEA>'       => 'wf0a9', // 海
		'<#SURF>'      => 'wf0aa', // サーフィン
		'<#YAMA>'      => 'wf0ab', // 山
		'<#FUJI>'      => 'wf0ac', // 富士山
		'<#CAMP>'      => 'wf0ad', // テント (キャンプ)
		'<#OCHIBA>'    => 'wf0ae', // 落葉
		'<#BUS>'       => 'wf0af', // バス
		'<#SOCCER>'    => 'wf0b0', // サッカー
		'<#BEGINNER>'  => 'wf0b1', // 初心者マーク
		'<#REW>'       => 'wf0b2', // 二重左矢印
		'<#FF>'        => 'wf0b3', // 二重右矢印
		'<#IMPORTANT>' => 'wf0b4', // 重要
		'<#18KIN>'     => 'wf0b5', // 18禁
		'<#CAUTION>'   => 'wf0b6', // !
		'<#RECICLE>'   => 'wf0b7', // リサイクルマーク
		'<#BARI3>'     => 'wf0b8', // アンテナ
		'<#DEMPA>'     => 'wf0b9', // )))
		'<#PEKE>'      => 'wf0ba', // ×
		'<#COPY>'      => 'wf0bb', // 著作権 (C)
		'<#REG>'       => 'wf0bc', // 登録商標 (R)
		'<#777>'       => 'wf0bd', // スロット (777)
		'<#0>'         => 'wf0be', // 0 (zero)
		'<#1>'         => 'wf0bf', // 1 (one)
		'<#2>'         => 'wf0c0', // 2 (two)
		'<#3>'         => 'wf0c1', // 3 (three)
		'<#4>'         => 'wf0c2', // 4 (four)
		'<#5>'         => 'wf0c3', // 5 (five)
		'<#6>'         => 'wf0c4', // 6 (six)
		'<#7>'         => 'wf0c5', // 7 (seven)
		'<#8>'         => 'wf0c6', // 8 (eight)
		'<#9>'         => 'wf0c7', // 9 (nine)
		'<#ARIES>'     => 'wf0c8', // 牡羊座
		'<#TAURUS>'    => 'wf0c9', // 牡牛座
		'<#GEMINI>'    => 'wf0ca', // 双子座
		'<#CANCER>'    => 'wf0cb', // 蟹座
		'<#LEO>'       => 'wf0cc', // 獅子座
		'<#VIRGO>'     => 'wf0cd', // 乙女座
		'<#LIBLA>'     => 'wf0ce', // 天秤座
		'<#SCORPIO>'   => 'wf0cf', // 蠍座
		'<#OPHIUCHUS>' => 'wf0d0', // 蛇遣座
		'<#SAGITTA>'   => 'wf0d1', // 射手座
		'<#CAPRICO>'   => 'wf0d2', // 山羊座
		'<#AQUARIUS>'  => 'wf0d3', // 水瓶座
		'<#PISCES>'    => 'wf0d4', // 魚座
		'<#JIZOU>'     => 'wf0d5', // 地蔵
		'<#MAKUDO>'    => 'wf0d6', // マクドナルド
		'<#MOS>'       => 'wf0d7', // モスバーガー
		'<#LOTTE>'     => 'wf0d9', // ロッテリア
		'<#DOUTOR>'    => 'wf0db', // ドトールコーヒー
		'<#PEACH>'     => 'wf0e0', // バーミヤン
		'<#!DONKEY>'   => 'wf0e3', // びっくりドンキー
		'<#LAWSON>'    => 'wf0e7', // ローソン
		'<#AM/PM>'     => 'wf0e9', // am/pm
		'<#SEIBU>'     => 'wf0f0', // 西武百貨店
		'<#85>'        => 'wf0fc', // ハチ公
		'<#MOYAI>'     => 'wf140', // モヤイ像
		'<#UFJ>'       => 'wf148', // UFJ Bank
		'<#EXIT2>'     => 'wf14d', // 非常口 (左向き)
		'<#TS-CRY>'    => 'wf150', // 泣き顔
	);
	static public $pics_docomo = array(
		"\xf8\x9f" => 'd001' , // 晴れ
		"\xf8\xa0" => 'd002' , // 曇り
		"\xf8\xa1" => 'd003' , // 雨
		"\xf8\xa2" => 'd004' , // 雪 
		"\xf8\xa3" => 'd005' , // 雷
		"\xf8\xa4" => 'd006' , // 台風
		"\xf8\xa5" => 'd007' , // 霧
		"\xf8\xa6" => 'd008' , // 小雨
		"\xf8\xa7" => 'd009' , // 牡羊座
		"\xf8\xa8" => 'd010' , // 牡牛座
		"\xf8\xa9" => 'd011' , // 双子座
		"\xf8\xaa" => 'd012' , // 蟹座
		"\xf8\xab" => 'd013' , // 獅子座
		"\xf8\xac" => 'd014' , // 乙女座
		"\xf8\xad" => 'd015' , // 天秤座
		"\xf8\xae" => 'd016' , // 蠍座
		"\xf8\xaf" => 'd017' , // 射手座
		"\xf8\xb0" => 'd018' , // 山羊座
		"\xf8\xb1" => 'd019' , // 水瓶座
		"\xf8\xb2" => 'd020' , // 魚座
		"\xf8\xb3" => 'd021' , // スポーツ
		"\xf8\xb4" => 'd022' , // 野球
		"\xf8\xb5" => 'd023' , // ゴルフ
		"\xf8\xb6" => 'd024' , // テニス
		"\xf8\xb7" => 'd025' , // サッカー
		"\xf8\xb8" => 'd026' , // スキー
		"\xf8\xb9" => 'd027' , // バスケットボール
		"\xf8\xba" => 'd028' , // モータースポーツ (チェッカーフラッグ)
		"\xf8\xbb" => 'd029' , // ポケットベル
		"\xf8\xbc" => 'd030' , // 電車
		"\xf8\xbd" => 'd031' , // 地下鉄
		"\xf8\xbe" => 'd032' , // 新幹線
		"\xf8\xbf" => 'd033' , // 車 (セダン)
		"\xf8\xc0" => 'd034' , // 車 (RV)
		"\xf8\xc1" => 'd035' , // バス
		"\xf8\xc2" => 'd036' , // 船
		"\xf8\xc3" => 'd037' , // 飛行機
		"\xf8\xc4" => 'd038' , // 家
		"\xf8\xc5" => 'd039' , // ビル
		"\xf8\xc6" => 'd040' , // 郵便局
		"\xf8\xc7" => 'd041' , // 病院
		"\xf8\xc8" => 'd042' , // 銀行
		"\xf8\xc9" => 'd043' , // ATM
		"\xf8\xca" => 'd044' , // ホテル
		"\xf8\xcb" => 'd045' , // コンビニ
		"\xf8\xcc" => 'd046' , // ガソリンスタンド
		"\xf8\xcd" => 'd047' , // 駐車場
		"\xf8\xce" => 'd048' , // 信号
		"\xf8\xcf" => 'd049' , // トイレ
		"\xf8\xd0" => 'd050' , // レストラン
		"\xf8\xd1" => 'd051' , // 喫茶店
		"\xf8\xd2" => 'd052' , // バー (マティーニ)
		"\xf8\xd3" => 'd053' , // ビール
		"\xf8\xd4" => 'd054' , // ファーストフード (ハンバーガー)
		"\xf8\xd5" => 'd055' , // ブティック
		"\xf8\xd6" => 'd056' , // 美容院 (鋏)
		"\xf8\xd7" => 'd057' , // カラオケ
		"\xf8\xd8" => 'd058' , // 映画
		"\xf8\xd9" => 'd059' , // 右斜め上
		"\xf8\xda" => 'd060' , // 遊園地 (木馬)
		"\xf8\xdb" => 'd061' , // 音楽 (ヘッドホン)
		"\xf8\xdc" => 'd062' , // アート
		"\xf8\xdd" => 'd063' , // 演劇
		"\xf8\xde" => 'd064' , // イベント (サーカス)
		"\xf8\xdf" => 'd065' , // チケット
		"\xf8\xe0" => 'd066' , // 喫煙
		"\xf8\xe1" => 'd067' , // 禁煙
		"\xf8\xe2" => 'd068' , // カメラ
		"\xf8\xe3" => 'd069' , // カバン
		"\xf8\xe4" => 'd070' , // 本
		"\xf8\xe5" => 'd071' , // リボン
		"\xf8\xe6" => 'd072' , // プレゼント
		"\xf8\xe7" => 'd073' , // バースデー
		"\xf8\xe8" => 'd074' , // 電話
		"\xf8\xe9" => 'd075' , // 携帯電話
		"\xf8\xea" => 'd076' , // メモ
		"\xf8\xeb" => 'd077' , // TV
		"\xf8\xec" => 'd078' , // ゲーム
		"\xf8\xed" => 'd079' , // CD
		"\xf8\xee" => 'd080' , // ハート
		"\xf8\xef" => 'd081' , // スペード
		"\xf8\xf0" => 'd082' , // ダイヤ
		"\xf8\xf1" => 'd083' , // クラブ
		"\xf8\xf2" => 'd084' , // 目
		"\xf8\xf3" => 'd085' , // 耳
		"\xf8\xf4" => 'd086' , // 手 (グー)
		"\xf8\xf5" => 'd087' , // 手 (チョキ)
		"\xf8\xf6" => 'd088' , // 手 (パー)
		"\xf8\xf7" => 'd089' , // 右斜め下
		"\xf8\xf8" => 'd090' , // 左斜め上
		"\xf8\xf9" => 'd091' , // 足
		"\xf8\xfa" => 'd092' , // くつ
		"\xf8\xfb" => 'd093' , // 眼鏡
		"\xf8\xfc" => 'd094' , // 車椅子
		"\xf9\x40" => 'd095' , // 新月
		"\xf9\x41" => 'd096' , // やや欠け月
		"\xf9\x42" => 'd097' , // 半月
		"\xf9\x43" => 'd098' , // 三日月
		"\xf9\x44" => 'd099' , // 満月
		"\xf9\x45" => 'd100' , // 犬
		"\xf9\x46" => 'd101' , // 猫
		"\xf9\x47" => 'd102' , // リゾート (ヨット)
		"\xf9\x48" => 'd103' , // クリスマス
		"\xf9\x49" => 'd104' , // 左斜め下
		"\xf9\x72" => 'd105' , // phone to
		"\xf9\x73" => 'd106' , // mail to
		"\xf9\x74" => 'd107' , // fax to
		"\xf9\x75" => 'd108' , // iモード
		"\xf9\x76" => 'd109' , // iモード (枠付き)
		"\xf9\x77" => 'd110' , // メール
		"\xf9\x78" => 'd111' , // ドコモ提供
		"\xf9\x79" => 'd112' , // ドコモポイント
		"\xf9\x7a" => 'd113' , // 有料
		"\xf9\x7b" => 'd114' , // 無料
		"\xf9\x7c" => 'd115' , // ID
		"\xf9\x7d" => 'd116' , // パスワード
		"\xf9\x7e" => 'd117' , // 次項有
		"\xf9\x80" => 'd118' , // クリア
		"\xf9\x81" => 'd119' , // サーチ (調べる)
		"\xf9\x82" => 'd120' , // NEW
		"\xf9\x83" => 'd121' , // 位置情報
		"\xf9\x84" => 'd122' , // フリーダイヤル
		"\xf9\x85" => 'd123' , // シャープダイヤル
		"\xf9\x86" => 'd124' , // モバQ
		"\xf9\x87" => 'd125' , // 1 (one)
		"\xf9\x88" => 'd126' , // 2 (two)
		"\xf9\x89" => 'd127' , // 3 (three)
		"\xf9\x8a" => 'd128' , // 4 (four)
		"\xf9\x8b" => 'd129' , // 5 (five)
		"\xf9\x8c" => 'd130' , // 6 (six)
		"\xf9\x8d" => 'd131' , // 7 (seven)
		"\xf9\x8e" => 'd132' , // 8 (eight)
		"\xf9\x8f" => 'd133' , // 9 (nine)
		"\xf9\x90" => 'd134' , // 0 (zero)
		"\xf9\xb0" => 'd135' , // 決定 (OK)
		"\xf9\x91" => 'd136' , // 黒ハート
		"\xf9\x92" => 'd137' , // 揺れるハート
		"\xf9\x93" => 'd138' , // 失恋
		"\xf9\x94" => 'd139' , // ハートたち (複数ハート)
		"\xf9\x95" => 'd140' , // わーい (嬉しい顔)
		"\xf9\x96" => 'd141' , // ちっ (怒った顔)
		"\xf9\x97" => 'd142' , // がく〜 (落胆した顔)
		"\xf9\x98" => 'd143' , // もうやだ〜 (悲しい顔)
		"\xf9\x99" => 'd144' , // ふらふら
		"\xf9\x9a" => 'd145' , // グッド (上向き矢印)
		"\xf9\x9b" => 'd146' , // るんるん (音符)
		"\xf9\x9c" => 'd147' , // いい気分 (温泉)
		"\xf9\x9d" => 'd148' , // かわいい
		"\xf9\x9e" => 'd149' , // キスマーク
		"\xf9\x9f" => 'd150' , // ぴかぴか (新しい)
		"\xf9\xa0" => 'd151' , // ひらめき
		"\xf9\xa1" => 'd152' , // むかっ (怒り)
		"\xf9\xa2" => 'd153' , // パンチ
		"\xf9\xa3" => 'd154' , // 爆弾
		"\xf9\xa4" => 'd155' , // ムード
		"\xf9\xa5" => 'd156' , // バッド (下向き矢印)
		"\xf9\xa6" => 'd157' , // 眠い (睡眠)
		"\xf9\xa7" => 'd158' , // exclamation
		"\xf9\xa8" => 'd159' , // exclamation and question
		"\xf9\xa9" => 'd160' , // double exclamation
		"\xf9\xaa" => 'd161' , // どんっ (衝撃)
		"\xf9\xab" => 'd162' , // あせあせ (飛び散る汗)
		"\xf9\xac" => 'd163' , // たらーっ (汗)
		"\xf9\xad" => 'd164' , // ダッシュ (走り出すさま)
		"\xf9\xae" => 'd165' , // ー (長音記号1)
		"\xf9\xaf" => 'd166' , // ー (長音記号2)
		"\xf9\x50" => 'd167' , // カチンコ
		"\xf9\x51" => 'd168' , // ふくろ
		"\xf9\x52" => 'd169' , // ペン
		"\xf9\x55" => 'd170' , // 人影
		"\xf9\x56" => 'd171' , // いす
		"\xf9\x57" => 'd172' , // 夜
		"\xf9\x5b" => 'd173' , // soon
		"\xf9\x5c" => 'd174' , // on
		"\xf9\x5d" => 'd175' , // end
		"\xf9\x5e" => 'd176' , // 時計
		"\xf9\xb1" => 'd201' , // iアプリ
		"\xf9\xb2" => 'd202' , // iアプリ (枠付き)
		"\xf9\xb3" => 'd203' , // Tシャツ (ボーダー)
		"\xf9\xb4" => 'd204' , // がま口財布
		"\xf9\xb5" => 'd205' , // 化粧
		"\xf9\xb6" => 'd206' , // ジーンズ
		"\xf9\xb7" => 'd207' , // スノボ
		"\xf9\xb8" => 'd208' , // チャペル
		"\xf9\xb9" => 'd209' , // ドア
		"\xf9\xba" => 'd210' , // ドル袋
		"\xf9\xbb" => 'd211' , // パソコン
		"\xf9\xbc" => 'd212' , // ラブレター
		"\xf9\xbd" => 'd213' , // レンチ
		"\xf9\xbe" => 'd214' , // 鉛筆
		"\xf9\xbf" => 'd215' , // 王冠
		"\xf9\xc0" => 'd216' , // 指輪
		"\xf9\xc1" => 'd217' , // 砂時計
		"\xf9\xc2" => 'd218' , // 自転車
		"\xf9\xc3" => 'd219' , // 湯のみ
		"\xf9\xc4" => 'd220' , // 腕時計
		"\xf9\xc5" => 'd221' , // 考えてる顔
		"\xf9\xc6" => 'd222' , // ほっとした顔
		"\xf9\xc7" => 'd223' , // 冷や汗 (顔)
		"\xf9\xc8" => 'd224' , // 冷や汗2 (顔)
		"\xf9\xc9" => 'd225' , // ぷっくっくな顔
		"\xf9\xca" => 'd226' , // ボケーっとした顔
		"\xf9\xcb" => 'd227' , // 目がハート (顔)
		"\xf9\xcc" => 'd228' , // 指でOK
		"\xf9\xcd" => 'd229' , // あっかんべー
		"\xf9\xce" => 'd230' , // ウィンク
		"\xf9\xcf" => 'd231' , // うれしい顔
		"\xf9\xd0" => 'd232' , // がまん顔
		"\xf9\xd1" => 'd233' , // 猫2
		"\xf9\xd2" => 'd234' , // 泣き顔
		"\xf9\xd3" => 'd235' , // 涙
		"\xf9\xd4" => 'd236' , // NG
		"\xf9\xd5" => 'd237' , // クリップ
		"\xf9\xd6" => 'd238' , // コピーライト (C)
		"\xf9\xd7" => 'd239' , // トレードマーク (TM)
		"\xf9\xd8" => 'd240' , // 走る人
		"\xf9\xd9" => 'd241' , // マル秘
		"\xf9\xda" => 'd242' , // リサイクル
		"\xf9\xdb" => 'd243' , // レジスタードトレードマーク (R)
		"\xf9\xdc" => 'd244' , // 危険・警告 (!)
		"\xf9\xdd" => 'd245' , // 禁止
		"\xf9\xde" => 'd246' , // 空室・空席・空車
		"\xf9\xdf" => 'd247' , // 合格マーク
		"\xf9\xe0" => 'd248' , // 満室・満席・満車
		"\xf9\xe1" => 'd249' , // 矢印左右
		"\xf9\xe2" => 'd250' , // 矢印上下
		"\xf9\xe3" => 'd251' , // 学校
		"\xf9\xe4" => 'd252' , // 波
		"\xf9\xe5" => 'd253' , // 富士山
		"\xf9\xe6" => 'd254' , // クローバー
		"\xf9\xe7" => 'd255' , // さくらんぼ
		"\xf9\xe8" => 'd256' , // チューリップ
		"\xf9\xe9" => 'd257' , // バナナ
		"\xf9\xea" => 'd258' , // りんご
		"\xf9\xeb" => 'd259' , // 芽
		"\xf9\xec" => 'd260' , // もみじ
		"\xf9\xed" => 'd261' , // 桜
		"\xf9\xee" => 'd262' , // おにぎり
		"\xf9\xef" => 'd263' , // ショートケーキ
		"\xf9\xf0" => 'd264' , // とっくり (おちょこ付き)
		"\xf9\xf1" => 'd265' , // どんぶり
		"\xf9\xf2" => 'd266' , // パン
		"\xf9\xf3" => 'd267' , // かたつむり
		"\xf9\xf4" => 'd268' , // ひよこ
		"\xf9\xf5" => 'd269' , // ペンギン
		"\xf9\xf6" => 'd270' , // 魚
		"\xf9\xf7" => 'd271' , // うまい! (顔)
		"\xf9\xf8" => 'd272' , // ウッシッシ (顔)
		"\xf9\xf9" => 'd273' , // ウマ
		"\xf9\xfa" => 'd274' , // ブタ
		"\xf9\xfb" => 'd275' , // ワイングラス
		"\xf9\xfc" => 'd276' , // げっそり (顔)
	);

/* ==================================================
 * @param	string   $buffer
 * @param	string   $charset
 * @return	string   $buffer
 */
public function pickup_pics($buffer, $charset) {
	$buffer = preg_replace('|(<#[-_0-9A-Z/!]+>)|e', '"<img localsrc=\"" . self::$pics_willcom["$1"] . "\" />"', $buffer);
	mb_regex_encoding('SJIS-win');
	$replaced = mb_ereg_replace(
		"([\xf8\x40-\xf8\x5b]|[\xf8\x5d-\xf8\xfc]|[\xf9\x40-\xf9\x5b]|[\xf9\x5d-\xf9\xfc])", 
		'isset(self::$pics_docomo["\1"]) ? 
		"<img localsrc=\"" . self::$pics_docomo["\1"] . "\" />" : 
		"<img localsrc=\"d\" alt=\"" . "[0x" . bin2hex("\1") . "]\" />"', 
		$buffer, 'e');
	if ($replaced) {
		$replaced = mb_ereg_replace("\xf8\x5c", '<img localsrc="d" alt="[0xf85c]" />', $replaced);
		$replaced = mb_ereg_replace("\xf9\x5c", '<img localsrc="' . self::$pics_docomo["\xf9\x5c"] . '" />', $replaced);
	}
	return $replaced ? $replaced : $buffer;
}

// ===== End of class ====================
}

/* ==================================================
 *   Ktai_Error class
   ================================================== */

if (! class_exists('Ktai_Error')) :

function is_ktai_error($thing) {
	return (is_object($thing) && is_a($thing, 'Ktai_Error'));
}

class Ktai_Error extends Exception {

public function setCode($code) {
	$this->code = $code;
}

// ===== End of class ====================
}
endif;

?>