<?php
/* ==================================================
 *   Ktai Content Shrinkage
   ================================================== */

global $KS_Shrinkage;
$KS_Shrinkage = new Ktai_Content_Shrinkage;

define ('KS_THUMBNAIL_FILENAME', '.ktai');
define ('KS_THUMBNAIL_MAX_SIZE', apply_filters('thumbnail_max_size/ktai_style.php', 96));
define ('KS_SIZE_EXCEED_COLOR', '#808080');
define ('KS_KTAI_SITE_CLASS', 'ktai');
define ('KS_PCONLY_SITE_CLASS', 'pconly');
define ('KS_REDIR_URL', 'redir.php?_wpnonce=%s&amp;url=%s');
define ('KS_DIRECT_LINK_IMAGE_SIZE', apply_filters('direct_link_image_size/ktai_style.php', 51200));
define ('KS_EXCERPT_LENGTH', 300);
define ('KS_MAX_PAGE_NUM', 1000);
define ('KS_START_PAGING_PAT', '@<!--start paging(\[(.*?)\])?-->\n*@');
define ('KS_END_PAGING_PAT', '@\n*<!--end paging(\[(.*?)\])?-->@');

//define ('KS_SHRINKAGE_DEBUG', true);

class Ktai_Content_Shrinkage {
	public  $parent;
	private $num_image;
	private $url;
	private $url_pat;
	private $wpurl;
	private $wpurl_pat;
	private $wpcontent_pat;
	private $basepath;
	private $short_links;
	private $internal_pat;
	private $short_int_pat;
	private $host_pat;
	private $wp_plugin_url;
	private $scheme_pat;
	private $leave_pat;
	private $mobile_pat;
	private $none_mobile_pat;
	private $image_services;
	private $image_services_pat;
	private $skip_shrink_content = false;
	static public $mobile_same_url = array(
		// Use same URL for PC and mobile
		'http://[-\w]+\.blog\d+\.fc2\.com/', 
		'http://(jugem|yaplog)\.jp/[-\w]+/', 
		'http://[-\w]+\.seesaa\.net/', 
		'http://blog\.goo\.ne\.jp/[-\w]+/', 
		'http://blogs\.dion\.ne\.jp/[-\w]+/',
		'http://blog\.auone\.jp/[-\w]+/',
		'http://[-\w]+\.blog\.so-net\.ne\.jp/',
		'http://[-\w]+\.paslog\.jp/',
		'http://[-\w]+\.vox\.com/',
		'http://hb\.afl\.rakuten\.co\.jp/hgc/',
		'http://[-\w]+\.ap\.teacup\.com/',
		'http://pub\.ne\.jp/[-.\w]+/',
		// Redirect mobile URL from PC
		'http://d\.hatena\.ne\.jp/[-\w]+/',
		'http://blog\.livedoor\.jp/[-\w]+/',
		'http://[-\w]+.(cocolog|air|moe|tea|txt|way)-nifty\.com/',
		'http://[-\w]+\.at\.webry\.info/',
		'http://ameblo\.jp/[-\w]+/',
		'http://[-\w]+\.spaces\.live\.com/',
		'http://plaza\.rakuten\.co\.jp/[-\w]+(/|$)',
	);
	static public $none_mobile_url = array(
		'http://(www|support|app)\.cocolog-nifty\.com/',
	);

// ==================================================
public function __construct() {
	global $Ktai_Style, $wpmu_version;
	$this->parent = $Ktai_Style;
	$this->num_image = 0;
	$this->url       = $this->parent->strip_host(get_bloginfo('url') . '/');
	$this->url_pat   = '!^(' . preg_quote(get_bloginfo('url'), '!') . '/|' . preg_quote($this->url, '!') . ')!';
	$this->wpurl     = $this->parent->strip_host(get_bloginfo('wpurl') . '/');
	if (! isset($wpmu_version)) {
		$this->wpurl_pat = '!^(' . preg_quote(get_bloginfo('wpurl'), '!') . '/|' . preg_quote($this->wpurl, '!') . ')!';
		$this->wpcontent_pat = preg_replace('/\)!$/', ')wp-content/!', $this->wpurl_pat);
		$this->basepath = ABSPATH;
		$this->internal_pat[0] = '!^' . preg_quote(get_bloginfo('wpurl'), '!') . '/?!';
	} else {
		$this->wpurl .= 'files/';
		$this->wpurl_pat = '!^(' . preg_quote(get_bloginfo('wpurl'), '!') . '/files/|' . preg_quote($this->wpurl, '!') . ')!';
		$this->wpcontent_pat = $this->wpurl_pat;
		$this->basepath = constant('ABSPATH') . constant('UPLOADS');
		$this->internal_pat[0] = '!^' . preg_quote(get_bloginfo('wpurl'), '!') . '/files/?!';
	}
	$this->short_links[0]  = $this->wpurl;
	if (strcmp($this->wpurl, $this->url) !== 0) {
		$this->internal_pat[] = '!^' . preg_quote(get_bloginfo('url'), '!') . '/?!';
		$this->short_links[]  = $this->url;
	}
	$this->short_int_pat = '!^(' . implode('|',  array_map('preg_quote', $this->short_links)) . ')!';
	if (preg_match('!^(https?://[^/]*)/?!', get_bloginfo('wpurl'), $host)) {
		$this->host_pat = '!^(/|' . preg_quote($host[1], '!') . '/)!';
	} else {
		$this->host_pat = '!^/!';
	}
	$this->wp_plugin_url = preg_replace($this->wpurl_pat, '', $this->parent->get('plugin_url'));
	
	$relative_url = array('^(\./|[-a-zA-Z0-9_.+=%~]+(/|$))');
	$leave_schemes = apply_filters('leave_scheme/ktai_style.php', array('tel:', 'tel-av:', 'vtel:', 'mailto:', 'device:', 'location:'));
	$leave_sites = preg_split('/\\s+/', ks_option('ks_treat_as_internal'), -1, PREG_SPLIT_NO_EMPTY);
	$this->scheme_pat = '!^(#|' . implode('|', $leave_schemes) . ')!';
	$this->leave_pat = '!^(#|' . implode('|', array_merge($relative_url,$leave_schemes, array_map('preg_quote', $leave_sites))) . ')!';
	$this->mobile_pat = '!^(' . implode('|', apply_filters('mobile_same_url/ktai_style.php', self::$mobile_same_url)) . ')!';
	$this->none_mobile_pat = '!^(' . implode('|', apply_filters('none_mobile_url/ktai_style.php', self::$none_mobile_url)) . ')!';
	$this->image_services = apply_filters('image_services/ktai_style.php', array(
		'^https?://[-\w.]+\.flickr.com/' => array($this, 'get_thumbnail_flickr'),
	));
	$this->image_services_pat = '!^(' . implode('|', array_keys($this->image_services)) . ')!';

	add_filter('attribute_escape', array($this, 'attribute_escape_filter'), 90, 2);
	add_filter('the_title', array($this, 'shrink_title'), 90);
	add_filter('the_content', array($this, 'shrink_content'), 90);
	remove_filter('get_the_excerpt', 'wp_trim_excerpt');
	add_filter('get_the_excerpt',  array($this, 'post_excerpt'), 9);
	add_filter('get_comment_excerpt', array($this, 'comment_excerpt'), 90);
	add_filter('get_comment_text', array($this, 'shrink_content'), 90);
	if (! defined('KS_ADMIN_MODE') || ! KS_ADMIN_MODE) {
		add_filter('post_link', array($this->parent, 'strip_host'), 90);
		add_filter('page_link', array($this->parent, 'strip_host'), 90);
		add_filter('attachment_link', array($this->parent, 'strip_host'), 90);
		add_filter('year_link', array($this->parent, 'strip_host'), 90);
		add_filter('month_link', array($this->parent, 'strip_host'), 90);
		add_filter('day_link', array($this->parent, 'strip_host'), 90);
		add_filter('category_link', array($this->parent, 'strip_host'), 90);
		add_filter('list_cats', array($this->parent, 'strip_host'), 90);
		add_filter('tag_link', array($this->parent, 'strip_host'), 90);
	}
	add_filter('redirect_canonical', array($this, 'complete_url'), 10, 2);
	add_filter('wp_generate_tag_cloud', array($this, 'shrink_tag_cloud'), 90, 3);
	add_filter('wp_dropdown_pages',  array($this, 'shrink_dropdown'), 90, 3);
	add_filter('comment_reply_link', array($this, 'fix_comment_reply_link'), 10, 4);
	add_filter('get_comments_pagenum_link', array($this, 'fix_comments_pagenum_link'));
	add_filter('split_page/ktai_style.php', array($this, 'add_url_inline_image'), 7);
	add_filter('split_page/ktai_style.php', array($this, 'split_page'), 9, 2);
	add_filter('split_page/ktai_style.php', array($this, 'trim_images'), 20);
	return;
}

// ==================================================
public function get($key) {
	return isset($this->$key) ? $this->$key : NULL;
}

// ==================================================
public function added_image() {
	return ++$this->num_image;
}

// ==================================================
public function has_inline_images() {
	return $this->num_image;
}

/* ==================================================
 * @param	string  $safe_text
 * @param	string  $text
 * @return	string  $safe_text
 */
public function attribute_escape_filter($safe_text, $text) {
	return str_replace('&#038;', '&amp;', $safe_text);
}

/* ==================================================
 * @param	string  $url
 * @return	string  $url
 */
public function complete_url($redirect_url, $requested_url) {
	if (preg_match('!^://!', $redirect_url)) {
		$request = @parse_url($requested_url);
		$redirect_url = $request['scheme'] . $redirect_url;
	} elseif (preg_match('!^/!', $redirect_url) && preg_match('!^(https?://[^/]*)!', $requested_url, $request)) {
		$redirect_url = $request[1] . $redirect_url;
	}
	return $redirect_url;
}

/* ==================================================
 * @param	string  $title
 * @return	string  $title
 */
public function shrink_title($title) {
	$phrase[0]     = str_replace('%s', '', __('Protected: %s'));
	$phrase_pat[0] = '/^' . str_replace('%s', '(.*)', preg_quote(__('Protected: %s'), '/')) . '$/';
	$icon[0]       = str_replace('%s', '$1', __('Protected: %s'));
	$icon[0]       = str_replace($phrase[0], '<img localsrc="501" alt="' . $phrase[0] . '" />', $icon[0]);
	$phrase[1]     = str_replace('%s', '', __('Private: %s'));
	$phrase_pat[1] = '/^' . str_replace('%s', '(.*)', preg_quote(__('Private: %s'), '/')) . '$/';
	$icon[1]       = str_replace('%s', '$1', __('Private: %s'));
	$icon[1]       = str_replace($phrase[1], '<img localsrc="279" alt="' . $phrase[1] . '" />', $icon[1]);
	return preg_replace($phrase_pat, $icon, $title);
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function convert_links($content) {
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)>(.*?)</a>!s', $content, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig      = $l[0][0];
		$offset    = $l[0][1];
		$attr      = $l[1][0];
		$label     = $l[2][0];
		$link_html = $label; // default is stripping links
		$replace   = $orig;
		if (! preg_match('/href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/s', $attr, $h)) {
			continue;
		}
		$q    = $h[1];
		$href = $h[2];
		preg_match('/class=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/s', $attr, $class);
		if (preg_match('!<img [^>]*?src=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1[^>]*? ?/?>!s', $label, $image)) {
			$src = $image[2];
			if (preg_match('!' . preg_quote($this->wp_plugin_url, '!') . '!', $src)) { // skip plug-in's icon
				continue; // leave links
			} elseif (ks_is_image_inline() && preg_match($this->image_services_pat, $href) && preg_match($this->image_services_pat, $src)) {
				foreach ($this->image_services as $pat => $callback) {
					if (preg_match('!' . $pat . '!', $src)) {
						$href = call_user_func($callback, $src, $href);
						break;
					}
				}
				$link_html = str_replace($h[0], 'href=' . $q . $href . $q, $orig); // leave image services URL (Flickr etc)
			} elseif (preg_match($this->wpurl_pat, $href) && preg_match($this->wpurl_pat, $src)) { // both internal link
				$path = preg_replace($this->wpurl_pat, $this->basepath, $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					if (ks_is_image_inline() && $imagesize && $imagesize <= min($this->parent->get('cache_size'), KS_DIRECT_LINK_IMAGE_SIZE)) {
						$link_html = $orig; // link to image
					} else {
						$thumbnail = str_replace('<img ', '<img has_orig="true" ', $label); // inform existance of original to images_to_link()
						$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to images_to_link()
					}
				} else { // internal link to other than images
					$link_html = $label . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} elseif (preg_match($this->host_pat, $href) && preg_match($this->host_pat, $src) && $_SERVER['DOCUMENT_ROOT']) { // both in-host link
				$path = preg_replace($this->host_pat, $_SERVER['DOCUMENT_ROOT'] . '/', $href);
				if (! is_dir($path) && $imagesize = @filesize($path)) { // a thumbnail linked to original image
					$thumbnail = str_replace('<img ', '<img has_orig="true" ', $label); // inform existance of original to images_to_link()
					$link_html = $thumbnail . '<img src="' . $href . '" alt="' . sprintf(__('Original(%dKB)', 'ktai_style'), intval($imagesize / 1024)) . '" filesize="' . $imagesize . '"/>'; // pass filesize to images_to_link()
				} else { // internal link to other than images
					$link_html = $label . '(<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>)';
				}
			} else { // external link
				$link_html = $this->rewrite_link($href, __('Link Target', 'ktai_style'), $class);
				if (is_null($link_html)) {
					$link_html = '<a href="' . $href . '">' . __('Link Target', 'ktai_style') . '</a>';
				}
				$link_html = "{$label}($link_html)";
			}
		} else {
			$link_html = $this->rewrite_link($href, $label, $class);
		}
		$replace = apply_filters('convert_links/ktai_style.php', $link_html, $orig, $href, $label);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig)); // convert links
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param   string  $href
 * @param	string  $label
 * @param	string  $class
 * @return	string  $link_html
 */
public function rewrite_link($href, $label, $class) {
	$clipped = preg_replace($this->internal_pat, $this->short_links, $href, 1, $is_internal);
	$leave_pat = ks_is_loggedin() ? $this->scheme_pat : $this->leave_pat;
	if ($is_internal) {
		$link_html = '<a href="' . $clipped . '">' . $label . '</a>';
	} elseif (preg_match($this->short_int_pat, $href) 
	       || preg_match($leave_pat, $href)) {
		$link_html = NULL; // leave links
	} else {
		$icon = '<img localsrc="70" alt="' . __('[external]', 'ktai_style') . '" />';
		$nonce = $this->parent->create_anon_nonce('redir_' . md5($href) . md5($_SERVER['HTTP_USER_AGENT']));
		if (preg_match('/(^| )' . preg_quote(KS_PCONLY_SITE_CLASS, '/') . '( |$)/', $class[2]) || $this->none_mobile_sites($href)) {
			$pconly_html = '&amp;' . KS_PCONLY_SITE_CLASS . '=true';
		} else {
			$pconly_html = '';
		}
		$redir_link = '<a href="' . ks_plugin_url(false) . sprintf(KS_REDIR_URL, attribute_escape($nonce) . $pconly_html, rawurlencode($href)) . '">';
		$direct_link = '<a href="' . attribute_escape($href) . '">';
		$colored_label = '<font color="' . ks_option('ks_external_link_color') . '">' . $label . '</font></a>';
		if (ks_is_loggedin()) {
			$link_html = $icon . $redir_link . $colored_label;
		} elseif (preg_match('/(^| )' . preg_quote(KS_KTAI_SITE_CLASS, '/') . '( |$)/', $class[2]) || $this->has_mobile_sites($href)) {
			$link_html = $direct_link . $label . '</a>';
		} elseif ($this->parent->get('use_redir')) {
			$link_html = $icon . $redir_link . $colored_label;
		} else {
			$link_html = $direct_link . $colored_label;
		}
		$link_html = apply_filters('external_link/ktai_style.php', $link_html, $href, $label, $icon);
	}
	return $link_html;
}

// ==================================================
private function has_mobile_sites($url) {
	if (preg_match($this->none_mobile_pat, $url)) {
		return false;
	}
	return preg_match($this->mobile_pat, $url);
}

// ==================================================
private function none_mobile_sites($url) {
	return preg_match($this->none_mobile_pat, $url);
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function convert_images($content) {
	for ($offset = 0, $replace = 'X'; 
	     preg_match('!<img ([^>]*?)src=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?) ?/?>!s', $content, $img, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $img[0][0];
		$offset  = $img[0][1];
		$q       = $img[2][0];
		$src     = $img[3][0];
		$attr    = $img[1][0] . $img[5][0];
		$replace = $orig;
		if (preg_match('/local$/', $img[1][0])) { // ezweb pict chars
			continue;
		}
		list($replace, $has_image) = $this->image_to_link($orig, $src, $q, $attr);
		$replace = apply_filters('image_to_link/ktai_style.php', $replace, $orig, $src);
		if (! is_null($replace)) {
			$content = substr_replace($content, $replace, $offset, strlen($orig));
			if ($has_image) {
				$this->added_image();
			}
		} else {
			$offset += strlen($orig);
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $html
 * @param	string  $src
 * @param	string  $q
 * @param	string  $attr
 * @return	string  $replace
 * @return	boolean $has_image
 */
private function image_to_link($html, $src, $q, $attr) {
	$replace = $html;
	$has_image = false;
	$has_class = preg_match('/class=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/s', $attr, $class);
	if (preg_match('/alt=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/s', $attr, $a)) {
		$alt = stripslashes($a[2]);
		if (empty($alt) && (! $has_class || ! preg_match('/(^| )(wp-image-\d+)( |$)/', $class[2]))) {
			$replace = ''; // hide images if the alt string is empty. 
			return array($replace, $has_image);
		}
	} else {
		$alt = NULL;
	}
	if (empty($alt)) {
		if (preg_match('/title=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1/s', $attr, $title)) {
			$alt = stripslashes($title[2]);
		} else {
			$url = parse_url($src);
			$alt = basename($url['path']);
		}
	}
	if (preg_match('/(width|height)=(([\'"])1\\3|1\b)/s', $attr)) {
		$replace = ''; // hide 1 pixel width/height images.
	} elseif ($has_class && preg_match('/(^| )(wp-smiley|' . preg_quote(KS_KTAI_SITE_CLASS) . ')( |$)/', $class[2])) {
		$short_src = preg_replace($this->host_pat, '/', $src);
		$replace = '<img src=' . $q . $short_src . $q . ' alt="' . addslashes($alt) . '" class="' . $class[2] . '" />';
	} elseif (preg_match('!' . preg_quote($this->wp_plugin_url, '!') . '!', $src)) { // plug-in's icon or what
		if ($this->parent->get('show_plugin_icon')) {
			$has_image = true;
			$replace = ks_is_image_inline() ? preg_replace('!(src=[\'"])https?://[^/]*!', '$1', $html) : "[$alt]"; // strip host
		} else {
			$replace = "[$alt]";
		}
	} elseif (preg_match('/filesize="(\d*)"/', $attr, $filesize)) { // original image for thumbnail passed by convert_links()
		$cache_size = $this->parent->get('cache_size');
		if ($filesize[1] && $cache_size > 0 && $filesize[1] > $cache_size) {
			$replace = '<font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>]';
		} else {
			$replace = '<a href=' . $q . $src . $q . '>' . $alt . '</a>]';
		}

	} else {
		if (preg_match($this->wpurl_pat, $src)) {
			list($thumb_path, $thumb_url, $img_path) = $this->check_thumbnail($src, $this->wpurl_pat, $this->basepath, $this->wpurl);
		} elseif (preg_match($this->host_pat, $src) && $_SERVER['DOCUMENT_ROOT']) {
			list($thumb_path, $thumb_url, $img_path) = $this->check_thumbnail($src, $this->host_pat, $_SERVER['DOCUMENT_ROOT'] . '/', '/');
		} else {
			list($thumb_path, $thumb_url, $img_path) = array(NULL, NULL, NULL);
			foreach ($this->image_services as $pat => $callback) {
				if (preg_match('!' . $pat . '!', $src)) {
					$thumb_url = $src = call_user_func($callback, $src);
					$has_image = true;
					break;
				}
			}
		}
		if (defined('KS_SHRINKAGE_DEBUG') && is_ks_error($thumb_path)) {
			$replace = '[[' . $thumb_path->getMessage() . ']]';
		} elseif (ks_is_image_inline() && $thumb_url) {
			$replace = '<img src="' . $thumb_url . '" alt="' . $alt . '" />';
			$replace .= preg_match('/has_orig="true"/', $attr) ? '[' : '';
			$has_image = true;
		} else {
			$replace = '[<img localsrc="94" alt="' . __('IMAGE:', 'ktai_style') . '" />';
			if (! $img_path) { // link to a image of external sites
				$replace .= '<a href=' . $q . $src . $q . '>' . $alt . '</a>';
			} elseif (! is_dir($img_path) && $size = @filesize($img_path) && $size <= $this->parent->get('cache_size')) { // link to the image
				$replace .= '<a href=' . $q . $src . $q . '>' . $alt . '</a>';
				$has_image = ! is_ks_error($thumb_path);
			} elseif ($thumb_path && $thumb_url) { // link to a thumbnail
				$replace .= '<a href=' . $q . $thumb_url . $q . '>' . $alt . '</a>';
				$has_image = ! is_ks_error($thumb_path);
			} else { // no link to images
				$replace .= '<font color="' . KS_SIZE_EXCEED_COLOR . '">' . $alt . '</font>';
			}
			$replace .= preg_match('/has_orig="true"/', $attr) ? ' | ' : ']';
		}
	}
	return array($replace, $has_image);
}

/* ==================================================
 * @param	string  $img_src
 * @param	string  $url_pat
 * @param	string  $path_prefix
 * @param	string  $short_url
 * @return	string  $thumb_path
 * @return	string  $thum_burl
 * @return	string  $img_path
 */
private function check_thumbnail($img_src, $url_pat, $path_prefix, $short_url) {
	$img_path = preg_replace($url_pat, $path_prefix, $img_src);
	$thumb_path = $this->get_thumbnail($img_path);
	if (is_ks_error($thumb_path)) {
		return array($thumb_path, NULL, $img_path);
	}
	$thumb_url = preg_replace('!^' . preg_quote($path_prefix, '!') . '!', $short_url, $thumb_path);
	return array($thumb_path, $thumb_url, $img_path);
}

/* ==================================================
 * @param	string  $path
 * @return	string  $thumb
 */
public function get_thumbnail($path) {
	if (! preg_match('!^(cropped-)?(.*?)(\.thumbnail|-\d+x\d+)?(\.[^.]+)?$!', basename($path), $file)) {
		return false;
	}
	$base = $file[2];
	$ext = isset($file[4]) ? $file[4] : '';
	$orig = dirname($path) . '/' . $base . $ext;
	if (isset($file[3]) && file_exists($orig)) {		
		$target = $orig; // Use the original image to make a smaller thumbnail.
		$result = $this->create_alter_image($path, false);
		if (defined('KS_SHRINKAGE_DEBUG') && is_ks_error($result)) {
			return $result;
		}
	} else {
		$target = $path;
	}
	$thumb = dirname($path) . '/' . $base . KS_THUMBNAIL_FILENAME . $ext;
	if (! file_exists($thumb)) {
		$thumb = $this->create_thumbnail($target, $thumb);
	}
	return $thumb;
}

/* ==================================================
 * @param	string  $img_path
 * @param	string  $thumb_path
 * @return	mix     $result
 */
private function create_thumbnail($img_path, $thumb_path) {
	$size = $this->create_alter_image($img_path, true);
	if (is_ks_error($size)) {
		return $size;
	}
	try {
		$width  = $size[0];
		$height = $size[1];
		$type   = $size[2];
		$image  = $size['image'];
		if ($width <= KS_THUMBNAIL_MAX_SIZE && $height <= KS_THUMBNAIL_MAX_SIZE) { // No need to make thumbnail
			return $img_path;
		}
		if ($width > $height) {
			$image_ratio = $width / KS_THUMBNAIL_MAX_SIZE;
			$new_width  = KS_THUMBNAIL_MAX_SIZE;
			$new_height = $height / $image_ratio;
		} else {
			$image_ratio = $height / KS_THUMBNAIL_MAX_SIZE;
			$new_height = KS_THUMBNAIL_MAX_SIZE;
			$new_width = $width / $image_ratio;
		}
		$thumbnail = @imagecreatetruecolor($new_width, $new_height);
		if (! $thumbnail) {
			throw new KS_Error('Cannot initialize for thumbnail');
		}
		if (function_exists('imageantialias')) {
			imageantialias($thumbnail, true);
		}
		if (! imagecopyresampled($thumbnail, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height)) {
			throw new KS_Error('Resample failed');
		}
	
		// move the thumbnail to it's final destination
		$other_path = NULL;
		$result_other = NULL;
		switch ($type) {
		case IMAGETYPE_GIF:
			$result = @imagegif($thumbnail, $thumb_path);
			if ($result) {
				$other_path = preg_replace('|\.gif$|i', '.png', $thumb_path);
				$result_other = @imagepng($thumbnail, $other_path);
			}
			break;
		case IMAGETYPE_PNG:
			$result = @imagepng($thumbnail, $thumb_path);
			if ($result) {
				$other_path = preg_replace('|\.png$|i', '.gif', $thumb_path);
				$result_other = @imagegif($thumbnail, $other_path);
			}
			break;
		case IMAGETYPE_JPEG:
		default:
			$result = @imagejpeg($thumbnail, $thumb_path);
		break;
		}
		imagedestroy($thumbnail);
		if (! $result || ! file_exists($thumb_path)) {
			throw new KS_Error('Thumbnail file not written');
		}
		chmod($thumb_path, 0646);
		if ($other_path && $result_other) {
			chmod($other_path, 0646);
		}
		return $thumb_path;
	
	} catch (KS_Error $e) {
		return $e;
	}
}

/* ==================================================
 * @param	string   $img_path
 * @param	boolean  $return_image
 * @return	resource $image
 */
private function create_alter_image($img_path, $return_image = true) {
	try {
		if (! function_exists('imagecreatetruecolor')) {
			throw new KS_Error('GD not available');
		}
		if (empty($img_path)) {
			throw new KS_Error('No file name');
		}
		if (! file_exists($img_path)) {
			throw new KS_Error('No such a file:' . $img_path);
		}		
		$size = getimagesize($img_path);
		if (! $size) {
			throw new KS_Error('Cannot access to image:' . $img_path);
		}
		$width  = $size[0];
		$height = $size[1];
		$type   = $size[2];
		if ($width <= 0 || $height <= 0) {
			throw new KS_Error('Zero size image');
		}
		$other_path = NULL;
		$result = NULL;
		switch ($type) {
		case IMAGETYPE_GIF:
			$image = imagecreatefromgif($img_path);
			$other_path = preg_replace('|\.gif$|i', '.png', $img_path);
			if ($image && ! file_exists($other_path)) {
				$result = @imagepng($image, $other_path);
			}
			break;
		case IMAGETYPE_PNG:
			$image = imagecreatefrompng($img_path);
			$other_path = preg_replace('|\.png$|i', '.gif', $img_path);
			if ($image && ! file_exists($other_path)) {
				$result = @imagegif($image, $other_path);
			}
			break;
		case IMAGETYPE_JPEG:
			if ($return_image) {
				$image = imagecreatefromjpeg($img_path);
			}
			break;
		default:
			throw new KS_Error(sprintf('Can\'t handle image type "%1$s" of file: %2$s', $size['mime'], $img_path));
			break;
		}
		if ($return_image && ! $image) {
			throw new KS_Error('Invalid image file: ' . $img_path);
		}
		if ($other_path && $result) {
			chmod($other_path, 0646);
		}
		if ($result === false) {
			throw new KS_Error('Cannot write PNG/GIF image: ' . $other_path);
		}
		if ($return_image) {
			$size['image'] = $image;
			return $size;
		} else {
			return $result;
		}

	} catch (KS_Error $e) {
		return $e;
	}
}

/* ==================================================
 * @param	string  $img_src
 * @param	string  $img_href
 * @return	string  $thumb_url
 */
public function get_thumbnail_flickr($img_src, $img_href = '') {
	if ($img_href) {
		$thumb_url = preg_replace('!(/\d+_[0-9a-z]+)(_[stmb])?(\.jpg)$!', '$1_m$3', $img_src);
	} else {
		$thumb_url = preg_replace('!(/\d+_[0-9a-z]+)(_[stmb])?(\.jpg)$!', '$1_t$3', $img_src);
	}
	return $thumb_url;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function strip_styles_scripts($buffer) {
	$buffer = preg_replace('!<(script|style)[^>]*>.*?</\\1>!s', '', $buffer);
	$buffer = preg_replace('|<!--.*?-->|', '', $buffer);
	return $buffer;
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function shrink_content($content) {
	if ($this->skip_shrink_content != true) {
		$content = preg_replace('!<del[^>]*>.*?</del>!s', '', $content);
		$content = $this->strip_styles_scripts($content);
		$content = $this->parent->filter_tags($content);
		$content = $this->convert_links($content);
		$content = $this->convert_images($content);
	}
	return $content;
}

/* ==================================================
 * @param	string  $text
 * @param	string  $text
 */
public function trim_excerpt($text) {
	$text = $this->parent->filter_tags($text);
	$text = preg_replace('!<del[^>]*>.*?</del>!s', '', $text);
	$text = str_replace(']]>', ']]&gt;', $text);
	$text = strip_tags($text, '<img>');
	$text = preg_replace('!<img ([^>]+?)(localsrc="\w+")?([^>]+?)>!e', '"$2" ? "<img $2 />" : ""', $text);
	$len = apply_filters('excerpt_length', KS_EXCERPT_LENGTH);
	if (strlen($text) > $len) {
		$text = ks_cut_html($text, $len, 0) . '...';
	}
	return $text;
}

/* ==================================================
 * @param	string  $text
 * @param	string  $text
 * Based on wp_trim_excerpt at formatting.php of WP 2.5
 */
public function post_excerpt($text) { // Fakes an excerpt if needed
	if ( '' == $text ) {
		$text = get_the_content('');
		if (function_exists('strip_shortcodes')) {
			$text = strip_shortcodes($text);
		}
		$this->skip_shrink_content = true;
		$text = apply_filters('the_content', $text);
		$this->skip_shrink_content = false;
		$text = $this->trim_excerpt($text);
	}
	return $text;
}

/* ==================================================
 * @param	string  $excerpt
 * @return	string  $excerpt
 */
public function comment_excerpt($excerpt) {
	global $comment;
	return $this->trim_excerpt($comment->comment_content);
}

/* ==================================================
 * @param	string  $buffer
 * @param	int     $page_num
 * @return	string  $paged_content
 */
public function split_page($buffer, $page_num) {
	if ($page_num > KS_MAX_PAGE_NUM) {
		$page_num = KS_MAX_PAGE_NUM;
	} elseif ($page_num < 1) {
		$page_num = 1;
	}
	list($header, $buffer, $footer, $sep) = $this->separate_buffer($buffer);

	$buffer = preg_replace('/>[ \t]*\n+[ \t]*</', '><', $buffer);
	if (preg_match('/<input type="hidden" name="post_password" value="(.*?)"/s', $buffer, $match)) {
		$post_password = $match[1];
	} else {
		$post_password = '';
	}
	list($navi, $del_accesskey) = $this->get_split_page_navi(KS_MAX_PAGE_NUM +1 ,true, $post_password);
	$page_size = $this->parent->get('page_size') - strlen($header . $navi . '<hr /><hr />' . $navi . $footer) - 32; // 32-byte is space for adding tags by force_balance_tags()
	if ($page_size < 256) { // too small
		if (preg_match('@<body[^>]*>@s', $header, $s, PREG_OFFSET_CAPTURE)) {
			$move2body = substr_replace($header, '', 0, $s[0][1] + strlen($s[0][0]));
			$header = substr_replace($header, '', $s[0][1] + strlen($s[0][0]));
		} else {
			$move2body = $header;
			$header = '';
		}
		$buffer = $move2body . $buffer . $footer;
		$footer = '';
		$page_size = $this->parent->get('page_size') - strlen($header . $navi . '<hr /><hr />' . $navi . $footer) - 32;
	}

	$start_tags = '';
	$terminator = '<!--KS_TERMINATOR_' . md5(uniqid()) . '-->';
	$marker = 0;
	$buffer_length = strlen($buffer);
	for ($count = 0 ; $count < $page_num ; $count++) {
		$fragment = ks_cut_html($buffer, $page_size, $marker, $this->parent->get('charset'));
		$fragment = preg_replace('/\x1b\$[GEFOPQ]?$/', '', $fragment);
		if (preg_match('/(\x1b\$[GEFOPQ])[!-z]+$/', $fragment, $pict_sequence)) {
			$complemention = "\x0f"; // complete softbank pictgram shift-in
		} else {
			$complemention = '';
		}
		$quoted = str_replace(array("<\x0f", ">\x0f"), array("&lt;\x0f", "&gt;\x0f"), $start_tags . $fragment . $terminator); // protect softbank pictograms
		$balanced = force_balance_tags($quoted);
		preg_match("/$terminator(.*)\$/", $balanced, $added_html);
		$complemented = preg_replace('/\x1b\$[GEFOPQ]?\x1b/', '', $start_tags . $fragment . $complemention . @$added_html[1]);
		if (preg_match_all('!</([^<>]*)>!', @$added_html[1], $added_tags)) {
			$start_tags = '<' . implode('><', array_reverse($added_tags[1])) . '>'; // store complemented tags to next fragment
			if (strpos($start_tags, '<ol>') !== false) {
				$start_tags = $this->detect_nesting_list($balanced, $start_tags);
			}
			$start_tags .= (isset($pict_sequence[1]) ? $pict_sequence[1] : '');
		} else {
			$start_tags = (isset($pict_sequence[1]) ? $pict_sequence[1] : '');
		}
		$marker += strlen($fragment);
		if ($marker >= $buffer_length) {
			$count++;
			break;
		}
	}

	if (strlen($fragment) < $buffer_length && isset($added_html[1])) {
		list($navi, $del_accesskey) = $this->get_split_page_navi($count, ($marker +1 < $buffer_length), $post_password);
		if ($del_accesskey) { // delete redundant access keys
			$complemented = preg_replace('/(<(a|label)[^>]*?) accesskey="[' . $del_accesskey . ']"([^>]*?)>/', '$1$3>', $complemented);
		}
		return $header . 
			$sep['start']['before'] . $navi . $sep['start']['after'] . 
			$complemented . 
			$sep['end']['before']   . $navi . $sep['end']['after'] . 
			$footer;
	} else {
		return $header . $buffer . $footer;
	}
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
private function separate_buffer($buffer) {
	$sep = array(
		'start' => array('before' => '', 'after' => '<hr />'),
		'end'   => array('before' => '<hr />', 'after' => ''),
	);
	if (preg_match(KS_START_PAGING_PAT, $buffer, $s, PREG_OFFSET_CAPTURE)) {
		$header = substr_replace($buffer, '', $s[0][1]);
		$buffer = substr_replace($buffer, '', 0, $s[0][1] + strlen($s[0][0]));
		if (isset($s[1])) {
			list($before, $after) = explode(',', $s[2][0]);
			$sep['start']['before'] = strpos($s[2][0], ',') !== false ? $before : '';
			$sep['start']['after']  = strpos($s[2][0], ',') !== false ? $after : $before;
		}
	} elseif (preg_match('@<body[^>]*>@s', $buffer, $s, PREG_OFFSET_CAPTURE)) {
		$header = substr_replace($buffer, '', $s[0][1] + strlen($s[0][0]));
		$buffer = substr_replace($buffer, '', 0, $s[0][1] + strlen($s[0][0]));
	} else {
		$header = '';
	}
	if ($num_match = preg_match_all(KS_END_PAGING_PAT, $buffer, $s, PREG_OFFSET_CAPTURE | PREG_SET_ORDER)) {
		$s = $s[$num_match -1];
		$footer = substr_replace($buffer, '', 0, $s[0][1] + strlen($s[0][0]));
		$buffer = substr_replace($buffer, '', $s[0][1]);
		if (isset($s[1])) {
			list($before, $after) = explode(',', $s[2][0]);
			$sep['end']['before'] = $before;
			$sep['end']['after']  = $after;
		}
	} else {
		if (preg_match('!<hr [^/>]*/>\s*(<div>\s*)?<a (id|name)="tail"!s', $buffer, $s, PREG_OFFSET_CAPTURE)) {
			$footer = substr_replace($buffer, '', 0, $s[0][1]);
			$buffer = substr_replace($buffer, '', $s[0][1]);
		} else {
			list($buffer, $footer) = preg_split('@</body@', $buffer, 2);
			$footer = '</body' . $footer;
		}
	}

	return array($header, $buffer, $footer, $sep);
}

/* ==================================================
 * @param	int     $num
 * @param	boolean $rest
 * @param	string  $post_password
 * @return	string  $navi
 * @return	int     $page_num
 */
private function get_split_page_navi($num, $rest, $post_password) {
	$link = htmlspecialchars(remove_query_arg('kp', $_SERVER['REQUEST_URI']), ENT_QUOTES);
	$link .= (strpos($link, '?') === false) ? '?kp=': '&amp;kp=';
	$del_accesskey = '';
	if ($num == 2) {
		$prev = _ks_internal_link(preg_replace('/(\?|&(amp;)?)kp=/', '', $link), '*', '', __('*.Prev', 'ktai_style'), $post_password) . ' | ';
		$del_accesskey .= '*';
	} elseif ($num >= 3) {
		$prev = _ks_internal_link($link . intval($num -1), '*', '', __('*.Prev', 'ktai_style'), $post_password) . ' | ';
		$del_accesskey .= '*';
	} else {
		$prev = '';
	}
	if ($rest) {
		$next = ' | ' . _ks_internal_link($link . intval($num +1), '#', '', __('#.Next', 'ktai_style'), $post_password);
		$del_accesskey .= '#';
	} else {
		$next = '';
	}
	$navi = sprintf(__('<div align="center">Splitting the page for mobile: %1$s page #%2$d %3$s</div>', 'ktai_style'), $prev, $num, $next);
	$navi = apply_filters('split_page_navi/ktai_style.php', $navi, $prev, $num, $next);
	if (function_exists('mb_convert_encoding')) {
		$navi = mb_convert_encoding($navi, $this->parent->get('charset'), get_bloginfo('charset'));
	}
	return array($navi, $del_accesskey);
}

/* ==================================================
 * @param	string  $balanced
 * @param	string  $start_tags
 * @return	string  $start_tags
 */
private function detect_nesting_list($balanced, $start_tags) {
	preg_match_all('!</?[ou]l([^>]*)>!s', $balanced, $lists, PREG_OFFSET_CAPTURE);
	$open[0] = '<ol>';
	do {
		$close = array_pop($lists[0]);
	} while (strpos($close, '</ol>') !== false);
	$max_ol_level = preg_match_all('/<ol>/', $start_tags, $ol);
	for ($ol_level = 0 ; $ol_level < $max_ol_level ; $ol_level++) {
		$inside[$ol_level][0] = array('start' => strlen($close[0]), 'end' => $close[1]);
	}
	$level = 0;
	$ol_level = 0;
	$below_level[$ol_level] = $level +1;
	$entered[$ol_level] = 1; // to make sure
	foreach (array_reverse($lists[0]) as $l) {
		if (strpos($l[0], '</') !== false) {
			$level++;
			if ($level == $below_level[$ol_level]) {
				$inside[$ol_level][0]['start'] = $l[1] + strlen($l[0]);
			}
			if (strpos($l[0], '</ol>') !== false && $ol_level < $max_ol_level -1 && ! isset($entered[$ol_level +1])) {
				$ol_level++;
				$below_level[$ol_level] = $level +1;
				$inside[$ol_level][0]['end'] = $l[1];
				$entered[$ol_level] = 1;
			}
		} elseif ($level <= 0) {
			$open[0] = $l[0];
			$inside[$ol_level][0]['start'] = $l[1] + strlen($l[0]);
			break;
		} else {
			if (strpos($l[0], '<ol') !== false && $level < $below_level[$ol_level] && @$entered[$ol_level] == 1) {
				$open[$ol_level] = $l[0];
				$inside[$ol_level][0]['start'] = $l[1] + strlen($l[0]);
				$entered[$ol_level] = 2;
				$ol_level--;
			}
			if ($level == $below_level[$ol_level]) {
				array_unshift($inside[$ol_level], array('end' => $l[1]));
			}
			$level--;
		}
	}
	for ($ol_level = 0 ; $ol_level < $max_ol_level ; $ol_level++) {
		if (preg_match('/start=[\'"](\d+)[\'"]/', $open[$ol_level], $start)) {
			$start_num = intval(@$start[1]);
		} else {
			$start_num = 1;
		}
		$inside_html = '';
		foreach ($inside[$ol_level] as $offset) {
			$inside_html .= substr($balanced, $offset['start'], $offset['end'] - $offset['start']);
		}
		$start_num += preg_match_all('/<li>/', $inside_html, $items);
		$ol_pos = strpos($start_tags, '<ol>'); // should be matched
		if (strpos($start_tags, '<li>', $ol_pos) == $ol_pos + 4) {
			$start_num -= 1; // use same number for splited item
		}
		if ($start_num > 1) {
			$start_html = ' start="' . $start_num . '"';
		} else {
			$start_html = ' start="1"';
		}
		preg_match('/\stype=[\'"][^\'"]+[\'"]/', $open[$ol_level], $type);
		$start_tags = preg_replace('/<ol>/', '<ol' . $start_html . @$type[0] . '>', $start_tags, 1);
	}
	return str_replace(' start="1"', '', $start_tags);
}

/* ==================================================
 * @param	string  $content
 * @return	string  $content
 */
public function trim_images($content) {
	if ($this->parent->get('cache_size') > 0) {
		$total_size = strlen($content);
		for ($offset = 0, $replace = 'X'; 
		     preg_match('!<img ([^>]*?)src=([\'"])([^\\\\>]*?(\\\\.[^\\2\\\\>]*?)*)\\2([^>]*?) ?/?>!s', $content, $i, PREG_OFFSET_CAPTURE, $offset); //"syntax highlighting fix
		     $offset += strlen($replace)) {
			$offset  = $i[0][1];
			$replace = $i[0][0];
			$src     = $i[3][0];
			$attr    = $i[1][0] . $i[5][0];
			if (preg_match($this->wpurl_pat, $src)) {
				$imagesize = @filesize(preg_replace($this->wpurl_pat, $this->basepath, $src));
				if ($imagesize) {
					$total_size += $imagesize;
				}
				if ($total_size > $this->parent->get('cache_size')) {
					if (preg_match('/alt=([\'"])([^\\\\>]*?(\\\\.[^\\1\\\\>]*?)*)\\1/s', $attr, $a)) { //"syntax highlighting fix
						$replace = $a[2];
					} else {
						$replace = basename($src);
					}
					$content = substr_replace($content, $replace, $offset, strlen($i[0][0]));
				}
			}
		}
	}
	return $content;
}

/* ==================================================
 * @param	string  $output
 * @return	string  $output
 */
public function shrink_dropdown($output) {
	$output = preg_replace(
		array('/ class=([\'"])[-_ \w]+\1/', '/[\r\n\t]/'),
		array('', ''),
		$output);
	$output = str_replace('&nbsp;', '-', $output);
	return $output;
}

/* ==================================================
 * @param	string  $content
 * @param	array   $tags
 * @param	array   $args
 * @return	string  $content
 */
public function shrink_tag_cloud($content, $tags, $args) {
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a href=([\'"])([^\\\\]*?(\\\\.[^\\1\\\\]*?)*)\\1([^>]*?)>(.*?)</a>!s', $content, $l, PREG_OFFSET_CAPTURE, $offset); 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[1][0];
		$href    = $l[2][0];
		$attr    = $l[4][0];
		$label   = $l[5][0];
		$replace = $orig;
		preg_match('/ style=([\'"])[^\\\\]*?(\\\\.[^\\1\\\\]*?)*\\1/s', $attr, $style);
		$replace = '<a href=' . $q . $href . $q . $style[0] . '>' . $label . '</a>';
		$content = substr_replace($content, $replace, $offset, strlen($orig));
	}
	return $content;
}

/* ==================================================
 * @param	string  $buffer
 * @return	string  $buffer
 */
public function add_url_inline_image($buffer) {
	if ($this->parent->ktai->get('image_inline_default') == $this->parent->ktai->get('image_inline')) {
		return $buffer;
	}
	$value = ks_is_image_inline() ? 'inline' : 'link';
	for ($offset = 0, $replace = 'X' ; 
	     preg_match('!<a ([^>]*?)href=([\'"])([^\\\\]*?(\\\\.[^\\2\\\\]*?)*)\\2([^>]*?)>!s', $buffer, $l, PREG_OFFSET_CAPTURE, $offset) ; 
	     $offset += strlen($replace))
	{
		$orig    = $l[0][0];
		$offset  = $l[0][1];
		$q       = $l[2][0];
		$href    = $l[3][0];
		$href    = _ks_quoted_remove_query_arg('img', $href);
		$attr1   = $l[1][0];
		$attr2   = $l[5][0];
		$replace = $orig;
		if (! preg_match($this->url_pat, $href) || preg_match($this->wpcontent_pat, $href) || preg_match('/id="inline"/', $attr1 . $attr2)) {
			continue;
		}
		$href .= (strpos($href, '?') === false ? '?' : '&amp;' ) . "img=$value";
		$replace = "<a {$attr1}href=$q$href$q$attr2>"; 
		$buffer = substr_replace($buffer, $replace, $offset, strlen($orig)); // convert links		
	}
	return $buffer;
}

/* ==================================================
 * @param	string  $link
 * @param	array   $args
 * @param	object  $comment
 * @param	object  $post
 * @return	none
 */
function fix_comment_reply_link($link, $args, $comment, $post) {
	if (strpos($link, 'wp-login.php?redirect_to=')) {
		$link = '<a href="' . ks_plugin_url(false) . 'login.php?redirect_to=' . urlencode(add_query_arg('replytocom', $comment->comment_ID, ks_comments_post_url($post->ID))) . '">' . $args['login_text'] . '</a>';
	} else {
		$co_post = add_query_arg('replytocom', $comment->comment_ID, ks_comments_post_url($post->ID));
		if ($post->post_password && ! ks_post_password_required($post)) {
			if (preg_match('!<img localsrc="\w+"[^>]*?>!s', $args['reply_text'], $icon)) {
				$icon = $icon[0];
				$reply_text = strip_tags($args['reply_text']);
			} else {
				$icon = '';
				$reply_text = strip_tags($args['reply_text']);
			}
			$link = _ks_internal_link($co_post, '', $icon, $reply_text, $post->post_password);
		} else {
			$link = '<a href="' . attribute_escape($co_post) . '">' . $args['reply_text'] . '</a>';

		}
	}
	return $args['before'] . $link . $args['after'];
}

/* ==================================================
 * @param	string  $result
 * @return	string  $result
 */
function fix_comments_pagenum_link($result) {
	$result = preg_replace('/#comments$/', '', $result);
	if (! preg_match('/(comment-page-\d+|cpage=\d+)/', $result)) {
		global $post;
		$result = ks_get_comments_list_link($post->ID);
	}
	return $result;
}

// ===== End of class ====================
}

if (! class_exists('KS_Error')) :
/* ==================================================
 *   KS_Error class
   ================================================== */

function is_ks_error($thing) {
	return (is_object($thing) && is_a($thing, 'KS_Error'));
}

class KS_Error extends Exception {

public function setCode($code) {
	$this->code = $code;
}

// ===== End of class ====================
}
endif;
?>