<?php
/*
Plugin Name: Simple Tweet
Version: 1.1.1
Plugin URI: http://wppluginsj.sourceforge.jp/simple-tweet/
Description: Simple Twitter Post
Author: wokamoto
Author URI: http://dogmap.jp/
Text Domain: simple_tweet
Domain Path: languages

License:
 Released under the GPL license
  http://www.gnu.org/copyleft/gpl.html

  Copyright 2008 - 2009 wokamoto (email : wokamoto1973@gmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/**************************************************************************************
 * Define
 *************************************************************************************/
define('TWEET_MAX', 140);
define('TWEET_TIMEOUT', 30);
define('TWEET_HOME_URL', 'http://twitter.com/' );
define('TWEET_SENT_URL', 'http://twitter.com/statuses/update.xml');
define('TWEET_TINYURL_URL', 'http://tinyurl.com/api-create.php?url=');
define('TWEET_TINYURL_LIMIT', 60 * 60 * 24 * 30 * 6);

define('TWEET_METAKEY_SID', 'twitter_id');
define('TWEET_METAKEY_URL', '_tiny_url');


/**************************************************************************************
 * Global
 *************************************************************************************/
global $simple_tweet;


/**************************************************************************************
 * Template Tag tweet_this_link
 *  usage : <?php if (function_exists('tweet_this_link')) tweet_this_link(); ?>
 *************************************************************************************/
function tweet_this_link($inreply_to = FALSE, $echo = TRUE) {
	global $simple_tweet;
	if ( !isset($simple_tweet) ) $simple_tweet = new SimpleTweetController();

	$tweet_this = $simple_tweet->TweetThisLink($inreply_to);
	if ( $tweet_this === FALSE )
		return;

	if ( $echo )
		echo $tweet_this;
	else
		return $tweet_this;
}

/**************************************************************************************
 * SimpleTweetController Class
 *************************************************************************************/
class SimpleTweetController {
	var $twitter_client_name = 'SimpleTweetWP';
	var $twitter_client_version = '1.1.1';
	var $twitter_client_url = 'http://dogmap.jp/';

	var $options;

	// Deafault Options
	var $options_default = array(
		'user' => '' ,
		'password' => '' ,
		'separator' => ' ' ,
		'tinyurl' => TRUE ,
		'tweet_text' => '' ,
		'tweet_without_url' => FALSE ,
		'add_content' => FALSE ,
		'tweet_this_link' => '' ,
		'tweet_this_text' => '' ,
		'log_write' => FALSE ,
		'activate' => 0 ,
		'deactivate' => 0 ,
		);

	// Common Variables
	var $plugin_dir, $plugin_file, $plugin_url;
	var $textdomain_name, $option_name;
	var $admin_option, $admin_action, $admin_hook;
	var $charset;
	var $note, $error;
	var $_log;

	//*****************************************************************************
	// Constructor
	//*****************************************************************************
	function SimpleTweetController() {
		$this->__construct();
	}
	function __construct() {
		$this->_init_variables();
		$this->_load_textdomain();

		$this->option_name = $this->twitter_client_name . " Options";
		$this->options = $this->_init_options($this->_get_options());
	}

	//*****************************************************************************
	// Common
	//*****************************************************************************

	// check wp version
	function _check_wp_version($version, $operator = ">=") {
		global $wp_version;
		return version_compare($wp_version, $version, $operator);
	}

	// init variables
	function _init_variables() {
		$this->charset = get_option('blog_charset');
		$this->_set_plugin_dir(__FILE__);
		$this->note = '';
		$this->error = 0;
	}

	// set plugin dir
	function _set_plugin_dir( $file = '' ) {
		$file_path = ( !empty($file) ? $file : __FILE__);
		$filename = explode("/", $file_path);
		if(count($filename) <= 1) $filename = explode("\\", $file_path);
		$this->plugin_dir  = $filename[count($filename) - 2];
		$this->plugin_file = $filename[count($filename) - 1];
		$this->plugin_url  = $this->_wp_plugin_url($this->plugin_dir);
		unset($filename);
	}

	// load textdomain
	function _load_textdomain( $sub_dir = 'languages' ) {
		$this->textdomain_name = $this->plugin_dir;
		$plugins_dir = trailingslashit(defined('PLUGINDIR') ? PLUGINDIR : 'wp-content/plugins');
		$abs_plugin_dir = $this->_wp_plugin_dir($this->plugin_dir);
		$sub_dir = ( !empty($sub_dir)
			? preg_replace('/^\//', '', $sub_dir)
			: (file_exists($abs_plugin_dir.'languages') ? 'languages' : (file_exists($abs_plugin_dir.'language') ? 'language' : (file_exists($abs_plugin_dir.'lang') ? 'lang' : '')))
			);
		$textdomain_dir = trailingslashit(trailingslashit($this->plugin_dir) . $sub_dir);

		if ( $this->_check_wp_version("2.6") && defined('WP_PLUGIN_DIR') )
			load_plugin_textdomain($this->textdomain_name, false, $textdomain_dir);
		else
			load_plugin_textdomain($this->textdomain_name, $plugins_dir . $textdomain_dir);
	}

	// Get Options
	function _get_options() {
		return get_option($this->option_name);
	}

	// Set Default Options
	function _set_default_options($options = '') {
		if (!is_array($options))
			$options = array();

		foreach ($this->options_default as $key => $val)
			$options[$key] = (isset($options[$key]) ? $options[$key] : $val);

		return $options;
	}

	// Handles Add/strips slashes to the given array
	function _strip_array($array) {
		if( !is_array($array) )
			return stripslashes($array);

		foreach($array as $key => $value)
			$slashed_array[$key] = ( !is_array($value)
				? stripslashes($value)
				: $this->_strip_array($value) );

		return $slashed_array;
	}

	// Make Nonce field
	function _make_nonce_field($action = -1, $name = "_wpnonce", $referer = true , $echo = true ) {
		return ( function_exists('wp_nonce_field')
			? wp_nonce_field($action, $name, $referer, $echo)
			: '' );
	}

	// Update Options
	function _update_options() {
		update_option($this->option_name, $this->options);
	}

	// Delete Options
	function _delete_options() {
		delete_option($this->option_name);
		$this->options = $this->_init_options(array());
	}

	// Get post_meta
	function _get_post_meta($post_id, $key) {
		return maybe_unserialize(get_post_meta($post_id, $key, true));
	}

	// Add or Update post_meta
	function _update_post_meta($post_id, $key, $val) {
		if (is_array($key)) $key = maybe_serialize($key);
		return (
			add_post_meta($post_id, $key, $val, true) or
			update_post_meta($post_id, $key, $val)
			);
	}

	// WP_CONTENT_DIR
	function _wp_content_dir($path = '') {
		return trailingslashit( trailingslashit( defined('WP_CONTENT_DIR')
			? WP_CONTENT_DIR
			: trailingslashit(ABSPATH) . 'wp-content'
			) . preg_replace('/^\//', '', $path) );
	}

	// WP_CONTENT_URL
	function _wp_content_url($path = '') {
		return trailingslashit( trailingslashit( defined('WP_CONTENT_URL')
			? WP_CONTENT_URL
			: trailingslashit(get_option('siteurl')) . 'wp-content'
			) . preg_replace('/^\//', '', $path) );
	}

	// WP_PLUGIN_DIR
	function _wp_plugin_dir($path = '') {
		return trailingslashit($this->_wp_content_dir( 'plugins/' . preg_replace('/^\//', '', $path) ));
	}

	// WP_PLUGIN_URL
	function _wp_plugin_url($path = '') {
		return trailingslashit($this->_wp_content_url( 'plugins/' . preg_replace('/^\//', '', $path) ));
	}

	// Add Option Page
	function _add_option_page($page_title, $function, $capability = 9, $menu_title = '', $file = '') {
		if ($menu_title == '') $menu_title = $page_title;
		if ($file == '') $file = $this->plugin_file;

		$this->admin_option = $file;
		$this->admin_action =
			trailingslashit(get_bloginfo('wpurl')) . 'wp-admin/' .
			( $this->_check_wp_version("2.7") ? 'options-general' : 'admin' ) . '.php' .
			'?page=' . $this->admin_option;
		$this->admin_hook = add_options_page($page_title, $menu_title, $capability, $file, $function);
	}


	//*****************************************************************************
	// Action/Filter hook
	//*****************************************************************************

	// publish post
	function publishPost($post_id = '') {
		return $this->_do_tweet($post_id);
	}

	// plugin activation
	function activation(){
		$this->options['activate'] = time();
		$this->options['deactivate'] = 0;
		$this->_update_options();
	}

	// plugin deactivation
	function deactivation(){
		$this->options['activate'] = 0;
		$this->options['deactivate'] = time();
		$this->_update_options();
	}

	// Add Admin Menu
	function addAdminMenu() {
		$this->_add_option_page( __('Simple Tweet', $this->textdomain_name), array($this,'optionPage'));
	}

	// Add Content
	function addContent($content) {
		if ( $this->options['add_content'] )
			$content .= "\n" . $this->TweetThisLink();
		return $content;
	}

	// Option Page
	function optionPage() {
		return $this->_option_page();
	}

	//*****************************************************************************
	// init options
	//*****************************************************************************
	function _init_options($options = ''){
		if (!is_array($options))
			$options = array();

		if (!isset($options['tweet_text']))
			$options['tweet_text'] = sprintf(
				__('blogged: %1$s - %2$s', $this->textdomain_name) ,
				'%POST_TITLE%' ,
				'%POST_EXCERPT%'
				);

		if (!isset($options['tweet_this_link']))
			$options['tweet_this_link'] = sprintf(
				__('RT @%1$s: %2$s - %3$s %4$s', $this->textdomain_name) ,
				'%TWITTER_ID%' ,
				'%POST_TITLE%' ,
				'%SITE_NAME%' ,
				'%PERMALINK%'
				);

		if (!isset($options['tweet_this_text']))
			$options['tweet_this_text'] = sprintf(
				'<img src="%1$simg/tweet.gif" title="%2$s" alt="%2$s" />%2$s' ,
				$this->plugin_url ,
				__('Tweet this!', $this->textdomain_name)
				);

		$options = $this->_set_default_options($options);

		if ($options['activate'] == 0)
			$options['activate'] = time();

		return $options;
	}

	//*****************************************************************************
	// Do tweet
	//*****************************************************************************
	function _do_tweet($post_id = '') {
		if (empty($post_id))
			return false;

		$this->_log = '';
		$post = &get_post($post_id);

		if ('publish' !== $post->post_status )
			return false;

		$post_time = strtotime($post->post_date_gmt . ' +0000');
		$meta_val = $this->_get_post_meta($post_id, TWEET_METAKEY_SID);

		$this->_log =
			"post_time:{$post_time}\n" .
			"activate:{$this->options['activate']}\n" .
			"meta_val:{$meta_val}\n" ;

		if ( empty($meta_val) && $post_time >= $this->options['activate'] ) {
			$this->_log .= "post ID:{$post_id}\n";

			$post_title = $post->post_title;
			$post_excerpt = (!empty($post->post_excerpt) ? $post->post_excerpt : $post->post_content);

			$url = get_permalink($post_id);
			$tiny = $this->_get_post_meta($post_id, TWEET_METAKEY_URL);
			$tiny_url = ( is_array($tiny) && $tiny['limit'] > time()
				? $tiny['tiny_url']
				: '' );
			if ( empty($tiny_url) ) {
				$tiny_url = $this->_get_TinyURL($url);
				$this->_update_post_meta(
					$post_id ,
					TWEET_METAKEY_URL,
					array(
						'url' => $url ,
						'limit' => time() + TWEET_TINYURL_LIMIT ,
						'tiny_url' => $tiny_url
						)
					);
			}
			$permalink = ( $this->options['tinyurl'] || mb_strlen($msg . $this->options['separator'] . $url) > TWEET_MAX
				? $tiny_url
				: $url );

			$msg = $this->_make_tweet_msg($this->options['tweet_text'], $post_id, $post_title, $post_excerpt, $permalink);

			$permalink = ( !$this->options['tweet_without_url']
				? $this->options['separator'] . $permalink
				: '');
			$tweet_msg = $msg . $permalink;
			if ( mb_strlen($tweet_msg, $this->charset) >= TWEET_MAX )
				$tweet_msg = mb_substr($msg, 0, TWEET_MAX - (mb_strlen($url, $this->charset) + 3), $this->charset) . '...' . $permalink;
			$this->_log .= "tweet message:{$notify_msg}\n";

			$tweet_result = $this->_post_twitter($tweet_msg, $this->options['user'], $this->options['password']);
			if ( $tweet_result !== FALSE ) {
				$tweet_id = $this->_get_tweet_id($tweet_result);
				$this->_log .= "id:{$tweet_id}\n";
				if ( $this->_update_post_meta($post_id, TWEET_METAKEY_SID, $tweet_id) )
					$this->_log = "*** OK! ***\n\n" . $this->_log;
				else
					$this->_log = "** ERROR **\n\n" . $this->_log;
			} else {
				$this->_log = "** ERROR **\n\n" . $this->_log;
			}
		}

		if ( $this->options['log_write'] && !empty($this->_log)) {
			$log_file = $this->_wp_content_dir() . 'simple_tweet.log';
			if (file_exists($log_file)) @unlink($log_file);
			$handle = fopen($log_file, 'w');
			fwrite($handle, $this->_log);
			fclose($handle);
		}
	}

	//*****************************************************************************
	// Post to Twitter!
	//*****************************************************************************
	function _post_twitter($tweet, $username, $password) {
		if (empty($tweet) || empty($username) || empty($password)) return FALSE;

		$result = FALSE;
		$log = '';

		if (!class_exists('Snoopy'))
			require_once(ABSPATH . WPINC . '/class-snoopy.php');

		if (class_exists('Snoopy')) {
			$snoop = new Snoopy;
			$snoop->agent = "{$this->twitter_client_name} ver.{$this->twitter_client_version} ({$this->twitter_client_url})";
			$snoop->rawheaders = array(
				'X-Twitter-Client' => $this->twitter_client_name ,
				'X-Twitter-Client-Version' => $this->twitter_client_version ,
				'X-Twitter-Client-URL' => $this->twitter_client_url
				);
			$snoop->user = $username;
			$snoop->pass = $password;
			$snoop->read_timeout = TWEET_TIMEOUT;
			$snoop->timed_out = true;
			$snoop->submit(
				TWEET_SENT_URL ,
				array(
					'status' => $tweet ,
					'source' => $this->twitter_client_name
					)
				);
			$result = ( strpos($snoop->response_code, '200') !== FALSE
				? $snoop->results
				: FALSE
				);
			$log .=	 "--- Class Snoopy Result ! ---\n"
				."response_code:{$snoop->response_code}"
				."results:{$snoop->results}\n"
				."status:{$snoop->status}\n"
				."error:{$snoop->error}\n";
			unset($snoop);
		}

		if ($result === FALSE) {
			$params = '?status=' . rawurlencode($tweet)
				. '&source=' . $this->twitter_client_name;
			$result = @file_get_contents(TWEET_SENT_URL.$params , false, stream_context_create(array(
				 "http" => array(
					"method" => "POST" ,
					"header" => "Authorization: Basic ". base64_encode($username. ":". $password)
					)
				))
			);
			$log .=	 "\n--- file_get_contents Result ! ---\n"
				."results:{$result}\n";
		}
		$this->_log .= $log;

		return $result;
	}

	//*****************************************************************************
	// Make Tweet Message
	//*****************************************************************************
	function _make_tweet_msg($text, $post_id, $post_title = '', $post_excerpt = '', $permalink = '') {
		if ( empty($text) )
			return '';

		$text = str_replace(
			array(
				'%SITE_NAME%' ,
				'%POST_NO%' ,
				'%POST_TITLE%' ,
				'%POST_EXCERPT%' ,
				'%PERMALINK%' ,
				'%TWITTER_ID%' ,
				) ,
			array(
				get_bloginfo('name') ,
				$post_id ,
				$post_title ,
				preg_replace('/[\r\n ]+/', '', strip_tags($post_excerpt)) ,
				$permalink ,
				$this->options['user'] ,
				) ,
			$text
			);

		return $text;
	}

	//*****************************************************************************
	// Get Tiny URL
	//*****************************************************************************
	function _get_TinyURL($url = '') {
		if (empty($url)) return '';

		$buff = '';
		$get_url = TWEET_TINYURL_URL . $url;
		if( function_exists('file_get_contents') ) {
			$buff = @file_get_contents( $get_url );
		} else {
			$fp = @fopen($get_url, 'r');
			if ( $fp === FALSE ) return $url;
			while(!feof($fp)) {$buff .= fread( $fp, 1024 );}
			fclose($fp);
		}

		return $buff;
	}

	//*****************************************************************************
	// Get TweetID
	//*****************************************************************************
	function _get_tweet_id($result = '') {
		if (empty($result)) return '';

		$tweet_id = '';
		if ( function_exists('simplexml_load_string') ) {
			$xml = simplexml_load_string($result);
			$tweet_id = $xml->id;
			unset($xml);
		} elseif ( preg_match_all('/<id>([0-9]+)<\/id>/i', $result, $matches, PREG_PATTERN_ORDER) ) {
			$tweet_id = $matches[1][0];
			unset($matches);
		}

		return $tweet_id;
	}

	//*****************************************************************************
	// Show Option Page
	//*****************************************************************************
	function _option_page() {
		if (isset($_POST['options_update'])) {
			// Check Nonce Field
			if ( function_exists('check_admin_referer') )
				check_admin_referer("update_options", "_wpnonce_update_options");

			// strip slashes array
			$_POST = $this->_strip_array($_POST);

			$this->options['user']       = $_POST['twitter_usr'];
			if ( trim($_POST['twitter_pwd']) !== '' )
				$this->options['password'] = $_POST['twitter_pwd'];
			$this->options['separator']  = $_POST['separator'];
			$this->options['tinyurl']    = (isset($_POST['tinyurl']) && $_POST['tinyurl'] == 'on' ? true : false);
			$this->options['tweet_text'] = $_POST['tweet_text'];
			$this->options['tweet_without_url']  = (isset($_POST['tweet_without_url']) && $_POST['tweet_without_url'] == 'on' ? true : false);
			$this->options['tweet_this_link'] = $_POST['tweet_this_link'];
			$this->options['tweet_this_text'] = $_POST['tweet_this_text'];
			$this->options['add_content']  = (isset($_POST['add_content']) && $_POST['add_content'] == 'on' ? true : false);
			$this->options['log_write']  = (isset($_POST['log_write']) && $_POST['log_write'] == 'on' ? true : false);

			if ($this->options['activate'] == 0)
				$this->options['activate'] = time();
			$this->options['deactivate'] = 0;

			// options update
			$this->_update_options();

			// Done!
			$this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";

		} elseif(isset($_POST['options_delete'])) {
			// Check Nonce Field
			if ( function_exists('check_admin_referer') )
				check_admin_referer("delete_options", "_wpnonce_delete_options");

			// options delete
			$this->_delete_settings();

			// Done!
			$this->note .= "<strong>".__('Done!', $this->textdomain_name)."</strong>";
			$this->error++;
		}

		$out  = '';

		// Add Options
		$out .= "<div class=\"wrap\">\n";
		$out .= "<h2>".__('Simple Tweet Options', $this->textdomain_name)."</h2><br />\n";
		$out .= "<form method=\"post\" id=\"update_options\" action=\"".$this->admin_action."\">\n";
		$out .= $this->_make_nonce_field("update_options", "_wpnonce_update_options", true, false);

		$out .= "<table class=\"optiontable form-table\" style=\"margin-top:0;\"><tbody>\n";

		$out .= "<tr>";
		$out .= "<th>".__('Twitter ID', $this->textdomain_name)."</th>";
		$out .= "<td><input type=\"text\" name=\"twitter_usr\" id=\"twitter_usr\" size=\"50\" value=\"{$this->options['user']}\" /></td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th>".__('Twitter Password', $this->textdomain_name)."</th>";
		$out .= "<td><input type=\"password\" name=\"twitter_pwd\" id=\"twitter_pwd\" size=\"50\" value=\"\" /></td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th>".__('Tweet text', $this->textdomain_name)."</th>";
		$out .= "<td><input type=\"text\" name=\"tweet_text\" id=\"tweet_text\" size=\"100\" value=\"".htmlspecialchars($this->options['tweet_text'])."\" /></td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th></th>";
		$out .= "<td>";
		$out .= "<input type=\"checkbox\" name=\"tweet_without_url\" id=\"tweet_without_url\" value=\"on\" style=\"margin-right:0.5em;\" ".($this->options['tweet_without_url'] === true ? " checked=\"true\"" : "")." />";
		$out .= __('Tweet without Permalink', $this->textdomain_name);
		$out .= "</td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th></th>";
		$out .= "<td>";
		$out .= "<input type=\"checkbox\" name=\"tinyurl\" id=\"tinyurl\" value=\"on\" style=\"margin-right:0.5em;\" ".($this->options['tinyurl'] === true ? " checked=\"true\"" : "")." />";
		$out .= __('Compress Permalink ( <a href="http://tinyurl.com/">TinyURL</a> )', $this->textdomain_name);
		$out .= "</td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th>".__('Separator between message and Permalink', $this->textdomain_name)."</th>";
		$out .= "<td><input type=\"text\" name=\"separator\" id=\"separator\" size=\"50\" value=\"{$this->options['separator']}\" /></td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th></th>";
		$out .= "<td>";
		$out .= "<input type=\"checkbox\" name=\"add_content\" id=\"add_content\" value=\"on\" style=\"margin-right:0.5em;\" ".($this->options['add_content'] === true ? " checked=\"true\"" : "")." />";
		$out .= __('Add content "Tweet this"', $this->textdomain_name);
		$out .= "</td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th>".__('Tweet this link', $this->textdomain_name)."</th>";
		$out .= "<td><input type=\"text\" name=\"tweet_this_link\" id=\"tweet_this_link\" size=\"100\" value=\"".htmlspecialchars($this->options['tweet_this_link'])."\" /></td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th>".__('Tweet this text', $this->textdomain_name)."</th>";
		$out .= "<td><input type=\"text\" name=\"tweet_this_text\" id=\"tweet_this_text\" size=\"100\" value=\"".htmlspecialchars($this->options['tweet_this_text'])."\" /></td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th></th>";
		$out .= "<td>";
		$out .= __('The following characters are converted respectively.', $this->textdomain_name).'<br />';
		$out .= '%TWITTER_ID% - '.__('Twitter ID', $this->textdomain_name).'<br />';
		$out .= '%SITE_NAME% - '.__('Site Name', $this->textdomain_name).'<br />';
		$out .= '%POST_NO% - '.__('Post No.', $this->textdomain_name).'<br />';
		$out .= '%POST_TITLE% - '.__('Post Title', $this->textdomain_name).'<br />';
		$out .= '%POST_EXCERPT% - '.__('Post Excerpt', $this->textdomain_name).'<br />';
		$out .= '%PERMALINK% - '.__('Permalink', $this->textdomain_name).'<br />';
		$out .= "</td>";
		$out .= "</tr>\n";

		$out .= "<tr>";
		$out .= "<th></th>";
		$out .= "<td>";
		$out .= "<input type=\"checkbox\" name=\"log_write\" id=\"log_write\" value=\"on\" style=\"margin-right:0.5em;\" ".($this->options['log_write'] === true ? " checked=\"true\"" : "")." />";
		$out .= __('Log write? (debug mode)', $this->textdomain_name);
		$out .= "</td>";
		$out .= "</tr>\n";

		$out .= "</tbody></table>";

		// Add Update Button
		$out .= "<p style=\"margin-top:1em\"><input type=\"submit\" name=\"options_update\" class=\"button-primary\" value=\"".__('Update Options &raquo;', $this->textdomain_name)."\" class=\"button\" /></p>";
		$out .= "</form></div>\n";

		// Options Delete
		$out .= "<div class=\"wrap\" style=\"margin-top:2em;\">\n";
		$out .= "<h2>" . __('Uninstall', $this->textdomain_name) . "</h2><br />\n";
		$out .= "<form method=\"post\" id=\"delete_options\" action=\"".$this->admin_action."\">\n";
		$out .= $this->_make_nonce_field("delete_options", "_wpnonce_delete_options", true, false);
		$out .= "<p>" . __('All the settings of &quot;Simple Tweet&quot; are deleted.', $this->textdomain_name) . "</p>";
		$out .= "<input type=\"submit\" name=\"options_delete\" class=\"button-primary\" value=\"".__('Delete Options &raquo;', $this->textdomain_name)."\" class=\"button\" />";
		$out .= "</form></div>\n";

		// Output
		echo ( !empty($this->note) ? "<div id=\"message\" class=\"updated fade\"><p>{$this->note}</p></div>\n" : '' ) . "\n";
		echo ( $this->error == 0 ? $out : '' ) . "\n";
	}

	// delete all settings
	function _delete_settings() {
		global $wpdb;

		$wpdb->query($wpdb->prepare(
			"DELETE FROM $wpdb->postmeta WHERE meta_key in (%s, %s)" ,
			$wpdb->escape(TWEET_METAKEY_SID) ,
			$wpdb->escape(TWEET_METAKEY_URL)
			)
		);

		$this->_delete_options();
	}

	//*****************************************************************************
	// Get Tweet this Link
	//*****************************************************************************
	function TweetThisLink($inreply_to = FALSE) {
		global $post;

		if ( !isset($post) )
			return false;

		$post_id = $post->ID;
		$post_title = $post->post_title;
		$post_excerpt = (!empty($post->post_excerpt) ? $post->post_excerpt : $post->post_content);

		$status_id = $this->_get_post_meta($post_id, TWEET_METAKEY_SID);
		if ( $inreply_to && empty($status_id) )
			return false;

		if ( $this->options['tinyurl'] ) {
			$tiny = $this->_get_post_meta($post_id, TWEET_METAKEY_URL);
			if ( !empty($tiny) && !is_array($tiny) ) {
				$tiny_url = $tiny;
				$tiny = array(
					'url' => get_permalink($post_id) ,
					'limit' => time() + TWEET_TINYURL_LIMIT ,
					'tiny_url' => $tiny_url
					);
				$this->_update_post_meta(
					$post_id ,
					TWEET_METAKEY_URL,
					$tiny
					);
			} else {
				$tiny_url = ( is_array($tiny) && $tiny['limit'] > time()
					? $tiny['tiny_url']
					: '' );
			}
			if ( empty($tiny_url) ) {
				$permalink = get_permalink($post_id);
				if ( is_single() ) {
					$tiny_url = $this->_get_TinyURL(get_permalink($permalink));
					$this->_update_post_meta(
						$post_id ,
						TWEET_METAKEY_URL,
						array(
							'url' => get_permalink($post_id) ,
							'limit' => time() + TWEET_TINYURL_LIMIT ,
							'tiny_url' => $tiny_url
							)
						);
					$permalink = $tiny_url;
				}
			} else {
				$permalink = $tiny_url;
			}
		} else {
			$permalink = get_permalink($post_id);
		}

		$link = $this->_make_tweet_msg($this->options['tweet_this_link'], $post_id, $post_title, $post_excerpt, $permalink);
		$text = $this->_make_tweet_msg($this->options['tweet_this_text'], $post_id, $post_title, $post_excerpt, $permalink);

		$tweet_this_link = '<a href="' . TWEET_HOME_URL .
			'?status=' . urlencode($link) .
			( !empty($status_id) ? '&amp;in_reply_to_status_id=' . $status_id : '' ) .
			'&amp;in_reply_to=' . $this->options['user'] .
			'" class="tweet-this" >' .
			$text .
			'</a>';

		return $tweet_this_link;
	}

}


/******************************************************************************
 * Go Go Go!
 *****************************************************************************/
$simple_tweet = new SimpleTweetController();

// add admin dashbord
if (is_admin()) {
	add_action('admin_menu', array(&$simple_tweet,'addAdminMenu'));
	if ( function_exists('register_activation_hook') )
		register_activation_hook(__FILE__, array(&$simple_tweet, 'activation'));
	if ( function_exists('register_deactivation_hook') )
		register_deactivation_hook(__FILE__, array(&$simple_tweet, 'deactivation'));
}

// post publish
add_action('publish_post', array(&$simple_tweet, 'publishPost'));

// for ktai-entry
add_action('publish_phone', array(&$simple_tweet, 'publishPost'));

// add content
if ( $simple_tweet->options['add_content'] )
	add_filter('the_content', array (&$simple_tweet, 'addContent'));

?>