/*
 * Decompiled with CFR 0.152.
 */
package lll.wrj4P5;

import javax.sound.sampled.AudioInputStream;
import lll.Loc.Loc;
import lll.wrj4P5.ButtonPressedThread;
import lll.wrj4P5.ButtonReleasedThread;
import lll.wrj4P5.GuitarPressedThread;
import lll.wrj4P5.GuitarReleasedThread;
import lll.wrj4P5.KurakonPressedThread;
import lll.wrj4P5.KurakonReleasedThread;
import lll.wrj4P5.NunchakuPressedThread;
import lll.wrj4P5.NunchakuReleasedThread;
import lll.wrj4P5.WiiGuitar;
import lll.wrj4P5.WiiKurakon;
import lll.wrj4P5.WiiNunchaku;
import lll.wrj4P5.Wrj4P5;
import wiiremotej.IRLight;
import wiiremotej.IRSensitivitySettings;
import wiiremotej.PrebufferedSound;
import wiiremotej.WiiRemote;
import wiiremotej.WiiRemoteExtension;
import wiiremotej.event.WRAccelerationEvent;
import wiiremotej.event.WRButtonEvent;
import wiiremotej.event.WRClassicControllerExtensionEvent;
import wiiremotej.event.WRExtensionEvent;
import wiiremotej.event.WRGuitarExtensionEvent;
import wiiremotej.event.WRIREvent;
import wiiremotej.event.WRNunchukExtensionEvent;
import wiiremotej.event.WRStatusEvent;
import wiiremotej.event.WiiRemoteAdapter;

public class WiiRimokon
extends WiiRemoteAdapter {
    public long tNow = 0L;
    public Loc sensed;
    public Loc senced = this.sensed = new Loc();
    public Loc acc = new Loc();
    public WiiNunchaku nunchaku;
    public WiiKurakon kurakon;
    public WiiGuitar guitar;
    public Loc[] irLights = new Loc[]{new Loc(-1.0f, -1.0f, -1.0f), new Loc(-1.0f, -1.0f, -1.0f), new Loc(-1.0f, -1.0f, -1.0f), new Loc(-1.0f, -1.0f, -1.0f)};
    private Wrj4P5 parent;
    private WiiRemote talker;
    private int myId;
    private Loc psensed = new Loc();
    private float batteryLevel;
    private boolean[] isIlluminated = new boolean[4];
    private PrebufferedSound prebuf;
    private float viblationMagnitude = 1.0f;
    private boolean isModurate = false;
    private long viblationInterval = 40L;
    private boolean isVibrating = false;
    private long lastCom = 0L;
    private long birthTime;

    public WiiRimokon(Wrj4P5 wii) {
        this.nunchaku = new WiiNunchaku();
        this.kurakon = new WiiKurakon();
        this.guitar = new WiiGuitar();
        this.parent = wii;
    }

    public WiiRemote addTalker(WiiRemote talker, int id, boolean ir, int irSens) {
        this.myId = id;
        this.talker = talker;
        this.birthTime = System.currentTimeMillis();
        try {
            talker.setIRSensorEnabled(true, ir ? WRIREvent.EXTENDED : WRIREvent.BASIC, irSens <= 0 ? IRSensitivitySettings.WII_LEVEL_1 : (irSens == 1 ? IRSensitivitySettings.WII_LEVEL_2 : (irSens == 2 ? IRSensitivitySettings.WII_LEVEL_3 : (irSens == 3 ? IRSensitivitySettings.WII_LEVEL_4 : IRSensitivitySettings.WII_LEVEL_5))));
            talker.setAccelerometerEnabled(true);
            talker.setSpeakerEnabled(true);
            talker.setLEDLights(this.isIlluminated);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return talker;
    }

    public void disconnected() {
        System.out.println("Remote disconnected... Please Wii again.");
        this.parent.disconnected(this.myId);
    }

    public void statusReported(WRStatusEvent evt) {
        this.batteryLevel = (float)evt.getBatteryLevel() / 200.0f;
        this.isIlluminated = evt.getLEDStatus();
    }

    public void IRInputReceived(WRIREvent evt) {
        IRLight[] spots = evt.getIRLights();
        int i = 0;
        while (i < 4) {
            this.irLights[i].move(i < spots.length - 1 && spots[i] != null ? (float)spots[i].getX() : -1.0f, i < spots.length - 1 && spots[i] != null ? (float)spots[i].getY() : -1.0f, i < spots.length - 1 && spots[i] != null ? (float)spots[i].getSize() : -1.0f);
            ++i;
        }
    }

    public void accelerationInputReceived(WRAccelerationEvent evt) {
        this.psensed.move(this.sensed);
        this.sensed.move((float)evt.getXAcceleration(), (float)evt.getYAcceleration(), (float)evt.getZAcceleration());
        this.acc.move(this.sensed.mul(9.80665f));
        ++this.tNow;
    }

    public void extensionInputReceived(WRExtensionEvent evt) {
        if (evt instanceof WRNunchukExtensionEvent) {
            Thread t;
            this.nunchaku.inputEvent((WRNunchukExtensionEvent)evt);
            if (this.parent.nunchakuPressed != null && this.isJustNunchakuPressed((WRNunchukExtensionEvent)evt)) {
                t = new NunchakuPressedThread((WRNunchukExtensionEvent)evt, this.parent, this.myId);
                ((NunchakuPressedThread)t).run();
            }
            if (this.parent.nunchakuReleased != null && this.isJustNunchakuReleased((WRNunchukExtensionEvent)evt)) {
                t = new NunchakuReleasedThread((WRNunchukExtensionEvent)evt, this.parent, this.myId);
                ((NunchakuReleasedThread)t).run();
            }
        } else if (evt instanceof WRClassicControllerExtensionEvent) {
            Thread t;
            this.kurakon.inputEvent((WRClassicControllerExtensionEvent)evt);
            if (this.parent.kurakonPressed != null && this.isJustKurakonPressed((WRClassicControllerExtensionEvent)evt)) {
                t = new KurakonPressedThread((WRClassicControllerExtensionEvent)evt, this.parent, this.myId);
                ((KurakonPressedThread)t).run();
            }
            if (this.parent.kurakonReleased != null && this.isJustKurakonReleased((WRClassicControllerExtensionEvent)evt)) {
                t = new KurakonReleasedThread((WRClassicControllerExtensionEvent)evt, this.parent, this.myId);
                ((KurakonReleasedThread)t).run();
            }
        } else if (evt instanceof WRGuitarExtensionEvent) {
            Thread t;
            this.guitar.inputEvent((WRGuitarExtensionEvent)evt);
            if (this.parent.guitarPressed != null && this.isJustGuitarPressed((WRGuitarExtensionEvent)evt)) {
                t = new GuitarPressedThread((WRGuitarExtensionEvent)evt, this.parent, this.myId);
                ((GuitarPressedThread)t).run();
            }
            if (this.parent.guitarReleased != null && this.isJustGuitarReleqsed((WRGuitarExtensionEvent)evt)) {
                t = new GuitarReleasedThread((WRGuitarExtensionEvent)evt, this.parent, this.myId);
                ((GuitarReleasedThread)t).run();
            }
        } else {
            System.err.println("Unknown extension connected!");
        }
    }

    public void extensionConnected(WiiRemoteExtension extension) {
        System.out.println("Extension connected!");
        try {
            this.talker.setExtensionEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void extensionPartiallyInserted() {
        System.out.println("Extension(#" + this.myId + ") partially inserted. Push it in more next time, jerk!");
    }

    public void extensionUnknown() {
        System.out.println("Extension(#" + this.myId + ") unknown. Did you try to plug in a toaster or something?");
    }

    public void extensionDisconnected(WiiRemoteExtension extension) {
        System.out.println("Extension(#" + this.myId + ") disconnected. Why'd you unplug it, retard?");
        this.parent.exDisconnected(this.myId);
    }

    public void buttonInputReceived(WRButtonEvent evt) {
        Thread t;
        if (this.parent.buttonPressed != null && this.isJustPressed(evt)) {
            t = new ButtonPressedThread(evt, this.parent, this.myId);
            ((ButtonPressedThread)t).run();
        }
        if (this.parent.buttonReleased != null && this.isJustReleased(evt)) {
            t = new ButtonReleasedThread(evt, this.parent, this.myId);
            ((ButtonReleasedThread)t).run();
        }
    }

    public void disconnect() {
        if (this.talker != null) {
            this.talker.disconnect();
            this.nunchaku = null;
            this.kurakon = null;
            this.talker = null;
        }
        this.parent.disconnected(this.myId);
    }

    public boolean isConnected() {
        return this.canCommunicateMe() ? this.talker.isConnected() : false;
    }

    public boolean isExtensionConnected() {
        return this.canCommunicateMe() ? this.talker.isExtensionConnected() : false;
    }

    public void requestStatus() {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            if (!this.talker.isReadingData()) {
                this.talker.requestStatus();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean isReadingData() {
        return this.canCommunicateMe() ? this.talker.isReadingData() : false;
    }

    public float getBatteryLevel() {
        return this.batteryLevel;
    }

    public boolean isLED(int lid) {
        if (this.canCommunicateMe()) {
            this.isIlluminated = this.talker.getLEDLights();
        }
        return this.isIlluminated[lid < 0 ? 0 : (lid > 3 ? 3 : lid)];
    }

    public void setLED(int lid, boolean illumination) {
        try {
            this.isIlluminated[lid] = illumination;
            if (this.canCommunicateMe()) {
                this.talker.setLEDLights(this.isIlluminated);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean[] getLEDs() {
        if (this.canCommunicateMe()) {
            this.isIlluminated = this.talker.getLEDLights();
        }
        return this.isIlluminated;
    }

    public void setLEDs(boolean[] illumination) {
        try {
            boolean isSame = true;
            int i = 0;
            while (i < 4) {
                isSame = isSame && this.isIlluminated[i] == illumination[i];
                ++i;
            }
            if (!isSame && this.canCommunicateMe()) {
                this.talker.setLEDLights(illumination);
                i = 0;
                while (i < 4) {
                    this.isIlluminated[i] = illumination[i];
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void bufferSound(AudioInputStream audioIn) {
        try {
            this.prebuf = WiiRemote.bufferSound((AudioInputStream)audioIn);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public float getVolume() {
        return this.canCommunicateMe() ? (float)this.talker.getSpeakerVolume() : 0.0f;
    }

    public void setVolume(float volume) {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            this.talker.setSpeakerVolume((double)volume);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean isPlaying() {
        return this.canCommunicateMe() ? this.talker.isPlayingSound() : false;
    }

    public void playBuffer() {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            this.talker.playPrebufferedSound(this.prebuf, (byte)0);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void play(AudioInputStream audioIn) {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            this.talker.playSound(audioIn, (byte)0);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void stopSound() {
        if (this.canCommunicateMe()) {
            this.talker.stopSound();
        }
    }

    public boolean isVibrating() {
        return this.canCommunicateMe() ? (this.isVibrating = this.talker.isVibrating()) : this.isVibrating;
    }

    public float getVibrationMagnitude(int magnitude) {
        return this.viblationMagnitude;
    }

    public void setVibrationMagnitude(int magnitude) {
        this.viblationMagnitude = magnitude < 0 ? 0 : (magnitude > 1 ? 1 : magnitude);
        this.isModurate = (double)magnitude > 0.9;
        this.viblationInterval = (long)(20.0f + 200.0f * (1.0f - this.viblationMagnitude));
    }

    public void startVibrating() {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            if (!this.isModurate) {
                this.talker.startVibrating();
            } else {
                this.talker.startModulatedVibrating(this.viblationInterval);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void vibrateFor(long time) {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            if (!this.isModurate) {
                this.talker.vibrateFor(time > 10L ? time : 10L);
            } else {
                this.talker.modulatedVibrateFor(time > 10L ? time : 10L, this.viblationInterval);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void stopVibrating() {
        if (!this.canCommunicateMe()) {
            return;
        }
        try {
            if (!this.isModurate) {
                this.talker.stopModulatedVibrating();
            } else {
                this.talker.stopVibrating();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean isIRSensorEnabled() {
        return this.canCommunicateMe() ? this.talker.isIRSensorEnabled() : false;
    }

    public float stablePitch() {
        return (float)Math.asin(this.sensed.y / 9.80665f);
    }

    public float stableRoll() {
        return (float)Math.asin(this.sensed.x / 9.80665f);
    }

    private boolean canCommunicateMe() {
        if (this.talker == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.birthTime < 3000L || !this.talker.isConnected()) {
            return false;
        }
        long dlt = now - this.lastCom;
        if (dlt > 100L) {
            this.lastCom = now;
        }
        return dlt > 100L;
    }

    private boolean isJustPressed(WRButtonEvent evt) {
        return evt.wasPressed(1) || evt.wasPressed(2) || evt.wasPressed(4) || evt.wasPressed(8) || evt.wasPressed(16) || evt.wasPressed(128) || evt.wasPressed(256) || evt.wasPressed(512) || evt.wasPressed(1024) || evt.wasPressed(2048) || evt.wasPressed(4096);
    }

    private boolean isJustNunchakuPressed(WRNunchukExtensionEvent evt) {
        return evt.wasPressed(2) || evt.wasPressed(1);
    }

    private boolean isJustKurakonPressed(WRClassicControllerExtensionEvent evt) {
        return evt.wasPressed(16) || evt.wasPressed(64) || evt.wasPressed(8) || evt.wasPressed(32) || evt.wasPressed(2048) || evt.wasPressed(2) || evt.wasPressed(32768) || evt.wasPressed(16384) || evt.wasPressed(1) || evt.wasPressed(8192) || evt.wasPressed(512) || evt.wasPressed(128) || evt.wasPressed(4) || evt.wasPressed(4096) || evt.wasPressed(1024);
    }

    private boolean isJustGuitarPressed(WRGuitarExtensionEvent evt) {
        return evt.wasPressed(32) || evt.wasPressed(16) || evt.wasPressed(4096) || evt.wasPressed(128) || evt.wasPressed(1024) || evt.wasPressed(64) || evt.wasPressed(16384) || evt.wasPressed(1) || evt.wasPressed(8);
    }

    private boolean isJustReleased(WRButtonEvent evt) {
        return evt.wasReleased(1) || evt.wasReleased(2) || evt.wasReleased(4) || evt.wasReleased(8) || evt.wasReleased(16) || evt.wasReleased(128) || evt.wasReleased(256) || evt.wasReleased(512) || evt.wasReleased(1024) || evt.wasReleased(2048) || evt.wasReleased(4096);
    }

    private boolean isJustNunchakuReleased(WRNunchukExtensionEvent evt) {
        return evt.wasReleased(2) || evt.wasReleased(1);
    }

    private boolean isJustKurakonReleased(WRClassicControllerExtensionEvent evt) {
        return evt.wasReleased(16) || evt.wasReleased(64) || evt.wasReleased(8) || evt.wasReleased(32) || evt.wasReleased(2048) || evt.wasReleased(2) || evt.wasReleased(32768) || evt.wasReleased(16384) || evt.wasReleased(1) || evt.wasReleased(8192) || evt.wasReleased(512) || evt.wasReleased(128) || evt.wasReleased(4) || evt.wasReleased(4096) || evt.wasReleased(1024);
    }

    private boolean isJustGuitarReleqsed(WRGuitarExtensionEvent evt) {
        return evt.wasReleased(32) || evt.wasReleased(16) || evt.wasReleased(4096) || evt.wasReleased(128) || evt.wasReleased(1024) || evt.wasReleased(64) || evt.wasReleased(16384) || evt.wasReleased(1) || evt.wasReleased(8);
    }
}

