/*
 * Decompiled with CFR 0.152.
 */
package lll.wrj4P5;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import lll.wrj4P5.GuitarEvent;
import lll.wrj4P5.KurakonEvent;
import lll.wrj4P5.NunchakuEvent;
import lll.wrj4P5.RimokonEvent;
import lll.wrj4P5.WiiBoard;
import lll.wrj4P5.WiiGuitar;
import lll.wrj4P5.WiiKurakon;
import lll.wrj4P5.WiiNunchaku;
import lll.wrj4P5.WiiRimokon;
import processing.core.PApplet;
import processing.core.PImage;
import wiiremotej.BalanceBoard;
import wiiremotej.WiiDevice;
import wiiremotej.WiiRemote;
import wiiremotej.WiiRemoteJ;
import wiiremotej.event.BalanceBoardListener;
import wiiremotej.event.WiiDeviceDiscoveredEvent;
import wiiremotej.event.WiiDeviceDiscoveryListener;
import wiiremotej.event.WiiRemoteListener;

public class Wrj4P5
implements WiiDeviceDiscoveryListener {
    public PApplet parent;
    public static int dCount;
    public static int rCount;
    public static int bCount;
    public static final float ONE_G = 9.80665f;
    public static final boolean IR = true;
    public static final boolean EX = false;
    private boolean isIR = false;
    private int irSens = 2;
    public static WiiRimokon rimokon;
    private static WiiRimokon[] rims;
    public static WiiBoard board;
    private static WiiBoard[] brds;
    public static WiiNunchaku nunchaku;
    public static WiiKurakon kurakon;
    public static WiiGuitar guitar;
    private static PImage waitingImg;
    Method buttonPressed;
    Method nunchakuPressed;
    Method kurakonPressed;
    Method guitarPressed;
    Method boardPressed;
    Method buttonReleased;
    Method nunchakuReleased;
    Method kurakonReleased;
    Method guitarReleased;
    Method boardReleased;
    Method disconnected;
    Method exDisconnected;

    static {
        rims = new WiiRimokon[7];
        brds = new WiiBoard[7];
    }

    public Wrj4P5(PApplet parent) {
        this.parent = parent;
        this.isIR = false;
        this.prepareReflection();
    }

    private void prepareReflection() {
        try {
            this.buttonPressed = this.parent.getClass().getMethod("buttonPressed", RimokonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nunchakuPressed = this.parent.getClass().getMethod("nunchakuPressed", NunchakuEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kurakonPressed = this.parent.getClass().getMethod("kurakonPressed", KurakonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.guitarPressed = this.parent.getClass().getMethod("guitarPressed", GuitarEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.boardPressed = this.parent.getClass().getMethod("boardPressed", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.buttonReleased = this.parent.getClass().getMethod("buttonReleased", RimokonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.nunchakuReleased = this.parent.getClass().getMethod("nunchakuReleased", NunchakuEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.kurakonReleased = this.parent.getClass().getMethod("kurakonReleased", KurakonEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.guitarReleased = this.parent.getClass().getMethod("guitarReleased", GuitarEvent.class, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.boardReleased = this.parent.getClass().getMethod("boardReleased", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.disconnected = this.parent.getClass().getMethod("disconnected", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.exDisconnected = this.parent.getClass().getMethod("exDisconnected", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.parent.registerDispose((Object)this);
        int i = 0;
        while (i < 7) {
            Wrj4P5.rims[i] = new WiiRimokon(this);
            Wrj4P5.brds[i] = new WiiBoard(this);
            ++i;
        }
        rimokon = rims[0];
        nunchaku = Wrj4P5.rims[0].nunchaku;
        kurakon = Wrj4P5.rims[0].kurakon;
        guitar = Wrj4P5.rims[0].guitar;
        board = brds[0];
    }

    public Wrj4P5 connect() {
        return this.connect(1);
    }

    public Wrj4P5 connect(boolean ir) {
        return this.connect(1, ir, false);
    }

    public Wrj4P5 connect(int n) {
        return this.connect(n, false, false);
    }

    public Wrj4P5 connect(int n, boolean ir) {
        return this.connect(n, ir, false);
    }

    public Wrj4P5 connect(int n, boolean ir, boolean log) {
        return this.connect(n, ir, log, 2);
    }

    public Wrj4P5 connect(int n, boolean ir, boolean log, int sense) {
        this.isIR = ir;
        this.irSens = Math.max(4, Math.min(0, sense));
        URL resource = null;
        Image img = null;
        try {
            if (log) {
                WiiRemoteJ.setConsoleLoggingAll();
            } else {
                WiiRemoteJ.setConsoleLoggingOff();
            }
            WiiRemoteJ.findDevices((WiiDeviceDiscoveryListener)this, (int)Integer.MAX_VALUE, (int)(n > 0 && n < 8 ? n : 1));
            System.out.println("trying to find a wii");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (waitingImg == null) {
            File f = new File(String.valueOf(this.parent.online ? "" : this.parent.sketchPath("")) + "data/WiiStart.jpg");
            if (f.exists()) {
                try {
                    resource = f.toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else {
                resource = this.getClass().getResource("WiiStart.jpg");
            }
            if (this.parent.online && resource != null) {
                img = this.parent.getImage(resource);
            } else if (resource != null) {
                img = Toolkit.getDefaultToolkit().getImage(resource);
            }
            if (img != null) {
                waitingImg = this.parent.loadImageSync(img);
            }
        }
        return this;
    }

    public void wiiDeviceDiscovered(WiiDeviceDiscoveredEvent evt) {
        int id = evt.getNumber();
        WiiDevice found = evt.getWiiDevice();
        if (found instanceof WiiRemote) {
            id = rCount++;
            ((WiiRemote)found).addWiiRemoteListener((WiiRemoteListener)rims[id]);
            rims[id].addTalker((WiiRemote)found, id, this.isIR, this.irSens);
            System.out.println("Discover Remote called # " + id);
        } else if (found instanceof BalanceBoard) {
            id = bCount++;
            ((BalanceBoard)found).addBalanceBoardListener((BalanceBoardListener)brds[id]);
            brds[id].addTalker((BalanceBoard)found, id);
            System.out.println("Discover Board called # " + id);
        }
        ++dCount;
    }

    public void findFinished(int numberFound) {
        dCount = numberFound + 1;
    }

    public WiiBoard board(int bid) {
        return bid >= 0 && bid < bCount ? brds[bid] : board;
    }

    public WiiRimokon rimokon(int rid) {
        return rid >= 0 && rid < rCount ? rims[rid] : rimokon;
    }

    public WiiNunchaku nunchaku(int rid) {
        return rid >= 0 && rid < rCount ? Wrj4P5.rims[rid].nunchaku : nunchaku;
    }

    public WiiKurakon kurakon(int rid) {
        return rid >= 0 && rid < rCount ? Wrj4P5.rims[rid].kurakon : kurakon;
    }

    public WiiGuitar guitar(int rid) {
        return rid >= 0 && rid < rCount ? Wrj4P5.rims[rid].guitar : guitar;
    }

    public void disconnected(int rid) {
        try {
            if (this.disconnected != null) {
                this.disconnected.invoke((Object)this.parent, new Integer(rid));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.disconnected = null;
        }
    }

    public void exDisconnected(int rid) {
        try {
            if (this.exDisconnected != null) {
                this.exDisconnected.invoke((Object)this.parent, new Integer(rid));
            }
        }
        catch (Exception e) {
            System.err.println("Disabling controller() for " + this.parent.getName() + " because of an error.");
            e.printStackTrace();
            this.exDisconnected = null;
        }
    }

    public void pre() {
    }

    public void dispose() {
        int i = 0;
        while (i < rCount) {
            rims[i].disconnect();
            ++i;
        }
        i = 0;
        while (i < bCount) {
            brds[i].disconnect();
            ++i;
        }
    }

    public boolean isConnecting() {
        if (dCount > 0) {
            return false;
        }
        this.parent.background(0);
        if (waitingImg != null) {
            this.parent.image(waitingImg, (float)(this.parent.width / 2 - Wrj4P5.waitingImg.width / 2), (float)(this.parent.height / 2 - Wrj4P5.waitingImg.height / 2));
        }
        return true;
    }
}

