/*
 * Copyright (C) 2012 Tatsuya Yagi(himrock922).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Libxcast routeine, Mostly based on /libxcast/libxcast.h.
 */

/*
 * Copyright (C) 2001 FUJITSU LABORATRIES LTD.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*****************************/
/* libxcastをRubyで読むための   */
/* ソースファイル               */
/*****************************/

/*---------------------------*/
/*     ライブラリの読込      */
/*---------------------------*/

#include "ruby.h"
#include "libxcast.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <assert.h>
#include <string.h>
/*---------------------------*/
/*      defineの定義         */
/*---------------------------*/

#define ARGUMENT        1
#define TWO_ARGUMENT    2
#define THIRD_ARGUMENT  3
#define FIVE_ARGUMENT   5

static struct xcast_member xm;
static char buf[256];
/*****************************/
/*       moduleの作成        */
/*****************************/

/*---------------------------*/
/* xcast_member構造体の作成  */
/*---------------------------*/
static
VALUE XMember(VALUE self ,VALUE addr,VALUE port)
{
  (struct aockaddr *)addr;
  xm.xm_dest=STR2CSTR(addr);
  xm.xm_dscp=NUM2INT(port);
}

/*----------------------------*/
/*       groupの作成          */
/*----------------------------*/
static
VALUE XCreateGroup(VALUE self, VALUE flagd, VALUE src, VALUE maxmbrs)
{
  if(XcastCreateGroup(
     NUM2INT(flagd),NULL,(unsigned short)NUM2INT(maxmbrs))==XCAST_SUCCESS)
    return INT2FIX(XCAST_SUCCESS); /* group作成成功 */
  else
    return INT2FIX(XCAST_FAILURE); /* group作成失敗 */
}

/*----------------------------*/
/*    setsockoptの作成        */
/*----------------------------*/
static
VALUE XSetSockOpt
(VALUE self,VALUE groupid,VALUE optlev,VALUE optname,VALUE optval,VALUE optlen)
{
  (char *)&optval;
  if(XcastSetSockOpt(
     NUM2INT(groupid),NUM2INT(optlev),NUM2INT(optname),
     (&optval), sizeof(NUM2INT(optlen)))==XCAST_SUCCESS)
    return INT2FIX(XCAST_SUCCESS); /* setsockopt成功  */
  else
    return INT2FIX(XCAST_FAILURE); /* setsockopt失敗  */
}
/*----------------------------*/
/* XcastAddMemberの作成       */
/*----------------------------*/
static
VALUE XAddMember(VALUE self, VALUE groupid)
{
    if(XcastAddMember(
		      NUM2INT(groupid),&xm) == XCAST_SUCCESS)
      return INT2FIX(XCAST_SUCCESS); /* addmember成功 */
    else
      return INT2FIX(XCAST_FAILURE); /* addmember失敗 */
}
/*----------------------------*/
/* XcastSendの作成            */
/*----------------------------*/
static 
VALUE XSend(VALUE self, VALUE groupid, VALUE datap)
{
  if(XcastSend(
	       NUM2INT(groupid),STR2CSTR(datap)) == XCAST_SUCCESS)
    return INT2FIX(XCAST_SUCCESS);/*Xsend成功*/
  else
    return INT2FIX(XCAST_FAILURE);/*Xsend失敗*/
}    

/*----------------------------*/
/* XastDeleteGroupの作成      */
/*----------------------------*/
static 
VALUE XDeleteGroup(VALUE self, VALUE groupid)
{
  if(XcastDeleteGroup(NUM2INT(groupid)) ==XCAST_SUCCESS)
    return INT2FIX(XCAST_SUCCESS); /* XDeleteGroup成功 */
  else
    return INT2FIX(XCAST_FAILURE); /* XdeleteGroup失敗 */
}

/**************************************/
/* Xcastライブラリ対応モジュールの作成*/
/**************************************/
void Init_xcast()
{
  VALUE module;
  module = rb_define_module("Xcast");      /* 関数の名前(Xcast) */ 
  rb_define_module_function(          
			    module,        /* モジュールの作成  */
			    "XMember",     /*                   */
			    XMember,       /*                   */ 
			    TWO_ARGUMENT   /*     (XMember)     */
				      );
                                                                      
  rb_define_module_function(
			    module,        /* モジュールの作成  */
			    "XCreateGroup",/*                   */
			    XCreateGroup,  /*                   */
			    THIRD_ARGUMENT /*   (XcreateGroup)  */
			    );
  
  rb_define_module_function(
			    module,       /* モジュールの作成  */
			    "XSetSockOpt",/*                   */
			    XSetSockOpt,  /*                   */
			    FIVE_ARGUMENT /*  (XsetSockOpt)    */
			    );
  
  rb_define_module_function(
			    module,       /* モジュールの作成 */
			    "XAddMember", /*                  */
			    XAddMember,   /*                  */
			    ARGUMENT      /* (XAddMember)     */
			    );
  rb_define_module_function(
			    module,       /* モジュールの作成 */
			    "XSend",      /*                  */
			    XSend,        /*                  */
			    TWO_ARGUMENT/*                  */
			    );            /* (XSend)          */
  rb_define_module_function(
			    module,        /* モジュールの作成 */
			    "XDeleteGroup",/*                  */
			    XDeleteGroup,  /*                  */
			    ARGUMENT       /*                  */
			    );             /* (XDeleteGroup)   */
}		
