/*
 * Copyright (C) 2001 FUJITSU LABORATRIES LTD.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Some parts of this file are took from header files of NetBSD. */
/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright (c) 1982, 1985, 1986, 1988, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


#ifndef _WINGLUE_H_
#define _WINGLUE_H_

/*
 * BSD-compatible typedefs.
 */
typedef char int8_t;
typedef short int16_t;
typedef long int32_t;
typedef __int64 int64_t;
typedef unsigned char u_int8_t;
typedef unsigned short u_int16_t;
typedef unsigned long u_int32_t;
typedef unsigned __int64 u_int64_t;

typedef char *caddr_t;

/*
 * Packet header structures
 */

/* Header types. */
#ifndef IPPROTO_HOPOPTS
#define IPPROTO_HOPOPTS		0
#endif
#ifndef IPPROTO_ROUTING
#define IPPROTO_ROUTING		43
#endif
#ifndef IPPROTO_DSTOPTS
#define IPPROTO_DSTOPTS		60
#endif

/* IP6 headers. took from netinet/ip6.h in NetBSD 1.5.2 */
struct ip6_hdr {
	union {
		struct ip6_hdrctl {
			u_int32_t ip6_un1_flow;	/* 20 bits of flow-ID */
			u_int16_t ip6_un1_plen;	/* payload length */
			u_int8_t  ip6_un1_nxt;	/* next header */
			u_int8_t  ip6_un1_hlim;	/* hop limit */
		} ip6_un1;
		u_int8_t ip6_un2_vfc;	/* 4 bits version, top 4 bits class */
	} ip6_ctlun;
	struct in6_addr ip6_src;	/* source address */
	struct in6_addr ip6_dst;	/* destination address */
};

#define ip6_vfc		ip6_ctlun.ip6_un2_vfc
#define ip6_flow	ip6_ctlun.ip6_un1.ip6_un1_flow
#define ip6_plen	ip6_ctlun.ip6_un1.ip6_un1_plen
#define ip6_nxt		ip6_ctlun.ip6_un1.ip6_un1_nxt
#define ip6_hlim	ip6_ctlun.ip6_un1.ip6_un1_hlim
#define ip6_hops	ip6_ctlun.ip6_un1.ip6_un1_hlim

#define IPV6_VERSION		0x60
#define IPV6_VERSION_MASK	0xf0

#if BYTE_ORDER == BIG_ENDIAN
#define IPV6_FLOWINFO_MASK	0x0fffffff	/* flow info (28 bits) */
#define IPV6_FLOWLABEL_MASK	0x000fffff	/* flow label (20 bits) */
#else
#if BYTE_ORDER == LITTLE_ENDIAN
#define IPV6_FLOWINFO_MASK	0xffffff0f	/* flow info (28 bits) */
#define IPV6_FLOWLABEL_MASK	0xffff0f00	/* flow label (20 bits) */
#endif /* LITTLE_ENDIAN */
#endif
#if 1
/* ECN bits proposed by Sally Floyd */
#define IP6TOS_CE		0x01	/* congestion experienced */
#define IP6TOS_ECT		0x02	/* ECN-capable transport */
#endif

struct	ip6_ext {
	u_char	ip6e_nxt;
	u_char	ip6e_len;
};

struct ip6_hbh {
	u_int8_t ip6h_nxt;	/* next header */
	u_int8_t ip6h_len;	/* length in units of 8 octets */
	/* followed by options */
};

struct ip6_dest {
	u_int8_t ip6d_nxt;	/* next header */
	u_int8_t ip6d_len;	/* length in units of 8 octets */
	/* followed by options */
};

#define IP6OPT_PAD1		0x00	/* 00 0 00000 */
#define IP6OPT_PADN		0x01	/* 00 0 00001 */

/* UDP header. took from netinet/udp.h in NetBSD 1.5.2 */
struct udphdr {
	u_int16_t uh_sport;		/* source port */
	u_int16_t uh_dport;		/* destination port */
	u_int16_t uh_ulen;		/* udp length */
	u_int16_t uh_sum;		/* udp checksum */
};


/* XCAST6 headers. */
#define XCAST6_DESTOPT		/* Support for XCAST6 destination option */

#define	IPV6_RTHDR_TYPE_XCAST6		0x11	/* XXX  needs to register */
#define	IP6OPT_TYPE_XCAST6		0x27	/* XXX  needs to register */

/* XXX  this address is not registered... */
#define IN6ADDR_ALL_XCAST6_ROUTERS_INIT	\
	{ 0xff, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, \
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10 }


/* XXX  Actually 0x7f, but limitation from the mbuf size */
#define XCAST6_MAX_DESTS		0x7e

/* X2U support level */
#define XCAST6_X2U_NEVER		0	/* no X2U support. */
#define XCAST6_X2U_SINGLEDEST		1	/* single dest. packet only. */
#define XCAST6_X2U_PREMATURE		2	/* every packet. N/A yet. */
typedef struct xcast6_rthdr {
	u_int8_t  x6r_nxt;	/* next header */
	u_int8_t  x6r_len;	/* length in units of 8 octets */
	u_int8_t  x6r_type;	/* IPV6_RTHDR_TYPE_XCAST */
	u_int8_t  x6r_reserved;	/* reserved */
	u_int8_t  x6r_flags;	/* version, anonymity, Xcast, DSCP */
	u_int8_t  x6r_ndest;	/* # of destinations */
	u_int16_t x6r_cksum;	/* checksum; 1's complement */
	u_int8_t  x6r_chid[16];	/* channel identifier */
	/* followed by a bitmap and destionation addresses */
} xcast6_rthdr_t;

#define	XCAST6_VERSION			1
#define	XCAST6_RTHDR_VERSION_MASK	0xf0
#define	XCAST6_RTHDR_VERSION_SHIFT	4
#define XCAST6_RTHDR_ANON		0x08
#define XCAST6_RTHDR_DONTX2U		0x04
#define XCAST6_RTHDR_DSCP		0x02

/* The size of a bitmap in routing header. */
#define	XCAST6_BM_SIZE(ndest)	(((((ndest) + 7) / 8) + 7) & ~7)
#define XCAST6_RTHDRLEN(ndest)		\
	(sizeof(xcast6_rthdr_t) +	\
	 XCAST6_BM_SIZE(ndest) +	\
	 sizeof(struct in6_addr) * (ndest))

/* Xcast6 Hop-by-Hop options header */
typedef struct xcast6_hbh {
	u_int8_t  x6h_type;		/* IP6OPT_TYPE_XCAST6 */
	u_int8_t  x6h_optdlen;		/* >= 0 */
	/* Xcast hop-by-hop extensions follow... */
} xcast6_hbh_t;

#define XCAST6_HBH_OPTLEN	(sizeof(xcast6_hbh_t) - 2)
#define XCAST6_HBH_HDRLEN		\
	((sizeof(struct ip6_hbh) + sizeof(xcast6_hbh_t) + 7) & ~7)

/* Xcast6 destination options header */
typedef struct xcast6_dest {
	u_int8_t  x6d_type;		/* IP6OPT_TYPE_XCAST6 */
	u_int8_t  x6d_optdlen;		/* >= 0 */
	/* Xcast destination ports follow... */
} xcast6_dest_t;

#define XCAST6_DEST_HDRLEN(ndest)		\
	((sizeof(struct ip6_dest) +		\
	  sizeof(xcast6_dest_t) +		\
	  sizeof(u_int16_t) * (ndest) + 7) & ~7)

/*
 * msghdr, cmsghdr, and CMSG_* stuff.
 */

/* took from sys/uio.h in NetBSD 1.5.2 */
struct iovec {
	void	*iov_base;	/* Base address. */
	size_t	 iov_len;	/* Length. */
};

/* took from sys/socket.h in NetBSD 1.5.2 */
struct msghdr {
	void		*msg_name;	/* optional address */
	socklen_t	msg_namelen;	/* size of address */
	struct iovec	*msg_iov;	/* scatter/gather array */
	int		msg_iovlen;	/* # elements in msg_iov */
	void		*msg_control;	/* ancillary data, see below */
	socklen_t	msg_controllen;	/* ancillary data buffer len */
	int		msg_flags;	/* flags on received message */
};

struct cmsghdr {
	socklen_t	cmsg_len;	/* data byte count, including hdr */
	int		cmsg_level;	/* originating protocol */
	int		cmsg_type;	/* protocol-specific type */
/* followed by	u_char  cmsg_data[]; */
};

#define	CMSG_DATA(cmsg) \
	((u_char *)(cmsg) + __CMSG_ALIGN(sizeof(struct cmsghdr)))
#define __CMSG_ALIGN(n)	(((n) + 7) & ~7)

#define	CMSG_NXTHDR(mhdr, cmsg)	\
	(((caddr_t)(cmsg) + __CMSG_ALIGN((cmsg)->cmsg_len) + \
			    __CMSG_ALIGN(sizeof(struct cmsghdr)) > \
	    (((caddr_t)(mhdr)->msg_control) + (mhdr)->msg_controllen)) ? \
	    (struct cmsghdr *)NULL : \
	    (struct cmsghdr *)((caddr_t)(cmsg) + __CMSG_ALIGN((cmsg)->cmsg_len)))

#define	CMSG_FIRSTHDR(mhdr)	((struct cmsghdr *)(mhdr)->msg_control)

#define CMSG_SPACE(l)	(__CMSG_ALIGN(sizeof(struct cmsghdr)) + __CMSG_ALIGN(l))
#define CMSG_LEN(l)	(__CMSG_ALIGN(sizeof(struct cmsghdr)) + (l))

/* cmsg_type field.  Only defined for avoiding unnesessary. */
#ifndef IPV6_PKTINFO
#define IPV6_PKTINFO		0	/* dummy */
#endif
#ifndef IPV6_HOPOPTS
#define IPV6_HOPOPTS		0	/* dummy */
#endif
#ifndef IPV6_RTHDR
#define IPV6_RTHDR		0	/* dummy */
#endif
#ifndef IPV6_DSTOPTS
#define IPV6_DSTOPTS		0	/* dummy */
#endif

/* took from netinet6/in6.h in NetBSD 1.5.2 */
struct in6_pktinfo {
	struct in6_addr	ipi6_addr;	/* src/dst IPv6 address */
	unsigned int	ipi6_ifindex;	/* send/recv interface index */
};


#endif /* _WINGLUE_H_ */
