#include "itext.h"

#include <wkf.h>

static unsigned int SPACE = ' ';
static unsigned int CHU_KEY_C1 = 0xa2;
static unsigned int CHU_KEY_C2 = 0xf6;
static unsigned char *CHU_SMALL_STR0 = "";
static unsigned char *CHU_SMALL_STR1 = "";
static unsigned char *CHU_SMALL_STR2 = "";
static unsigned char *CHU_SMALL_STR3 = "";
static unsigned char *CHU_BOUTEN_STR = "˵";

static IBUF_T *ibuf_data_alloc()
{
	IBUF_T *it;

	it = (IBUF_T *)malloc(sizeof(IBUF_T));

	it->line = 0;
	it->buf = NULL;
	it->i_head = NULL;
	it->i_tail = NULL;

	return it;
}
static void ibuf_data_add(IBUF_T **start,IBUF_T **end,IBUF_T *mg)
{
	if(*end){
		mg->next = NULL;
		mg->prev = *end;

		(*end)->next = mg;
		*end = mg;
	}else{
		mg->next = NULL;
		mg->prev = NULL;

		*end = mg;
		*start = mg;
	}
}
void ibuf_data_free(IBUF_T *start,IBUF_T *end)
{
	IBUF_T *ib,*ibb;
	ITEXT_T *it,*itt;

	if(start == NULL) return;

	for(ib=start;ib!=NULL;ib=ibb){
		ibb = ib->next;

		for(it=ib->i_head;it!=NULL;it=itt){
			itt = it->next;
			free(it);
		}

		free(ib);
	}

	return;
}
static void itext_data_free(ITEXT_T *ihead)
{
	ITEXT_T *it,*itt;

	for(it=ihead;it!=NULL;it=itt){
		itt = it->next;
		if(it->rubi_head != NULL) itext_data_free(it->rubi_head);
		if(it->chu_head != NULL) itext_data_free(it->chu_head);

		free(it);
	}

	return ;
}
static ITEXT_T *itext_data_alloc()
{
	ITEXT_T *it;

	it = (ITEXT_T *)malloc(sizeof(ITEXT_T));
	it->c1 = ' ';
	it->c2 = ' ';

	it->ej = 0;
	it->chu = 0;
	it->bouten = 0;
	it->small = 0;

	it->rubi_head = NULL;
	it->rubi_tail = NULL;

	it->chu_head = NULL;
	it->chu_tail = NULL;

	return it;
}
static void itext_data_add(ITEXT_T **start,ITEXT_T **end,ITEXT_T *mg)
{
	if(*end){
		mg->next = NULL;
		mg->prev = *end;

		(*end)->next = (ITEXT_T *)mg;
		*end = mg;
	}else{
		mg->next = NULL;
		mg->prev = NULL;

		*end = mg;
		*start = mg;
	}
}
static int _change_c(unsigned int *c1,unsigned int *c2,unsigned int *c3)
{
	switch(*c2){
		case 0x2d: /* - */
			*c2 = 0x7c; /* | */
		break;
	}

	return 0;
}
static int _ibuf_add(	IBUF_T **head,
			IBUF_T **tail,
			ITEXT_T **ihead,
			ITEXT_T **itail,
			unsigned char *s,
			int i,
			int line	)
{
	IBUF_T *ib;

	ib = (IBUF_T *)ibuf_data_alloc();
	ib->buf = (unsigned char *)malloc(i + 2);
	strcpy(ib->buf,s);
	ib->line = line;
	ib->i_head = *ihead;
	ib->i_tail = *itail;
	ibuf_data_add(head,tail,ib);

	*ihead = NULL;
	*itail = NULL;

	return 0;
}
static int _no_k(unsigned char *s)
{
	int i;
	unsigned char *p;

	for(p=s,i=0;*p;p++,i++){
		if(*p == '\r' || *p == '\n'){
			*p = '\0';
			break;
		}
	}

	return i;
}
int _checkFileType(char *fname)
{
	char *p;
	int i;

	for(i=strlen(fname)-1;i>0;i--){
		if(*(fname+i) == '/') break;
	}
	for(p=fname+i;*p;p++){
		if(*p == '.') break;
	}

	if(strcmp(p,".txt")==0 || strcmp(p,".TXT")==0 || strcmp(p,".text")==0 || strcmp(p,".TEXT")==0) return 0;

	if(strcmp(p,".zip")==0 || strcmp(p,".ZIP")==0 || strcmp(p,".Zip")==0) return 1;

	return -1;

}
static int _itext_data_insert(	ITEXT_T **ihead,
				ITEXT_T **itail,
				unsigned int c1,
				unsigned int c2,
				int ej,
				int chu,
				int small,
				iconv_t con		)
{
	ITEXT_T *it;
	char temp[3],*utf8 = NULL;

	if(ej == 1){
		temp[0] = c1;
		temp[1] = c2;
		temp[2] = '\0';

		utf8 = (char *)euc2utf8(con,temp,2);
	}

	it = (ITEXT_T *)itext_data_alloc();
	it->c1 = c1;
	it->c2 = c2;
	it->utf8 = utf8;
	it->ej = ej;
	it->chu = chu;
	it->small = small;
	itext_data_add(ihead,itail,it);

	return 0;
}
static int _check_chu_string(iconv_t con,unsigned char *line_str,int i,ITEXT_T **ihead,ITEXT_T **itail,int *small)
{
	ITEXT_T *chu,*it,*chu_head,*chu_tail;
	ITEXT_T *bt,*bouten_head = NULL, *bouten_tail = NULL;
	unsigned char temp[BUFSIZ];
	int a,flag;

	if(*itail == NULL) return i;
	chu_head = (*itail)->chu_head;

	a=0;
	for(chu=chu_head;chu!=NULL;chu=chu->next){
		temp[a++] = chu->c1;
		temp[a++] = chu->c2;
	}
	temp[a] = '\0';

	if(strstr(temp,CHU_BOUTEN_STR) != NULL){

		flag = 0;
		for(chu=chu_head;chu!=NULL;chu=chu->next){
			if((chu->c1 == 0xa1) && (chu->c2 == 0xd6)){
			       	flag = 1;
				continue;
			}
			if((chu->c1 == 0xa1) && (chu->c2 == 0xd7) && flag) break;

			if(flag){
			       	_itext_data_insert(&bouten_head,&bouten_tail,chu->c1,chu->c2,0,0,0,con);
			}
		}
		if(bouten_head == NULL) goto add_string;

		chu_tail = *itail;
		for(bt=bouten_tail;bt!=NULL;bt=bt->prev){
			for(chu=chu_tail;chu!=NULL;chu=chu->prev){
				if((bt->c1 == chu->c1) && (bt->c2 == chu->c2)){
					chu->bouten = 1;
					break;
				}
			}
		}
		itext_data_free(bouten_head);
		return i;

	}else if((*itail)->c1 == CHU_KEY_C1 && (*itail)->c2 == CHU_KEY_C2){

			if(	strstr(temp,CHU_SMALL_STR0) != NULL && 
				strstr(temp,CHU_SMALL_STR1) != NULL 		){

				(*itail)->small = 1;
				*small = 1;
				return i;
			}
			if(	strstr(temp,CHU_SMALL_STR2) != NULL && 
				strstr(temp,CHU_SMALL_STR3) != NULL		){
			
				*small = 0;
				return i;
			}
	}


add_string :
	for(chu=chu_head;chu!=NULL;chu=chu->next){

		*(line_str + (i++)) = chu->c1;
		*(line_str + (i++)) = chu->c2;

		_itext_data_insert(ihead,itail,chu->c1,chu->c2,1,1,*small,con);

	}
	return i;
}
int itextGetTextData(char *fname,char *title,IBUF_T **head,IBUF_T **tail,int ruby_on)
{
	iconv_t con;

	FILE *fp;
	unsigned char *p;
	unsigned char buf[BUFSIZ];
	unsigned char buf_euc[BUFSIZ];
	unsigned char line_str[BUFSIZ];

	IBUF_T *ib;
	ITEXT_T *it,*rb,*chu;
	ITEXT_T *ihead = NULL;
	ITEXT_T *itail = NULL;

	unsigned int c1;
	unsigned int c2;

	int slen;
	int i;
	int total_line = 1;
	int file_type;
	char zipfname[256];

	int RUBI=0;
	int CHU=0;
	int SMALL=0;


	file_type = _checkFileType(fname);

	if(file_type == 0){
		if((fp = fopen(fname,"r")) == NULL) return -1;

	}else if(file_type == 1){

		if(itextUnZipFile(fname,zipfname) < 0) return -1;
		if((fp = fopen(zipfname,"r")) == NULL) return -1;
	}else{
		return -1;
	}

	con = iconv_open("UTF-8","EUC-JP");

	while(fgets(buf,BUFSIZ,fp) != NULL){

		wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,buf_euc,BUFSIZ);

		if((slen = _no_k(buf_euc)) == 0){
			line_str[0] = '\0';
			_ibuf_add(head,tail,&ihead,&itail,line_str,0,total_line++); 
		}
		if(total_line == 1) strcpy(title,buf_euc);

		i=0;
		for(p=buf_euc;*p;p++){
			if(*p & 0x80){
				c1 = *p++;
				c2 = *p;

				if(ruby_on){if(c1 == 0xa1 && c2 == 0xd4){ RUBI=1;continue;}} 

				if(c1 == 0xa1 && c2 == 0xd5 && RUBI){ RUBI=0;continue;}

				if(ruby_on){
					if(c1 == 0xa1 && c2 == 0xce && CHU == 0){
						if(*(p+1) == 0xa1 && *(p+2) == 0xf4){
					       		CHU = 1;
							continue;
						}
					}
				}
				if(c1 == 0xa1 && c2 == 0xcf && CHU == 1){

					i = _check_chu_string(con,line_str,i,&ihead,&itail,&SMALL);

				       	CHU = 0;
					continue;
				}


				if(RUBI){
					_itext_data_insert(&itail->rubi_head,&itail->rubi_tail,c1,c2,1,0,0,con);

				}else if(CHU){
					if(itail != NULL){
						_itext_data_insert(&itail->chu_head,&itail->chu_tail,c1,c2,1,0,0,con);
					}else{
						line_str[i++] = CHU_KEY_C1;
						line_str[i++] = CHU_KEY_C2;

						_itext_data_insert(&ihead,&itail,CHU_KEY_C1,CHU_KEY_C2,1,1,SMALL,con);
						_itext_data_insert(&itail->chu_head,&itail->chu_tail,c1,c2,0,0,0,con);
					}

				}else{
					line_str[i++] = c1;
					line_str[i++] = c2;

					_itext_data_insert(&ihead,&itail,c1,c2,1,0,SMALL,con);

				}

			}else{
				if(*p == '\t'){
					int xj;
					for(xj=0;xj<4;xj++){
						line_str[i++] = SPACE; 
						c1 = SPACE;
						c2 = SPACE;

						_itext_data_insert(&ihead,&itail,c1,c2,0,0,SMALL,con);
					}
				}else{

					line_str[i++] = *p; 
					c1 = *p;
					c2 = SPACE;

					_itext_data_insert(&ihead,&itail,c1,c2,0,0,SMALL,con);
				}

			}
			
		}
		if(i > 0){
			line_str[i] = '\0';
			_ibuf_add(head,tail,&ihead,&itail,line_str,i,total_line++); 
		}

	}

	fclose(fp);
	iconv_close(con);

	if(file_type == 1) unlink(zipfname);

	return total_line;
}
