/********************************
 * 2005/3/21
 * *****************************/

#include "xtext.h"

#include <stdarg.h>
#include <locale.h>

#define debug 0

char *XJP_MESSAGE[] = {
        "ˡ Ϥߤޤ",
        "¸ʸˤ̵ѥǤ",
        "٤Ϥޤ줿޽ϡޤ",
        "¸ޤ",
	"ǡ顼ȯޤ",
        "ե륨顼ȯޤ"
};
char *SELECTOR_BACKGROUND_COLOR = NULL;
char *SELECTOR_FOREGROUND_COLOR = NULL;
char *SELECTOR_SELECTFONT_COLOR = NULL;

extern int opterr;
extern int optind;
extern char *optarg;
extern int getopt(int argc,char * const * argv,const char * pattern);

static Display *disp;
static Window root;
static my_window_t main_win;

static xtext_siori_t *siori_head = NULL, *siori_tail = NULL;
static sub_window_t *book_head = NULL,*book_tail = NULL,*bh;
static sub_window_t *si_head = NULL,*si_tail = NULL;
static sub_window_t *help_head = NULL, *help_tail = NULL;

static IBUF_T *line_head = NULL, *line_tail = NULL;
static page_data_t *char_p;
static int NPC = 0;

static char_data_t char_d = {
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		-1,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL	
};
static xtext_conf_t xconf_default = {
	500,
	400,
	"lavender",
	"Black",
	"gray60",
	"SteelBlue",
	"SteelBlue",
	"White",
	"RoyalBlue4",
	"snow",
	"salmon4",
	"-misc-fixed-*-*-*-*-14-*-*-*-*-*-*-*",
	"-misc-fixed-*-*-*-*-14-*-*-*-*-*-iso8859-*",
	"-misc-*-*-*-*-*-12-*-*-*-*-*-*-*",
	"/home/***/***/book/",
	"-misc-*-*-*-*-*-10-*-*-*-*-*-*-*",
	0,
	1,
	1,
	0,
	0,
	"Down",
	"Up",
	"h",
	"space",
	"s",
	"q",
	"f",
	"Tab"	
};
static xtext_conf_t xconf;

static void _usage()
{
	fprintf(stderr,"\n");
	fprintf(stderr,"    %s  Version : %s\n\n",XTEXT_NAME,XTEXT_VERSION);
	fprintf(stderr,"Usage:	xtext [option] filename\n\n");
	fprintf(stderr,"[option]\n");
	fprintf(stderr,	
"   -h       Help Message\n \
  -d <dir>   Book Directory\n \
  -f <file>  Book(.txt|.zip) Path\n \
  -a <num>   Window Width\n \
  -b <num>   Window Height\n \
  -c <str>   Main Window-Color (X11 Color_Name)\n \
  -e <str>   Main Font-Color (X11 Color_Name)\n \
  -g <str>   Ruby Font-Color (X11 Color_Name)\n \
  -i <str>   Message Font-Color (X11 Color_Name)\n \
  -j <str>   Message Window-Color (X11 Color_Name)\n \
  -k <str>   Main Font_Name (Xlfd format)\n \
  -l <str>   Sub Font_Name (Xlfd format)\n \
  -m <str>   1Byte Font_Name (xlfd format)\n \
  -n <str>   Ruby Font_Name (xlfd format)\n \
  -o         Use Xft ?\n \
  -p <num>   Line Space (Pixel)\n \
  -q <num>   Row Space (Pixel)\n \
  -r         Display Book_Title ?\n \
					 ");
	fprintf(stderr,"\n");

	exit(1);
}	
static void _set_util()
{
	main_win.title_on = xconf.title_on;
	main_win.anti = xconf.anti;
}
static void _set_window()
{
	XSetWindowBackground(disp,main_win.win,main_win.bg_pixel);
	XClearWindow(disp,main_win.win);
}
static void _x_init()
{
	setlocale(LC_ALL,"");

	disp = XOpenDisplay(NULL);
	root = DefaultRootWindow(disp);
	main_win.cmap = DefaultColormap(disp,0);
	main_win.visual = DefaultVisual(disp,0);

	main_win.gc = XCreateGC(disp,root,0,0);
	main_win.bgc = XCreateGC(disp,root,0,0);
	main_win.fgc = XCreateGC(disp,root,0,0);
	main_win.rfgc = XCreateGC(disp,root,0,0);
	main_win.rubi_gc = XCreateGC(disp,root,0,0);
	main_win.sgc = XCreateGC(disp,root,0,0);
}
static void _x_drawable()
{
	int w,h;
	long fg,bg;

	main_win.width = xconf.main_window_width;
	main_win.height = xconf.main_window_height;

	w = main_win.width;
	h = main_win.height;
	fg = 0;
	bg = 0;

	main_win.win = XCreateSimpleWindow(disp,root,0,0,w,h,0,fg,bg);

	XSelectInput(disp,main_win.win,	ExposureMask|StructureNotifyMask|ButtonPressMask|KeyPressMask);

	XMapWindow(disp,main_win.win);
#if HAVE_LIBXFT
	main_win.draw = XftDrawCreate(disp,main_win.win,main_win.visual,main_win.cmap);
#endif
}
static void _set_color()
{
	XColor bg0,bg1;
	XColor fg0,fg1;
	XColor menu_font_color0,menu_font_color1;
	XColor menu_window_color0,menu_window_color1;
	XColor rubi_fg0,rubi_fg1;
	XColor shadow_fg0,shadow_fg1;

	XAllocNamedColor(disp,main_win.cmap,xconf.main_font_color,&fg1,&fg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.main_window_color,&bg1,&bg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.menu_font_color,&menu_font_color1,&menu_font_color0);
	XAllocNamedColor(disp,main_win.cmap,xconf.menu_window_color,&menu_window_color1,&menu_window_color0);
	XAllocNamedColor(disp,main_win.cmap,xconf.rubi_font_color,&rubi_fg1,&rubi_fg0);
	XAllocNamedColor(disp,main_win.cmap,xconf.main_shadow_color,&shadow_fg1,&shadow_fg0);

	XSetForeground(disp,main_win.gc,fg1.pixel);
	XSetForeground(disp,main_win.bgc,bg1.pixel);
	XSetForeground(disp,main_win.fgc,menu_font_color1.pixel);
	XSetForeground(disp,main_win.rfgc,menu_window_color1.pixel);
	XSetForeground(disp,main_win.rubi_gc,rubi_fg1.pixel);
	XSetForeground(disp,main_win.sgc,shadow_fg1.pixel);

	XSetBackground(disp,main_win.gc,bg1.pixel);
	XSetBackground(disp,main_win.bgc,fg1.pixel);
	XSetBackground(disp,main_win.fgc,menu_window_color1.pixel);
	XSetBackground(disp,main_win.rfgc,menu_font_color1.pixel);

	main_win.fg_pixel = fg1.pixel;
	main_win.bg_pixel = bg1.pixel;
	main_win.menu_fg_pixel = menu_font_color1.pixel;
	main_win.menu_bg_pixel = menu_window_color1.pixel;


#if HAVE_LIBXFT
	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.main_window_color,&(main_win.bg_color));
	main_win.bg_color.color.alpha = 0xFFFF;

	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.main_font_color,&(main_win.fg_color));
	main_win.fg_color.color.alpha = 0xFFFF;

	XftColorAllocName(disp,main_win.visual,main_win.cmap,xconf.rubi_font_color,&(main_win.rubi_color));
	main_win.fg_color.color.alpha = 0xCCCC;
#endif

	SELECTOR_BACKGROUND_COLOR = (char *)xconf.select_window_color;
	SELECTOR_FOREGROUND_COLOR = (char *)xconf.select_font_color;
	SELECTOR_SELECTFONT_COLOR = (char *)xconf.select_font_background_color;
}
static void _set_font()
{
	char font_str[200],font_e[100];
	char **miss,*def;
	int n_miss;

	xtext_font_J2E(xconf.main_font_j,font_e);
	sprintf(font_str,"%s,%s",xconf.main_font_j,font_e);
	main_win.fs = XCreateFontSet(disp,font_str,&miss,&n_miss,&def);

	main_win.fs_e = XCreateFontSet(disp,xconf.main_font_e,&miss,&n_miss,&def);

	xtext_font_J2E(xconf.main_font_s,font_e);
	sprintf(font_str,"%s,%s",xconf.main_font_s,font_e);
	main_win.fs_s = XCreateFontSet(disp,font_str,&miss,&n_miss,&def);

	main_win.rubi_fs = XCreateFontSet(disp,xconf.rubi_font,&miss,&n_miss,&def);

#if HAVE_LIBXFT
	main_win.font = XftFontOpenXlfd(disp,0,xconf.main_font_j);
	main_win.font_e = XftFontOpenXlfd(disp,0,xconf.main_font_e);
	main_win.font_s = XftFontOpenXlfd(disp,0,xconf.main_font_s);
	main_win.font_rubi = XftFontOpenXlfd(disp,0,xconf.rubi_font);
#endif

}
static void _set_char()
{
	char_d.xpad = xconf.line_space != -1 ? xconf.line_space:0;
	char_d.ypad = xconf.row_space != -1 ? xconf.row_space:0;
}
static void _set_xconf_data()
{
	_set_color();
	_set_window();

	_set_font();
	_set_char();
	_set_util();

	return ;
}
static page_data_t * _get_page_data(page_data_t *head,int no)
{
	page_data_t *p;

	for(p=head;p!=NULL;p=p->next){
		if(p->next == NULL) return p;

		if(no >= p->char_no && no < p->next->char_no) return p;
	}

	return head;
}
static page_data_t *_set_redraw_text()
{
	if(line_head == NULL) return NULL;

	xtext_get_charsize(disp,main_win,line_head,&char_d);

	char_p = _get_page_data(char_d.head,NPC);

	return char_p;
}
static int _init_book_data(char *book_name,int n)
{
	iconv_t con;
	char *utf8;
	unsigned char title[256];

#if debug
fprintf(stderr,"main_bookname : %s %d\n",book_name,n);
#endif

	NPC = n;

	if(line_head != NULL) ibuf_data_free(line_head,line_tail);
	if(char_d.book != NULL) free(char_d.book);

	con = iconv_open("UTF-8","EUC-JP");
	char_d.book = (book_data_t *)malloc(sizeof(book_data_t));

	line_head = NULL;
	line_tail = NULL;
	if(itextGetTextData(book_name,title,&line_head,&line_tail,xconf.ruby_on)<0) return -1;
#if debug
fprintf(stderr,"main_booktitle : %s\n",title);
#endif
	utf8 = (char *)euc2utf8(con,title,strlen(title));

	strcpy(char_d.book->book_path,book_name);
	strcpy(char_d.book->book_title,title);
	strcpy(char_d.book->book_title_utf8,utf8);

	char_p = (page_data_t *)_set_redraw_text();

	XStoreName(disp,main_win.win,book_name);

	if(utf8) free(utf8);
	iconv_close(con);

	return 0;

}
static int _help_book_data()
{
	char *result;

	xtextHelpData2Sub(&help_head,&help_tail,&xconf);

	if((result = xtextSubWindow(disp,main_win,help_head,help_tail))==NULL) return -1;

	if(strcmp(result,XJP_OK) == 0) return 1;

	return 0;
}
static void _select_book_data(char *book_dir)
{
	char *book_path;

#if debug
fprintf(stderr,"main_selectdir : %s\n",book_dir);
#endif
	xtextBookData2Sub(&book_head,&book_tail,book_dir);
	if(book_head == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[1]);
		return ;
	}

	if((book_path = (char *)xtextSubWindow(disp,main_win,book_head,book_tail)) == NULL)
		return ;

	if(strcmp(book_path,XJP_CANCEL) == 0) return;
#if debug
fprintf(stderr,"main_selectpath : %s\n",book_dir);
#endif
       	_init_book_data(book_path,0);

}
static void _siori_book_data()
{
	char *book_path;
	xtext_siori_t *si;

	xtextSioriData2Sub(&si_head,&si_tail,siori_head);
	if(si_head == NULL){
		xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[2]);
		return ;
	}

	if((book_path = (char *)xtextSubWindow(disp,main_win,si_head,si_tail)) == NULL) return ;

	if(strcmp(book_path,XJP_CANCEL) == 0) return;

	for(si=siori_head;si!=NULL;si=si->next){
		if(strcmp(si->book_path,book_path)==0){
			_init_book_data(book_path,si->NPC);
			return;
		}
	}

}
static int _xtext_event()
{
	XEvent ev;
	char *keyname;

	XNextEvent(disp,&ev);

	switch(ev.type){
		case Expose:
			if((NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p)) < 0) xtext_Draw_Help(disp,main_win,xconf);
		break;
		case ConfigureNotify:
			if(main_win.width != ev.xconfigure.width || main_win.height != ev.xconfigure.height){
				main_win.width = xconf.main_window_width = ev.xconfigure.width;
				main_win.height = xconf.main_window_height = ev.xconfigure.height;
				char_p = (page_data_t *)_set_redraw_text();
			}
		break;
		case KeyPress:
			keyname = (char *)XKeysymToString(XLookupKeysym(&ev.xkey,0)); 

			if(strcmp(keyname,xconf.menu)==0){
				_select_book_data(xconf.book_dir);
				xtext_siori_data_write(&siori_head,&siori_tail);

			}else if(strcmp(keyname,xconf.conf_page)==0){
				if(_help_book_data()){
					_set_xconf_data();
					char_p = (page_data_t *)_set_redraw_text();
				}

			}else if(strcmp(keyname,xconf.book_mark)==0){
			   	xtext_siori_data_mark(&siori_head,&siori_tail,char_d.book->book_path,char_d.book->book_title,NPC);
				xtextSubWindow_Message(disp,main_win,XJP_MESSAGE[0]);

			}else if(strcmp(keyname,xconf.siori_menu)==0){
				_siori_book_data();

			}else if(strcmp(keyname,xconf.quit)==0){
				return 0;

			}else if(strcmp(keyname,xconf.page_next)==0){
				if(line_head == NULL || char_p->next == NULL) break;

				char_p = char_p->next;
				NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);

			}else if(strcmp(keyname,xconf.page_prev)==0){
				if(line_head == NULL || char_p->prev == NULL) break;

				char_p = char_p->prev;
				NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);

			}else if(strcmp(keyname,xconf.title_key)==0){
				if(xconf.title_on)
				      	xconf.title_on = 0;
				else
					xconf.title_on = 1;	

				_set_util();

				NPC = xtext_Draw_Text(disp,main_win,line_head,char_d,char_p);
			}
		break;
	}

	return 1;
}
static char * _get_option(int c,char **v)
{
	int option;

	while(1){
		if((option = getopt(c,v,"a:b:c:d:e:f:g:i:j:k:l:m:no:p:qh")) == -1) break;
		switch(option){
			case 'h': _usage(); break;
			case 'f':return optarg;break;
			case 'd':strcpy(xconf.book_dir,optarg);break;

			case 'a':xconf.main_window_width = atoi(optarg);break;
			case 'b':xconf.main_window_height = atoi(optarg);break;
			case 'c':strcpy(xconf.main_window_color,optarg);break;
			case 'e':strcpy(xconf.main_font_color,optarg);break;
			case 'g':strcpy(xconf.rubi_font_color,optarg);break;
			case 'i':strcpy(xconf.menu_font_color,optarg);break;
			case 'j':strcpy(xconf.menu_window_color,optarg);break;
			case 'k':strcpy(xconf.main_font_j,optarg);break;
			case 'l':strcpy(xconf.main_font_s,optarg);break;
			case 'm':strcpy(xconf.main_font_e,optarg);break;
			case 'n':strcpy(xconf.rubi_font,optarg);break;
			case 'o':xconf.anti = 1;
			case 'p':xconf.line_space = atoi(optarg);break;
			case 'q':xconf.row_space = atoi(optarg);break;
			case 'r':xconf.title_on = 1;break;
			default: _usage(); break;
		}
	}

	return NULL;
}
int main(int argc,char *argv[])
{
	char *opt_book_path = NULL;
	int loop = 1;

	xtext_conf_data(&xconf,xconf_default);

	opt_book_path = (char *)_get_option(argc,argv);

	_x_init();
	_x_drawable();
	_set_xconf_data();

	if(opt_book_path != NULL) _init_book_data(opt_book_path,0);

	xtext_siori_data_read(&siori_head,&siori_tail);
	while(loop){
		while(XPending(disp)){
			loop = _xtext_event();
		}
		usleep(500);
	}
	xtext_siori_data_write(&siori_head,&siori_tail);

	return 0;
}

