#include "itext_html.h"
#include "../xjp.h"
#if HAVE_LIBWKF
#include <wkf.h>
#endif

int 
_test_02(FILE *fp,iconv_t icon,ICONTENT_T *book,int ruby_on,int buf_size,int file_size)
{
	itext_html_t *head = NULL, *tail = NULL, *ih;
	unsigned char *body = NULL, *tmp = NULL, *buf = NULL, *buf_euc = NULL;
	int header = 0, total_size = 0, tmp_size = 0, total = 0, tag = 0;
	int i,len;

	if(fp == NULL) return -1;
	if(itextBufferAlloc(&buf,&buf_euc,buf_size) < 0) return -1;

	while(fgets(buf,buf_size,fp) != NULL){
		total_size += (len = strlen(buf));
		xtext_usage(XJP_MESSAGE[7],(double)total_size / file_size,50);

		if(itextBufferOver(buf,len,buf_size)){
			if(itextBufferAlloc(&tmp,&buf_euc,tmp_size += buf_size * 2) < 0)
				return -1;
			sprintf(tmp,"%s%s",tmp,buf);
			continue;
		}
		if(tmp != NULL) len = itextBufferCat(&tmp,&buf,&buf_euc,&tmp_size);
#if HAVE_LIBWKF
                wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,buf_euc,len * 2);
#else
                itextConvKanjiCode(icon,buf_euc,buf,len);
#endif
		body = buf_euc;
		if(header == 0){
			if((body = (unsigned char *)_check_header(buf_euc)) != NULL){
				header = 1;
			}else{
				continue;
			}
		}
		tag = _test_func0(&head,&tail,body,tag);
		_test_func1(book,head,tail,total++); _itext_html_free(&head,&tail);
	}
	if(buf != NULL) free(buf);
	if(buf_euc != NULL) free(buf_euc);

	return total;
}
