#ifndef __ITEXT_H
#define __ITEXT_H 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define ChFlag(flag,n)  ((flag & (1 << n - 1)) ? 1 : 0)   
#define OnFlag(flag,n)  (flag |= (1 << n - 1))
#define OfFlag(flag,n)  (flag &= ~(1 << n - 1))
#define SetFlag(flag,n) (flag |= (n * 1024))
#define GetFlag(flag,n) (n = (short)(flag >> 10))
#define _EJC    1
#define _CHU    2
#define _SML    3
#define _LST    4
#define _TOP    5
#define _TEN    6
#define _SEN    7
#define _RUB    8
#define _FND    9
#define _KUN   10

typedef struct ITEXTR{
	unsigned char c1,c2;
	struct ITEXTR *next, *prev;
}ITEXTR_T;
typedef struct ITEXT{
	unsigned char c1,c2;
	char *chu_string;
	char off;
	short flag;
	ITEXTR_T *rubi_head,*rubi_tail;
	ITEXTR_T *chu_head,*chu_tail;
	struct ITEXT *next,*prev;
}ITEXT_T;
typedef struct OTHERFILEDATA{
	char *fname;
	struct OTHERFILEDATA *next,*prev;
}IOTHER_T;
typedef struct IBUF{
	short line;
	ITEXT_T *i_head,*i_tail;
	struct IBUF *next,*prev;
}IBUF_T;
typedef struct ICONTENTDATA{
	char *filename, *titlename;
	int total_line;
	IOTHER_T *o_head;
	IBUF_T *b_head,*b_tail;
}ICONTENT_T;
typedef struct SIORIDATA{
        int NPC;
        unsigned char book_path[256],book_title[256],book_time[256];
        struct SIORIDATA *next,*prev;
}ISIORI_T;
typedef struct BOOKFILEDATA{
        char fullpath[256],filename[256],title[256],person[256];
        int size,code;
	unsigned long fno;
	char *summary,*bookdir,*dbpath;
	ISIORI_T *siori;
        struct BOOKFILEDATA *next,*prev;
}IBOOK_T;
typedef struct PERSONFILEDATA{
	char *person;
	int no;
	IBOOK_T *head,*tail;
	struct PERSONFILEDATA *next,*prev;
}IPERSON_T;

int ibookGetBookData(IBOOK_T **,IBOOK_T **,char *);
int ibookGetPersonData(IPERSON_T **,IPERSON_T **,IBOOK_T *);
int ibookMatchFileData(IBOOK_T **,IBOOK_T **,IBOOK_T *,char *);
int itextGetTextData(ICONTENT_T *,int,int);
int itextGetStrData(unsigned char *,ITEXT_T **,ITEXT_T **,int *,int *,int *,int);
int itextGetTitleBuf(char *,char *,int);
int itextUnZipFile(char *,char **,IOTHER_T **);
int itextDataInsert(ITEXT_T **,ITEXT_T **,unsigned char ,unsigned char,int,int,int);
int itextRubiDataInsert(ITEXTR_T **,ITEXTR_T **,unsigned char ,unsigned char);
int checkRubyString(ITEXT_T **,ITEXT_T **,int *,unsigned char *);
int _ibuf_add(IBUF_T **,IBUF_T **,ITEXT_T *,ITEXT_T *,int);
void ibuf_data_free(ICONTENT_T *);
void itext_data_free(ITEXT_T *);
void itext_rubidata_free(ITEXTR_T *);
void book_link_free(IBOOK_T **,IBOOK_T **);
void book_link_add(IBOOK_T **,IBOOK_T **,IBOOK_T *);
void content_link_free(ICONTENT_T *);
IBOOK_T * book_link_alloc();
ICONTENT_T *content_link_alloc();

#endif
