#include "itext.h"
#include "itext_file.h"
#include "xjp.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <pwd.h>
#if HAVE_LIBWKF
#include <wkf.h>
#endif

static int _link_data_change(IBOOK_T **,IBOOK_T **,IBOOK_T *,IBOOK_T *);
static int _book_link_sort(IBOOK_T **,IBOOK_T **);
static int _ibookGetTitle(char *,char *,char *,ftype_t);
static int _get_book_data_file(char *,char *,char *,char *,char *,int *,int *,unsigned long *);
static void _person_link_add(IPERSON_T **,IPERSON_T **,IPERSON_T *);
static IPERSON_T *_person_link_alloc();
static IBOOK_T *_check_book_data(IBOOK_T *,char *,char *,unsigned long);

IBOOK_T *book_link_alloc()
{
	IBOOK_T *ik;
	if((ik = (IBOOK_T *)malloc(sizeof(IBOOK_T))) == NULL){
		fprintf(stderr,"False _book_link_alloc() (malloc())\n"); return NULL; }
	ik->siori = NULL; ik->summary = NULL; ik->dbpath = NULL;
	return ik;
}
void book_link_add(IBOOK_T **head,IBOOK_T **tail,IBOOK_T *ik)
{
	if(*tail){ik->next = NULL;ik->prev = *tail;(*tail)->next = ik;*tail = ik;}
	else{ik->next = NULL;ik->prev = NULL;*tail = ik; *head = ik;}
}
void person_link_free(IPERSON_T *head)
{
	IPERSON_T *ip,*ipp;

	if(head == NULL) return;
	for(ip=head;ip!=NULL;ip=ipp){
		ipp = ip->next; free(ip); 
	}
}
void book_link_free(IBOOK_T **head,IBOOK_T **tail)
{
	IBOOK_T *wd,*wdd;

	if(*head == NULL) return;
	for(wd = *head;wd!=NULL;wd=wdd){
		wdd = wd->next; free(wd); }

	*head = NULL; *tail = NULL;
	return ;
}
static int _link_data_change(IBOOK_T **head,IBOOK_T **tail,IBOOK_T *p,IBOOK_T *t)
{
        IBOOK_T *next,*prev;

        if(p->prev == NULL || t->prev == NULL){
                if(p->prev == NULL){
			t->prev->next = p;
			p->prev = t->prev;

			t->prev = NULL;
                        *head = t;
                }else if(t->prev == NULL){
                        p->prev->next = t;
                        t->prev = p->prev;

                        p->prev = NULL;
                        *head = p;
                }
        }else{
                p->prev->next = t;
                t->prev->next = p;
                prev = p->prev;
                p->prev = t->prev;
                t->prev = prev;
        }
        if(p->next == NULL || t->next == NULL){
                if(p->next == NULL){
			t->next->prev = p;
                        p->next = t->next;
                        t->next = NULL;
                        *tail = t;
                }else if(t->next == NULL){
                        p->next->prev = t;
                        t->next = p->next;
                        p->next = NULL;
                        *tail = p;
                }
        }else{
		p->next->prev = t;
                t->next->prev = p;
                next = p->next;
                p->next = t->next;
                t->next = next;
        }
	        return 0;
}
/*
static int _book_link_sort(IBOOK_T **head,IBOOK_T **tail)
{
	 IBOOK_T *t,*p,*next,*cm;
         unsigned long x,x1;

         if(*head == NULL) return -1;
         for(t = *head;t->next != NULL;t = next){
                 x = t->fno;
                 next = t->next;
                 cm = NULL;
                 for(p = next;p != NULL;p = p->next){
                         x1 = p->fno;
                         if(x1 > x){
                                 x = x1;
                                 cm = p;
                         }
                 }
                 if(cm != NULL){
                         _link_data_change(head,tail,t,cm);
                 }
	 }
	 return 0;
}
*/
static IBOOK_T * _book_marge_1(IBOOK_T *head,IBOOK_T *ihead)
{
	IBOOK_T i,*p;

        p = &i;
        while( head != NULL && ihead != NULL){
                if( head->fno >= ihead->fno){
                        p->next = head; p = head; head = head->next; }
                else{
                        p->next = ihead; p = ihead; ihead = ihead->next; }
        }
        if(head == NULL){ p->next = ihead;}
        else{ p->next = head; }
        return i.next;
}
static IBOOK_T * _book_marge(IBOOK_T *head)
{
        IBOOK_T *i, *j, *ihead;
        if(head == NULL || head->next == NULL) return head;
        i = head; j = head->next; if(j != NULL) j = j->next;
        while(j != NULL){
                i = i->next; j = j->next; if(j != NULL) j = j->next; }

        ihead = i->next; i->next = NULL;

	return _book_marge_1( _book_marge(head),_book_marge(ihead));
}
static int _book_link_sort(IBOOK_T **head,IBOOK_T **tail)
{
	*head = _book_marge(*head);
	return 0;
}
static IPERSON_T * _person_link_alloc()
{
	IPERSON_T *ip;

	if((ip = (IPERSON_T *)malloc(sizeof(IPERSON_T))) == NULL){
		fprintf(stderr,"False _peson_link(malloc())\n"); return NULL; }

	ip->person = NULL; ip->no = 0; ip->head = NULL;  ip->tail = NULL;
	return ip;
}
static void 
_person_link_add(IPERSON_T **head,IPERSON_T **tail,IPERSON_T *ik)
{
	if(*tail){
		ik->next = NULL; ik->prev = *tail; (*tail)->next = ik; *tail = ik; }
	else{
		ik->next = NULL; ik->prev = NULL; *tail = ik; *head = ik;
	}
}
static void 
_toKanji(char *euc,char *buf,int size)
{
	iconv_t con;
#if HAVE_LIBWKF
	wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,euc,size * 2);
#else
	con = (iconv_t)itextConvOpen(NULL,buf);
	itextConvKanjiCode(con,euc,buf,size);
	itextConvClose(con);
#endif
}
static int 
_ibookGetTitle(char *fname,char *title,char *person,ftype_t ftype)
{
	if(ftype == F_TXT){
		FILE *fp;
		unsigned char buf[1024],euc[1024 * 2];
		int size;

		if((fp = fopen(fname,"r")) == NULL){
			strcpy(title,"Broken File ?"); strcpy(person,"Broken File ?");
			return -1; }

		size = fread(buf,sizeof(char),1024,fp);
		buf[size] = '\0';
		fclose(fp);
		_toKanji(euc,buf,size);
		itextGetTitlePerson(euc,title,person);
		return 1;

	}else if(ftype == F_HTM){
		FILE *fp;
		unsigned char buf[2048],euc[2048 * 2];
		int size;

		if((fp = fopen(fname,"r")) == NULL){
			strcpy(title,"Broken File ?"); strcpy(person,"Broken File ?");
			return -1; }

		size = fread(buf,sizeof(char),2048,fp);
		buf[size] = '\0';
		fclose(fp);
		_toKanji(euc,buf,size);
		itextGetTitlePerson_htm(euc,title,person);
		return 1;
	}else if(ftype == F_ZIP){
		unsigned char buf[1024],euc[1024 * 2];
		int size;

		if((size = itextGetZipTitleBuf(fname,buf,1024)) > 0){
			_toKanji(euc,buf,size);
			itextGetTitlePerson(euc,title,person);
			return 1;
		}else{
			strcpy(title,"Broken Zip_File ?"); strcpy(person,"Broken Zip_File ?");
			return 1;
		}
	}
}
int ibookMatchFileData(IBOOK_T **bhead,IBOOK_T **btail,IBOOK_T *head,char *key)
{
	IBOOK_T *bp,*bp0;

	if(head == NULL || key == NULL) return -1;

	for(bp=head;bp!=NULL;bp=bp->next){
		if(itextStrStr(bp->title,key) != NULL	||
		   itextStrStr(bp->person,key) != NULL	||
		   itextStrStr(bp->filename,key) != NULL ){

			if((bp0 = (IBOOK_T *)book_link_alloc()) == NULL)
				continue;

			strcpy(bp0->fullpath,bp->fullpath);
			strcpy(bp0->filename,bp->filename);
			strcpy(bp0->title,bp->title);
			strcpy(bp0->person,bp->person);
			bp0->size = bp->size;
			bp0->code = bp->code;
			bp0->fno = bp->fno;
			bp0->siori = NULL;
			bp0->summary = NULL;
			bp0->dbpath = NULL;
			book_link_add(bhead,btail,bp0);
		}
	}
	return 0;
}
static int _get_book_data_file(		char *buf,
					char *fullpath,
					char *filename,
					char *title,
					char *person,
					int *size,
					int *code,
					unsigned long *fno		)
{
	char *p,temp[BUFSIZ];
	int i=0,flag=0,cont=0;

	for(p=buf;*p;p++){
		if(*p == '"'){
			if(flag == 0){
				flag = 1;
			}else{
				flag = 0;
				temp[i] = '\0';
				i = 0;
				switch(cont){
					case 0:strncpy(fullpath,temp,254);break;
					case 1:strncpy(filename,temp,254);break;
					case 2:strncpy(title,temp,126);break;
					case 3:strncpy(person,temp,126);break;
					case 4:*size = atoi(temp);break;
					case 5:*code = atoi(temp);break;
					case 6:*fno = atol(temp);break;
				}
				cont++;
			}
			continue;
		}
		if(flag) temp[i++] = *p;
	}
	if(cont != 7) return -1;

	return 0;
}
int ibookWriteFileData(IBOOK_T *head,char *fname)
{
	FILE *fp;
	IBOOK_T *ik;

	if((fp = fopen(fname,"w")) == NULL) return -1;
	for(ik=head;ik!=NULL;ik=ik->next){
		fprintf(fp,"\"%s\"\"%s\"\"%s\"\"%s\"\"%d\"\"%d\"\"%ld\"\n",ik->fullpath,ik->filename,ik->title,ik->person,ik->size,ik->code,ik->fno);
	}
	fclose(fp);

	return 0;
}
int ibookReadFileData(IBOOK_T **bhead,IBOOK_T **btail,char *fname)
{
	FILE *fp;
	char buf[BUFSIZ];
	IBOOK_T *ik;

	if((fp = fopen(fname,"r")) == NULL){ return -1; }
	while(fgets(buf,BUFSIZ,fp) != NULL){
		if(buf[0] == '\n') continue;
		if((ik = (IBOOK_T *)book_link_alloc()) == NULL) continue;;
		if(_get_book_data_file(	buf,
					ik->fullpath,
					ik->filename,
					ik->title,
					ik->person,
					&(ik->size),
					&(ik->code),
					&(ik->fno)		) < 0){
			free(ik);
			continue;
		}
		book_link_add(bhead,btail,ik);
	}
	fclose(fp);
	return 0;
}
static IBOOK_T * _check_book_data(	IBOOK_T *head,
					char *fullpath,
					char *filename,
					unsigned long fno	)
{
	IBOOK_T *ik;

	if(head == NULL) return NULL;
	for(ik=head;ik!=NULL;ik=ik->next){
		if(	strcmp(ik->fullpath,fullpath) == 0	&&
			strcmp(ik->filename,filename) == 0	&&
			ik->fno == fno				) return ik;
	}
	return NULL;
}	
int ibookGetBookData(IBOOK_T **bhead,IBOOK_T **btail,char *directory)
{
	DIR *dp;
	struct dirent *dir;
	struct stat sbuf;
	char fname[256],fullpath[256];
	IBOOK_T *ik,*fk,*fhead = NULL, *ftail = NULL;
	int book_total = 0;
	ftype_t ftype;

	sprintf(fname,"%s/%s/%s",(getpwuid(getuid()))->pw_dir,CONF_DIR_NAME,BOOK_FILE_NAME);
	ibookReadFileData(&fhead,&ftail,fname);
	if(*bhead != NULL) book_link_free(bhead,btail);
	if((dp = opendir(directory)) == NULL) return -1;
	xtext_usage(NULL,0,25);
	while((dir=readdir(dp)) != NULL){
		if(strncmp(dir->d_name,".",1) == 0 || strncmp(dir->d_name,"..",2) == 0) continue;
		xtext_usage(XJP_MESSAGE[15],0,25);

		sprintf(fullpath,"%s%s",directory,dir->d_name);
		stat(fullpath,&sbuf);

		if((fk = _check_book_data(fhead,fullpath,dir->d_name,sbuf.st_ctime)) == NULL){
			ftype = itextCheckFileType(fullpath);
			if(ftype == F_TXT || ftype == F_ZIP || ftype == F_HTM){
				if((ik = (IBOOK_T *)book_link_alloc()) == NULL) continue;
				ik->size = sbuf.st_size;
				strcpy(ik->fullpath,fullpath);
				strcpy(ik->filename,dir->d_name);
				ik->code = _ibookGetTitle(ik->fullpath,ik->title,ik->person,ftype);
				ik->fno = sbuf.st_ctime;
				book_link_add(bhead,btail,ik);
				book_total++;
			}
		}else{
			if((ik = (IBOOK_T *)book_link_alloc()) == NULL) continue;
			strcpy(ik->fullpath,fk->fullpath);
			strcpy(ik->filename,fk->filename);
			strcpy(ik->title,fk->title);
			strcpy(ik->person,fk->person);
			ik->size = fk->size;
			ik->code = fk->code;
			ik->fno = fk->fno;
			book_link_add(bhead,btail,ik);
			book_total++;
		}
	}
	closedir(dp);
	book_link_free(&fhead,&ftail);
	xtext_usage(NULL,0,25);
	_book_link_sort(bhead,btail);
	ibookWriteFileData(*bhead,fname);
	return book_total;
}
int ibookGetPersonData(IPERSON_T **phead,IPERSON_T **ptail,IBOOK_T *bhead)
{
	IPERSON_T *ip;
	IBOOK_T *ib,*ibb;

	if(bhead == NULL) return -1;
	for(ib=bhead;ib!=NULL;ib=ib->next){
		for(ip = *phead;ip!=NULL;ip=ip->next){
			if(strcmp(ib->person,ip->person) == 0) break;
		}
		if(ip == NULL){
			if((ip = (IPERSON_T *)_person_link_alloc()) != NULL){
				ip->person = ib->person; ip->no = 1; 
				if((ibb = (IBOOK_T *)book_link_alloc()) != NULL){
					memcpy(ibb,ib,sizeof(IBOOK_T));
					book_link_add(&(ip->head),&(ip->tail),ibb); }
				_person_link_add(phead,ptail,ip);
			}
		}else{
			ip->no += 1;
			if((ibb = (IBOOK_T *)book_link_alloc()) != NULL){
				memcpy(ibb,ib,sizeof(IBOOK_T));
				book_link_add(&(ip->head),&(ip->tail),ibb);
			}
		}

	}
	return 0;
}
