#include "itext.h"
#include "xjp.h"
#include <iconv.h>
#if HAVE_LIBWKF
#include <wkf.h>
#endif

#define ITEXT_BOUTYPE 
#include "itext_f2.h"

static int _check_kunten_type(ITEXTR_T *);
static int _check_jis_no(unsigned char *);
static int _check_bouten_type(unsigned char *);
static int _check_bousen_type(unsigned char *);
static int _put_bousen_type(unsigned char *,ITEXT_T *);
static int _put_small_font(unsigned char *,ITEXT_T *,int *);
static int _put_position(unsigned char *,ITEXT_T *,ITEXT_T *,unsigned char *);

static int _check_jis_no(unsigned char *temp)
{
	unsigned char c1,c2;
	unsigned char *p,no[5];
	int i,flag;

	if(strstr(temp,CHU_JI_STR1) != NULL) return 1;

	if(	(p = (unsigned char *)strstr(temp,CHU_JI_STR0)) == NULL &&
		(p = (unsigned char *)strstr(temp,CHU_JI_STR2)) == NULL	&&
		(p = (unsigned char *)strstr(temp,CHU_JI_STR3)) == NULL &&
		(p = (unsigned char *)strstr(temp,CHU_JI_STR4)) == NULL ){

		if((p = (unsigned char *)strstr(temp,CHU_TE_STR0)) == NULL	&&
		   (p = (unsigned char *)strstr(temp,CHU_TE_STR1)) == NULL	){ 
			return -1;
		}
	}
	i = 0; flag = 0;
	while(1){
		if(*p == '\0') break;
		if(itextCheckEuc(p) == 0) continue;
		c1 = *p++;
		c2 = *p++;
		if(c1 == NOSTR_1){
		       if(c2 >= 0xb0 && c2 <= 0xb9){
				flag++;
				switch(c2){
					case 0xb0:no[i++] = '0';break;
					case 0xb1:no[i++] = '1';break;
					case 0xb2:no[i++] = '2';break;
					case 0xb3:no[i++] = '3';break;
					case 0xb4:no[i++] = '4';break;
					case 0xb5:no[i++] = '5';break;
					case 0xb6:no[i++] = '6';break;
					case 0xb7:no[i++] = '7';break;
					case 0xb8:no[i++] = '8';break;
					case 0xb9:no[i++] = '9';break;
				}
		       }else{
			       if(flag) break;
		       }
		}else{
			if(flag) break;
		}
	}
	if(i == 0) return -3;

	no[i] = '\0';
	return atoi(no)+1;
}
static int _check_bouten_type(unsigned char *temp)
{
	int i;
	int max = sizeof(bouten_type) / sizeof(BOUTEN_T);
	for(i=0;i<max;i++){
		if(strstr(temp,bouten_type[i].name) != NULL) return i;
	}
	if(strstr(temp,CHU_BOUTEN_STR) != NULL) return 3;
	fprintf(stderr,"Check!!! [%s]\n",temp);
	return 0;
}
static int _check_bousen_type(unsigned char *temp)
{
	int i;
	int max = sizeof(bousen_type)/sizeof(BOUTEN_T);
	for(i=0;i<max;i++){
		if(strstr(temp,bousen_type[i].name) != NULL) return i;
	}
	return -1; 
}
static int _check_kunten_type(ITEXTR_T *head)
{
	ITEXTR_T *it;
	int i,ok;
	for(it=head,i=0;it!=NULL;it=it->next,i++){
		if(it->c1 == SKAKO_1 && it->c2 == EKAKO_2 && i == 3) return 1;
	}
	i = 0; ok = 0;
	for(it=head;it!=NULL;it=it->next){
		if(it->c1 == SHARP_1 && it->c2 == SHARP_2){
			if(i++ >= 1) break;
		       	continue;
		}
		if(it->c1 == 0xa5 && it->c2 == 0xec) continue;
		if(it->c1 == 0xb0 && it->c2 == 0xec) continue;
		if(it->c1 == 0xc6 && it->c2 == 0xf3) continue;
		if(it->c1 == 0xbb && it->c2 == 0xb0) continue;
		if(it->c1 == 0xbe && it->c2 == 0xe5) continue;
		if(it->c1 == 0xc3 && it->c2 == 0xe6) continue;
		if(it->c1 == 0xb2 && it->c2 == 0xbc) continue;
		if(it->c1 == 0xb9 && it->c2 == 0xc3) continue;
		if(it->c1 == 0xb2 && it->c2 == 0xb5) continue;
		if(it->c1 == 0xca && it->c2 == 0xba) continue;
		if(it->c1 == 0xc5 && it->c2 == 0xb7) continue;
		if(it->c1 == 0xc3 && it->c2 == 0xcf) continue;
		if(it->c1 == 0xbf && it->c2 == 0xcd) continue;
		ok++;
	}
	if(ok == 0) return 1;
	return 0;
}
static int _put_bousen_type(unsigned char *temp,ITEXT_T *it)
{
	ITEXT_T	*ch;
	ITEXTR_T *bouten_head=NULL,*bouten_tail=NULL,*bt,*chu;
	int tors,btype,flag;

	if(temp == NULL || it == NULL) return 0;
	if(strstr(temp,CHU_BOUTEN_STR) == NULL && strstr(temp,CHU_BOUSEN_STR) == NULL)
		return 0;

	if(strstr(temp,CHU_BOUTEN_STR) != NULL){
		tors = 0;
		btype = _check_bouten_type(temp);
	}else if(strstr(temp,CHU_BOUSEN_STR) != NULL){
		tors = 1;
		btype = _check_bousen_type(temp);
	}
	flag = 0;
	for(chu=it->chu_head;chu!=NULL;chu=chu->next){
		if(chu->c1 == SKAGI_1 && chu->c2 == SKAGI_2 && flag == 0){
		       	flag = 1;
			continue;
		}
		if(chu->c1 == SKAGI_1 && chu->c2 == EKAGI_2 && flag == 1){
			break;
		}
		if(flag){
		       	itextRubiDataInsert(&bouten_head,&bouten_tail,chu->c1,chu->c2);
		}
	}
	if(bouten_head == NULL) return 0;
	for(bt=bouten_tail;bt!=NULL;bt=bt->prev){
		for(ch=it;ch!=NULL;ch=ch->prev){
			if((bt->c1 == ch->c1) && (bt->c2 == ch->c2)){
				if(tors == 0){
					OnFlag(ch->flag,_TEN);
					if(btype > 31)btype = 31;
					SetFlag(ch->flag,btype);
				}else if(tors == 1){
					OnFlag(ch->flag,_SEN);
					if(btype > 31)btype = 31;
					SetFlag(ch->flag,btype);
				}
				break;
			}
		}
	}
	itext_rubidata_free(bouten_head);
	return 1;
}
static int _put_small_font(unsigned char *temp,ITEXT_T *it,int *small)
{
	if(temp == NULL || it == NULL) return 0;

	if(	strstr(temp,CHU_SMALL_STR0) != NULL && 
		strstr(temp,CHU_SMALL_STR1) != NULL 		){
		OnFlag(it->flag,_SML);
		*small = 1;
		return 1;
	}
	if(	((strstr(temp,CHU_SMALL_STR3) != NULL 	||
	 	strstr(temp,CHU_SMALL_STR3_1) != NULL) 	&&
		(strstr(temp,CHU_SMALL_STR1) != NULL	||
		 strstr(temp,CHU_SMALL_STR2) != NULL))	&&
		*small == 1				){

		*small = 0;
		return 1;
	}
	return 0;
}
static int _put_position(unsigned char *temp,ITEXT_T *ihead,ITEXT_T *itail,unsigned char *p)
{
	int m,head_mark=0;

	if(temp == NULL || ihead == NULL || itail == NULL || p == NULL) return -1;
	if(itail->c1 == CHU_KEY_C1 && itail->c2 == CHU_KEY_C2) head_mark = 1;

	if(	strstr(temp,CHU_JI_STR0) != NULL	|| 
		strstr(temp,CHU_JI_STR1) != NULL	||
		strstr(temp,CHU_JI_STR2) != NULL	||
		strstr(temp,CHU_JI_STR3) != NULL	||
		strstr(temp,CHU_JI_STR4) != NULL	||
		strstr(temp,CHU_JI_STR5) != NULL	){

		if((m = _check_jis_no(temp)) > 31) m = 31;

		if(head_mark){
			OnFlag(itail->flag,_LST); SetFlag(itail->flag,m);return 0;
		}else{
			if(!*(p + 1)){
				OnFlag(ihead->flag,_LST); SetFlag(ihead->flag,m);return 0;
			}else{
				return m;
			}
		}
	}
	if(	strstr(temp,CHU_TE_STR0) != NULL	||
		strstr(temp,CHU_TE_STR1) != NULL	){

		if((m = _check_jis_no(temp)+1) > 31) m = 31;
		if(head_mark){
			OnFlag(itail->flag,_TOP); SetFlag(itail->flag,m);return 0;
		}else{
			return -1;
		}
	}
	return -1;
}
static int _put_wchufont(unsigned char *tmp,ITEXT_T **ihead,ITEXT_T **itail)
{
	unsigned char c1,c2;
	int ej,ch,sm;

	if(tmp == NULL || *ihead == NULL | *itail == NULL) return 0;
	ej = ChFlag((*itail)->flag,_EJC) ? 1 : 0;
	ch = ChFlag((*itail)->flag,_CHU) ? 1 : 0;
	sm = ChFlag((*itail)->flag,_SML) ? 1 : 0;

	if(	strstr(tmp,CHU_SMALL_STR0) != NULL 	&&
		(strstr(tmp,CHU_SMALL_STR4) != NULL 	||
		 strstr(tmp,CHU_SMALL_STR4_1) != NULL)	){

		c1 = WCHUS_1;c2 = WCHUS_2;
		itextDataInsert(ihead,itail,c1,c2,ej,ch,sm);
		return 1;
	}
	if(	(strstr(tmp,CHU_SMALL_STR3) != NULL	||
		strstr(tmp,CHU_SMALL_STR3_1) != NULL)	&&

		(strstr(tmp,CHU_SMALL_STR4) != NULL	||
		 strstr(tmp,CHU_SMALL_STR4_1) != NULL)	){

		c1 = WCHUE_1;c2 = WCHUE_2;
		itextDataInsert(ihead,itail,c1,c2,ej,ch,sm);
		return 1;
	}
	return 0;
}
int checkRubyString(ITEXT_T **ihead,ITEXT_T **itail,int *small,unsigned char *p)
{
	ITEXTR_T *chu,*chu_s;
	unsigned char temp[BUFSIZ];
	int a,ok,m;

	if(*itail == NULL) return 0;
	if(ChFlag((*itail)->flag,_KUN) == 0){
		if(_check_kunten_type((*itail)->chu_head)){
			OnFlag((*itail)->flag,_KUN); return 0;
		}
	}
	a = 0; ok = 0; chu_s = NULL;
	for(chu=(*itail)->chu_head;chu!=NULL;chu=chu->next){
		if(chu->c1 == SHARP_1 && chu->c2 == SHARP_2){
			if((ok = _check_kunten_type(chu) ? 0 : 1)){
			       	chu_s = chu->prev;
			}else{
				if(chu_s != NULL){chu_s->next = chu; chu_s = NULL;}
			}
		}
		if(ok){
			temp[a++] = chu->c1; temp[a++] = chu->c2;
		}
	}
	if(a == 0) return 0;
	if(chu_s != NULL){
		chu_s->next = NULL;
		(*itail)->chu_tail = chu_s;
	}
	temp[a] = '\0';

	if(_put_bousen_type(temp,*itail)) return 0;
	if(_put_small_font(temp,*itail,small)) return 0;
	if((m = _put_position(temp,*ihead,*itail,p)) >= 0) return m;
	if(_put_wchufont(temp,ihead,itail)) return 0;

	(*itail)->chu_string = (char *)malloc(a+2);
	strncpy((*itail)->chu_string,temp,a+2);

	return 0;
/*
	}
	for(chu=(*itail)->chu_head;chu!=NULL;chu=chu->next){
		itextDataInsert(ihead,itail,chu->c1,chu->c2,1,1,*small);
	}
	return i;
	*/
}
int falseSmlString(FILE *fp,int *sml,iconv_t icon)
{
	fpos_t pos;
	unsigned char buf[BUFSIZ],buf_euc[BUFSIZ * 2];
	int i,len;

	fgetpos(fp,&pos);
	i = 0;
	while(fgets(buf,BUFSIZ,fp) != NULL){
		len = strlen(buf);
#if HAVE_LIBWKF
		wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,buf_euc,BUFSIZ * 2);
#else
		itextConvKanjiCode(icon,buf_euc,buf,len);
#endif
		if(	strstr(buf_euc,CHU_SMALL_STR3) != NULL	||
			strstr(buf_euc,CHU_SMALL_STR3_1) != NULL){
				fsetpos(fp,&pos);
				return 1;
		}
		if(i++ > 100) break;
	}
	fsetpos(fp,&pos);
	*sml = 0;
	return 0;
}
int falseRubyString(ITEXT_T **ihead,ITEXT_T **itail)
{
	ITEXTR_T *rb, *rubi_head;

	if((rubi_head = (*itail)->rubi_head) == NULL) return -1;
	itextDataInsert(ihead,itail,SRUBY_1,SRUBY_2,1,0,0);
	for(rb=rubi_head;rb!=NULL;rb=rb->next){
		itextDataInsert(ihead,itail,rb->c1,rb->c2,1,0,0);
	}
	return 0;
}
