#include "itext.h"
#include "itext_file.h"
#include <ctype.h>

int itextCheckEuc(unsigned char *p)
{
	if(*p & 0x80) return 1;
	return 0;
}
char * itextStrStr(char *str0,char *str1)
{
        char *p,str[256];
        int i;

        i=0;
        for(p=str0;*p;p++){
                if(isspace(*p)) continue;
                str[i++] = *p;
        }
        str[i] = '\0';
        if((p = strstr(str,str1)) != NULL) return p;
        return NULL;
}
ftype_t itextCheckFileType_ex(char *fname)
{
	char *p;

	for(p=fname+(strlen(fname)-1);*p;p--){
		if(*p == '.'){
			if(	strcmp(p,".txt") == 0	|| 
				strcmp(p,".TXT") == 0 	|| 
				strcmp(p,".text") == 0	|| 
				strcmp(p,".TEXT") == 0	||
				strcmp(p,".Text") == 0	||
				strcmp(p,".Txt") == 0	){
			       		return F_TXT;
			}else if(
					strcmp(p,".html") == 0	||
					strcmp(p,".HTML") == 0	||
					strcmp(p,".htm") == 0	||
					strcmp(p,".HTM") == 0	){
						return F_HTM;

			}else if(	strcmp(p,".csv") == 0	||
					strcmp(p,".CSV") == 0	){
						return F_CSV;

			}else if(	strcmp(p,".zip") == 0	||
					strcmp(p,".ZIP") == 0	||
					strcmp(p,".Zip") == 0	){
						return F_ZIP;
			}else{
				return F_NIP;
			}
			break;
		}
	}
	return F_BIP;
}
fcode_t itextCheckKanjiCode(FILE *fp,unsigned char *fbuf)
{
	fpos_t pos;
	unsigned char buf[1024];
	unsigned char *p,*pp;
	int size,flag;

	if(fp != NULL && fbuf == NULL){
		fgetpos(fp,&pos);
		size = fread(buf,sizeof(char),1024,fp);
		buf[size] = '\0';
		fsetpos(fp,&pos);
		pp = buf;
	}else if(fp == NULL && fbuf != NULL){
		pp = fbuf;
	}else if(fp != NULL && fbuf != NULL){
		pp = fbuf;
	}else if(fp == NULL && fbuf == NULL){
		return _U;
	}
	flag = 0;
	for(p=pp;*p;p++){
		if(*p == 0x1b && flag == 0)
		       	flag++;
		else if(*p == 0x24 && flag == 1)
		       	flag++;
		else if(*p == 0x26 && flag == 1)
		       	flag++;
		else if(*p == 0x40 && flag == 2)
			return _J;
		else if(*p == 0x42 && flag == 2)
			return _J;
		else if(*p == 0x28 && flag == 2)
			flag++;
		else if(*p == 0x44 && flag == 3)
			return _J;
		else
			flag = 0;
	}
	for(p=pp;*p;p++)
		if(*p > 0x80 && *p < 0xa0) return _S;
	for(p=pp;*p;p++)
		if(*p == 0xfd || *p == 0xfe) return _E;
	flag = 0;
	for(p=pp;*p;p++){
		if(*p & 0x80)
			flag = flag ? 0 : 1;
		if(flag)
			if(*p > 0xa1 && *p < 0xdf) return _E;
	}
	flag = 0;
	for(p=pp;*p;p++)
		if(*p > 0x20 && *p < 0x7f) flag++;
	if((flag * 100 / strlen(pp)) >= 80) return _U;

	return _S;
}
ftype_t itextCheckFileType(char *fname)
{
	FILE *fp;
	char buf[2048];
	fcode_t code;
	ftype_t re = F_BIP;

	if((fp = fopen(fname,"r")) == NULL) return F_BIP;
	if(fgetc(fp) == 'P'){
		if(fgetc(fp) == 'K'){
			re = F_ZIP;
			goto _end;
		}
	}
	fseek(fp,0L,SEEK_SET);
	fread(buf,sizeof(char),2048,fp);
	if(	(strstr(buf,"<html") != NULL || strstr(buf,"<HTML") != NULL)	&&
		(strstr(buf,"<body") != NULL || strstr(buf,"<BODY") != NULL)	||
		(strstr(buf,"<br") != NULL   || strstr(buf,"<BR") != NULL)	){

		re = F_HTM;
		goto _end;
	}
	fseek(fp,0L,SEEK_SET);
	switch((code = itextCheckKanjiCode(fp,NULL))){
		case _J:case _E:case _S:
			re = F_TXT;
			goto _end;
		break;
	}
	re = itextCheckFileType_ex(fname);
_end:
	fclose(fp);
	return re;
}
iconv_t itextConvOpen(FILE *fp,unsigned char *buf)
{
        iconv_t con;

	/*
	printf("%d\n",itextCheckKanjiCode(fp,buf));
	*/
        switch(itextCheckKanjiCode(fp,buf)){
                case _J:con = iconv_open("EUC-JP","ISO2022JP");break;
                case _S:con = iconv_open("EUC-JP","SHIFT-JIS");break;
		case _E:con = NULL;break;
		default:con = NULL;break;
        }
        return con;
}
void itextConvClose(iconv_t con)
{
	if(con != NULL)
        	iconv_close(con);
}
int itextConvKanjiCode(iconv_t con,char *to,char *from,int size)
{
        char *inbuf = NULL, *outbuf = NULL;
        int  len,in_len,out_len,from_len;

	if(from == NULL) return -1;
	if(con == NULL){ memcpy(to,from,size); *(to+size) = '\0'; return size;}

	from_len = size; len = from_len * 2;
        out_len = len; in_len = from_len;
        inbuf = from; outbuf = to;
        if(iconv(con,&inbuf,&in_len,&outbuf,&out_len) < 0){
		fprintf(stderr,"False itextConvKanjiCode()(iconv())\n");;
		return -1;
	}
	len -= out_len;
	*(to+len) = '\0';
        return len;
}
int itextGetTitlePerson(char *buf,char *title,char *person)
{
	int i=0,j=0;
	char *p,tmp[BUFSIZ],temp[10][BUFSIZ];

	for(p=buf;*p;p++){
		if(*p == '\r') continue;
		if(*p == '\n'){
			tmp[i] = '\0';
			if(strncmp(tmp,"----------",10) == 0) break;
			if(i <= 1 && j > 0) break;
			if(i > 1){
				strcpy(temp[j++],tmp);
				if(j == 10) break;
			}
			i = 0;
			continue;
		}
		tmp[i++] = *p;
	}
	if(j > 0)
		strncpy(title,temp[0],126);
	else
		strcpy(title,"");

	if(j > 1) 
		strncpy(person,temp[j-1],126);
	else
		strcpy(person,"");
	return 0;
}
int itextBufferAlloc(unsigned char **b,unsigned char **e,int size)
{
	if(*b != NULL){
                if((*b = (unsigned char *)realloc(*b,size)) == NULL){
                        fprintf(stderr,"False _buf_alloc(1)(realloc())\n");
                        return -1;
		}
        }else{
		if((*b = (unsigned char *)malloc(size)) == NULL){
                        fprintf(stderr,"False _buf_alloc(1)(malloc())\n");
			return -1;
           	}
                memset(*b,0,size);
        }
        if(*e != NULL){
                if((*e = (unsigned char *)realloc(*e,size * EUC_BUFFER)) == NULL){
                        fprintf(stderr,"False _buf_alloc(2)(realloc())\n");
                        return -1;
                }
        }else{
                if((*e = (unsigned char *)malloc(size * EUC_BUFFER)) == NULL){
                        fprintf(stderr,"False _buf_alloc(2)(malloc())\n");
                        return -1;
                }
                memset(*e,0,size * EUC_BUFFER);
        }
        return 0;
}
int itextBufferOver(unsigned char *buf,int len,int size)
{
	int end = len - 1;
	if(buf == NULL)
	       	return 0;
	if(*(buf+end) != '\r' && *(buf+end) != '\n' && len > size - 2)
		return 1;
	return 0;
}
int itextBufferCat(unsigned char **b,unsigned char **e,unsigned char **u,int *size)
{
	int len;

        if(*b == NULL || *e == NULL || *u == NULL || *size <= 0){
                fprintf(stderr,"False buf_cat()\n");
                exit(1);
        }
	len = strlen(*b) + strlen(*e);
        if(*size <= len){
                *size = len + 4;
                if((*b = (unsigned char *)realloc(*b,*size)) == NULL){
                        fprintf(stderr,"False buf_cat()(reallo())\n");
                        exit(1);
                }
        }
        sprintf(*b,"%s%s",*b,*e);
        if(itextBufferAlloc(e,u,*size) < 0)
                exit(1);
        strncpy(*e,*b,len);
        if(*b != NULL) free(*b);
        *b = NULL;
        *size = 0;
        return len;
}
