#include "itext.h"
#include "itext_file.h"
#include "xjp.h"
#include "./unzip/unzip.h"
#include <dirent.h>
#include <sys/types.h>
#include <pwd.h>

static IOTHER_T * _other_data_alloc();
static int _checkOtherDir(char *);
static void _other_data_add(IOTHER_T **,IOTHER_T **,IOTHER_T *);
static int _other_data_insert(IOTHER_T **,IOTHER_T **,char *);
static void _saveDecompressFile(unzFile *,unz_file_info *,FILE *);

void other_data_free(IOTHER_T *head)
{
	IOTHER_T *op,*opp;
	struct passwd *pwd;
	char other_file[256];

	pwd = getpwuid(getuid());
	for(op=head;op!=NULL;op=opp){
		opp = op->next;
		if(op->fname != NULL){
			sprintf(other_file,"%s/%s/%s",pwd->pw_dir,OTHER_FILE_DIR,op->fname);
			unlink(other_file);
		       	free(op->fname);
		}
		free(op);
	}
}
static IOTHER_T * _other_data_alloc()
{
	IOTHER_T *op;

	if((op = (IOTHER_T *)malloc(sizeof(IOTHER_T))) == NULL){
		fprintf(stderr,"False IOTHER_T * (malloc())\n");
		return NULL;
	}
	op->fname = NULL;
	return op;
}
static void _other_data_add(IOTHER_T **head,IOTHER_T **tail,IOTHER_T *ik)
{ 
	if(*tail){ik->next = NULL;ik->prev = *tail;(*tail)->next = ik;*tail = ik;}
        else{ik->next = NULL;ik->prev = NULL;*tail = ik;*head = ik;}
}
static int _other_data_insert(IOTHER_T **head,IOTHER_T **tail,char *fname)
{
	IOTHER_T *op;

	if((op = (IOTHER_T *)_other_data_alloc()) == NULL) return -1;
	op->fname = (char *)malloc(strlen(fname)+2);
	strcpy(op->fname,fname);
	_other_data_add(head,tail,op);
	return 0;
}
static int _unzipLog(char *s)
{
	FILE *fp;

	fp = fopen("./unzip.log","a");
	fprintf(fp,"%s\n",s);
	fclose(fp);
	return 0;
}
static int _checkOtherDir(char *other_dir)
{
	DIR *dp;

	if((dp = opendir(other_dir)) == NULL){
		if(mkdir(other_dir,0755) < 0) return -1;
	}
	closedir(dp);
	return 0;
}
static void _saveDecompressFile(unzFile *fz,unz_file_info *finfo,FILE *fp)
{
	void *un_buf;
	int un_size;

	unzOpenCurrentFile(fz);
	un_buf = (void *)malloc(BUFSIZ);
	while((un_size = unzReadCurrentFile(fz,un_buf,BUFSIZ)) > 0){
		fwrite(un_buf,1,un_size,fp);
	}
	free(un_buf);
	unzCloseCurrentFile(fz);
}
int itextUnZipFile(char *file_path,char **get_file_path,IOTHER_T **OT)
{
	FILE *fp;
	struct passwd *pwd;

	char log[100];

	char gcomment[256];
	char filename[256];
	char get_filename[256];

	unzFile *fz;
	unz_global_info ginfo;
	unz_file_info finfo;

	IOTHER_T *head = NULL, *tail = NULL;
	int MAIN_FLAG = 0,i;
	ftype_t ftype;

	if((fz = unzOpen(file_path)) == NULL){
		sprintf(log,"unzip : False Open File %s",file_path); return -1; }
	if(unzGetGlobalInfo(fz,&ginfo) != UNZ_OK){
		_unzipLog("unzip : False unzGetGloblInfo()"); return -1; }
	if(unzGetGlobalComment(fz,gcomment,256) < 0){
		_unzipLog("unzip : False unzGetGlobalComment()"); }
	if(unzGoToFirstFile(fz) != UNZ_OK){
		_unzipLog("unzip : False unzGoToFirstFile()"); return -1;}

	pwd = getpwuid(getuid());
	for(i=0;i<ginfo.number_entry;i++){
		unzGetCurrentFileInfo(fz,&finfo,filename,sizeof(filename),NULL,0,NULL,0);
		ftype = itextCheckFileType_ex(filename);
		if((ftype == F_TXT || ftype == F_CSV) && MAIN_FLAG == 0){
			sprintf(get_filename,"%s/%s",pwd->pw_dir,filename);
			if((fp = fopen(get_filename,"wb")) == NULL) continue;
			*get_file_path = (char *)malloc(strlen(get_filename)+2);
			strcpy(*get_file_path,get_filename);
		}else{
			_other_data_insert(&head,&tail,filename);
			sprintf(get_filename,"%s/%s",pwd->pw_dir,OTHER_FILE_DIR);
			if(_checkOtherDir(get_filename) < 0) continue;
			sprintf(get_filename,"%s/%s",get_filename,filename);
			if((fp = fopen(get_filename,"wb")) == NULL) continue;
		}
		_saveDecompressFile(fz,&finfo,fp);
		fclose(fp);
		MAIN_FLAG = 1;
		unzGoToNextFile(fz);
	}
	unzClose(fz);
	*OT = head;
	return finfo.uncompressed_size;
}
