#include "itext.h"
#include "itext_file.h"
#include "./unzip/unzip.h"

int itextGetZipTitleBuf(char *file_path,char *getbuf,int getsize)
{
	char filename[256];
	void *un_buf;
	unzFile *fz;
	unz_global_info ginfo;
	unz_file_info finfo;
	ftype_t ftype;
	int i,un_size;

	if((fz = unzOpen(file_path)) == NULL){
		fprintf(stderr,"unzip : False Open File %s",file_path);
		return -1;
	}
	if(unzGetGlobalInfo(fz,&ginfo) != UNZ_OK){
		fprintf(stderr,"unzip : False unzGetGloblInfo()");
		return -1;
	}
	if(unzGoToFirstFile(fz) != UNZ_OK){
		fprintf(stderr,"unzip : False unzGoToFirstFile()");
		return -1;
	}
	for(i=0;i<ginfo.number_entry;i++){
		unzGetCurrentFileInfo(fz,&finfo,filename,sizeof(filename),NULL,0,NULL,0);
		if((ftype = itextCheckFileType_ex(filename)) == F_TXT){
			unzOpenCurrentFile(fz);
			un_buf = (void *)malloc(getsize);
			un_size = unzReadCurrentFile(fz,un_buf,getsize);
			memcpy(getbuf,un_buf,un_size);
			free(un_buf);
			unzCloseCurrentFile(fz);
			break;
		}
		unzGoToNextFile(fz);
	}
	unzClose(fz);
	return un_size;
}
