#include "itext.h"
#include "xjp.h"
#include "itext_file.h"
#include "itext_f2.h"
#include <sys/stat.h>
/*
#include <sys/time.h>
*/
#if HAVE_LIBWKF
#include <wkf.h>
#endif
#define MAX_HEAD_LINE 	30
#define READ_ON 	0

static void ibuf_data_add(IBUF_T **,IBUF_T **,IBUF_T *);
static void itext_data_add(ITEXT_T **,ITEXT_T **,ITEXT_T *);
static void itext_rubidata_add(ITEXTR_T **,ITEXTR_T **,ITEXTR_T *);
static int _check_cr(unsigned char *,unsigned char *);
static int _check_ruby(unsigned char,unsigned char,ITEXT_T *,int *,int,int);
static int _check_chu(unsigned char,unsigned char,unsigned char *,int *,int);
static int _check_header(unsigned char *,int,int);
static int _check_buffer(ICONTENT_T *,unsigned char *,int,int,int,int *,int *,int *);
static char * _get_titlename(unsigned char *,int);
static ftype_t _open_file(ICONTENT_T *,FILE **,char **,int *);
static IBUF_T *ibuf_data_alloc();
static ITEXT_T *itext_data_alloc();
static ITEXTR_T *itext_rubidata_alloc();

ICONTENT_T 
*content_link_alloc()
{
        ICONTENT_T *ic;
        if((ic = (ICONTENT_T *)malloc(sizeof(ICONTENT_T))) == NULL){
                fprintf(stderr,"False _content_link_alloc()(malloc)\n"); return NULL; }
        ic->filename = NULL; ic->titlename = NULL; ic->total_line = 0;
        ic->o_head = NULL; ic->b_head = NULL; ic->b_tail = NULL;
        return ic;
}
void 
content_link_free(ICONTENT_T *ic)
{       
        if(ic != NULL) ibuf_data_free(ic);
}               
static 
IBUF_T *ibuf_data_alloc()
{
	IBUF_T *it;

	if((it = (IBUF_T *)malloc(sizeof(IBUF_T))) == NULL){
		fprintf(stderr,"False ibuf_add()(malloc())\n"); return NULL; }
	it->line = 0; it->i_head = NULL; it->i_tail = NULL;
	return it;
}
static void 
ibuf_data_add(IBUF_T **start,IBUF_T **end,IBUF_T *mg)
{
	if(*end){mg->next = NULL;mg->prev = *end;(*end)->next = mg;*end = mg;}
	else{mg->next = NULL;mg->prev = NULL;*end = mg;*start = mg;}
}
void 
ibuf_data_free(ICONTENT_T *book)
{
	IBUF_T *ib,*ibb;
	ITEXT_T *it,*itt;

	if(book->b_head == NULL) return;
	if(book->o_head != NULL) other_data_free(book->o_head);
	for(ib = book->b_head;ib!=NULL;ib=ibb){
		ibb = ib->next; itext_data_free(ib->i_head); free(ib); }
	book->b_head = NULL; book->b_tail = NULL; book->o_head = NULL;
	book->total_line = 0;
	return;
}
void
itext_rubidata_free(ITEXTR_T *ihead)
{
	ITEXTR_T *ir,*irr;
	for(ir=ihead;ir!=NULL;ir=irr){
		irr = ir->next; free(ir); }
}
void 
itext_data_free(ITEXT_T *ihead)
{
	ITEXT_T *it,*itt;

	if(ihead == NULL) return;
	for(it=ihead;it!=NULL;it=itt){
		itt = it->next;
		if(it->chu_string != NULL) free(it->chu_string);
		if(it->rubi_head != NULL) itext_rubidata_free(it->rubi_head);
		if(it->chu_head != NULL) itext_rubidata_free(it->chu_head);
		free(it);
	}
	return ;
}
static ITEXTR_T *
itext_rubidata_alloc()
{
	ITEXTR_T *ir;
	if((ir = (ITEXTR_T *)malloc(sizeof(ITEXTR_T))) == NULL) return NULL; return ir;
}
static ITEXT_T *
itext_data_alloc()
{
	ITEXT_T *it;

	if((it = (ITEXT_T *)malloc(sizeof(ITEXT_T))) == NULL) return NULL;
	it->c1 = ' '; it->c2 = ' ';
	it->off = 0; it->flag = 0;
	it->chu_string = NULL;
	it->rubi_head = NULL; it->rubi_tail = NULL;
	it->chu_head = NULL; it->chu_tail = NULL;
	return it;
}
static void 
itext_rubidata_add(ITEXTR_T **start,ITEXTR_T **end,ITEXTR_T *mg)
{
	if(*end){mg->next = NULL;mg->prev = *end;(*end)->next = (ITEXTR_T *)mg;*end = mg;}
	else{mg->next = NULL;mg->prev = NULL;*end = mg;*start = mg;}
}
static void 
itext_data_add(ITEXT_T **start,ITEXT_T **end,ITEXT_T *mg)
{
	if(*end){mg->next = NULL;mg->prev = *end;(*end)->next = (ITEXT_T *)mg;*end = mg;}
	else{mg->next = NULL;mg->prev = NULL;*end = mg;*start = mg;}
}
int _ibuf_add(		IBUF_T **head,
			IBUF_T **tail,
			ITEXT_T *ihead,
			ITEXT_T *itail,
			int line	)
{
	IBUF_T *ib;
	if((ib = (IBUF_T *)ibuf_data_alloc()) == NULL) return -1;
	ib->line = line;
	ib->i_head = ihead; ib->i_tail = itail;
	ibuf_data_add(head,tail,ib);
	return 0;
}
static int 
_check_cr(unsigned char *s,unsigned char *n)
{
	int i;
	unsigned char *p;
	for(p=s,i=0;*p;p++,i++){
		if(*p == '\r' || *p == '\n'){
			if(n != NULL) *p = *n; return i; }
	}
	return -1;
}
int 
itextRubiDataInsert(	ITEXTR_T **ihead,
			ITEXTR_T **itail,
			unsigned char c1,
			unsigned char c2	)
{
	ITEXTR_T *ir;
	if((ir = (ITEXTR_T *)itext_rubidata_alloc()) == NULL) return -1;
	ir->c1 = c1; ir->c2 = c2; itext_rubidata_add(ihead,itail,ir); return 0;
}
int 
itextDataInsert(		ITEXT_T **ihead,
				ITEXT_T **itail,
				unsigned char c1,
				unsigned char c2,
				int ej,int ch,int sm	)
{
	ITEXT_T *it;

	if((it = (ITEXT_T *)itext_data_alloc()) == NULL) return -1;
	it->c1 = c1; it->c2 = c2;
	if(ej) OnFlag(it->flag,_EJC); else OfFlag(it->flag,_EJC);
	if(ch) OnFlag(it->flag,_CHU); else OfFlag(it->flag,_CHU);
	if(sm) OnFlag(it->flag,_SML); else  OfFlag(it->flag,_SML);
	itext_data_add(ihead,itail,it);
	return 0;
}
static int 
_check_ruby(unsigned char c1,unsigned char c2,ITEXT_T *itail,int *rubi,int ruby,int start)
{
	static int rub;

	if(ruby == 0) return 0;
	if(start == 0) rub = -1;
	if(rub >= 0) rub++;

	if(c1 == LRUBU_1 && c2 == LRUBU_2){
		rub = 0;  return 1; }
	if(c1 == SRUBY_1 && c2 == SRUBY_2 && *rubi == 0){
	        if(itail != NULL && rub >= 0){
			OnFlag(itail->flag,_RUB); SetFlag(itail->flag,rub); }
		rub = -1; *rubi = 1;
		return 1;
	}
	if(c1 == SRUBY_1 && c2 == ERUBY_2 && *rubi == 1){
         	*rubi = 0; return 1; }
	return 0;
}
static int 
_check_chu(unsigned char c1,unsigned char c2,unsigned char *p,int *chu,int ruby)
{
	if(ruby == 0) return 0;
	if(c1 == SCHUS_1 && c2 == SCHUS_2 && *chu == 0){
	        if((*(p+1) == SHARP_1 && *(p+2) == SHARP_2) ||
                   (*(p+1) == SHARP_1 && *(p+2) == ASTAR_2) ){
			*chu = 1; return 1; }
	}
        if(c1 == SCHUS_1 && c2 == SCHUE_2 && *chu == 1){
		        *chu = 0; return 1; }
	return 0;
}
static int 
_check_header(unsigned char *buf_euc,int ruby,int start)
{
	static int line;
	static int head,head1;

	line++;
	if(start == 0){ line = 0; head = 0; head1 = 0;}
	if(line > MAX_HEAD_LINE || head1 == 1 || ruby == 0) return 0;
	if(strncmp(buf_euc,STR_HEAD_LINE,strlen(STR_HEAD_LINE)) == 0	){
		head = head ? 0 : 1; return 1; }
	if(strncmp(buf_euc,STR_HEAD_LINE1,strlen(STR_HEAD_LINE1)) == 0	){
		head1 = 1; }
	if(head == 0) return 0; return 1;
}
static char * 
_get_titlename(unsigned char *buf,int len)
{
	char *p;
	if((p = (char *)malloc(len+2)) == NULL){
	       fprintf(stderr,"False _get_booktitle()(malloc())\n"); return 0; }
	strcpy(p,buf); return p;
}
static int 
_check_buffer(			ICONTENT_T *book,
				unsigned char *buf_euc,
				int len,
				int ruby_on,
				int head_start,
				int *chu,
				int *sml,
				int *total_line			)
{
	if(_check_header(buf_euc,ruby_on,head_start)) return -1;
	if(_check_cr(buf_euc,"\0") == 0){
		_ibuf_add(&(book->b_head),&(book->b_tail),NULL,NULL,*total_line++); 
		if(*sml == 1) return 0; return -1;
	}
	if(*chu == 1){
		checkRubyString(&((book->b_tail)->i_head),&((book->b_tail)->i_tail),sml,NULL);
	        *chu = 0;
	}
	if(book->titlename == NULL) book->titlename = _get_titlename(buf_euc,len);
	return 1;
}
int 
itextGetStrData(		unsigned char *buf_euc,
				ITEXT_T **ihead,
				ITEXT_T **itail,
				int *rubi,
				int *chu,
				int *sml,
				int ruby_on		)
{
	unsigned char c1,c2,*p;
	int ruby_start = 0, ch_l = 0;

	for(p=buf_euc;*p;p++){
		if(itextCheckEuc(p)){
			c1 = *p++; c2 = *p;
			if(_check_ruby(c1,c2,*itail,rubi,ruby_on,ruby_start++)) 
				continue;
			if(_check_chu(c1,c2,p,chu,ruby_on)){
				if(*chu == 0)
					ch_l = checkRubyString(ihead,itail,sml,p);
				continue;
			}
			if(*rubi){
				itextRubiDataInsert(&(*itail)->rubi_head,&(*itail)->rubi_tail,c1,c2);
			}else if(*chu){
				if(*itail != NULL){
					itextRubiDataInsert(&(*itail)->chu_head,&(*itail)->chu_tail,c1,c2);
				}else{
					itextDataInsert(ihead,itail,CHU_KEY_C1,CHU_KEY_C2,1,1,*sml);
					itextRubiDataInsert(&(*itail)->chu_head,&(*itail)->chu_tail,c1,c2);
				}
			}else{
				itextDataInsert(ihead,itail,c1,c2,1,0,*sml);
				if(ch_l > 0){
					OnFlag((*itail)->flag,_LST);
					SetFlag((*itail)->flag,ch_l);
					ch_l = 0;
				}
			}
		}else{
			if(*p == '\t'){
				int xj;
				for(xj=0;xj<4;xj++){
					c1 = ' '; c2 = ' ';
					itextDataInsert(ihead,itail,c1,c2,1,0,*sml);
				}
			}else{
				c1 = *p; c2 = ' ';
				if(*chu)
					itextRubiDataInsert(&(*itail)->chu_head,&(*itail)->chu_tail,c1,c2);
				else
					itextDataInsert(ihead,itail,c1,c2,0,0,*sml);
			}
		}
	}
	if(*rubi == 1){
		falseRubyString(ihead,itail); *rubi = 0; }
	return 0;
}
int _test_01(FILE *fp,iconv_t icon,ICONTENT_T *book,int ruby_on,int buf_size,int file_size)
{
	IBUF_T *ib = NULL;
	ITEXT_T *ihead = NULL, *itail = NULL;
	unsigned char *tmp = NULL, *buf = NULL, *buf_euc = NULL;
	int total_size = 0, head_start = 0, total_line = 0;
	int len = 0, tmp_size = 0, check_buf = 0;
	int rubi = 0, chu = 0, sml = 0;

	if(itextBufferAlloc(&buf,&buf_euc,buf_size) < 0) return -1;
	while(fgets(buf,buf_size,fp) != NULL){
		total_size += (len = strlen(buf));
		xtext_usage(XJP_MESSAGE[7],(double)total_size/file_size,50);
		if(itextBufferOver(buf,len,buf_size)){
			if(itextBufferAlloc(&tmp,&buf_euc,tmp_size += buf_size * 2) < 0)
			       	return -1;
			sprintf(tmp,"%s%s",tmp,buf); continue;
		}
		if(tmp != NULL)	len = itextBufferCat(&tmp,&buf,&buf_euc,&tmp_size);
#if HAVE_LIBWKF
		wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,buf_euc,len * 2);
#else
		itextConvKanjiCode(icon,buf_euc,buf,len);
#endif
		if((check_buf = _check_buffer(book,buf_euc,len,ruby_on,head_start++,&chu,&sml,&total_line)) < 0) continue;
		if(check_buf == 0){ falseSmlString(fp,&sml,icon); continue;}
		ihead = NULL; itail = NULL;
		itextGetStrData(buf_euc,&ihead,&itail,&rubi,&chu,&sml,ruby_on);
		_ibuf_add(&(book->b_head),&(book->b_tail),ihead,itail,total_line++); 
	}
	free(buf); free(buf_euc);
	return total_line;
}
static ftype_t  
_open_file(ICONTENT_T *book,FILE ** fp,char **zip,int *fsize)
{
	struct stat sbuf; ftype_t ftype;
	switch((ftype = itextCheckFileType(book->filename))){
		case F_TXT: case F_HTM:
			if((*fp = fopen(book->filename,"r")) == NULL){
				fprintf(stderr,"False open_file()(txt)\n"); return F_BIP;}
		break;
		case F_ZIP:
			itextUnZipFile(book->filename,zip,&(book->o_head));
			if(*zip == NULL){
				fprintf(stderr,"False unzip_file()\n"); return F_BIP; }
			if((*fp = fopen(*zip,"r")) == NULL){
			       fprintf(stderr,"False open_file()(zip)\n"); return F_BIP; }
		break;
		default:
			       fprintf(stderr,"False open_file()(?)\n"); return F_BIP;
		break;
	}
	fstat(fileno(*fp),&sbuf); *fsize = sbuf.st_size;
	return ftype;
}
int itextGetTextData(ICONTENT_T *book,int ruby_on,int buf_size)
{
#if READ_ON 
	struct timeval tv0,tv1;
#endif
	FILE *fp = NULL;
	char *zipfname = NULL;
	int total_line,file_size = 0;
	iconv_t icon;
	ftype_t ftype;

	if((ftype = _open_file(book,&fp,&zipfname,&file_size)) == F_BIP) return -1;

	xtext_usage(NULL,0,0);
	icon = itextConvOpen(fp,NULL);
#if READ_ON
	gettimeofday(&tv0,NULL);
#endif
	if(ftype == F_TXT || ftype == F_ZIP)
		total_line = _test_01(fp,icon,book,ruby_on,buf_size,file_size);
	else if(ftype == F_HTM)
		total_line = _test_02(fp,icon,book,ruby_on,buf_size,file_size);
	else
		exit(1);
#if READ_ON
	gettimeofday(&tv1,NULL);
	printf("%d   %d\n",tv1.tv_sec - tv0.tv_sec,tv1.tv_usec - tv0.tv_usec);
#endif
	itextConvClose(icon); fclose(fp);
	xtext_usage(NULL,0,0);
	if(zipfname != NULL){ unlink(zipfname); free(zipfname);}
	return total_line;
}
