/*--------------------------------
 * 2002/7/31
 * ------------------------------*/
#if HAVE_NETDB_H
#include "ido_net.h"

char *idoGetUrlHost(char *target)
{
	char *p,*host,*http = "://";
	int i,h,next,httplen;

	httplen = strlen(http);
	if((host = (char *)malloc(strlen(target))) == NULL){
		fprintf(stderr,"False idogeturlhost()(malloc())\n");
		return NULL;
	}
	i = 0; h = 0; next=0;
	for(p=target;*p;p++){
		if(*p == *(http+h))
		       	h++;
		else 
			h = 0;

		if(httplen == h){ next = 1; continue; }
		if(*p=='/' && next==1){ *(host + i) = '\0'; break;}
		if(next) *(host+(i++)) = *p;
	}
	return host;
}
static shtml_t *
shtml_data_alloc(char *target,char *refere,char *host)
{
	shtml_t *shtml;
	if((shtml = (shtml_t *)malloc(sizeof(shtml_t))) == NULL) return NULL;
	shtml->target = target;
	shtml->refere = refere;
	shtml->host = host;
	shtml->agent = UA;
	shtml->accept = AP;
	shtml->accept_charset = APC;
	shtml->accept_encoding = APE;
	shtml->connection = CN;
	shtml->te = TE;
	shtml->header = NULL;
	shtml->recv_euc = NULL;
	shtml->title_euc = NULL;
	shtml->euc_size = 0;
	return shtml;
}
int idoGetNetworkData(char *target,char *host,char *referer,char *savefile,char *message)
{
	FILE *fp;
	shtml_t *shtml;

	if((shtml = (shtml_t *)shtml_data_alloc(target,referer,host)) == NULL)
		return -1;

	if(HTTP_Data_Session(shtml,message) < 0){
		HTTP_Data_Free(shtml);
		return -1;
	}
	if((fp = fopen(savefile,"w")) == NULL){
		fprintf(stderr,"False GetNetworkData()(%s)\n",savefile);
		HTTP_Data_Free(shtml);
		return -1;
	}
	fwrite(shtml->recv_euc,sizeof(unsigned char),shtml->euc_size,fp);
	fclose(fp);
	HTTP_Data_Free(shtml);
	return 0;

}
#endif
