/*****************************
 * 2002/8/10
 * **************************/
#if HAVE_NETDB_H
#include "ido_net.h"
#include "../itext.h"
#include "../itext_file.h"

jmp_buf env;

static int net_tsize=0,net_psize=0,net_csize=0;

void tout(int sig){
	signal(sig,SIG_IGN);
        signal(sig,SIG_DFL);

	longjmp(env,1);
}
static int Net_Link(char *addres,int port)
{
	int sig;
	int fd;
	int connectcount;
	struct sockaddr_in addr;
	struct hostent *hp;

	signal(SIGALRM,tout);

	if((fd=socket(AF_INET,SOCK_STREAM,0)) < 0){
		return -1;
	}
	bzero((char *)&addr,sizeof(addr));

	if((hp=gethostbyname(addres))==NULL){
		return -2;
	}
	bcopy(hp->h_addr,&addr.sin_addr,hp->h_length);
	addr.sin_family=AF_INET;
	addr.sin_port=htons(port);


	if(setjmp(env)==0){
		alarm(3);
		if(connect(fd,(struct sockaddr *)&addr,sizeof(addr))<0){
			return -3;
		}
		alarm(0);
		return fd;
	}else{
		close(fd);
		alarm(0);
		return -4;
	}
			
}
static int get_chunk_size(unsigned char *str,int *size)
{
	char buf[100];
	char chunksize[100];
	char *p,*key = "\r\n";
	int keylen,a,b,k;

	keylen = strlen(key);

	a=0;
	b=0;
	k=0;
	for(p=str,a=0;*p,a<99;p++,a++){
		if(b > 0){
			if(*p == *(key+k)){
				k++;
			}else{
				k=0;
			}
			if(keylen == k){
				buf[b] = '\0';
				sprintf(chunksize,"0x%s",buf);

				*size = strtol(chunksize,NULL,16);
				return a+1;
			}
		}
		if(!isspace(*p))  buf[b++] = *p;
	}

	return 0;
}
static header_t *
header_alloc()
{
	header_t *h;

	if((h = (header_t *)malloc(sizeof(header_t))) == NULL){
		fprintf(stderr,"header_alloc()(malloc())\n");
		return NULL;
	}
	h->http = NULL;
	h->date = NULL;
	h->server = NULL;
	h->lastmodified = NULL;
	h->etag = NULL;
	h->acceptranges = NULL;
	h->contentlength = NULL;
	h->keepalive = NULL;
	h->connection = NULL;
	h->contenttype = NULL;
	h->transferencoding = NULL;
	h->contentencoding = NULL;
	h->location = NULL;
	return h;
}
static char *
header_sep(char *buf,int len,int no)
{
	char *p,*t;
	int i = 0;

	if((t = (char *)malloc(len)) == NULL){
		fprintf(stderr,"False header_sep()(malloc()\n");
		return NULL;
	}
	for(p=buf+no;*p;p++){
		if(isspace(*p) && i == 0) continue;
		*(t + (i++)) = *p;
	}
	*(t + i) = '\0';
	return t;
}
static int 
header_httpcode(char *str)
{
	char *p,tmp[10];
	int i = -1;

	for(p=str;*p;p++){
		if(isspace(*p)){
			if(i < 0){ i = 0;}
			else{ tmp[i] = '\0'; break;}
		}
		if(i >= 0) tmp[i++] = *p;
		if(i >= 9) return -1;
	}
	if(i < 0) return -1;
	return atoi(tmp);
}
static int 
header_app(header_t **header,char *str)
{
	char *sep = "\r\n\r\n";
	char *p,buf[512];
	int seplen,i,j;

	if((*header = (header_t *)header_alloc()) == NULL) return -1;
	seplen = strlen(sep);

	i = 0; j = 0;
	for(p=str;*p;p++){
		if(*p == *(sep+j))
			j++;
		else
			j=0;
		if(j == seplen) break;

		if(*p == '\r' || *p == '\n'){
			buf[i] = '\0'; 

			if(strncmp(buf,"HTTP/",5)==0){
				(*header)->http = header_sep(buf,i,0);
				(*header)->http_code = header_httpcode((*header)->http);
			}else if(strncmp(buf,"Date:",5)==0){
				(*header)->date = header_sep(buf,i,5);
			}else if(strncmp(buf,"Server:",7)==0){
				(*header)->server = header_sep(buf,i,7);
			}else if(strncmp(buf,"Last-Modified:",14)==0){
				(*header)->lastmodified = header_sep(buf,i,14);
			}else if(strncmp(buf,"Last-modified:",14)==0){
				(*header)->lastmodified = header_sep(buf,i,14);
			}else if(strncmp(buf,"ETag:",5)==0){
				(*header)->etag = header_sep(buf,i,5);
			}else if(strncmp(buf,"Accept-Ranges:",14)==0){
				(*header)->acceptranges = header_sep(buf,i,14);
			}else if(strncmp(buf,"Accept-ranges:",14)==0){
				(*header)->acceptranges = header_sep(buf,i,14);
			}else if(strncmp(buf,"Content-Length:",15)==0){
				(*header)->contentlength = header_sep(buf,i,15);
			}else if(strncmp(buf,"Content-length:",15)==0){
				(*header)->contentlength = header_sep(buf,i,15);
			}else if(strncmp(buf,"Keep-Alive:",11)==0){
				(*header)->keepalive = header_sep(buf,i,11);
			}else if(strncmp(buf,"Keep-alive:",11)==0){
				(*header)->keepalive = header_sep(buf,i,11);
			}else if(strncmp(buf,"Connection:",11)==0){
				(*header)->connection = header_sep(buf,i,11);
			}else if(strncmp(buf,"Content-Type:",13)==0){
				(*header)->contenttype = header_sep(buf,i,13);
			}else if(strncmp(buf,"Content-type:",13)==0){
				(*header)->contenttype = header_sep(buf,i,13);
			}else if(strncmp(buf,"Transfer-Encoding:",18)==0){
				(*header)->transferencoding = header_sep(buf,i,18);
			}else if(strncmp(buf,"Transfer-encoding:",18)==0){
				(*header)->transferencoding = header_sep(buf,i,18);
			}else if(strncmp(buf,"Content-Encoding:",17)==0){
				(*header)->contentencoding = header_sep(buf,i,17);
			}else if(strncmp(buf,"Content-encoding:",17)==0){
				(*header)->contentencoding = header_sep(buf,i,17);
			}else if(strncmp(buf,"Location:",9)==0){
				(*header)->location = header_sep(buf,i,9);
			}
			i = 0;
		}
		if(*p != '\r' && *p != '\n') buf[i++] = *p;
	}
	return 0;
}
static 
int get_header_body(char **header,char *str)
{
	char *p,*sep = "\r\n\r\n";
	int i,j,seplen;
	int size;

	if((*header = (char *)malloc(strlen(str))) == NULL) return -1;
	seplen = strlen(sep);

	i = 0; j = 0;
	for(p=str;*p;p++){
		if(*p == *(sep+j))
			j++;
		else
			j=0;
		if(j == seplen){
			*((*header)+(i++)) = '\n';
			*((*header)+i) = '\0';
			return i;
		}
		*((*header)+(i++)) = *p;
	}
	fprintf(stderr,"False getheaderbody()\n");
	return 0;
}
static int 
Put_Chunked_Body(char **recvmes,char *buf,int n)
{
	int len,after,total;
	char *p;
	char n2ch_mes[50];

	net_tsize += n;

	*recvmes = (unsigned char *)realloc(*recvmes,net_tsize+2);

	if(n >= net_csize){
		total = n-net_csize;
		if(net_csize == 0){
			p=buf;
		}else{	
			memcpy(*recvmes+net_psize,buf,net_csize);
			net_psize += net_csize;
			p=buf+net_csize;

			if(total == 2  && *(p+0)=='\r' && *(p+1)=='\n'){
				net_csize = 0;
				return 0;
			}
		}
		while(1){
			if((after = get_chunk_size(p,&net_csize))==0){
				net_csize = 0;
				break;
			}
			if(net_csize == 0){
				return net_psize;
			}
			
			p = p+after;

			if((len = total-after) < net_csize){
				memcpy(*recvmes+net_psize,p,len);
				*((*recvmes+net_psize) + len) = '\0';
				net_psize += len;
				net_csize -= len;
				break;
			}else{
				total = len - net_csize;
				memcpy(*recvmes+net_psize,p,net_csize);
				*((*recvmes+net_psize) + net_csize) = '\0';
				net_psize += net_csize;
				p = p+net_csize;
			}
		}
	}else{
		memcpy(*recvmes+net_psize,buf,n);
		*((*recvmes+net_psize) + n) = '\0';
		net_psize += n;
		net_csize -= n;
	}

	return 0;
}
static int 
put_normal_body(char **recvmes,char *buf,int bufn,int n,int csize)
{
	int osize;

	osize = net_psize;
	net_psize += bufn;
	net_tsize += n;

	if((*recvmes = (unsigned char *)realloc(*recvmes,net_psize+2)) == NULL) return 1;
	memcpy(*recvmes+osize,buf,bufn);
	*((*recvmes+osize)+bufn) = '\0';

	if(net_psize >= csize) 
		return net_psize;
	return 0;
}

static int 
_http_text_code(shtml_t *shtml,unsigned char *recvmes,unsigned long tsize)
{
	unsigned char *gzipmes;
	unsigned long gzip_size;
	int kerr;

	if(recvmes == NULL) return -1;
	if(shtml->header->contentencoding != NULL){
		iconv_t icon;

		gzipmes = (unsigned char *)malloc(tsize * 5);
		if((gzip_size = gzip_decompress(recvmes,tsize,gzipmes,tsize * 5))!=0){
			*(gzipmes + gzip_size) = '\0';

			shtml->recv_euc = (unsigned char *)malloc(gzip_size * 2);

			if((icon = itextConvOpen(NULL,gzipmes)) == NULL){
				strcpy(shtml->recv_euc,recvmes);
			}else{
				if(itextConvKanjiCode(icon,shtml->recv_euc,gzipmes,gzip_size) < 0)
					strcpy(shtml->recv_euc,recvmes);
			}
			itextConvClose(icon);

		}else{
			shtml->recv_euc = (unsigned char *)malloc(20);
			strcpy(shtml->recv_euc,"No Message");
		}

		free(gzipmes);
	}else{
		iconv_t icon;

		shtml->recv_euc = (unsigned char *)malloc(tsize * 2);
		if((icon = itextConvOpen(NULL,recvmes)) == NULL){;
			strcpy(shtml->recv_euc,recvmes);
		}else{
			if(itextConvKanjiCode(icon,shtml->recv_euc,recvmes,tsize) < 0)
				strcpy(shtml->recv_euc,recvmes);
		}
		itextConvClose(icon);
	}
	shtml->euc_size = strlen(shtml->recv_euc);
	return 0;
}
static int 
_http_image_code(shtml_t *shtml,unsigned char *recvmes,unsigned long tsize)
{
	if(recvmes == NULL) return -1;
	if((shtml->recv_euc = (unsigned char *)malloc(tsize+2)) == NULL){
		fprintf(stderr,"False http_image_code()(malloc())\n");
		return -1;
	}
	memcpy(shtml->recv_euc,recvmes,tsize);
	*(shtml->recv_euc+tsize) = '\0';
	shtml->euc_size = tsize;
	return 0;
}
int
code_302(shtml_t *shtml)
{
	char *p,*buf,*host,*href = "<A HREF=\"";
	int i,j,k,s;
	if(shtml == NULL || buf == NULL) return -1;
	shtml->refere = shtml->target;
	buf = shtml->recv_euc;

	i = 0; j = 0;
	while(*(buf+i) != '\0' && *(href+j) != '\0'){
		if(*(buf+i) == *(href+j)){
			i++; j++;
		}else{
			i = i - j + 1; j = 0;
		}
	}
	if(*(href+j) != '\0') return -1;
	s = i;

	for(p=buf+s,k=0;*p;p++,k++){
		if(*p == '\"') break;
	}
	if((shtml->target = (char *)malloc(k+2)) == NULL) return -1;
	strncpy(shtml->target,buf+s,k);
	*(shtml->target + k) = '\0';
	shtml->host = (char *)idoGetUrlHost(shtml->target);

	shtml->header = NULL;
	shtml->recv_euc = NULL;
	shtml->title_euc = NULL;
	shtml->euc_size = 0;

	return 0;
}
int HTTP_Data_Free(shtml_t *shtml)
{
	if(shtml == NULL) return 0;

	if(shtml->recv_euc != NULL) free(shtml->recv_euc);
	if(shtml->title_euc != NULL) free(shtml->title_euc);
	if(shtml->header != NULL){
		char *p;
		p = shtml->header->http;if(p!=NULL) free(p);
		p = shtml->header->date;if(p!=NULL) free(p);
		p = shtml->header->server;if(p!=NULL) free(p);
		p = shtml->header->lastmodified;if(p!=NULL) free(p);
		p = shtml->header->etag;if(p!=NULL) free(p);
		p = shtml->header->acceptranges;if(p!=NULL) free(p);
		p = shtml->header->contentlength;if(p!=NULL) free(p);
		p = shtml->header->keepalive;if(p!=NULL) free(p);
		p = shtml->header->connection;if(p!=NULL) free(p);
		p = shtml->header->transferencoding;if(p!=NULL) free(p);
		p = shtml->header->contenttype;if(p!=NULL) free(p);
		p = shtml->header->contentencoding;if(p!=NULL) free(p);
		p = shtml->header->location;if(p!=NULL) free(p);
	       	free(shtml->header);
	}
	free(shtml);

	return 0;
}
int HTTP_Data_Session(shtml_t *shtml,char *message)
{
	int NORMAL_FLAG = 0;
	int CHUNKED_FLAG = 0;
	int fd;
	char *head = NULL;
	char *p,*recvmes = NULL;
	char sendstr[BUFSIZ];
        char buf[BUFSIZ];
        int n,after,header_count;
	long csize,tsize,hlen,nsize;

	sprintf(sendstr,"GET %s HTTP/1.0\r\n",shtml->target);
        sprintf(sendstr,"%sHOST: %s\r\n",sendstr,shtml->host);
        sprintf(sendstr,"%sUser-Agent: %s\r\n",sendstr,shtml->agent);
        sprintf(sendstr,"%sAccept: %s\r\n",sendstr,shtml->accept);
        sprintf(sendstr,"%sAccept-Language: %s\r\n",sendstr,shtml->accept_charset);
        sprintf(sendstr,"%sAccept-Encoding: %s\r\n",sendstr,shtml->accept_encoding);
        sprintf(sendstr,"%sReferer: %s\r\n",sendstr,shtml->refere);
        sprintf(sendstr,"%sConnection: %s\r\n",sendstr,shtml->connection);
        sprintf(sendstr,"%sTE: %s\r\n",sendstr,shtml->te);
        sprintf(sendstr,"%s\r\n",sendstr);

	if(message != NULL){
	       	xtext_usage(NULL,0,0);
		xtext_usage("³",0,0);
	}
	if((fd = Net_Link(shtml->host,80)) < 0){
	       	if(message != NULL) xtext_usage(NULL,0);
	       	return -1;
	}
	if(message != NULL) xtext_usage(NULL,0);

        send(fd,sendstr,strlen(sendstr),0);

	if((recvmes = (char *)malloc(10)) == NULL) return -1;
	*(recvmes + 0) = '\0';

	if(message != NULL) xtext_usage(NULL,0,0);

	net_psize = 0;
	net_tsize = 0;
	net_csize = 0;
	csize = 0;
	tsize = 0;
	nsize = 0;
	header_count = 0;
	while(1){
		if((n = recv(fd,buf,BUFSIZ,0))<=0){
			tsize = nsize;
		       	break;
		}
		/*n = recv(fd,buf,BUFSIZ,0);*/
		buf[n] = '\0';
		nsize += n;
		if(message != NULL) xtext_usage(message,(double)net_tsize/csize);
		if(shtml->header == NULL){
			if((hlen = get_header_body(&head,buf)) < 0) return -1;
			header_app(&(shtml->header),head);

			if(shtml->header->contentlength != NULL){
				csize = atoi(shtml->header->contentlength);
			}else{
				csize = 99999999;
			}
			if(shtml->header->transferencoding != NULL){
				if(strcmp(shtml->header->transferencoding,"chunked")==0){
					if((tsize = Put_Chunked_Body(&recvmes,buf+hlen,n-hlen)) > 0) break;;
					CHUNKED_FLAG = 1;
				}else{
					if((tsize = put_normal_body(&recvmes,buf+hlen,n-hlen,n,csize))>0) break;
					NORMAL_FLAG = 1;
				}
			}else{
				if((tsize = put_normal_body(&recvmes,buf+hlen,n-hlen,n,csize))>0) break;
				NORMAL_FLAG = 1;
			}
			continue;
		}
		if(CHUNKED_FLAG){
			if((tsize = Put_Chunked_Body(&recvmes,buf,n))>0) break;
		}else if(NORMAL_FLAG){
			if((tsize = put_normal_body(&recvmes,buf,n,n,csize))>0) break;
		}
	}
	net_psize = 0;
	net_tsize = 0;
	net_csize = 0;
	close(fd);
	if(message != NULL) xtext_usage(NULL,0);

	if(strstr(shtml->header->contenttype,"text")!=NULL || strstr(shtml->header->contenttype,"html")!=NULL){
		_http_text_code(shtml,recvmes,tsize);
	}else{
		_http_image_code(shtml,recvmes,tsize);
	}
	if(recvmes != NULL){
		free(recvmes); recvmes = NULL;
	}
	return 0;
}
#endif
