#if HAVE_NETDB_H
#include "../itext.h"
#include "../itext_file.h"
#include "../xtext.h"
#include "../xjp.h"
#include "ijp_net.h"
#include <sys/stat.h>
#include <time.h>
#include <pwd.h>
#define PFILE	".list_person_all.zip"
#define CFILE	".card.html"

char *CARD_FILE = NULL;
static char *CARD_URL = NULL;
extern xtext_net_t xnet;

static PLIST_T * _plist_data_alloc();
static ILIST_T * _list_data_alloc();
static PLIST_T * _check_plist_person(PLIST_T *,PLIST_T *,char *);
static void _plist_data_add(PLIST_T **,PLIST_T **,PLIST_T *);
static void _list_data_add(ILIST_T **,ILIST_T **,ILIST_T *);
static int _get_list_data(char **,char *,int);
static int _list_data_insert(ILIST_T **,ILIST_T **,char *,char *,char *);
static int _get_book_list(ILIST_T **,ILIST_T **,char *,char *,char *);
static int _itext_mv(char *,char *);
static int _itext_cmp(char *,char *);
static char * _get_down_name(char *);

static int 
_get_list_data(char **to,char *buf,int no)
{
	char *p,temp[BUFSIZ];
	int i,j;

	i = 0;
	j = 0;
	for(p=buf;*p;p++){
		if(*p == ','){
			temp[i] = '\0';
			if(j == no){
				if((*to = (char *)malloc(i + 2)) != NULL)
					strcpy(*to,temp);
				return 0;
			}
			i=0;
			j++;
			continue;
		}
		temp[i++] = *p;
	}
	return -1;
}
static void 
_plist_data_add(PLIST_T **start,PLIST_T **end,PLIST_T *mg)
{
	if(*end){
		mg->next = NULL;
	        mg->prev = *end;
		(*end)->next = mg;
                *end = mg;
	}else{
		mg->next = NULL;
	        mg->prev = NULL;
		*end = mg;
		*start = mg;
	}
}
static void 
_list_data_add(ILIST_T **start,ILIST_T **end,ILIST_T *mg)
{
	if(*end){
		mg->next = NULL;
	        mg->prev = *end;
		(*end)->next = mg;
                *end = mg;
	}else{
		mg->next = NULL;
	        mg->prev = NULL;
		*end = mg;
		*start = mg;
	}
}
static PLIST_T * _plist_data_alloc()
{
	PLIST_T *pl;

	if((pl = (PLIST_T *)malloc(sizeof(PLIST_T))) == NULL) 
		return NULL;

	pl->person = NULL;
	pl->total = 1;
	pl->file_date = NULL;
	pl->list_head = NULL;
	pl->list_tail = NULL;
	return pl;
}
static ILIST_T * _list_data_alloc()
{
	ILIST_T *il;

	if((il = (ILIST_T *)malloc(sizeof(ILIST_T))) == NULL)
	       	return NULL;
	il->csv_date = NULL;
	il->save_dir = NULL;
	il->person_id = NULL;
	il->person = NULL;
	il->title = NULL;
	il->type = NULL;
	il->person_h = NULL;
	il->person_i = NULL;
	il->stat = NULL;
	il->date = NULL;
	il->date1 = NULL;
	return il;
}
void ilist_data_free(ILIST_T **head,ILIST_T **tail,int type)
{
	ILIST_T *il,*ill;
	for(il = *head; il != NULL; il = ill){
		ill = il->next;
		if(type == 0){
			if(il->person_id != NULL) free(il->person_id);
			if(il->person != NULL) free(il->person);
			if(il->title != NULL) free(il->title);
			if(il->type != NULL) free(il->type);
			if(il->person_h != NULL) free(il->person_h);
			if(il->person_i != NULL) free(il->person_i);
			if(il->stat != NULL) free(il->stat);
			if(il->date != NULL) free(il->date);
			if(il->date1 != NULL) free(il->date1);
		}
		free(il);
	}
	*head = NULL; *tail = NULL;
}
void plist_data_free(PLIST_T **head,PLIST_T **tail)
{
	PLIST_T *pl,*pll; ILIST_T *il,*ill;
	for(pl = *head; pl != NULL;pl = pll){
		pll = pl->next;
		if(pl->list_head != NULL){
			for(il = pl->list_head; il != NULL; il = il->next){
				ill = il->next; free(il); }
		}
		free(pl);
	}
	*head = NULL; *tail = NULL;
}
static int 
_list_data_insert(ILIST_T **head,ILIST_T **tail,char *buf_euc,char *fdate,char *sdir)
{
	ILIST_T *il;
	char *p, *temp; int i, j = 0;

	if((il = (ILIST_T *)_list_data_alloc()) == NULL)
	       	return -1;
	if((il->csv_date = (char *)malloc(strlen(fdate)+2)) != NULL)
		strcpy(il->csv_date,fdate);

	il->save_dir = sdir;
	_get_list_data(&(il->person_id),buf_euc,0);
	_get_list_data(&(il->person),buf_euc,1);
	_get_list_data(&temp,buf_euc,2);
	il->book_id = atoi(temp); free(temp);
	_get_list_data(&(il->title),buf_euc,3);
	_get_list_data(&(il->type),buf_euc,4);
	_get_list_data(&(il->person_h),buf_euc,5);
	_get_list_data(&(il->person_i),buf_euc,6);
	_get_list_data(&(il->stat),buf_euc,8);
	_get_list_data(&(il->date),buf_euc,9);
	for(p = il->date,i = 0; *p; p++, i++){
		if(*p == '-') if(j++ == 1) break; }
	if((il->date1 = (char *)malloc(i + 2)) != NULL){
		strncpy(il->date1,il->date,i); *((il->date1) + i) = '\0'; }

	_list_data_add(head,tail,il);

	return 0;
}
static PLIST_T * _check_plist_person(PLIST_T *head,PLIST_T *tail,char *person)
{
	PLIST_T *pl;
	if(head == NULL) return NULL;
	for(pl = head; pl != NULL; pl = pl->next){
		if(strcmp(pl->person,person) == 0) return pl;
	}
	return NULL;
}
static int 
_get_book_list(ILIST_T **head,ILIST_T **tail,char *fname,char *fdate,char *sdir)
{
	iconv_t icon;

	PLIST_T *pl;
	ILIST_T *il;

	struct stat sbuf;
	int len = 0,total = 0;

	FILE *fp;
	char buf[BUFSIZ],buf_euc[BUFSIZ * 2],*person;
	
	stat(fname,&sbuf);

	if((fp = fopen(fname,"r")) == NULL) return -1;
	if(*head != NULL) ilist_data_free(head,tail,0);

	xtext_usage(NULL,0,0);
	icon = itextConvOpen(fp,NULL);
	while(fgets(buf,BUFSIZ,fp) != NULL){
		total += (len=strlen(buf));
		xtext_usage(XJP_MESSAGE[14],(double)total/sbuf.st_size,5);
		itextConvKanjiCode(icon,buf_euc,buf,len);
		_list_data_insert(head,tail,buf_euc,fdate,sdir);
	}
	fclose(fp);
	itextConvClose(icon);
	xtext_usage(NULL,0,0);
	return 0;
}
static int _itext_cmp(char *str0,char *str1)
{
	if(str0 == NULL || str1 == NULL) return -1;
	if(isspace(*(str0+0))){
		char *p,*tmp; int i = 0;
		if((tmp = (char *)malloc(strlen(str0))) == NULL) return -1;
		for(p=str0;*p;p++){
			if(isspace(*p)) continue; 
			*(tmp + (i++)) = *p;
		}
		*(tmp + i) = '\0';
		if(strcmp(tmp,str1) == 0) return 0;
		free(tmp);
		return 1;
	}else{
		if(strcmp(str0,str1) == 0) return 0;
		return 1;
	}
}
static int _itext_mv(char *fname,char *tname)
{
	FILE *fp,*tp;
	size_t size;
	char buf[BUFSIZ];

	if(fname == NULL) return -1;

	if((fp = fopen(fname,"r")) == NULL) return -1;
	if((tp = fopen(tname,"w")) == NULL) return -1;

	while((size = fread(buf,sizeof(char),BUFSIZ,fp)) > 0)
		fwrite(buf,sizeof(char),size,tp);

	fclose(fp);
	fclose(tp);

	return 1;
}
static int _itext_comp_change_ilist(ILIST_T **head,ILIST_T **tail,ILIST_T *p,ILIST_T *t)
{
	ILIST_T  *next, *prev;
	if(p->prev == NULL || t->prev == NULL){
                if(p->prev == NULL){
                        t->prev->next = p; p->prev = t->prev;
                        t->prev = NULL; *head = t; }

                else if(t->prev == NULL){
                        p->prev->next = t; t->prev = p->prev;
                        p->prev = NULL; *head = p; }
	}else{
                 p->prev->next = t; t->prev->next = p;
                 prev = p->prev; p->prev = t->prev;
                 t->prev = prev;
        }
	if(p->next == NULL || t->next == NULL){
		if(p->next == NULL){
		        t->next->prev = p; p->next = t->next;
	                t->next = NULL; *tail = t; }

	         else if(t->next == NULL){
	                p->next->prev = t; t->next = p->next;
	                p->next = NULL; *tail = p; }
	}else{
                p->next->prev = t; t->next->prev = p;
                next = p->next; p->next = t->next;
                t->next = next;
        }
	return 0;
}
static int _itext_comp_change_plist(PLIST_T **head,PLIST_T **tail,PLIST_T *p,PLIST_T *t)
{
	PLIST_T  *next, *prev;
	if(p->prev == NULL || t->prev == NULL){
                if(p->prev == NULL){
                        t->prev->next = p; p->prev = t->prev;
                        t->prev = NULL; *head = t; }

                else if(t->prev == NULL){
                        p->prev->next = t; t->prev = p->prev;
                        p->prev = NULL; *head = p; }
	}else{
                 p->prev->next = t; t->prev->next = p;
                 prev = p->prev; p->prev = t->prev;
                 t->prev = prev;
        }
	if(p->next == NULL || t->next == NULL){
		if(p->next == NULL){
		        t->next->prev = p; p->next = t->next;
	                t->next = NULL; *tail = t; }

	         else if(t->next == NULL){
	                p->next->prev = t; t->next = p->next;
	                p->next = NULL; *tail = p; }
	}else{
                p->next->prev = t; t->next->prev = p;
                next = p->next; p->next = t->next;
                t->next = next;
        }
	return 0;
}
static int _get_tmp(char tmp[],char *date)
{
	char *p; int i = 0;
	if(date == NULL)  return -1;
	for(p = date; *p; p++){ if(*p == '-') continue; tmp[i++] = *p; } tmp[i] = '\0';
	return 0;
}
static int _itext_comp_date_plist(PLIST_T **head,PLIST_T **tail)
{
	PLIST_T *t, *p, *next, *cm;
	unsigned long x,x1; char tmp[10];

	if(*head == NULL) return -1;
	for(t = *head; t->next != NULL; t = next){
		_get_tmp(tmp,t->person); x = atol(tmp); next = t->next; cm = NULL;
                for(p = next;p != NULL;p = p->next){
			_get_tmp(tmp,p->person); x1 = atol(tmp);
                        if(x1 > x){ x = x1; cm = p; }
		}
		if(cm != NULL) _itext_comp_change_plist(head,tail,t,cm);
	}
	 return 0;
}
static PLIST_T * _ms_plist_1(PLIST_T *head,PLIST_T *ihead)
{
	PLIST_T i,*p; int x,x1;

	p = &i;
	while( head != NULL && ihead != NULL){
		x = head->total; x1 = ihead->total;
		if( x >= x1){
			p->next = head; p = head; head = head->next;
		}else{
			p->next = ihead; p = ihead; ihead = ihead->next;
		}
	}
	if(head == NULL){ p->next = ihead;}
	else{ p->next = head; }
	return i.next;
}
static PLIST_T * _ms_plist(PLIST_T *head)
{
	PLIST_T *i, *j, *ihead;
	if(head == NULL || head->next == NULL) return head;
	i = head; j = head->next; if(j != NULL) j = j->next;
	while(j != NULL){
		i = i->next; j = j->next; if(j != NULL) j = j->next; }
	ihead = i->next; i->next = NULL;
	return _ms_plist_1( _ms_plist(head),_ms_plist(ihead));
}
static int _itext_comp_total_plist(PLIST_T **head,PLIST_T **tail)
{
	*head = _ms_plist(*head);
	return 0;
}
static ILIST_T * _ms_ilist_1(ILIST_T *head,ILIST_T *ihead)
{
	ILIST_T i,*p;
	unsigned long x,x1; char tmp[10];

	p = &i;
	while( head != NULL && ihead != NULL){
		_get_tmp(tmp,head->date); x = atol(tmp);
		_get_tmp(tmp,ihead->date); x1 = atol(tmp);
		if( x >= x1){
			p->next = head; p = head; head = head->next;
		}else{
			p->next = ihead; p = ihead; ihead = ihead->next;
		}
	}
	if(head == NULL){ p->next = ihead;}
	else{ p->next = head; }
	return i.next;
}
static ILIST_T * _ms_ilist(ILIST_T *head)
{
	ILIST_T *i, *j, *ihead;
	if(head == NULL || head->next == NULL) return head;
	i = head; j = head->next; if(j != NULL) j = j->next;
	while(j != NULL){
		i = i->next; j = j->next; if(j != NULL) j = j->next; }

	ihead = i->next; i->next = NULL;

	return _ms_ilist_1( _ms_ilist(head),_ms_ilist(ihead));
}
static int _itext_comp_date_ilist(ILIST_T **head)
{
	*head = _ms_ilist(*head);
	return 0;
}
static int _itext_comp(PLIST_T *phead)
{
	PLIST_T *pl;
	for(pl = phead; pl != NULL; pl = pl->next){
		_itext_comp_date_ilist(&(pl->list_head));
	}
	return 0;
}
static char * _get_down_name(char *url)
{
	char *p,*pp; int i,j,len;

	if(url == NULL) return NULL;
	len = strlen(url);
	if(( pp = (char *)malloc(len+2) ) == NULL) return NULL;
	for(p=url+(len-1),i=0;*p;p--,i++)
		if(*p == '/' || isspace(*p)) break;

	if(i != 0){
		strcpy(pp,p+1); return pp;
	}
	for(p = url+(len-2),i = 0; *p; p--,i++)
		if(*p == '/' || isspace(*p)) break;

	if(i != 0){
		strcpy(pp,p+1);
		for(j=0;j<=i;j++){
			if(*(pp + j) == '/'){ *(pp + j) = '\0'; break;}
		}
	       	return pp;
	}
	return NULL;
}
itext_table_t * _check_td(itext_table_t *tr,char *key)
{
	itext_table_t *td;

	if(tr == NULL) return NULL;
	for(td=tr->head;td!=NULL;td=td->next)
		if(_itext_cmp(td->name,key) == 0) return td;
	return NULL;
}
int itext_book_download(void *data0,int data1)
{
	ILIST_T *il;
	struct passwd *pwd;
	char c_url[256];

	if(data0 == NULL) return -1;
	if(xnet.ao_url == NULL) return -8;

	il = (ILIST_T *)data0;
	if(il->person_id == NULL || il->book_id <= 0) return -1;

	pwd = getpwuid(getuid());

	if(CARD_FILE != NULL) free(CARD_FILE);
	CARD_FILE = (char *)malloc(strlen(pwd->pw_dir)+strlen(CFILE)+10);
	sprintf(CARD_FILE,"%s/%s",pwd->pw_dir,CFILE);
	if(CARD_URL != NULL) free(CARD_URL);
	CARD_URL = (char *)malloc(strlen(xnet.ao_url) + strlen(il->person_id) + 20);
	sprintf(CARD_URL,"%scards/%s",xnet.ao_url,il->person_id);
	sprintf(c_url,"%s/card%d.html",CARD_URL,il->book_id);
	if(idoGetNetworkData(c_url,idoGetUrlHost(c_url),
				xnet.ao_url,CARD_FILE,XJP_MESSAGE[18])<0) return -5;
	xtextDispCard(il,0);
	return 0;
}
int itext_book_download_1(void *data0,int data1)
{
	itext_table_t *start,*td;
	char book_url[256],book_file[256],*save_dir,*save_file;
	int i;

	if(data0 == NULL) return -1;
	if(CARD_URL == NULL) return -1;
	if(xnet.ao_url == NULL) return -8;
	start = (itext_table_t *)data0;
	save_dir = (char *)((itext_table_t *)start->data);

	for(td = start, i = 0; td != NULL; td = td->next,i++)
		if(i == 2) break;
	if(td == NULL) return -7;

	if((save_file = (char *)_get_down_name(td->data)) == NULL) return -5;
	sprintf(book_file,"%s/%s",save_dir,save_file);
	if(strncmp(td->data,"http://",7) == 0)
		strcpy(book_url,td->data);
	else
		sprintf(book_url,"%s/%s",CARD_URL,td->data);

	if(idoGetNetworkData(book_url,idoGetUrlHost(book_url),
				xnet.ao_url,book_file,XJP_MESSAGE[10]) < 0) return -5;

	if(CARD_URL != NULL) free(CARD_URL);
	CARD_URL = NULL;

	return 1;
}
int itext_list_download(void *data0,int data1)
{
	IOTHER_T *ot,*ot_head = NULL;
	struct passwd *pwd;
	char person_file[128], *list_url;
	char *person_file_csv = NULL;
	char *person_file_csv_temp = NULL;

	if(xnet.ao_url == NULL) return -8;
	if((list_url = (char *)malloc(strlen(xnet.ao_url) + strlen(xnet.ao_list) + 2)) == NULL) return -1;
	sprintf(list_url,"%s/%s",xnet.ao_url,xnet.ao_list);

	pwd = getpwuid(getuid());
	sprintf(person_file,"%s/%s",pwd->pw_dir,PFILE);
	if(idoGetNetworkData(list_url,idoGetUrlHost(list_url),
				xnet.ao_url,person_file,XJP_MESSAGE[9])<0) return -5;
	free(list_url);

	if(data0 == NULL){
		person_file_csv = (char *)malloc(128);
		sprintf(person_file_csv,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,LIST_FILE_NAME);
	}else{
		person_file_csv = (char *)data0;
	}
	itextUnZipFile(person_file,&person_file_csv_temp,&ot_head);
	if(_itext_mv(person_file_csv_temp,person_file_csv) > 0){
		unlink(person_file);
		unlink(person_file_csv_temp);
		if(person_file_csv_temp != NULL) free(person_file_csv_temp);
		if(ot_head != NULL) other_data_free(ot_head);
	}
	return 1;
}
int itextListToPerson(PLIST_T **phead,PLIST_T **ptail,ILIST_T *lhead,int type)
{
	ILIST_T *il,*ilp; PLIST_T *pl; char *compe;

	for(il = lhead; il != NULL; il = il->next){
		if(type == 0) compe = il->person;
		if(type == 1) compe = il->person_i;
		if(type == 2) compe = il->date1;

		if((pl = _check_plist_person(*phead,*ptail,compe)) == NULL){
			if((pl = (PLIST_T *)_plist_data_alloc()) != NULL){
				pl->person = compe;
				pl->file_date = il->csv_date;
				pl->total = 1;
				if((ilp = (ILIST_T *)_list_data_alloc()) != NULL){
					*ilp = *il;
					_list_data_add(&(pl->list_head),&(pl->list_tail),ilp); }
				_plist_data_add(phead,ptail,pl);
			}
		}else{
			pl->total += 1;
			if((ilp = (ILIST_T *)_list_data_alloc()) != NULL){
				*ilp = *il;
				_list_data_add(&(pl->list_head),&(pl->list_tail),ilp); }
		}
	}
	if(type == 1) _itext_comp_total_plist(phead,ptail);
	if(type == 2) _itext_comp_date_plist(phead,ptail);
	_itext_comp(*phead); 
	return 0;
}
int itextNetBookList(ILIST_T **head,ILIST_T **tail)
{
	char person_file[128],person_file_csv[128],person_file_csv_temp[128];
	char time_str[64];
	struct passwd *pwd; struct stat sbuf; struct tm *tmval;

	if(*head != NULL) ilist_data_free(head,tail,0);
	pwd = getpwuid(getuid());
	sprintf(person_file_csv,"%s/%s/%s",pwd->pw_dir,CONF_DIR_NAME,LIST_FILE_NAME);
	if(stat(person_file_csv,&sbuf) < 0){
		if(itext_list_download((char *)person_file_csv,0) < 0) return -1;
	}
	tmval = localtime(&sbuf.st_ctime);
	strftime(time_str,sizeof(time_str),"%Yǯ%m%d(%H%Mʬ)",tmval);
	_get_book_list(head,tail,person_file_csv,time_str,xnet.book_dir);
	return 0;
}
int itextMatchBookList(ILIST_T **phead,ILIST_T **ptail,PLIST_T *head,char *result)
{
	PLIST_T *pl; ILIST_T *il, *ilp;
	if(head == NULL || result == NULL) return -1;
	for(pl = head; pl != NULL; pl = pl->next){
		for(il = pl->list_head; il != NULL; il = il->next){
			if(	itextStrStr(il->person,result) != NULL		||
				itextStrStr(il->title,result) != NULL		||
				itextStrStr(il->person_h,result) != NULL	||
				itextStrStr(il->person_i,result) != NULL	){

				if((ilp = _list_data_alloc()) != NULL){
					*ilp = *il; _list_data_add(phead,ptail,ilp);
				}
			}
		}
	}
	if(*phead == NULL) return -1;
	_itext_comp_date_ilist(phead);
	return 0;
}
#endif
